/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.MsgfParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MsgfProcessBuilder
extends SearchGUIProcessBuilder {
    private File msgfModFile;
    private File msgfEnzymesFile;
    private File msgfTempFolder;
    private HashMap<String, Integer> enzymeMap = new HashMap();
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final String MOD_FILE = "Mods.txt";
    private final String ENZYMES_FILE = "enzymes.txt";
    private final String PARAMS_FOLDER_NAME = "params";
    public static final String EXECUTABLE_FILE_NAME = "MSGFPlus.jar";
    private File spectrumFile;
    private MsgfParameters msgfParameters;
    private SearchParameters searchParameters;

    public MsgfProcessBuilder(File msgfDirectory, File msgfTempFolder, File mgfFile, File fastaFile, File outputFile, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads, boolean isCommandLine) throws IOException, ClassNotFoundException {
        this.searchParameters = searchParameters;
        this.msgfParameters = (MsgfParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex());
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.msgfTempFolder = msgfTempFolder;
        this.spectrumFile = mgfFile;
        if (!msgfTempFolder.exists()) {
            msgfTempFolder.mkdirs();
        }
        File msgfExecutable = new File(msgfDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        msgfExecutable.setExecutable(true);
        File msgfParamsFolder = new File(msgfTempFolder, "params");
        msgfParamsFolder.mkdir();
        this.msgfModFile = new File(msgfParamsFolder, "Mods.txt");
        this.createModificationsFile();
        this.msgfEnzymesFile = new File(msgfParamsFolder, "enzymes.txt");
        this.createEnzymesFile();
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        ArrayList javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserParameters.getSearchGuiPath());
        this.process_name_array.add(javaHomeAndOptions.get(0));
        if (!isCommandLine) {
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
        } else {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            for (String element : aList) {
                this.process_name_array.add(element);
            }
        }
        this.process_name_array.add("-jar");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)new File(msgfDirectory, EXECUTABLE_FILE_NAME)));
        this.process_name_array.add("-s");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.spectrumFile));
        this.process_name_array.add("-d");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)fastaFile));
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)outputFile));
        Double precursorMassError = searchParameters.getPrecursorAccuracy();
        String precursorMassErrorUnit = "ppm";
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            precursorMassErrorUnit = "Da";
        }
        this.process_name_array.add("-t");
        this.process_name_array.add(precursorMassError + precursorMassErrorUnit);
        this.process_name_array.add("-tda");
        if (this.msgfParameters.searchDecoyDatabase()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-mod");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.msgfModFile));
        this.process_name_array.add("-numMods");
        this.process_name_array.add("" + this.msgfParameters.getNumberOfModificationsPerPeptide());
        this.process_name_array.add("-minCharge");
        this.process_name_array.add("" + searchParameters.getMinChargeSearched());
        this.process_name_array.add("-maxCharge");
        this.process_name_array.add("" + searchParameters.getMaxChargeSearched());
        this.process_name_array.add("-inst");
        this.process_name_array.add("" + this.msgfParameters.getInstrumentID());
        this.process_name_array.add("-thread");
        this.process_name_array.add("" + nThreads);
        if (this.msgfParameters.getNumberOfTasks() != null) {
            this.process_name_array.add("-tasks");
            this.process_name_array.add("" + this.msgfParameters.getNumberOfTasks());
        }
        this.process_name_array.add("-m");
        this.process_name_array.add("" + this.msgfParameters.getFragmentationType());
        Integer msgfEnzyme = this.getEnzymeMapping(searchParameters.getDigestionParameters());
        if (msgfEnzyme != null) {
            this.process_name_array.add("-e");
            this.process_name_array.add(msgfEnzyme.toString());
        }
        this.process_name_array.add("-ntt");
        this.process_name_array.add("" + this.msgfParameters.getNumberTolerableTermini());
        this.process_name_array.add("-protocol");
        this.process_name_array.add("" + this.msgfParameters.getProtocol());
        this.process_name_array.add("-minLength");
        this.process_name_array.add("" + this.msgfParameters.getMinPeptideLength());
        this.process_name_array.add("-maxLength");
        this.process_name_array.add("" + this.msgfParameters.getMaxPeptideLength());
        this.process_name_array.add("-n");
        this.process_name_array.add("" + this.msgfParameters.getNumberOfSpectrumMatches());
        this.process_name_array.add("-addFeatures");
        if (this.msgfParameters.isAdditionalOutput()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            Integer missedCleavages = null;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                missedCleavages = enzymeMissedCleavages;
            }
            if (missedCleavages != null) {
                this.process_name_array.add("-maxMissedCleavages");
                this.process_name_array.add("" + missedCleavages);
            }
        }
        this.process_name_array.add("-ti");
        this.process_name_array.add(CommandLineUtils.getQuoteType() + searchParameters.getMinIsotopicCorrection() + "," + searchParameters.getMaxIsotopicCorrection() + CommandLineUtils.getQuoteType());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "ms-gf+ command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(msgfTempFolder);
        this.pb.redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModificationsFile() throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.msgfModFile));){
            bw.write("#max number of modifications per peptide\n");
            bw.write("NumMods=" + this.msgfParameters.getNumberOfModificationsPerPeptide() + "\n\n");
            bw.write("#fixed modifications\n");
            ArrayList fixedModifications = this.searchParameters.getModificationParameters().getFixedModifications();
            for (String modName : fixedModifications) {
                bw.write(this.getModificationFormattedForMsgf(modName, true) + "\n");
            }
            bw.write("\n");
            bw.write("#variable modifications\n");
            ArrayList variableModifications = this.searchParameters.getModificationParameters().getVariableModifications();
            for (String modName : variableModifications) {
                bw.write(this.getModificationFormattedForMsgf(modName, false) + "\n");
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS-GF+ modifications file. Unable to write file: '" + ioe.getMessage() + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnzymesFile() throws IOException {
        this.enzymeMap = new HashMap();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.msgfEnzymesFile));){
            EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
            int enzymeCounter = 10;
            for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                String cleavageType;
                String enzymeName = enzyme.getName();
                Integer enzymeIndex = this.getEnzymeMapping(enzyme);
                if (enzymeIndex != null) continue;
                String cleavageSite = "";
                if (!enzyme.getAminoAcidBefore().isEmpty()) {
                    cleavageType = "C";
                    for (Character character : enzyme.getAminoAcidBefore()) {
                        cleavageSite = cleavageSite + character;
                    }
                } else {
                    cleavageType = "N";
                    for (Character character : enzyme.getAminoAcidAfter()) {
                        cleavageSite = cleavageSite + character;
                    }
                }
                String nameWithoutComma = enzymeName;
                nameWithoutComma = nameWithoutComma.replaceAll(",", "");
                String nameWithoutCommaAndSpaces = nameWithoutComma.replaceAll(" ", "_");
                bw.write(nameWithoutCommaAndSpaces + ",");
                bw.write(cleavageSite + ",");
                bw.write(cleavageType + ",");
                bw.write(nameWithoutComma + System.getProperty("line.separator"));
                this.enzymeMap.put(enzymeName, enzymeCounter++);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not create MS-GF+ enzymes file. Unable to write file: '" + ioe.getMessage() + "'.");
        }
    }

    private String getModificationFormattedForMsgf(String modName, boolean fixed) {
        Modification modification = this.modificationFactory.getModification(modName);
        String aminoAcidsAtTarget = "";
        AminoAcidPattern aminoAcidPattern = modification.getPattern();
        if (aminoAcidPattern != null) {
            for (Character aa : modification.getPattern().getAminoAcidsAtTarget()) {
                aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
            }
        }
        if (aminoAcidsAtTarget.length() == 0) {
            aminoAcidsAtTarget = "*";
        }
        String position = "";
        switch (modification.getModificationType()) {
            case modaa: {
                position = "any";
                break;
            }
            case modc_protein: 
            case modcaa_protein: {
                position = "Prot-C-term";
                break;
            }
            case modc_peptide: 
            case modcaa_peptide: {
                position = "C-term";
                break;
            }
            case modn_protein: 
            case modnaa_protein: {
                position = "Prot-N-term";
                break;
            }
            case modn_peptide: 
            case modnaa_peptide: {
                position = "N-term";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Modification type " + modification.getModificationType() + " not supported.");
            }
        }
        String cvTermName = modName;
        CvTerm cvTerm = modification.getUnimodCvTerm();
        if (cvTerm != null) {
            cvTermName = cvTerm.getName();
        }
        String modType = "fix";
        if (!fixed) {
            modType = "opt";
        }
        return modification.getRoundedMass() + "," + aminoAcidsAtTarget + "," + modType + "," + position + "," + cvTermName;
    }

    @Override
    public String getType() {
        return "MS-GF+";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    private Integer getEnzymeMapping(DigestionParameters digestionPreferences) throws IOException {
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            return 9;
        }
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            return 0;
        }
        if (digestionPreferences.getEnzymes().size() > 1) {
            throw new IOException("Multiple enzymes not supported by MS-GF+!");
        }
        Enzyme enzyme = (Enzyme)digestionPreferences.getEnzymes().get(0);
        return this.getEnzymeMapping(enzyme);
    }

    private Integer getEnzymeMapping(Enzyme enzyme) {
        String enzymeName = enzyme.getName();
        if (enzymeName.equalsIgnoreCase("Trypsin")) {
            return 1;
        }
        if (enzymeName.equalsIgnoreCase("Chymotrypsin")) {
            return 2;
        }
        if (enzymeName.equalsIgnoreCase("Lys-C")) {
            return 3;
        }
        if (enzymeName.equalsIgnoreCase("Lys-N")) {
            return 4;
        }
        if (enzymeName.equalsIgnoreCase("Glu-C")) {
            return 5;
        }
        if (enzymeName.equalsIgnoreCase("Arg-C")) {
            return 6;
        }
        if (enzymeName.equalsIgnoreCase("Asp-N")) {
            return 7;
        }
        return this.enzymeMap.get(enzyme.getName());
    }
}

