/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PeptideShakerProcessBuilder
extends SearchGUIProcessBuilder {
    private final String reference;
    private final ArrayList<File> spectrumFiles;
    private final File fastaFile;
    private final ArrayList<File> identificationFiles;
    private final File identificationParametersFile;
    private final File psdbFile;
    private final boolean showGuiProgress;
    private final boolean includeData;

    public PeptideShakerProcessBuilder(WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, String reference, ArrayList<File> spectrumFiles, File fastaFile, ArrayList<File> identificationFiles, File identificationParametersFile, File psdbFile, boolean showGuiProgress, ProcessingParameters processingParameters, boolean includeData) throws IOException, ClassNotFoundException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.reference = reference;
        this.spectrumFiles = spectrumFiles;
        this.fastaFile = fastaFile;
        this.identificationParametersFile = identificationParametersFile;
        this.identificationFiles = identificationFiles;
        this.psdbFile = psdbFile;
        this.showGuiProgress = showGuiProgress;
        this.includeData = includeData;
        this.setUpProcessBuilder();
    }

    private void setUpProcessBuilder() throws IOException, ClassNotFoundException {
        try {
            UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
            CompomicsWrapper wrapper = new CompomicsWrapper();
            ArrayList javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserParameters.getPeptideShakerPath());
            this.process_name_array.add(javaHomeAndOptions.get(0));
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
            this.process_name_array.add("-cp");
            this.process_name_array.add(new File(utilitiesUserParameters.getPeptideShakerPath()).getName());
            this.process_name_array.add("eu.isas.peptideshaker.cmd.PeptideShakerCLI");
            this.process_name_array.add("-reference");
            this.process_name_array.add(this.reference);
            this.process_name_array.add("-identification_files");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.identificationFiles));
            this.process_name_array.add("-spectrum_files");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.spectrumFiles));
            this.process_name_array.add("-fasta_file");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.fastaFile));
            this.process_name_array.add("-id_params");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.identificationParametersFile));
            this.process_name_array.add("-out");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.psdbFile));
            if (this.includeData) {
                File zipFile = new File(this.psdbFile.getParentFile(), IoUtil.removeExtension((String)this.psdbFile.getName()) + ".zip");
                this.process_name_array.add("-zip");
                this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)zipFile));
            }
            if (this.showGuiProgress) {
                this.process_name_array.add("-gui");
                this.process_name_array.add("1");
            }
            this.process_name_array.trimToSize();
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "PeptideShaker command: ");
            for (Object current_entry : this.process_name_array) {
                System.out.print(current_entry + " ");
            }
            System.out.println(System.getProperty("line.separator"));
            this.pb = new ProcessBuilder(this.process_name_array);
            File psFolder = new File(utilitiesUserParameters.getPeptideShakerPath()).getParentFile();
            this.pb.directory(psFolder);
            this.pb.redirectErrorStream(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "PeptideShaker";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.reference;
    }
}

