/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;

public abstract class SearchGUIProcessBuilder
implements Runnable {
    ArrayList process_name_array = new ArrayList();
    ProcessBuilder pb;
    Process p;
    protected WaitingHandler waitingHandler;
    protected ExceptionHandler exceptionHandler;

    @Override
    public void run() {
        try {
            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) {
                this.startProcess();
            }
        }
        catch (Exception e) {
            this.exceptionHandler.catchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException {
        if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) {
            Duration processDuration = new Duration();
            processDuration.start();
            this.p = null;
            try {
                this.p = this.pb.start();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
            }
            InputStream inputStream = this.p.getInputStream();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                if (this.getType().equalsIgnoreCase("Comet")) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\n|\b ");
                    String lastString = "";
                    while (scanner.hasNext() && !this.waitingHandler.isRunCanceled()) {
                        String temp = scanner.next();
                        if (!lastString.contains(temp)) {
                            this.waitingHandler.appendReport(temp + " ", false, temp.lastIndexOf("%") == -1 || temp.lastIndexOf("100%") != -1);
                        }
                        lastString = temp;
                    }
                    scanner.close();
                } else if (this.getType().equalsIgnoreCase("msconvert")) {
                    String line;
                    boolean progressOutputStarted = false;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.startsWith("processing file:") || line.startsWith("writing output file:")) {
                            this.waitingHandler.appendReport(line, false, true);
                            if (!line.startsWith("writing output file:")) continue;
                            progressOutputStarted = true;
                            this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                            this.waitingHandler.resetSecondaryProgressCounter();
                            this.waitingHandler.setMaxSecondaryProgressCounter(100);
                            continue;
                        }
                        if (!progressOutputStarted || line.lastIndexOf("/") == -1) continue;
                        String[] progress = line.split("/");
                        try {
                            int currentValue = Integer.parseInt(progress[0].trim());
                            int maxValue = Integer.parseInt(progress[1].trim());
                            int msConvertProgressFrequency = 100;
                            int previousProgressPercentage = (int)Math.floor((double)(currentValue - msConvertProgressFrequency) / (double)maxValue * 100.0);
                            int currentProgressPercentage = (int)Math.floor((double)currentValue / (double)maxValue * 100.0);
                            if (currentValue == 1 || previousProgressPercentage == currentProgressPercentage) continue;
                            this.waitingHandler.increaseSecondaryProgressCounter();
                        }
                        catch (NumberFormatException currentValue) {}
                    }
                } else if (this.getType().equalsIgnoreCase("ThermoRawFileParser")) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\\s|\\n");
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setMaxSecondaryProgressCounter(100);
                    while (scanner.hasNext() && !this.waitingHandler.isRunCanceled()) {
                        String temp = scanner.next();
                        if (!temp.isEmpty()) {
                            if (temp.endsWith("%")) {
                                this.waitingHandler.increaseSecondaryProgressCounter(10);
                                continue;
                            }
                            this.waitingHandler.appendReport(temp + " ", false, temp.endsWith("scans"));
                            continue;
                        }
                        this.waitingHandler.appendReportEndLine();
                    }
                    scanner.close();
                } else if (this.getType().equalsIgnoreCase("MetaMorpheus")) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\\s|\\n");
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setMaxSecondaryProgressCounter(100);
                    int numberOfEmptyLines = 0;
                    boolean ignoreOutput = false;
                    boolean lastProgressCounter = false;
                    boolean currentlyCountingProgress = false;
                    String currentText = "";
                    while (scanner.hasNext() && !this.waitingHandler.isRunCanceled()) {
                        String temp = scanner.next();
                        if (!currentlyCountingProgress) {
                            if ((currentText = currentText + temp + " ").lastIndexOf("Starting task: Task1GptmdTask") != -1) {
                                currentText = "";
                                this.waitingHandler.setMaxSecondaryProgressCounter(200);
                            } else if (currentText.lastIndexOf("Finished task: Task1GptmdTask") != -1) {
                                temp = "Finished task: Task1GptmdTask";
                                currentText = "";
                                ignoreOutput = false;
                            } else if (currentText.lastIndexOf("Starting task: Task1SearchTask") != -1 || currentText.lastIndexOf("Starting task: Task2SearchTask") != -1) {
                                currentText = "";
                                lastProgressCounter = true;
                            }
                        }
                        if (ignoreOutput) continue;
                        if (!temp.isEmpty()) {
                            if (temp.matches("[1-9]?\\d") || temp.equalsIgnoreCase("100")) {
                                this.waitingHandler.increaseSecondaryProgressCounter(1);
                                currentlyCountingProgress = true;
                                if (Integer.parseInt(temp) == 99 || Integer.parseInt(temp) == 100) {
                                    currentlyCountingProgress = false;
                                    ignoreOutput = true;
                                    if (lastProgressCounter) {
                                        this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                                        this.waitingHandler.appendReport("Writing MetaMorpheus output.", false, true);
                                    }
                                }
                            } else {
                                this.waitingHandler.appendReport(temp + " ", false, false);
                            }
                            numberOfEmptyLines = 0;
                            continue;
                        }
                        if (++numberOfEmptyLines >= 3) continue;
                        this.waitingHandler.appendReportEndLine();
                    }
                    scanner.close();
                } else {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        if ((line = line + System.getProperty("line.separator")).lastIndexOf("<CompomicsError>") != -1) {
                            this.waitingHandler.appendReportEndLine();
                            line = line.substring("<CompomicsError>".length(), line.length() - ("</CompomicsError>".length() + 2));
                            this.waitingHandler.appendReport(line, true, true);
                            this.waitingHandler.setRunCanceled();
                            continue;
                        }
                        this.waitingHandler.appendReport(line, false, false);
                    }
                }
                inputStream.close();
                bufferedReader.close();
            }
            finally {
                block45: {
                    if (this.waitingHandler.isRunCanceled()) {
                        if (this.p != null) {
                            this.p.destroy();
                        }
                    } else {
                        processDuration.end();
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReport(this.getType() + " finished for " + this.getCurrentlyProcessedFileName() + " (" + processDuration.toString() + ").", true, true);
                        this.waitingHandler.appendReportEndLine();
                        try {
                            this.p.waitFor();
                        }
                        catch (InterruptedException e) {
                            if (this.p == null) break block45;
                            this.p.destroy();
                        }
                    }
                }
            }
        }
    }

    public void endProcess() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public abstract String getType();

    public abstract String getCurrentlyProcessedFileName();
}

