package eu.isas.searchgui.gui;

import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.searchgui.OutputParameters;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.SwingConstants;

/**
 * SearchGUI advanced settings dialog.
 *
 * @author Harald Barsnes
 * @author Marc Vaudel
 */
public class AdvancedParametersDialog extends javax.swing.JDialog {

    /**
     * Creates a new AdvancedSettingsDialog.
     *
     * @param searchGUI the SearchGUI main frame
     * @param modal if the dialog is to be modal
     */
    public AdvancedParametersDialog(SearchGUI searchGUI, boolean modal) {
        super(searchGUI, modal);
        initComponents();

        UtilitiesUserParameters userParameters = UtilitiesUserParameters.loadUserParameters();

        mgfMaxSizeTxt.setText(userParameters.getMgfMaxSize() + "");
        mgfReducedSizeTxt.setText(userParameters.getMgfNSpectra() + "");
        if (userParameters.renameXTandemFile()) {
            renameCmb.setSelectedIndex(0);
        } else {
            renameCmb.setSelectedIndex(1);
        }
        if (userParameters.checkPeakPicking()) {
            peakPickingComboBox.setSelectedIndex(0);
        } else {
            peakPickingComboBox.setSelectedIndex(1);
        }
        if (userParameters.checkDuplicateTitles()) {
            duplicateTitlesComboBox.setSelectedIndex(0);
        } else {
            duplicateTitlesComboBox.setSelectedIndex(1);
        }
        if (userParameters.checkMgfSize()) {
            checkMgfFileSizeComboBox.setSelectedIndex(0);
        } else {
            checkMgfFileSizeComboBox.setSelectedIndex(1);
        }
        if (userParameters.isCheckSpectrumCharges()) {
            checkSpectrumChargesComboBox.setSelectedIndex(0);
        } else {
            checkSpectrumChargesComboBox.setSelectedIndex(1);
        }
        
        lowSpectrumChargeRangeTxt.setText(userParameters.getMinSpectrumChargeRange() + "");
        highSpectrumChargeRangeTxt.setText(userParameters.getMaxSpectrumChargeRange() + "");
        
        refMassTxt.setText(userParameters.getRefMass() + "");
        groupResultFilesCmb.setSelectedIndex(userParameters.getSearchGuiOutputParameters().id);
        if (userParameters.outputData()) {
            includeDataCmb.setSelectedIndex(0);
        } else {
            includeDataCmb.setSelectedIndex(1);
        }
        if (userParameters.isIncludeDateInOutputName()) {
            includeDateCmb.setSelectedIndex(0);
        } else {
            includeDateCmb.setSelectedIndex(1);
        }
        if (userParameters.isGzip()) {
            zipIdFilesCmb.setSelectedIndex(0);
        } else {
            zipIdFilesCmb.setSelectedIndex(1);
        }

        renameCmb.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        groupResultFilesCmb.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        includeDataCmb.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        includeDateCmb.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        peakPickingComboBox.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        duplicateTitlesComboBox.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        checkSpectrumChargesComboBox.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        checkMgfFileSizeComboBox.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));
        zipIdFilesCmb.setRenderer(new com.compomics.util.gui.renderers.AlignedListCellRenderer(SwingConstants.CENTER));

        setLocationRelativeTo(searchGUI);
        setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        advancedParamatersPanel = new javax.swing.JPanel();
        spectrumProcessingPanel = new javax.swing.JPanel();
        peakPickingLabel = new javax.swing.JLabel();
        peakPickingComboBox = new javax.swing.JComboBox();
        duplicateTitlesLabel = new javax.swing.JLabel();
        duplicateTitlesComboBox = new javax.swing.JComboBox();
        maxMgfFileSizeLabel = new javax.swing.JLabel();
        maxSpectraPerFileLabel = new javax.swing.JLabel();
        mgfMaxSizeTxt = new javax.swing.JTextField();
        mgfReducedSizeTxt = new javax.swing.JTextField();
        checkSpectrumChargesLabel = new javax.swing.JLabel();
        checkSpectrumChargesComboBox = new javax.swing.JComboBox();
        spectrumChargeRangeLabel = new javax.swing.JLabel();
        lowSpectrumChargeRangeTxt = new javax.swing.JTextField();
        highSpectrumChargeRangeTxt = new javax.swing.JTextField();
        spectrumChargeRangeDelimiterLabel = new javax.swing.JLabel();
        checkMgfFileSizeLabel = new javax.swing.JLabel();
        checkMgfFileSizeComboBox = new javax.swing.JComboBox();
        openDialogHelpJButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        outputPanel = new javax.swing.JPanel();
        groupResultFilesTxt = new javax.swing.JLabel();
        groupResultFilesCmb = new javax.swing.JComboBox();
        includeDataTxt = new javax.swing.JLabel();
        includeDataCmb = new javax.swing.JComboBox();
        includeDateLbl = new javax.swing.JLabel();
        includeDateCmb = new javax.swing.JComboBox();
        renameXTandemFileLabel = new javax.swing.JLabel();
        renameCmb = new javax.swing.JComboBox();
        zipIdFilesLabel = new javax.swing.JLabel();
        zipIdFilesCmb = new javax.swing.JComboBox();
        identificationParametersPanel = new javax.swing.JPanel();
        refMassLbl = new javax.swing.JLabel();
        refMassTxt = new javax.swing.JTextField();
        closeButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Advanced Settings");
        setMinimumSize(new java.awt.Dimension(500, 300));
        setResizable(false);

        advancedParamatersPanel.setBackground(new java.awt.Color(230, 230, 230));

        spectrumProcessingPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Spectrum Processing"));
        spectrumProcessingPanel.setOpaque(false);

        peakPickingLabel.setText("Peak Picking Check");

        peakPickingComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));

        duplicateTitlesLabel.setText("Duplicate Titles Check");

        duplicateTitlesComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));

        maxMgfFileSizeLabel.setText("Maximum Mgf File Size (MB)");

        maxSpectraPerFileLabel.setText("Maximum Spectra in Mgf File");

        mgfMaxSizeTxt.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        mgfMaxSizeTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mgfMaxSizeTxtActionPerformed(evt);
            }
        });
        mgfMaxSizeTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                mgfMaxSizeTxtKeyReleased(evt);
            }
        });

        mgfReducedSizeTxt.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        mgfReducedSizeTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mgfReducedSizeTxtActionPerformed(evt);
            }
        });
        mgfReducedSizeTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                mgfReducedSizeTxtKeyReleased(evt);
            }
        });

        checkSpectrumChargesLabel.setText("Spectrum Charges Check");

        checkSpectrumChargesComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));
        checkSpectrumChargesComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkSpectrumChargesComboBoxActionPerformed(evt);
            }
        });

        spectrumChargeRangeLabel.setText("Spectrum Charge Range");

        lowSpectrumChargeRangeTxt.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        lowSpectrumChargeRangeTxt.setText("2");
        lowSpectrumChargeRangeTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lowSpectrumChargeRangeTxtActionPerformed(evt);
            }
        });
        lowSpectrumChargeRangeTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                lowSpectrumChargeRangeTxtKeyReleased(evt);
            }
        });

        highSpectrumChargeRangeTxt.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        highSpectrumChargeRangeTxt.setText("4");
        highSpectrumChargeRangeTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                highSpectrumChargeRangeTxtActionPerformed(evt);
            }
        });
        highSpectrumChargeRangeTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                highSpectrumChargeRangeTxtKeyReleased(evt);
            }
        });

        spectrumChargeRangeDelimiterLabel.setText("-");

        checkMgfFileSizeLabel.setText("Mgf File Size Check");

        checkMgfFileSizeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));
        checkMgfFileSizeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkMgfFileSizeComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout spectrumProcessingPanelLayout = new javax.swing.GroupLayout(spectrumProcessingPanel);
        spectrumProcessingPanel.setLayout(spectrumProcessingPanelLayout);
        spectrumProcessingPanelLayout.setHorizontalGroup(
            spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                        .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addComponent(peakPickingLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(peakPickingComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addComponent(duplicateTitlesLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(duplicateTitlesComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addComponent(checkSpectrumChargesLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(checkSpectrumChargesComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addGap(206, 206, 206)
                                .addComponent(lowSpectrumChargeRangeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 62, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(spectrumChargeRangeDelimiterLabel))
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addComponent(checkMgfFileSizeLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(checkMgfFileSizeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addComponent(spectrumChargeRangeLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(137, 137, 137)
                                .addComponent(highSpectrumChargeRangeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(maxMgfFileSizeLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(maxSpectraPerFileLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addGap(18, 18, 18)
                                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(mgfMaxSizeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(mgfReducedSizeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                .addContainerGap())
        );

        spectrumProcessingPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {highSpectrumChargeRangeTxt, lowSpectrumChargeRangeTxt});

        spectrumProcessingPanelLayout.setVerticalGroup(
            spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(spectrumProcessingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(peakPickingComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(peakPickingLabel))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(duplicateTitlesComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(duplicateTitlesLabel))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(checkSpectrumChargesLabel)
                    .addComponent(checkSpectrumChargesComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spectrumChargeRangeLabel)
                    .addComponent(lowSpectrumChargeRangeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(highSpectrumChargeRangeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(spectrumChargeRangeDelimiterLabel))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(checkMgfFileSizeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(checkMgfFileSizeLabel))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(maxMgfFileSizeLabel)
                    .addComponent(mgfMaxSizeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(spectrumProcessingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(maxSpectraPerFileLabel)
                    .addComponent(mgfReducedSizeTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        openDialogHelpJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help.GIF"))); // NOI18N
        openDialogHelpJButton.setToolTipText("Help");
        openDialogHelpJButton.setBorder(null);
        openDialogHelpJButton.setBorderPainted(false);
        openDialogHelpJButton.setContentAreaFilled(false);
        openDialogHelpJButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                openDialogHelpJButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                openDialogHelpJButtonMouseExited(evt);
            }
        });
        openDialogHelpJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openDialogHelpJButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        outputPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Output"));
        outputPanel.setOpaque(false);

        groupResultFilesTxt.setText("Group Identification Files");

        groupResultFilesCmb.setModel(new DefaultComboBoxModel(com.compomics.util.parameters.searchgui.OutputParameters.getOutputParametersNames()));
        groupResultFilesCmb.setToolTipText("Output files grouping options");
        groupResultFilesCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                groupResultFilesCmbActionPerformed(evt);
            }
        });

        includeDataTxt.setText("Include Spectra and Database");
        includeDataTxt.setToolTipText("");

        includeDataCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));
        includeDataCmb.setSelectedIndex(1);
        includeDataCmb.setToolTipText("Copy the spectra and fasta files along with the identification results");

        includeDateLbl.setText("Include Date in File Name");

        includeDateCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));
        includeDateCmb.setSelectedIndex(1);

        renameXTandemFileLabel.setText("Rename X! Tandem File");

        renameCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));

        zipIdFilesLabel.setText("Zip Individual ID Files");

        zipIdFilesCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Yes", "No" }));

        javax.swing.GroupLayout outputPanelLayout = new javax.swing.GroupLayout(outputPanel);
        outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(
            outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(outputPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(outputPanelLayout.createSequentialGroup()
                        .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(outputPanelLayout.createSequentialGroup()
                                .addComponent(renameXTandemFileLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(4, 4, 4)
                                .addComponent(renameCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(outputPanelLayout.createSequentialGroup()
                                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(groupResultFilesTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(includeDataTxt, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 190, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(includeDateLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(4, 4, 4)
                                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(includeDateCmb, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(includeDataCmb, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(groupResultFilesCmb, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addGap(0, 2, Short.MAX_VALUE))
                    .addGroup(outputPanelLayout.createSequentialGroup()
                        .addComponent(zipIdFilesLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(zipIdFilesCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        outputPanelLayout.setVerticalGroup(
            outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(outputPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(groupResultFilesCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(groupResultFilesTxt))
                .addGap(0, 0, 0)
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(includeDataTxt)
                    .addComponent(includeDataCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(includeDateLbl)
                    .addComponent(includeDateCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(renameCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(renameXTandemFileLabel))
                .addGap(0, 0, 0)
                .addGroup(outputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(zipIdFilesCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(zipIdFilesLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        identificationParametersPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Search"));
        identificationParametersPanel.setOpaque(false);

        refMassLbl.setText("Reference Mass (Da)");
        refMassLbl.setToolTipText("Reference mass used to convert tolerances from ppm to Da");

        refMassTxt.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        refMassTxt.setToolTipText("Reference mass used to convert tolerances from ppm to Da");
        refMassTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refMassTxtActionPerformed(evt);
            }
        });
        refMassTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                refMassTxtKeyReleased(evt);
            }
        });

        javax.swing.GroupLayout identificationParametersPanelLayout = new javax.swing.GroupLayout(identificationParametersPanel);
        identificationParametersPanel.setLayout(identificationParametersPanelLayout);
        identificationParametersPanelLayout.setHorizontalGroup(
            identificationParametersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(identificationParametersPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(refMassLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(refMassTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        identificationParametersPanelLayout.setVerticalGroup(
            identificationParametersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(identificationParametersPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(identificationParametersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(refMassLbl)
                    .addComponent(refMassTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout advancedParamatersPanelLayout = new javax.swing.GroupLayout(advancedParamatersPanel);
        advancedParamatersPanel.setLayout(advancedParamatersPanelLayout);
        advancedParamatersPanelLayout.setHorizontalGroup(
            advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(openDialogHelpJButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(okButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(closeButton))
                    .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                        .addComponent(spectrumProcessingPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                                .addComponent(outputPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, advancedParamatersPanelLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(identificationParametersPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap())
        );

        advancedParamatersPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {closeButton, okButton});

        advancedParamatersPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {identificationParametersPanel, outputPanel, spectrumProcessingPanel});

        advancedParamatersPanelLayout.setVerticalGroup(
            advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(spectrumProcessingPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(advancedParamatersPanelLayout.createSequentialGroup()
                        .addComponent(outputPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(identificationParametersPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(advancedParamatersPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(okButton)
                    .addComponent(openDialogHelpJButton)
                    .addComponent(closeButton))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(advancedParamatersPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(advancedParamatersPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Validate the input and, if OK, save and close the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        if (validateAdvancedParametersInput(true)) {

            UtilitiesUserParameters userParameters = UtilitiesUserParameters.loadUserParameters();
            userParameters.setRenameXTandemFile(renameCmb.getSelectedIndex() == 0);
            userParameters.setCheckPeakPicking(peakPickingComboBox.getSelectedIndex() == 0);
            userParameters.setCheckDuplicateTitles(duplicateTitlesComboBox.getSelectedIndex() == 0);
            userParameters.setCheckMgfSize(checkMgfFileSizeComboBox.getSelectedIndex() == 0);
            userParameters.setMgfMaxSize(Double.parseDouble(mgfMaxSizeTxt.getText().trim()));
            userParameters.setMgfNSpectra(Integer.parseInt(mgfReducedSizeTxt.getText().trim()));
            OutputParameters outputParameters = OutputParameters.getOutputParameters(groupResultFilesCmb.getSelectedIndex());
            userParameters.setSearchGuiOutputParameters(outputParameters);
            userParameters.setOutputData(includeDataCmb.getSelectedIndex() == 0);
            userParameters.setIncludeDateInOutputName(includeDateCmb.getSelectedIndex() == 0);
            userParameters.setRefMass(Double.parseDouble(refMassTxt.getText()));
            userParameters.setCheckSpectrumCharges(checkSpectrumChargesComboBox.getSelectedIndex() == 0);
            userParameters.setMinSpectrumChargeRange(Integer.parseInt(lowSpectrumChargeRangeTxt.getText()));
            userParameters.setMaxSpectrumChargeRange(Integer.parseInt(highSpectrumChargeRangeTxt.getText()));
            userParameters.setGzip(zipIdFilesCmb.getSelectedIndex() == 0);

            UtilitiesUserParameters.saveUserParameters(userParameters);

            dispose();
        }
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Close the dialog without saving.
     *
     * @param evt
     */
    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        dispose();
    }//GEN-LAST:event_closeButtonActionPerformed

    /**
     * Open the help dialog.
     *
     * @param evt
     */
    private void openDialogHelpJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openDialogHelpJButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        new HelpDialog(this, getClass().getResource("/helpFiles/AdvancedSettingsDialog.html"),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/searchgui.gif")),
                "Advanced Settings - Help", 500, 50);
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_openDialogHelpJButtonActionPerformed

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void openDialogHelpJButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_openDialogHelpJButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_openDialogHelpJButtonMouseExited

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void openDialogHelpJButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_openDialogHelpJButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_openDialogHelpJButtonMouseEntered

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void refMassTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refMassTxtActionPerformed
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_refMassTxtActionPerformed

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void refMassTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_refMassTxtKeyReleased
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_refMassTxtKeyReleased

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void highSpectrumChargeRangeTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_highSpectrumChargeRangeTxtKeyReleased
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_highSpectrumChargeRangeTxtKeyReleased

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void highSpectrumChargeRangeTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_highSpectrumChargeRangeTxtActionPerformed
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_highSpectrumChargeRangeTxtActionPerformed

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void lowSpectrumChargeRangeTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_lowSpectrumChargeRangeTxtKeyReleased
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_lowSpectrumChargeRangeTxtKeyReleased

    /**
     * Validate the input parameters.
     *
     * @param evt
     */
    private void lowSpectrumChargeRangeTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lowSpectrumChargeRangeTxtActionPerformed
        validateAdvancedParametersInput(false);
    }//GEN-LAST:event_lowSpectrumChargeRangeTxtActionPerformed

    /**
     * Enable/disable the spectrum charge range input.
     *
     * @param evt
     */
    private void checkSpectrumChargesComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkSpectrumChargesComboBoxActionPerformed
        spectrumChargeRangeLabel.setEnabled(checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        lowSpectrumChargeRangeTxt.setEnabled(checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        spectrumChargeRangeDelimiterLabel.setEnabled(checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        highSpectrumChargeRangeTxt.setEnabled(checkSpectrumChargesComboBox.getSelectedIndex() == 0);
    }//GEN-LAST:event_checkSpectrumChargesComboBoxActionPerformed

    /**
     * Verify the input for the max spectra in mgf file.
     *
     * @param evt
     */
    private void mgfReducedSizeTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_mgfReducedSizeTxtKeyReleased
        mgfReducedSizeTxtActionPerformed(null);
    }//GEN-LAST:event_mgfReducedSizeTxtKeyReleased

    /**
     * Verify the input for the max spectra in mgf file.
     *
     * @param evt
     */
    private void mgfReducedSizeTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mgfReducedSizeTxtActionPerformed
        try {
            Integer.valueOf(mgfReducedSizeTxt.getText().trim());
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Maximum amount of spectra could not be parsed.",
                    "Input Error", JOptionPane.WARNING_MESSAGE);
            mgfReducedSizeTxt.setText(mgfReducedSizeTxt.getText());
        }
    }//GEN-LAST:event_mgfReducedSizeTxtActionPerformed

    /**
     * Verify the max mgf file size input.
     *
     * @param evt
     */
    private void mgfMaxSizeTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_mgfMaxSizeTxtKeyReleased
        mgfMaxSizeTxtActionPerformed(null);
    }//GEN-LAST:event_mgfMaxSizeTxtKeyReleased

    /**
     * Verify the max mgf file size input.
     *
     * @param evt
     */
    private void mgfMaxSizeTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mgfMaxSizeTxtActionPerformed
        try {
            Double.valueOf(mgfMaxSizeTxt.getText().trim());
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Maximum MGF file size could not be parsed.",
                    "Input Error", JOptionPane.WARNING_MESSAGE);
            mgfMaxSizeTxt.setText(mgfMaxSizeTxt.getText());
        }
    }//GEN-LAST:event_mgfMaxSizeTxtActionPerformed

    /**
     * Enable/disable the mgf file size filter input.
     *
     * @param evt
     */
    private void checkMgfFileSizeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkMgfFileSizeComboBoxActionPerformed
        maxMgfFileSizeLabel.setEnabled(checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        mgfMaxSizeTxt.setEnabled(checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        maxSpectraPerFileLabel.setEnabled(checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        mgfReducedSizeTxt.setEnabled(checkMgfFileSizeComboBox.getSelectedIndex() == 0);
    }//GEN-LAST:event_checkMgfFileSizeComboBoxActionPerformed

    /**
     * Enable/disable the zipping details.
     *
     * @param evt
     */
    private void groupResultFilesCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_groupResultFilesCmbActionPerformed
        boolean enabled = !((String) groupResultFilesCmb.getSelectedItem()).equalsIgnoreCase(OutputParameters.no_zip.name);
        includeDataTxt.setEnabled(enabled);
        includeDataCmb.setEnabled(enabled);
    }//GEN-LAST:event_groupResultFilesCmbActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel advancedParamatersPanel;
    private javax.swing.JComboBox checkMgfFileSizeComboBox;
    private javax.swing.JLabel checkMgfFileSizeLabel;
    private javax.swing.JComboBox checkSpectrumChargesComboBox;
    private javax.swing.JLabel checkSpectrumChargesLabel;
    private javax.swing.JButton closeButton;
    private javax.swing.JComboBox duplicateTitlesComboBox;
    private javax.swing.JLabel duplicateTitlesLabel;
    private javax.swing.JComboBox groupResultFilesCmb;
    private javax.swing.JLabel groupResultFilesTxt;
    private javax.swing.JTextField highSpectrumChargeRangeTxt;
    private javax.swing.JPanel identificationParametersPanel;
    private javax.swing.JComboBox includeDataCmb;
    private javax.swing.JLabel includeDataTxt;
    private javax.swing.JComboBox includeDateCmb;
    private javax.swing.JLabel includeDateLbl;
    private javax.swing.JTextField lowSpectrumChargeRangeTxt;
    private javax.swing.JLabel maxMgfFileSizeLabel;
    private javax.swing.JLabel maxSpectraPerFileLabel;
    private javax.swing.JTextField mgfMaxSizeTxt;
    private javax.swing.JTextField mgfReducedSizeTxt;
    private javax.swing.JButton okButton;
    private javax.swing.JButton openDialogHelpJButton;
    private javax.swing.JPanel outputPanel;
    private javax.swing.JComboBox peakPickingComboBox;
    private javax.swing.JLabel peakPickingLabel;
    private javax.swing.JLabel refMassLbl;
    private javax.swing.JTextField refMassTxt;
    private javax.swing.JComboBox renameCmb;
    private javax.swing.JLabel renameXTandemFileLabel;
    private javax.swing.JLabel spectrumChargeRangeDelimiterLabel;
    private javax.swing.JLabel spectrumChargeRangeLabel;
    private javax.swing.JPanel spectrumProcessingPanel;
    private javax.swing.JComboBox zipIdFilesCmb;
    private javax.swing.JLabel zipIdFilesLabel;
    // End of variables declaration//GEN-END:variables

    /**
     * Inspects the parameters validity.
     *
     * @param showMessage if true an error messages are shown to the users
     * @return a boolean indicating if the parameters are valid
     */
    public boolean validateAdvancedParametersInput(boolean showMessage) {

        boolean valid = true;

        valid = GuiUtilities.validateDoubleInput(this, maxMgfFileSizeLabel, mgfMaxSizeTxt, "mgf max size", "Mgf Max Size Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, maxSpectraPerFileLabel, mgfReducedSizeTxt, "max spectra in mgf file", "Max Spectra Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, refMassLbl, refMassTxt, "reference mass", "Reference Mass Error", true, showMessage, valid);

        boolean lowerChargeValid = GuiUtilities.validateIntegerInput(this, spectrumChargeRangeLabel, lowSpectrumChargeRangeTxt, "lower bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, spectrumChargeRangeLabel, highSpectrumChargeRangeTxt, "upper bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        if (!lowerChargeValid) {
            GuiUtilities.validateIntegerInput(this, spectrumChargeRangeLabel, lowSpectrumChargeRangeTxt, "lower bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        }

        // make sure that the lower charge is smaller than the upper charge
        try {
            int chargeLowerBound = Integer.parseInt(lowSpectrumChargeRangeTxt.getText().trim());
            int chargeUpperBound = Integer.parseInt(highSpectrumChargeRangeTxt.getText().trim());

            if (chargeUpperBound < chargeLowerBound) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The minimum precursor charge must be lower than or equal to the maximum precursor charge.",
                            "Precursor Charge Error", JOptionPane.WARNING_MESSAGE);
                }
                valid = false;
                spectrumChargeRangeLabel.setForeground(Color.RED);
                spectrumChargeRangeLabel.setToolTipText("Minimum precursor charge > Maximum precursor charge!");
            }

        } catch (NumberFormatException e) {
            // ignore, error already caught above
        }

        return valid;
    }
}
