/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ModificationtableContent {
    private final HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> map = new HashMap();
    private double totalIntensity = 0.0;
    private double maxIntensity = 0.0;

    public void addIntensity(int nMod, Integer peptideFragmentIonType, int aa, double intensity) {
        if (!this.map.containsKey(nMod)) {
            this.map.put(nMod, new HashMap());
        }
        if (!this.map.get(nMod).containsKey(peptideFragmentIonType)) {
            this.map.get(nMod).put(peptideFragmentIonType, new HashMap());
        }
        if (!this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            this.map.get(nMod).get(peptideFragmentIonType).put(aa, new ArrayList());
        }
        this.map.get(nMod).get(peptideFragmentIonType).get(aa).add(intensity);
        this.totalIntensity += intensity;
        if (intensity > this.maxIntensity) {
            this.maxIntensity = intensity;
        }
    }

    public ArrayList<Double> getIntensities(int nMod, Integer peptideFragmentIonType, int aa) {
        if (this.map.containsKey(nMod) && this.map.get(nMod).containsKey(peptideFragmentIonType) && this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            return this.map.get(nMod).get(peptideFragmentIonType).get(aa);
        }
        return new ArrayList<Double>();
    }

    public Double getQuantile(int nMod, Integer peptideFragmentIonType, int aa, double quantile) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        if (intensities.size() > 0) {
            int index = (int)(quantile * (double)intensities.size());
            return intensities.get(index);
        }
        return 0.0;
    }

    public int[] getHistogram(int nMod, Integer peptideFragmentIonType, int aa, int bins) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        int[] values = new int[bins];
        if (intensities.size() > 0) {
            for (Double intensity : intensities) {
                double currentIntensity = intensity;
                for (int j = 0; j < bins; ++j) {
                    double index = j;
                    if (!(index / (double)bins < currentIntensity) || !(currentIntensity < (index + 1.0) / (double)bins)) continue;
                    int n = j;
                    values[n] = values[n] + 1;
                }
                if (currentIntensity != 1.0) continue;
                int n = values.length - 1;
                values[n] = values[n] + 1;
            }
            return values;
        }
        return values;
    }

    public HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> getMap() {
        return this.map;
    }

    public void addAll(ModificationtableContent anotherContent) {
        for (int nMod : anotherContent.getMap().keySet()) {
            for (Integer peptideFragmentIonType : anotherContent.getMap().get(nMod).keySet()) {
                for (int nAA : anotherContent.getMap().get(nMod).get(peptideFragmentIonType).keySet()) {
                    for (double intensity : anotherContent.getIntensities(nMod, peptideFragmentIonType, nAA)) {
                        this.addIntensity(nMod, peptideFragmentIonType, nAA, intensity);
                    }
                }
            }
        }
    }

    public void normalize() {
        if (this.totalIntensity > 0.0) {
            double normalization = this.totalIntensity;
            this.totalIntensity = 0.0;
            this.maxIntensity = 0.0;
            for (int nMod : this.map.keySet()) {
                for (Integer peptideFragmentIonType : this.map.get(nMod).keySet()) {
                    for (int nAA : this.map.get(nMod).get(peptideFragmentIonType).keySet()) {
                        ArrayList<Double> tempIntensities = new ArrayList<Double>();
                        for (double intensity : this.getIntensities(nMod, peptideFragmentIonType, nAA)) {
                            tempIntensities.add(intensity / normalization);
                        }
                        this.map.get(nMod).get(peptideFragmentIonType).put(nAA, tempIntensities);
                    }
                }
            }
        }
    }

    public double getMaxIntensity() {
        return this.maxIntensity;
    }

    public static HashMap<PeptideFragmentIon, ArrayList<IonMatch>> getModificationPlotData(Peptide peptide, Modification modification, int nMod, String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationParameters, SpecificAnnotationParameters specificAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        ModificationMatch[] modificationMatches = peptide.getVariableModifications();
        ModificationMatch[] newMatches = (ModificationMatch[])Arrays.stream(modificationMatches).filter(modificationMatch -> !modificationMatch.getModification().equals(modification.getName())).toArray(ModificationMatch[]::new);
        Peptide noModPeptide = new Peptide(peptide.getSequence(), newMatches);
        PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
        HashMap<Integer, ArrayList<Ion>> fragmentIons = spectrumAnnotator.getExpectedIons(specificAnnotationParameters, noModPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        HashMap<PeptideFragmentIon, ArrayList<IonMatch>> map = new HashMap<PeptideFragmentIon, ArrayList<IonMatch>>();
        for (int i = 0; i <= nMod; ++i) {
            IonMatch[] matches;
            spectrumAnnotator.setMassShift((double)i * modification.getMass());
            block1: for (IonMatch ionMatch : matches = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, noModPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters)) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                for (Ion noModIon : fragmentIons.get(ionMatch.charge)) {
                    if (noModIon.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !peptideFragmentIon.isSameAs(noModIon)) continue;
                    PeptideFragmentIon noModFragmentIon = (PeptideFragmentIon)noModIon;
                    if (!map.containsKey(noModFragmentIon)) {
                        map.put(noModFragmentIon, new ArrayList(1));
                    }
                    map.get(noModFragmentIon).add(ionMatch);
                    continue block1;
                }
            }
        }
        return map;
    }

    public static ModificationtableContent getModificationTableContent(PeptideAssumption peptideAssumption, Modification modification, int nMod, String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        Peptide peptide = peptideAssumption.getPeptide();
        ModificationtableContent tableContent = new ModificationtableContent();
        HashSet<String> forbiddenMod = new HashSet<String>(1);
        forbiddenMod.add(modification.getName());
        Peptide noModPeptide = peptide.getNoModPeptide(forbiddenMod);
        PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, spectrumAnnotator);
        spectrumAnnotator.setPeptide(noModPeptide, peptideAssumption.getIdentificationCharge(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, specificAnnotationParameters);
        NeutralLossesMap lossesMap = new NeutralLossesMap();
        specificAnnotationParameters.getNeutralLossesMap().getAccountedNeutralLosses().stream().map(name -> NeutralLoss.getNeutralLoss(name)).filter(neutralLoss -> Math.abs(neutralLoss.getMass() - modification.getMass()) > specificAnnotationParameters.getFragmentIonAccuracyInDa(spectrum.getMaxMz())).forEach(neutralLoss -> lossesMap.addNeutralLoss((NeutralLoss)neutralLoss, 1, 1));
        int i = 0;
        while (i <= nMod) {
            spectrumAnnotator.setMassShift((double)i * modification.getMass());
            int index = i++;
            spectrumAnnotator.getSpectrumAnnotationStream(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, noModPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters).filter(ionMatch -> ionMatch.ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION).forEach(ionMatch -> {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                tableContent.addIntensity(index, peptideFragmentIon.getSubType(), peptideFragmentIon.getAaNumber(peptide.getSequence().length()), ionMatch.peakIntensity);
            });
        }
        return tableContent;
    }
}

