/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.peptide_mapping.performance;

import com.compomics.util.experiment.identification.modification.peptide_mapping.performance.PerformanceBenchmarkRunnable;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.waiting.Duration;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PerformanceBenchmark {
    public static final int REPLICATES = 10;

    public static void main(String[] args) {
        PerformanceBenchmark performanceBenchmark = new PerformanceBenchmark();
        String fileStem = args.length > 0 ? args[0] : "/home/marc/Github/papers/peptides-modifications-matching/benchmark/benchmark_23.02.02";
        try {
            performanceBenchmark.run(fileStem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run(String fileStem) throws InterruptedException, TimeoutException {
        this.benchmarkRandom(fileStem);
        this.benchmarkBySize(fileStem);
    }

    private void benchmarkRandom(String fileStem) throws InterruptedException, TimeoutException {
        try (SimpleFileWriter writer = new SimpleFileWriter(new File(fileStem + ".benchmark_threads"), false);){
            writer.writeLine("threads", "peptides", "replicate", "time", "failed");
            for (int i = 1; i <= 6; ++i) {
                for (int j = 1; j <= Runtime.getRuntime().availableProcessors() / 2; ++j) {
                    int nThreads = 2 * j;
                    int nPeptidesTotal = (int)Math.pow(10.0, i);
                    int nPeptides = nPeptidesTotal / nThreads;
                    for (int replicate = 1; replicate <= 10; ++replicate) {
                        System.out.println(Instant.now() + "    Random peptide - " + nPeptidesTotal + " peptides, " + nThreads + " threads (" + replicate + "/" + 10 + ")");
                        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
                        ArrayList<PerformanceBenchmarkRunnable> runnables = new ArrayList<PerformanceBenchmarkRunnable>(nThreads);
                        for (int threadI = 0; threadI < nThreads; ++threadI) {
                            PerformanceBenchmarkRunnable runnable2 = new PerformanceBenchmarkRunnable(nPeptides, null, null, null);
                            pool.submit(runnable2);
                            runnables.add(runnable2);
                        }
                        Duration duration = new Duration();
                        duration.start();
                        pool.shutdown();
                        if (!pool.awaitTermination(1L, TimeUnit.DAYS)) {
                            throw new TimeoutException("Analysis timed out (time out: 1 days)");
                        }
                        duration.end();
                        int nFailed = runnables.stream().mapToInt(runnable -> runnable.failedPeptides).sum();
                        writer.writeLine(Integer.toString(nThreads), Integer.toString(nPeptidesTotal), Integer.toString(replicate), Long.toString(duration.getDuration()), Integer.toString(nFailed));
                        System.gc();
                    }
                }
            }
        }
    }

    private void benchmarkBySize(String fileStem) throws InterruptedException, TimeoutException {
        try (SimpleFileWriter writer = new SimpleFileWriter(new File(fileStem + ".benchmark_size"), false);){
            writer.writeLine("modifications", "sites", "occupancy", "replicate", "time", "peptides", "failed");
            int nPeptides = 1000;
            for (int i = 1; i <= 10; ++i) {
                int nSites = 2 * i;
                for (int occupancy = 1; occupancy <= nSites; ++occupancy) {
                    for (int k = 1; k <= 5; ++k) {
                        int nMods = 2 * k;
                        for (int replicate = 1; replicate <= 10; ++replicate) {
                            System.out.println(Instant.now() + "    Size benchmark - " + occupancy + " in " + nSites + " sites, " + nMods + " modifications (" + replicate + "/" + 10 + ")");
                            PerformanceBenchmarkRunnable runnable = new PerformanceBenchmarkRunnable(nPeptides, nMods, nSites, occupancy);
                            Duration duration = new Duration();
                            duration.start();
                            runnable.run();
                            duration.end();
                            writer.writeLine(Integer.toString(nMods), Integer.toString(nSites), Integer.toString(occupancy), Integer.toString(replicate), Long.toString(duration.getDuration()), Integer.toString(nPeptides), Integer.toString(runnable.failedPeptides));
                            System.gc();
                        }
                    }
                }
            }
        }
    }
}

