/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.FeaturesMap;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAIdentityFeatureAbsolute;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAIdentityFeatureRelative;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyFeatureAbsolute;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyFeatureRelative;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyRelationshipFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ComplementaryIonAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ComplementaryIonFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ForwardIonAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ForwardIonFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ModificationFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.PeptideAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.PeptideFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.generic.AASequenceFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.generic.IonFeature;

public class FeaturesMapManager {
    public static FeaturesMap getDefaultFeaturesMap() {
        char[] aminoAcids;
        AminoAcid.Property[] properties;
        FeaturesMap featuresMap = new FeaturesMap();
        featuresMap.addFeature(new PeptideFeature(PeptideFeature.Property.mass));
        featuresMap.addFeature(new PeptideFeature(PeptideFeature.Property.length));
        for (AminoAcid.Property property : properties = new AminoAcid.Property[]{AminoAcid.Property.mass, AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI}) {
            featuresMap.addFeature(new AAPropertyFeatureAbsolute(0, property));
        }
        for (AminoAcid.Property property : properties) {
            featuresMap.addFeature(new AAPropertyFeatureAbsolute(-1, property));
        }
        for (AminoAcid.Property property : properties) {
            featuresMap.addFeature(new AAPropertyFeatureRelative(0, property));
        }
        for (AminoAcid.Property property : properties) {
            featuresMap.addFeature(new AAPropertyFeatureRelative(-1, property));
        }
        for (AminoAcid.Property property : properties) {
            featuresMap.addFeature(new AAPropertyFeatureRelative(1, property));
        }
        for (AminoAcid.Property property : properties) {
            featuresMap.addFeature(new AAPropertyFeatureRelative(2, property));
        }
        for (char aminoAcid : aminoAcids = new char[]{'D', 'E', 'K', 'P', 'R'}) {
            featuresMap.addFeature(new AAIdentityFeatureAbsolute(0, aminoAcid));
        }
        for (char aminoAcid : aminoAcids) {
            featuresMap.addFeature(new AAIdentityFeatureAbsolute(-1, aminoAcid));
        }
        for (char aminoAcid : aminoAcids) {
            featuresMap.addFeature(new AAIdentityFeatureRelative(0, aminoAcid));
        }
        for (char aminoAcid : aminoAcids) {
            featuresMap.addFeature(new AAIdentityFeatureRelative(1, aminoAcid));
        }
        featuresMap.addFeature(new PeptideAminoAcidFeature(AminoAcid.Property.mass, AASequenceFeature.Function.mean));
        properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI};
        AASequenceFeature.Function[] functions = new AASequenceFeature.Function[]{AASequenceFeature.Function.mean, AASequenceFeature.Function.maximum, AASequenceFeature.Function.minimum};
        for (AminoAcid.Property property : properties) {
            for (AASequenceFeature.Function function : functions) {
                featuresMap.addFeature(new PeptideAminoAcidFeature(property, function));
            }
        }
        properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI};
        functions = new AASequenceFeature.Function[]{AASequenceFeature.Function.mean, AASequenceFeature.Function.maximum, AASequenceFeature.Function.minimum};
        for (AminoAcid.Property property : properties) {
            for (AASequenceFeature.Function function : functions) {
                featuresMap.addFeature(new ForwardIonAminoAcidFeature(property, function));
            }
        }
        properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI};
        functions = new AASequenceFeature.Function[]{AASequenceFeature.Function.mean, AASequenceFeature.Function.maximum, AASequenceFeature.Function.minimum, AASequenceFeature.Function.sum};
        for (AminoAcid.Property property : properties) {
            for (AASequenceFeature.Function function : functions) {
                featuresMap.addFeature(new ComplementaryIonAminoAcidFeature(property, function));
            }
        }
        featuresMap.addFeature(new ForwardIonFeature(IonFeature.Property.length));
        featuresMap.addFeature(new ForwardIonFeature(IonFeature.Property.relativeLength));
        featuresMap.addFeature(new ForwardIonFeature(IonFeature.Property.mass));
        featuresMap.addFeature(new ForwardIonFeature(IonFeature.Property.massOverLength));
        featuresMap.addFeature(new ComplementaryIonFeature(IonFeature.Property.mass));
        featuresMap.addFeature(new ComplementaryIonFeature(IonFeature.Property.massOverLength));
        properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI};
        AAPropertyRelationshipFeature.Relationship[] relationships = new AAPropertyRelationshipFeature.Relationship[]{AAPropertyRelationshipFeature.Relationship.addition, AAPropertyRelationshipFeature.Relationship.multiplication};
        for (AminoAcid.Property property : properties) {
            AAPropertyFeatureRelative currentAminoAcidFeature = new AAPropertyFeatureRelative(0, property);
            AAPropertyFeatureRelative nextAminoAcidFeature = new AAPropertyFeatureRelative(1, property);
            for (AAPropertyRelationshipFeature.Relationship relationship : relationships) {
                featuresMap.addFeature(new AAPropertyRelationshipFeature(relationship, currentAminoAcidFeature, nextAminoAcidFeature));
            }
            featuresMap.addFeature(new AAPropertyRelationshipFeature(AAPropertyRelationshipFeature.Relationship.subtraction, currentAminoAcidFeature, nextAminoAcidFeature));
            featuresMap.addFeature(new AAPropertyRelationshipFeature(AAPropertyRelationshipFeature.Relationship.subtraction, nextAminoAcidFeature, currentAminoAcidFeature));
        }
        for (AminoAcid.Property property : properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI}) {
            AAPropertyFeatureRelative currentAminoAcidFeature = new AAPropertyFeatureRelative(0, property);
            AAPropertyFeatureAbsolute nTermAminoAcid = new AAPropertyFeatureAbsolute(0, property);
            featuresMap.addFeature(new AAPropertyRelationshipFeature(AAPropertyRelationshipFeature.Relationship.addition, currentAminoAcidFeature, nTermAminoAcid));
        }
        for (AminoAcid.Property property : properties = new AminoAcid.Property[]{AminoAcid.Property.basicity, AminoAcid.Property.helicity, AminoAcid.Property.hydrophobicity, AminoAcid.Property.pI}) {
            AAPropertyFeatureRelative currentAminoAcidFeature = new AAPropertyFeatureRelative(1, property);
            AAPropertyFeatureAbsolute cTermAminoAcid = new AAPropertyFeatureAbsolute(-1, property);
            featuresMap.addFeature(new AAPropertyRelationshipFeature(AAPropertyRelationshipFeature.Relationship.addition, currentAminoAcidFeature, cTermAminoAcid));
        }
        featuresMap.addFeature(new ModificationFeature(ModificationFeature.Property.mass));
        return featuresMap;
    }
}

