/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.SimplePeptideAnnotator;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import java.util.ArrayList;

public class FragmentAnnotator {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final double[] forwardIonMz1;
    private final double[] complementaryIonMz1;
    private final int peptideLength;
    private final int forwardIonType;
    private final int complementaryIonType;

    public FragmentAnnotator() {
        this.forwardIonMz1 = null;
        this.complementaryIonMz1 = null;
        this.peptideLength = 0;
        this.forwardIonType = 0;
        this.complementaryIonType = 0;
    }

    public FragmentAnnotator(Peptide peptide, String[] fixedModifications, SimplePeptideAnnotator.IonSeries ionSeries) {
        this(peptide, fixedModifications, ionSeries, true, true);
    }

    public FragmentAnnotator(Peptide peptide, String[] fixedModifications, SimplePeptideAnnotator.IonSeries ionSeries, boolean forward, boolean complementary) {
        double complementaryMass;
        double forwardMass;
        ModificationMatch[] modificationMatches;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        double[] modificationsMasses = new double[this.peptideLength];
        for (ModificationMatch modificationMatch : modificationMatches = peptide.getVariableModifications()) {
            String modificationName = modificationMatch.getModification();
            Modification modification = this.modificationFactory.getModification(modificationName);
            double modificationMass = modification.getMass();
            int i = modificationMatch.getSite();
            int site = i > 0 && i < this.peptideLength + 1 ? i - 1 : (i == 0 ? i : i - 2);
            int n = site;
            modificationsMasses[n] = modificationsMasses[n] + modificationMass;
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        for (int i = 0; i < this.peptideLength; ++i) {
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            forwardMass += modificationsMasses[i];
            if (forward) {
                this.forwardIonMz1[i] = forwardMass;
            }
            if (!complementary) continue;
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (int i = 0; i < this.peptideLength; ++i) {
            PeptideFragmentIon ion;
            double ionMz = this.forwardIonMz1[i];
            int[] indexes = spectrumIndex.getMatchingPeaks(ionMz);
            if (indexes.length > 0) {
                int ionNumber = i + 1;
                double ionMass = ionMz - ElementaryIon.proton.getTheoreticMass();
                for (int index : indexes) {
                    ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, null);
                    results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
                }
            }
            if ((indexes = spectrumIndex.getMatchingPeaks(ionMz = this.complementaryIonMz1[i])).length <= 0) continue;
            double ionMass = ionMz - ElementaryIon.proton.getTheoreticMass();
            int ionNumber = this.peptideLength - i - 1;
            for (int index : indexes) {
                ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, null);
                results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
            }
        }
        for (int ionCharge = 2; ionCharge < peptideCharge; ++ionCharge) {
            int extraProtons = ionCharge - 1;
            double protonContribution = ElementaryIon.getProtonMassMultiple(extraProtons);
            for (int i = 0; i < this.peptideLength; ++i) {
                PeptideFragmentIon ion;
                double ionMz1 = this.forwardIonMz1[i];
                double ionMz = (ionMz1 + protonContribution) / (double)ionCharge;
                int[] indexes = spectrumIndex.getMatchingPeaks(ionMz);
                if (indexes.length > 0) {
                    int ionNumber = i + 1;
                    double ionMass = ionMz1 - ElementaryIon.proton.getTheoreticMass();
                    for (int index : indexes) {
                        ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, null);
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, ionCharge));
                    }
                }
                if ((indexes = spectrumIndex.getMatchingPeaks(ionMz = ((ionMz1 = this.complementaryIonMz1[i]) + protonContribution) / (double)ionCharge)).length <= 0) continue;
                double ionMass = ionMz1 - ElementaryIon.proton.getTheoreticMass();
                int ionNumber = this.peptideLength - i - 1;
                for (int index : indexes) {
                    ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, null);
                    results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
                }
            }
        }
        return results;
    }
}

