/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PepxmlIdfileReader
implements IdfileReader {
    private ArrayList<SpectrumMatch> spectrumMatches = null;
    private String searchEngine = null;
    private String searchEngineVersion = null;
    private File idFile;
    private String spectrumFileName;
    private HashMap<Character, ArrayList<Double>> fixedModificationsMassDiffs;
    private ArrayList<Double> fixedModificationMasses;
    private ArrayList<Double> fixedNTerminalModifications = new ArrayList();
    private ArrayList<Double> fixedCTerminalModifications = new ArrayList();

    public PepxmlIdfileReader() {
    }

    public PepxmlIdfileReader(File idFile) {
        this.idFile = idFile;
    }

    private void parseFile(WaitingHandler waitingHandler, boolean expandAaCombinations, boolean overwriteExtension, SpectrumProvider spectrumProvider) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.idFile);){
            int type;
            parser.setInput(reader.getReader());
            boolean hasMatch = false;
            HashMap<Long, SpectrumMatch> spectrumMatchesMap = new HashMap<Long, SpectrumMatch>();
            this.spectrumMatches = new ArrayList();
            SpectrumMatch currentMatch = null;
            Integer currentCharge = null;
            while ((type = parser.next()) != 1) {
                String tagName = parser.getName();
                if (type == 2 && tagName.equals("msms_run_summary")) {
                    this.parseRunSummary(parser, overwriteExtension);
                }
                if (type == 2 && tagName.equals("search_summary")) {
                    this.parseSearchSummary(parser);
                }
                if (type == 2 && tagName.equals("spectrum_query")) {
                    currentMatch = this.parseSpectrumQuery(parser, spectrumProvider);
                    SpectrumMatch previousMatch = (SpectrumMatch)spectrumMatchesMap.get(currentMatch.getKey());
                    if (previousMatch != null) {
                        currentMatch = previousMatch;
                    }
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attributeName = parser.getAttributeName(i);
                        if (!attributeName.equals("assumed_charge")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            currentCharge = Integer.valueOf(value.trim());
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Charge " + value + " could not be parsed. Integer expected.");
                        }
                    }
                }
                if (type == 2 && tagName.equals("search_hit")) {
                    if (currentMatch == null) {
                        throw new IllegalArgumentException("No spectrum match when parsing search hit.");
                    }
                    if (currentCharge == null) {
                        throw new IllegalArgumentException("No charge found when parsing search hit of spectrum " + currentMatch.getKey() + ".");
                    }
                    PeptideAssumption peptideAssumption = this.parseSearchHit(parser, currentCharge);
                    Peptide peptide = peptideAssumption.getPeptide();
                    String peptideSequence = peptide.getSequence();
                    hasMatch = true;
                    boolean found = false;
                    if (currentMatch.getAllPeptideAssumptions().count() > 0L) {
                        for (PeptideAssumption tempPeptideAssumption : currentMatch.getAllPeptideAssumptions().collect(Collectors.toList())) {
                            boolean sameModifications;
                            Peptide tempPeptide = tempPeptideAssumption.getPeptide();
                            if (!peptide.getSequence().equals(tempPeptide.getSequence())) continue;
                            boolean bl = sameModifications = peptide.getNVariableModifications() == tempPeptide.getNVariableModifications();
                            if (sameModifications) {
                                for (ModificationMatch originalMatch : peptide.getVariableModifications()) {
                                    boolean modFound = false;
                                    for (ModificationMatch otherMatch : tempPeptide.getVariableModifications()) {
                                        if (!originalMatch.getModification().equals(otherMatch.getModification()) || originalMatch.getSite() != otherMatch.getSite()) continue;
                                        modFound = true;
                                        break;
                                    }
                                    if (modFound) continue;
                                    sameModifications = false;
                                    break;
                                }
                            }
                            if (!sameModifications) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        Advocate advocate = Advocate.getAdvocate(this.searchEngine);
                        if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                            ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                            for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                                ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                                Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                                PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                                currentMatch.addPeptideAssumption(advocate.getIndex(), newAssumption);
                            }
                        } else {
                            currentMatch.addPeptideAssumption(advocate.getIndex(), peptideAssumption);
                        }
                    }
                }
                if (type == 3 && tagName.equals("spectrum_query") && hasMatch) {
                    long key = currentMatch.getKey();
                    if (!spectrumMatchesMap.containsKey(key)) {
                        spectrumMatchesMap.put(key, currentMatch);
                        this.spectrumMatches.add(currentMatch);
                    }
                    hasMatch = false;
                    currentMatch = null;
                    currentCharge = null;
                }
                if (waitingHandler == null) continue;
                waitingHandler.isRunCanceled();
            }
            spectrumMatchesMap.clear();
        }
    }

    private PeptideAssumption parseSearchHit(XmlPullParser parser, int charge) throws XmlPullParserException, IOException {
        String attributeName;
        int type;
        Integer rank = null;
        String sequence = null;
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        Double score = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("hit_rank")) {
                String value = parser.getAttributeValue(i);
                try {
                    rank = Integer.valueOf(value.trim());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing rank " + value + ". Integer expected.");
                }
            }
            if (!name.equals("peptide")) continue;
            sequence = parser.getAttributeValue(i).trim();
        }
        while ((type = parser.next()) != 2) {
        }
        String tagName = parser.getName();
        if (tagName.equals("modification_info")) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                int site;
                boolean variableModification;
                String attributeName2 = parser.getAttributeName(i);
                if (!attributeName2.equals("mod_nterm_mass") && !attributeName2.equals("mod_cterm_mass")) continue;
                String value = parser.getAttributeValue(i).trim();
                Double terminalMass = null;
                try {
                    terminalMass = Double.valueOf(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing modification terminal mass " + value + ". Number expected.");
                }
                if (attributeName2.equals("mod_nterm_mass")) {
                    variableModification = !this.fixedNTerminalModifications.contains(terminalMass);
                } else {
                    boolean bl = variableModification = !this.fixedCTerminalModifications.contains(terminalMass);
                }
                if (!variableModification) continue;
                if (attributeName2.equals("mod_nterm_mass")) {
                    site = 1;
                    terminalMass = terminalMass - Atom.H.getMonoisotopicMass();
                } else {
                    site = sequence.length();
                    terminalMass = terminalMass - (Atom.O.getMonoisotopicMass() + Atom.H.getMonoisotopicMass());
                    if (this.searchEngine != null && this.searchEngine.equalsIgnoreCase("Comet") && this.searchEngineVersion != null && !this.searchEngineVersion.equalsIgnoreCase("2015.02 rev. 4") && !this.searchEngineVersion.equalsIgnoreCase("2015.02 rev. 5")) {
                        terminalMass = terminalMass - Atom.H.getMonoisotopicMass();
                    }
                }
                char aa = sequence.charAt(site - 1);
                terminalMass = Util.roundDouble(terminalMass, 2);
                String tempModificationName = terminalMass + "@" + aa;
                ModificationMatch modificationMatch = new ModificationMatch(tempModificationName, site);
                modificationMatches.add(modificationMatch);
            }
            while ((type = parser.next()) != 1) {
                tagName = parser.getName();
                if (tagName == null) continue;
                if (tagName.equals("mod_aminoacid_mass")) {
                    boolean variableModification;
                    Integer site = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attributeName3 = parser.getAttributeName(i);
                        if (!attributeName3.equals("position")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            site = Integer.valueOf(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("An error occurred while parsing modification position " + value + ". Integer expected.");
                        }
                    }
                    if (site == null) continue;
                    Double modifiedAaMass = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attributeName = parser.getAttributeName(i);
                        if (!attributeName.equals("mass")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            modifiedAaMass = Double.valueOf(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("An error occurred while parsing modification mass " + value + ". Number expected.");
                        }
                    }
                    if (modifiedAaMass == null) continue;
                    char aa = sequence.charAt(site - 1);
                    AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                    double fixedModificationMass = 0.0;
                    if (this.fixedModificationMasses.contains(modifiedAaMass)) {
                        variableModification = false;
                    } else {
                        if (this.fixedModificationsMassDiffs.get(Character.valueOf(aa)) != null) {
                            for (Double tempMassDiff : this.fixedModificationsMassDiffs.get(Character.valueOf(aa))) {
                                fixedModificationMass += tempMassDiff.doubleValue();
                            }
                        }
                        variableModification = true;
                    }
                    if (!variableModification) continue;
                    double modificationMass = modifiedAaMass - fixedModificationMass - aminoAcid.getMonoisotopicMass();
                    modificationMass = Util.roundDouble(modificationMass, 2);
                    String tempModificationName = modificationMass + "@" + aa;
                    ModificationMatch modificationMatch = new ModificationMatch(tempModificationName, site);
                    modificationMatches.add(modificationMatch);
                    continue;
                }
                if (type != 3 || !parser.getName().equals("modification_info")) continue;
                while ((type = parser.next()) != 2) {
                }
                break block13;
            }
        }
        while (type != 1) {
            tagName = parser.getName();
            if (tagName != null) {
                if (type == 2 && parser.getName().equals("search_score")) {
                    String name = null;
                    String value = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attributeName = parser.getAttributeName(i);
                        if (attributeName.equals("name")) {
                            name = parser.getAttributeValue(i);
                            continue;
                        }
                        if (!attributeName.equals("value")) continue;
                        value = parser.getAttributeValue(i);
                    }
                    if (name != null && value != null && (name.equals("expect") || name.equals("Morpheus Score"))) {
                        try {
                            score = Double.valueOf(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Impossible to parse expectation value " + value + ". Number expected.");
                        }
                    }
                } else if (type == 3 && tagName.equals("search_hit")) break;
            }
            type = parser.next();
        }
        Peptide peptide = new Peptide(sequence, modificationMatches.toArray(new ModificationMatch[modificationMatches.size()]), true);
        Advocate advocate = Advocate.getAdvocate(this.searchEngine);
        return new PeptideAssumption(peptide, rank, advocate.getIndex(), charge, score, score, this.idFile.getName());
    }

    private SpectrumMatch parseSpectrumQuery(XmlPullParser parser, SpectrumProvider spectrumProvider) throws XmlPullParserException, IOException {
        Integer index = null;
        String spectrumId = null;
        String spectrumNativeID = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("spectrum")) {
                spectrumId = parser.getAttributeValue(i);
                continue;
            }
            if (name.equals("index")) {
                String value = parser.getAttributeValue(i);
                try {
                    index = Integer.valueOf(value.trim());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing index " + value + ". Integer expected.");
                }
            }
            if (!name.equals("spectrumNativeID")) continue;
            spectrumNativeID = parser.getAttributeValue(i).trim();
            spectrumNativeID = URLDecoder.decode(spectrumNativeID, "utf-8");
        }
        if (index == null) {
            throw new IllegalArgumentException("No index found for spectrum " + spectrumId + ".");
        }
        String spectrumTitle = spectrumNativeID != null ? spectrumNativeID : spectrumProvider.getSpectrumTitles(IoUtil.removeExtension(this.spectrumFileName))[index];
        SpectrumMatch spectrumMatch = new SpectrumMatch(this.spectrumFileName, spectrumTitle);
        return spectrumMatch;
    }

    private void parseRunSummary(XmlPullParser parser, boolean overwriteExtension) throws XmlPullParserException, IOException {
        String path = "";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("base_name")) {
                path = path + parser.getAttributeValue(i);
                continue;
            }
            if (overwriteExtension || !name.equals("raw_data")) continue;
            path = path + parser.getAttributeValue(i);
        }
        if (overwriteExtension) {
            path = path + ".mgf";
        }
        File spectrumFile = new File(path);
        this.spectrumFileName = IoUtil.getFileName(spectrumFile);
    }

    private void parseSearchSummary(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("search_engine")) {
                this.searchEngine = parser.getAttributeValue(i);
                continue;
            }
            if (!name.equals("search_engine_version")) continue;
            this.searchEngineVersion = parser.getAttributeValue(i);
            if (this.searchEngineVersion.lastIndexOf("MSFragger") == -1) continue;
            this.searchEngine = "MSFragger";
        }
        this.fixedModificationsMassDiffs = new HashMap();
        this.fixedModificationMasses = new ArrayList();
        this.fixedNTerminalModifications = new ArrayList();
        this.fixedCTerminalModifications = new ArrayList();
        while (!((type = parser.next()) == 1 || type == 3 && parser.getName() != null && parser.getName().equals("search_summary"))) {
            if (type != 2) continue;
            String tagName = parser.getName();
            if (type == 2 && tagName.equals("aminoacid_modification")) {
                Character aminoacid = null;
                Boolean variable = null;
                Double massDiff = null;
                Double mass = null;
                block14: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String name;
                    switch (name = parser.getAttributeName(i)) {
                        case "aminoacid": {
                            aminoacid = Character.valueOf(parser.getAttributeValue(i).charAt(0));
                            continue block14;
                        }
                        case "massdiff": {
                            massDiff = Double.valueOf(parser.getAttributeValue(i));
                            continue block14;
                        }
                        case "mass": {
                            mass = Double.valueOf(parser.getAttributeValue(i));
                            continue block14;
                        }
                        case "variable": {
                            String variableAsString = parser.getAttributeValue(i);
                            if (variableAsString.equalsIgnoreCase("Y")) {
                                variable = true;
                                continue block14;
                            }
                            if (!variableAsString.equalsIgnoreCase("N")) continue block14;
                            variable = false;
                            continue block14;
                        }
                    }
                }
                if (variable != null && massDiff != null && mass != null && aminoacid != null) {
                    if (variable.booleanValue()) continue;
                    ArrayList<Double> massDiffs = this.fixedModificationsMassDiffs.get(aminoacid);
                    if (massDiffs == null) {
                        massDiffs = new ArrayList();
                    }
                    massDiffs.add(massDiff);
                    this.fixedModificationsMassDiffs.put(aminoacid, massDiffs);
                    this.fixedModificationMasses.add(mass);
                    continue;
                }
                throw new IllegalArgumentException("An error occurred while parsing aminoacid_modification element. Missing values.");
            }
            if (type != 2 || !tagName.equals("terminal_modification")) continue;
            Boolean variable = null;
            Double mass = null;
            String terminus = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                if (name.equals("terminus")) {
                    String terminusAsString = parser.getAttributeValue(i);
                    if (!terminusAsString.equalsIgnoreCase("N") && !terminusAsString.equalsIgnoreCase("C")) continue;
                    terminus = terminusAsString;
                    continue;
                }
                if (name.equals("mass")) {
                    mass = Double.valueOf(parser.getAttributeValue(i));
                    continue;
                }
                if (!name.equals("variable")) continue;
                String variableAsString = parser.getAttributeValue(i);
                if (variableAsString.equalsIgnoreCase("Y")) {
                    variable = true;
                    continue;
                }
                if (!variableAsString.equalsIgnoreCase("N")) continue;
                variable = false;
            }
            if (variable != null && mass != null && terminus != null) {
                if (variable.booleanValue()) continue;
                if (terminus.equalsIgnoreCase("N")) {
                    this.fixedNTerminalModifications.add(mass);
                    continue;
                }
                this.fixedCTerminalModifications.add(mass);
                continue;
            }
            throw new IllegalArgumentException("An error occurred while parsing terminal_modification element. Missing values.");
        }
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add(this.searchEngineVersion);
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(1);
        result.put(this.searchEngine, versions);
        return result;
    }

    @Override
    public String getExtension() {
        return ".pep.xml";
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        if (this.spectrumMatches == null) {
            this.parseFile(waitingHandler, expandAaCombinations, true, spectrumProvider);
        }
        return this.spectrumMatches;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

