/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.modification;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.modification.ModificationtableContent;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.extra.CellHighlighterRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ModificationTable
extends JTable {
    private final AnnotationParameters annotationParameters;
    private final Identification identification;
    private final ModificationParameters modificationParameters;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final SequenceMatchingParameters modificationSequenceMatchingParameters;
    private ArrayList<String> tooltips = new ArrayList();
    private final Modification modification;
    private int nModifications;
    private boolean areaChart = false;
    private double maxAreaChartValue = 0.0;
    private final ArrayList<Integer> modificationSites;
    private PeptideMatch peptideMatch;

    public ModificationTable(Identification identification, AnnotationParameters annotationParameters, PeptideMatch peptideMatch, Modification modification, boolean areaChart, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        this.identification = identification;
        this.annotationParameters = annotationParameters;
        this.modification = modification;
        this.nModifications = 0;
        this.peptideMatch = peptideMatch;
        this.areaChart = areaChart;
        this.modificationParameters = modificationParameters;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.modificationSequenceMatchingParameters = modificationSequenceMatchingParameters;
        this.modificationSites = new ArrayList();
        for (ModificationMatch modMatch : peptideMatch.getPeptide().getVariableModifications()) {
            if (!modMatch.getModification().equals(modification.getName())) continue;
            this.modificationSites.add(modMatch.getSite());
            ++this.nModifications;
        }
        this.setUpTable();
        this.addPeptideSequence();
        if (areaChart) {
            this.insertAreaCharts();
        } else {
            this.insertBarCharts();
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return (String)ModificationTable.this.tooltips.get(realIndex);
            }
        };
    }

    private void setUpTable() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
        JLabel label = (JLabel)((Object)renderer);
        label.setHorizontalAlignment(0);
        Vector<String> columnHeaders = new Vector<String>();
        ArrayList<Class<Integer>> tempColumnTypes = new ArrayList<Class<Integer>>();
        this.tooltips = new ArrayList();
        columnHeaders.add(" ");
        tempColumnTypes.add(Integer.class);
        this.tooltips.add("a, b and c ion index");
        if (this.annotationParameters.getFragmentIonTypes().contains(0)) {
            columnHeaders.add("a");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("a-ion");
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(1)) {
            columnHeaders.add("b");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("b-ion");
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(2)) {
            columnHeaders.add("c");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("c-ion");
        }
        columnHeaders.add("AA");
        tempColumnTypes.add(String.class);
        this.tooltips.add("amino acid sequence");
        if (this.annotationParameters.getFragmentIonTypes().contains(3)) {
            columnHeaders.add("x");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("x-ion");
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(4)) {
            columnHeaders.add("y");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("y-ion");
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(5)) {
            columnHeaders.add("z");
            if (this.areaChart) {
                tempColumnTypes.add(JSparklinesDataset.class);
            } else {
                tempColumnTypes.add(Double.class);
            }
            this.tooltips.add("z-ion");
        }
        columnHeaders.add("  ");
        tempColumnTypes.add(Integer.class);
        this.tooltips.add("x, y and z ion index");
        final ArrayList<Class<Integer>> columnTypes = tempColumnTypes;
        this.setModel(new DefaultTableModel(new Vector(), columnHeaders){

            public Class getColumnClass(int columnIndex) {
                return (Class)columnTypes.get(columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        int tempWidth = 30;
        this.getColumn(" ").setMaxWidth(tempWidth);
        this.getColumn(" ").setMinWidth(tempWidth);
        this.getColumn("  ").setMaxWidth(tempWidth);
        this.getColumn("  ").setMinWidth(tempWidth);
        this.getColumn("AA").setMaxWidth(tempWidth);
        this.getColumn("AA").setMinWidth(tempWidth);
        this.getColumn(" ").setCellRenderer((TableCellRenderer)new CellHighlighterRenderer(Color.LIGHT_GRAY, Color.YELLOW, 0, "*"));
        this.getColumn("  ").setCellRenderer((TableCellRenderer)new CellHighlighterRenderer(Color.LIGHT_GRAY, Color.YELLOW, 0, "*"));
        this.getColumn("AA").setCellRenderer((TableCellRenderer)new CellHighlighterRenderer(Color.LIGHT_GRAY, Color.YELLOW, 0, "*"));
    }

    private void addPeptideSequence() {
        int i;
        String peptideSequence = this.peptideMatch.getPeptide().getSequence();
        for (i = 0; i < peptideSequence.length(); ++i) {
            ((DefaultTableModel)this.getModel()).addRow(new Object[]{i + 1});
        }
        for (i = 0; i < peptideSequence.length(); ++i) {
            if (this.modificationSites.contains(i + 1)) {
                this.setValueAt(peptideSequence.charAt(i) + "*", i, this.getColumn("AA").getModelIndex());
            } else {
                this.setValueAt(Character.valueOf(peptideSequence.charAt(i)), i, this.getColumn("AA").getModelIndex());
            }
            this.setValueAt(peptideSequence.length() - i, i, this.getColumn("  ").getModelIndex());
        }
    }

    private void insertAreaCharts() {
        ModificationtableContent tableContent = new ModificationtableContent();
        Peptide peptide = this.peptideMatch.getPeptide();
        for (long spectrumMatchKey : this.peptideMatch.getSpectrumMatchesKeys()) {
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
            ModificationtableContent tempContent = ModificationtableContent.getModificationTableContent(spectrumMatch.getBestPeptideAssumption(), this.modification, this.nModifications, spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), spectrum, this.annotationParameters, this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters);
            tempContent.normalize();
            tableContent.addAll(tempContent);
        }
        this.maxAreaChartValue = 0.0;
        for (int aa = 0; aa < peptide.getSequence().length(); ++aa) {
            int column = 1;
            if (this.annotationParameters.getFragmentIonTypes().contains(0)) {
                this.addAreaChart(tableContent, 0, aa + 1, column);
                ++column;
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(1)) {
                this.addAreaChart(tableContent, 1, aa + 1, column);
                ++column;
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(2)) {
                this.addAreaChart(tableContent, 2, aa + 1, column);
                ++column;
            }
            ++column;
            if (this.annotationParameters.getFragmentIonTypes().contains(3)) {
                this.addAreaChart(tableContent, 3, peptide.getSequence().length() - aa, column);
                ++column;
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(4)) {
                this.addAreaChart(tableContent, 4, peptide.getSequence().length() - aa, column);
                ++column;
            }
            if (!this.annotationParameters.getFragmentIonTypes().contains(5)) continue;
            this.addAreaChart(tableContent, 5, peptide.getSequence().length() - aa, column);
            ++column;
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(0)) {
            try {
                this.getColumn("a").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(1)) {
            try {
                this.getColumn("b").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(2)) {
            try {
                this.getColumn("c").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(3)) {
            try {
                this.getColumn("x").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(4)) {
            try {
                this.getColumn("y").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.annotationParameters.getFragmentIonTypes().contains(5)) {
            try {
                this.getColumn("z").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, Double.valueOf(this.maxAreaChartValue)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void addAreaChart(ModificationtableContent tableContent, int fragmentIonType, int aa, int column) {
        ArrayList<JSparklinesDataSeries> sparkLineDataSeriesAll = new ArrayList<JSparklinesDataSeries>();
        String tempModification = "";
        String shortName = this.modification.getShortName();
        for (int modCpt = 0; modCpt <= this.nModifications; ++modCpt) {
            if (modCpt > 0) {
                tempModification = modCpt == 1 ? " <" + shortName + ">" : " <" + modCpt + shortName + ">";
            }
            ArrayList<Double> data = new ArrayList<Double>();
            int[] histogram = tableContent.getHistogram(modCpt, fragmentIonType, aa, 50);
            data.add(0.0);
            for (int frequency : histogram) {
                if (frequency <= 0) continue;
                data.add(Double.valueOf(frequency));
                if (!((double)frequency > this.maxAreaChartValue)) continue;
                this.maxAreaChartValue = frequency;
            }
            data.add(0.0);
            double colorCoef = this.nModifications == 0 ? 1.0 : 1.0 - 1.0 * (double)modCpt / (double)this.nModifications;
            Ion genericIon = Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, fragmentIonType, new NeutralLoss[0]);
            Color areaColor = SpectrumPanel.determineFragmentIonColor(genericIon, false);
            areaColor = new Color((int)(colorCoef * (double)areaColor.getRed()), (int)(colorCoef * (double)areaColor.getGreen()), (int)(colorCoef * (double)areaColor.getBlue()));
            String tooltip = "<html>" + PeptideFragmentIon.getSubTypeAsString(fragmentIonType) + "<sub>" + aa + "</sub>" + tempModification + "</html>";
            JSparklinesDataSeries sparklineDataseries = new JSparklinesDataSeries(data, areaColor, tooltip);
            sparkLineDataSeriesAll.add(sparklineDataseries);
        }
        JSparklinesDataset dataset = new JSparklinesDataset(sparkLineDataSeriesAll);
        this.setValueAt(dataset, aa - 1, column);
    }

    private void insertBarCharts() {
        ModificationtableContent tableContent = new ModificationtableContent();
        String shortName = this.modification.getShortName();
        Peptide peptide = this.peptideMatch.getPeptide();
        for (long spectrumMatchKey : this.peptideMatch.getSpectrumMatchesKeys()) {
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
            ModificationtableContent tempContent = ModificationtableContent.getModificationTableContent(spectrumMatch.getBestPeptideAssumption(), this.modification, this.nModifications, spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), spectrum, this.annotationParameters, this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters);
            tempContent.normalize();
            tableContent.addAll(tempContent);
        }
        for (int aa = 0; aa < peptide.getSequence().length(); ++aa) {
            int modCpt;
            int column = 1;
            for (modCpt = 0; modCpt <= this.nModifications; ++modCpt) {
                if (this.annotationParameters.getFragmentIonTypes().contains(0)) {
                    this.setValueAt(tableContent.getQuantile(modCpt, 0, aa + 1, 0.75), aa, column);
                    ++column;
                }
                if (this.annotationParameters.getFragmentIonTypes().contains(1)) {
                    this.setValueAt(tableContent.getQuantile(modCpt, 1, aa + 1, 0.75), aa, column);
                    ++column;
                }
                if (!this.annotationParameters.getFragmentIonTypes().contains(2)) continue;
                this.setValueAt(tableContent.getQuantile(modCpt, 2, aa + 1, 0.75), aa, column);
                ++column;
            }
            ++column;
            for (modCpt = 0; modCpt <= this.nModifications; ++modCpt) {
                if (this.annotationParameters.getFragmentIonTypes().contains(3)) {
                    this.setValueAt(tableContent.getQuantile(modCpt, 3, aa + 1, 0.75), aa, column);
                    ++column;
                }
                if (this.annotationParameters.getFragmentIonTypes().contains(4)) {
                    this.setValueAt(tableContent.getQuantile(modCpt, 4, aa + 1, 0.75), aa, column);
                    ++column;
                }
                if (!this.annotationParameters.getFragmentIonTypes().contains(5)) continue;
                this.setValueAt(tableContent.getQuantile(modCpt, 5, aa + 1, 0.75), aa, column);
                ++column;
            }
        }
        for (int modCpt = 0; modCpt <= this.nModifications; ++modCpt) {
            String tempModification = "";
            if (modCpt > 0) {
                tempModification = modCpt == 1 ? " <" + shortName + ">" : " <" + modCpt + shortName + ">";
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(0)) {
                try {
                    this.getColumn("a" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(0), false)));
                    ((JSparklinesBarChartTableCellRenderer)this.getColumn("a" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(1)) {
                try {
                    this.getColumn("b" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(1), false)));
                    ((JSparklinesBarChartTableCellRenderer)this.getColumn("b" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(2)) {
                try {
                    this.getColumn("c" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(2), false)));
                    ((JSparklinesBarChartTableCellRenderer)this.getColumn("c" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(3)) {
                try {
                    this.getColumn("x" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(3), false)));
                    ((JSparklinesBarChartTableCellRenderer)this.getColumn("x" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.annotationParameters.getFragmentIonTypes().contains(4)) {
                try {
                    this.getColumn("y" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(4), false)));
                    ((JSparklinesBarChartTableCellRenderer)this.getColumn("y" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!this.annotationParameters.getFragmentIonTypes().contains(5)) continue;
            try {
                this.getColumn("z" + tempModification).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tableContent.getMaxIntensity()), SpectrumPanel.determineFragmentIonColor(new PeptideFragmentIon(5), false)));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("z" + tempModification).getCellRenderer()).setMinimumChartValue(0.0);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

