/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class IntensityHistogram
extends JPanel {
    private ChartPanel chartPanel;

    public IntensityHistogram(IonMatch[] annotations, Spectrum currentSpectrum, double intensityThreshold, boolean lowResolution) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        double[] annotatedPeakIntensities = Arrays.stream(annotations).mapToDouble(ionMatch -> ionMatch.peakIntensity).toArray();
        HashSet annotatedPeakIntensitiesSet = Arrays.stream(annotatedPeakIntensities).boxed().collect(Collectors.toCollection(HashSet::new));
        double[] nonAnnotatedPeakIntensities = Arrays.stream(currentSpectrum.intensity).filter(intensity -> intensity > intensityThreshold && !annotatedPeakIntensitiesSet.contains(intensity)).toArray();
        int bins = 30;
        if (nonAnnotatedPeakIntensities.length > 0) {
            HistogramDataset dataset = new HistogramDataset();
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
            dataset.addSeries((Comparable)((Object)"Not Annotated"), nonAnnotatedPeakIntensities, bins, 0.0, currentSpectrum.getMaxIntensity());
            dataset.addSeries((Comparable)((Object)"Annotated"), annotatedPeakIntensities, bins, 0.0, currentSpectrum.getMaxIntensity());
            JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            this.chartPanel = new ChartPanel(chart, lowResolution);
            this.chartPanel.setBorder(null);
            chart.setBorderVisible(false);
            XYPlot plot = chart.getXYPlot();
            XYBarRenderer renderer = new XYBarRenderer();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            renderer.setShadowVisible(false);
            renderer.setSeriesPaint(0, (Paint)new Color(210, 210, 210, 150));
            renderer.setSeriesPaint(1, (Paint)new Color(110, 196, 97));
            plot.setRenderer((XYItemRenderer)renderer);
            plot.getRangeAxis().setRange(0.0, plot.getRangeAxis().getUpperBound());
            plot.setOutlineVisible(false);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            this.chartPanel.setBackground(Color.WHITE);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            this.add((Component)this.chartPanel);
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

