/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.codec.binary.Base64;

public class IoUtil {
    public static final String ENCODING = "UTF-8";
    public static final String DEFAULT_SEPARATOR = "\t";

    public static boolean emptyDir(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                boolean success = IoUtil.deleteDir(child);
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        boolean empty = IoUtil.emptyDir(dir);
        if (!empty) {
            return false;
        }
        return dir.delete();
    }

    public static void copyFile(File in, File out) throws IOException {
        IoUtil.copyFile(in, out, true);
    }

    public static void append(File in, File out) throws IOException {
        IoUtil.copyFile(in, out, false);
    }

    public static void copyFile(File in, File out, boolean overwrite) throws IOException {
        long start = 0L;
        if (out.exists() && out.length() > 0L) {
            if (overwrite) {
                out.delete();
            } else {
                start = out.length();
            }
        }
        try (FileChannel inChannel = new FileInputStream(in).getChannel();
             FileChannel outChannel = new FileOutputStream(out).getChannel();){
            for (long bytesCopied = 0L; bytesCopied < in.length(); bytesCopied += inChannel.transferTo(start + bytesCopied, inChannel.size(), outChannel)) {
            }
        }
    }

    public static String getFileName(String filePath) {
        int slash2;
        String tempFileName = filePath;
        int slash1 = tempFileName.lastIndexOf("/");
        int lastSlashIndex = Math.max(slash1, slash2 = tempFileName.lastIndexOf("\\"));
        if (lastSlashIndex != -1) {
            tempFileName = tempFileName.substring(lastSlashIndex + 1);
        }
        return tempFileName;
    }

    public static String getFileName(File file) {
        return IoUtil.getFileName(file.getAbsolutePath());
    }

    public static String getExtension(File file) {
        String fileName = IoUtil.getFileName(file.getAbsolutePath());
        return IoUtil.getExtension(fileName);
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        return index > 0 ? fileName.substring(index) : "";
    }

    public static String getFilenameExtensionLowerCase(String fileName) {
        return IoUtil.removeExtension(fileName) + IoUtil.getExtension(fileName).toLowerCase();
    }

    public static File existsExtensionNotCaseSensitive(File file) {
        if (file.exists()) {
            return file;
        }
        File folder = file.getParentFile();
        String fileName = file.getName();
        String nameExtensionLowerCase = IoUtil.getFilenameExtensionLowerCase(fileName);
        for (File tempFile : folder.listFiles()) {
            String tempName = tempFile.getName();
            String tempNameExtensionLowerCase = IoUtil.getFilenameExtensionLowerCase(tempName);
            if (!tempNameExtensionLowerCase.equals(nameExtensionLowerCase)) continue;
            return tempFile;
        }
        return file;
    }

    public static String appendSuffix(String fileName, String suffix) {
        String extension;
        String tempName;
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex > -1) {
            tempName = fileName.substring(0, fileName.lastIndexOf("."));
            extension = fileName.substring(fileName.lastIndexOf("."));
        } else {
            tempName = fileName;
            extension = "";
        }
        return tempName + suffix + extension;
    }

    public static String removeExtension(String fileName) {
        int pointIndex;
        if (fileName.endsWith(".gz")) {
            fileName = fileName.substring(0, fileName.length() - 3);
        }
        return (pointIndex = fileName.lastIndexOf(".")) > 0 ? fileName.substring(0, pointIndex) : fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveUrl(File saveFile, String targetUrlAsString, int fileSizeInBytes, String userName, String password, WaitingHandler waitingHandler) throws MalformedURLException, IOException, FileNotFoundException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            int contentLength;
            boolean urlExists = IoUtil.checkIfURLExists(targetUrlAsString, userName, password);
            if (!urlExists && targetUrlAsString.endsWith(".gz")) {
                targetUrlAsString = targetUrlAsString.substring(0, targetUrlAsString.length() - 3);
                saveFile = new File(saveFile.getAbsolutePath().substring(0, saveFile.getAbsolutePath().length() - 3));
            }
            URL targetUrl = new URL(targetUrlAsString);
            URLConnection urlConnection = targetUrl.openConnection();
            if (password != null) {
                String userpass = userName + ":" + password;
                String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
                urlConnection.setRequestProperty("Authorization", basicAuth);
            }
            if ((contentLength = urlConnection.getContentLength()) != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                waitingHandler.setMaxPrimaryProgressCounter(contentLength);
            } else if (fileSizeInBytes != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                contentLength = fileSizeInBytes;
                waitingHandler.setMaxPrimaryProgressCounter(contentLength);
            } else {
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
            }
            in = new BufferedInputStream(urlConnection.getInputStream());
            fout = new FileOutputStream(saveFile);
            long start = System.currentTimeMillis();
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1 && !waitingHandler.isRunCanceled()) {
                long now;
                fout.write(data, 0, count);
                if (contentLength == -1 || (now = System.currentTimeMillis()) - start <= 100L) continue;
                waitingHandler.setPrimaryProgressCounter((int)saveFile.length());
                start = System.currentTimeMillis();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        return saveFile;
    }

    public static boolean checkIfURLExists(String targetUrlAsString, String userName, String password) {
        try {
            URL targetUrl = new URL(targetUrlAsString);
            URLConnection urlConnection = targetUrl.openConnection();
            if (password != null) {
                String userpass = userName + ":" + password;
                String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
                urlConnection.setRequestProperty("Authorization", basicAuth);
            }
            InputStream inputStream = urlConnection.getInputStream();
            inputStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileSize(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            conn.disconnect();
        }
    }

    public static void closeBuffer(MappedByteBuffer buffer) {
        block6: {
            if (buffer == null || !buffer.isDirect()) {
                return;
            }
            boolean isOldJDK = System.getProperty("java.specification.version", "99").startsWith("1.");
            try {
                Class<?> unsafeClass;
                if (isOldJDK) {
                    Method cleaner = buffer.getClass().getMethod("cleaner", new Class[0]);
                    cleaner.setAccessible(true);
                    Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                    clean.setAccessible(true);
                    clean.invoke(cleaner.invoke((Object)buffer, new Object[0]), new Object[0]);
                    break block6;
                }
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Method clean = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                clean.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                clean.invoke(theUnsafe, buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

