/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarUtils {
    public static final int BUFFER_SIZE = 1024;

    public static void tarFolder(File folder, File destinationFile, WaitingHandler waitingHandler) throws ArchiveException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
        try (TarArchiveOutputStream tarOutput = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)bos);){
            tarOutput.setLongFileMode(2);
            File matchFolder = folder;
            TarUtils.addFolderContent((ArchiveOutputStream)tarOutput, matchFolder, waitingHandler);
        }
    }

    public static void tarFolderContent(File folder, File destinationFile, HashSet<String> exceptionsPaths, WaitingHandler waitingHandler) throws ArchiveException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
        try (TarArchiveOutputStream tarOutput = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)bos);){
            tarOutput.setLongFileMode(2);
            for (File file : folder.listFiles()) {
                String path = file.getAbsolutePath();
                if (exceptionsPaths.contains(path)) continue;
                if (file.isDirectory()) {
                    TarUtils.addFolderContent((ArchiveOutputStream)tarOutput, file, waitingHandler);
                    continue;
                }
                TarUtils.addFile((ArchiveOutputStream)tarOutput, file, waitingHandler);
            }
        }
    }

    public static void addFolderContent(ArchiveOutputStream tarOutput, File folder, WaitingHandler waitingHandler) throws IOException {
        TarUtils.addFolderContent(tarOutput, folder, null, waitingHandler);
    }

    private static void addFolderContent(ArchiveOutputStream tarOutput, File folder, String parentFolder, WaitingHandler waitingHandler) throws IOException {
        if (parentFolder == null) {
            parentFolder = folder.getParentFile().getAbsolutePath();
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                TarUtils.addFolderContent(tarOutput, file, parentFolder, waitingHandler);
                continue;
            }
            TarUtils.addFile(tarOutput, file, parentFolder, waitingHandler);
        }
    }

    private static void addFile(ArchiveOutputStream tarOutput, File file, WaitingHandler waitingHandler) throws IOException {
        TarUtils.addFile(tarOutput, file, null, waitingHandler);
    }

    private static void addFile(ArchiveOutputStream tarOutput, File file, String parentFolder, WaitingHandler waitingHandler) throws IOException {
        if (parentFolder == null) {
            parentFolder = file.getParentFile().getAbsolutePath();
        }
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            int count;
            byte[] data = new byte[1024];
            String filePath = file.getAbsolutePath();
            String relativePath = filePath.substring(parentFolder.length() + 1);
            TarArchiveEntry entry = new TarArchiveEntry(file, relativePath);
            tarOutput.putArchiveEntry((ArchiveEntry)entry);
            while ((count = input.read(data, 0, 1024)) != -1) {
                tarOutput.write(data, 0, count);
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            }
            tarOutput.closeArchiveEntry();
        }
    }

    public static void extractFile(File tarFile, WaitingHandler waitingHandler) throws ArchiveException, IOException {
        TarUtils.extractFile(tarFile, null, waitingHandler);
    }

    public static void extractFile(File tarFile, File destinationFolder, WaitingHandler waitingHandler) throws ArchiveException, IOException {
        byte[] data = new byte[1024];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(tarFile));){
            boolean isWindowsPlatform = System.getProperty("os.name").lastIndexOf("Windows") == -1;
            try (ArchiveInputStream tarInput = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);){
                ArchiveEntry archiveEntry;
                long fileLength = tarFile.length();
                while ((archiveEntry = tarInput.getNextEntry()) != null) {
                    String entryName = archiveEntry.getName();
                    entryName = isWindowsPlatform ? entryName.replaceAll("\\\\", "/") : entryName.replaceAll("/", "\\\\");
                    File entryFile = new File(entryName);
                    File entryFolder = destinationFolder == null ? entryFile.getParentFile() : new File(destinationFolder, entryName).getParentFile();
                    File destinationFile = new File(entryFolder, entryFile.getName());
                    if (archiveEntry.isDirectory()) {
                        destinationFile.mkdirs();
                    } else if (entryFolder.exists() || entryFolder.mkdirs()) {
                        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));){
                            int count;
                            while ((count = tarInput.read(data, 0, 1024)) != -1) {
                                bos.write(data, 0, count);
                                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                                break;
                            }
                        }
                        if (waitingHandler != null) {
                            int progress = (int)(100L * tarInput.getBytesRead() / fileLength);
                            waitingHandler.setSecondaryProgressCounter(progress);
                        }
                    } else {
                        throw new IOException("Folder " + destinationFolder.getAbsolutePath() + " does not exist and could not be created. Verify that you have the right to write in this directory.");
                    }
                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                    break;
                }
            }
        }
    }
}

