/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression;

import com.compomics.util.TempByteArray;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;

public class ZstdUtils {
    public static byte[] zstdDecompress(byte[] compressedByteArray, int uncompressedLength) {
        return ZstdUtils.zstdDecompress(new ZstdDecompressor(), compressedByteArray, uncompressedLength);
    }

    public static byte[] zstdDecompress(ZstdDecompressor decompressor, byte[] compressedByteArray, int uncompressedLength) {
        byte[] uncompressedByteAray = new byte[uncompressedLength];
        long decompressedBytes = decompressor.decompress(compressedByteArray, 0, compressedByteArray.length, uncompressedByteAray, 0, uncompressedLength);
        if (decompressedBytes != (long)uncompressedLength) {
            throw new IllegalArgumentException(decompressedBytes + " bytes decompressed where " + uncompressedLength + " expected.");
        }
        return uncompressedByteAray;
    }

    public static TempByteArray zstdCompress(byte[] uncompressedData) {
        return ZstdUtils.zstdCompress(new ZstdCompressor(), uncompressedData);
    }

    public static TempByteArray zstdCompress(ZstdCompressor compressor, byte[] uncompressedData) {
        int maxLength = compressor.maxCompressedLength(uncompressedData.length);
        int attempts = 0;
        while (true) {
            try {
                byte[] destinationArray = new byte[maxLength];
                int compressedArrayLength = compressor.compress(uncompressedData, 0, uncompressedData.length, destinationArray, 0, maxLength);
                return new TempByteArray(destinationArray, compressedArrayLength);
            }
            catch (IllegalStateException e) {
                if (attempts++ < 10) {
                    maxLength *= 2;
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

