/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.parameters.searchgui.OutputParameters;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;

public class UtilitiesUserParameters
extends ExperimentObject {
    static final long serialVersionUID = -4343570286224891504L;
    private static String USER_PARAMETERS_FILE = System.getProperty("user.home") + "/.compomics/userparameters.cup";
    private float spectrumAnnotatedPeakWidth = 1.0f;
    private float spectrumBackgroundPeakWidth = 1.0f;
    private Color spectrumAnnotatedPeakColor = Color.RED;
    private Color spectrumAnnotatedMirroredPeakColor = Color.BLUE;
    private Color spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
    private Color sparklineColorValidated = new Color(110, 196, 97);
    private Color sparklineColorNonValidated = new Color(208, 19, 19);
    private Color sparklineColorNotFound = new Color(222, 222, 222);
    private Color sparklineColorPossible = new Color(100, 150, 255);
    private Color sparklineColorDoubtful = new Color(255, 204, 0);
    private Color sparklineColorFalsePositive = new Color(255, 51, 51);
    private Color peptideSelected = new Color(0, 0, 255);
    private int memoryParameter = 4096;
    private String javaHome = null;
    private String proteoWizardPath = null;
    private String searchGuiPath = null;
    private String peptideShakerPath = null;
    private String deNovoGuiPath = null;
    private String reporterPath = null;
    private String relimsPath = null;
    private String localPrideFolder = "user.home";
    private String dbFolder = null;
    private String spectrumFolder = null;
    private String outputFolder = null;
    private ArrayList<String> readTweets = null;
    private ArrayList<String> displayedTips = null;
    private boolean autoUpdate = true;
    private LastSelectedFolder lastSelectedFolder = new LastSelectedFolder();
    private boolean sortPsmsOnRt = false;
    private boolean checkPeakPicking = true;
    private boolean checkDuplicateTitles = true;
    private boolean checkMgfSize = false;
    private double mgfMaxSize = 1000.0;
    private int mgfNSpectra = 25000;
    private double refMass = 2000.0;
    private boolean gzip = true;
    private OutputParameters outputOption = OutputParameters.grouped;
    private boolean outputData = false;
    private boolean includeDateInOutputName = false;
    private boolean renameXTandemFile = true;
    private boolean checkSpectrumCharges = true;
    private int minSpectrumChargeRange = 2;
    private int maxSpectrumChargeRange = 4;

    public Color getSparklineColor() {
        return this.sparklineColorValidated;
    }

    public void setSparklineColor(Color sparklineColorValidated) {
        this.sparklineColorValidated = sparklineColorValidated;
    }

    public Color getSparklineColorNonValidated() {
        if (this.sparklineColorNonValidated == null) {
            this.sparklineColorNonValidated = new Color(255, 0, 0);
        }
        return this.sparklineColorNonValidated;
    }

    public Color getPeptideSelected() {
        if (this.peptideSelected == null) {
            this.peptideSelected = new Color(0, 0, 255);
        }
        return this.peptideSelected;
    }

    public Color getSparklineColorNotFound() {
        if (this.sparklineColorNotFound == null) {
            this.sparklineColorNotFound = new Color(222, 222, 222);
        }
        return this.sparklineColorNotFound;
    }

    public void setSparklineColorNotFound(Color sparklineColorNotFound) {
        this.sparklineColorNotFound = sparklineColorNotFound;
    }

    public void setSparklineColorNonValidated(Color sparklineColorNonValidated) {
        this.sparklineColorNonValidated = sparklineColorNonValidated;
    }

    public Color getSparklineColorPossible() {
        return this.sparklineColorPossible;
    }

    public void setSparklineColorPossible(Color sparklineColorPossible) {
        this.sparklineColorPossible = sparklineColorPossible;
    }

    public Color getSparklineColorDoubtful() {
        return this.sparklineColorDoubtful;
    }

    public void setSparklineColorDoubtful(Color sparklineColorDoubtful) {
        this.sparklineColorDoubtful = sparklineColorDoubtful;
    }

    public Color getSparklineColorFalsePositives() {
        return this.sparklineColorFalsePositive;
    }

    public void setSparklineColorFalsePositives(Color sparklineColorFalsePositive) {
        this.sparklineColorFalsePositive = sparklineColorFalsePositive;
    }

    public Integer getMemoryParameter() {
        return this.memoryParameter;
    }

    public void setMemoryParameter(int memoryParameter) {
        this.memoryParameter = memoryParameter;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public Color getSpectrumAnnotatedPeakColor() {
        return this.spectrumAnnotatedPeakColor;
    }

    public void setSpectrumAnnotatedPeakColor(Color spectrumAnnotatedPeakColor) {
        this.spectrumAnnotatedPeakColor = spectrumAnnotatedPeakColor;
    }

    public Color getSpectrumAnnotatedMirroredPeakColor() {
        return this.spectrumAnnotatedMirroredPeakColor;
    }

    public void setSpectrumAnnotatedMirroredPeakColor(Color spectrumAnnotatedMirroredPeakColor) {
        this.spectrumAnnotatedMirroredPeakColor = spectrumAnnotatedMirroredPeakColor;
    }

    public Color getSpectrumBackgroundPeakColor() {
        return this.spectrumBackgroundPeakColor;
    }

    public void setSpectrumBackgroundPeakColor(Color spectrumBackgroundPeakColor) {
        this.spectrumBackgroundPeakColor = spectrumBackgroundPeakColor;
    }

    public float getSpectrumAnnotatedPeakWidth() {
        return this.spectrumAnnotatedPeakWidth;
    }

    public void setSpectrumAnnotatedPeakWidth(float spectrumAnnotatedPeakWidth) {
        this.spectrumAnnotatedPeakWidth = spectrumAnnotatedPeakWidth;
    }

    public float getSpectrumBackgroundPeakWidth() {
        return this.spectrumBackgroundPeakWidth;
    }

    public void setSpectrumBackgroundPeakWidth(float spectrumBackgroundPeakWidth) {
        this.spectrumBackgroundPeakWidth = spectrumBackgroundPeakWidth;
    }

    public String getSearchGuiPath() {
        return this.searchGuiPath;
    }

    public void setSearchGuiPath(String searchGuiPath) {
        this.searchGuiPath = searchGuiPath;
    }

    public String getDeNovoGuiPath() {
        return this.deNovoGuiPath;
    }

    public void setDeNovoGuiPath(String deNovoGuiPath) {
        this.deNovoGuiPath = deNovoGuiPath;
    }

    public String getProteoWizardPath() {
        return this.proteoWizardPath;
    }

    public void setProteoWizardPath(String proteoWizardPath) {
        this.proteoWizardPath = proteoWizardPath;
    }

    public String getRelimsPath() {
        return this.relimsPath;
    }

    public void setRelimsPath(String relimsPath) {
        this.relimsPath = relimsPath;
    }

    public String getPeptideShakerPath() {
        return this.peptideShakerPath;
    }

    public void setPeptideShakerPath(String peptideShakerPath) {
        this.peptideShakerPath = peptideShakerPath;
    }

    public String getReporterPath() {
        return this.reporterPath;
    }

    public void setReporterPath(String reporterPath) {
        this.reporterPath = reporterPath;
    }

    public static void saveUserParameters(UtilitiesUserParameters userParameters) {
        try {
            File file = new File(USER_PARAMETERS_FILE);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            JsonMarshaller marshaller = new JsonMarshaller();
            marshaller.saveObjectToJson(userParameters, file);
        }
        catch (Exception e) {
            System.err.println("An error occurred while saving " + USER_PARAMETERS_FILE + ".");
            e.printStackTrace();
        }
    }

    public static UtilitiesUserParameters loadUserParameters() {
        UtilitiesUserParameters userParameters;
        File file = new File(USER_PARAMETERS_FILE);
        if (!file.exists()) {
            userParameters = new UtilitiesUserParameters();
            UtilitiesUserParameters.saveUserParameters(userParameters);
        } else {
            try {
                JsonMarshaller marshaller = new JsonMarshaller();
                userParameters = (UtilitiesUserParameters)marshaller.fromJson(UtilitiesUserParameters.class, file);
            }
            catch (Exception e) {
                System.err.println("An error occurred while loading " + USER_PARAMETERS_FILE + ". Parameters set back to default.");
                e.printStackTrace();
                userParameters = new UtilitiesUserParameters();
                UtilitiesUserParameters.saveUserParameters(userParameters);
            }
        }
        return userParameters;
    }

    public String getLocalPrideFolder() {
        return this.localPrideFolder;
    }

    public void setLocalPrideFolder(String localPrideFolder) {
        this.localPrideFolder = localPrideFolder;
    }

    public File getDbFolder() {
        return this.dbFolder != null ? new File(this.dbFolder) : null;
    }

    public void setDbFolder(File dbFolder) {
        this.dbFolder = dbFolder.getAbsolutePath();
    }

    public File getSpectrumFolder() {
        return this.spectrumFolder != null ? new File(this.spectrumFolder) : null;
    }

    public void setSpectrumFolder(File spectrumFolder) {
        this.spectrumFolder = spectrumFolder.getAbsolutePath();
    }

    public File getOutputFolder() {
        return this.outputFolder != null ? new File(this.outputFolder) : null;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder.getAbsolutePath();
    }

    public ArrayList<String> getReadTweets() {
        if (this.readTweets == null) {
            this.readTweets = new ArrayList(0);
        }
        return this.readTweets;
    }

    public void setReadTweets(ArrayList<String> readTweets) {
        this.readTweets = readTweets;
    }

    public ArrayList<String> getDisplayedTips() {
        return this.displayedTips;
    }

    public void setDisplayedTips(ArrayList<String> displayedTips) {
        this.displayedTips = displayedTips;
    }

    public static String getUserParametersFile() {
        return USER_PARAMETERS_FILE;
    }

    public static String getUserParametersFolder() {
        File tempFile = new File(UtilitiesUserParameters.getUserParametersFile());
        return tempFile.getParent();
    }

    public static void setUserParametersFolder(String userParametersFolder) {
        File tempFile = new File(userParametersFolder, "/utilities_userPreferences.cup");
        USER_PARAMETERS_FILE = tempFile.getAbsolutePath();
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public LastSelectedFolder getLastSelectedFolder() {
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    public boolean getSortPsmsOnRt() {
        return this.sortPsmsOnRt;
    }

    public void setSortPsmsOnRt(Boolean sortPsmsOnRt) {
        this.sortPsmsOnRt = sortPsmsOnRt;
    }

    public boolean checkPeakPicking() {
        return this.checkPeakPicking;
    }

    public void setCheckPeakPicking(boolean checkPeakPicking) {
        this.checkPeakPicking = checkPeakPicking;
    }

    public boolean checkDuplicateTitles() {
        return this.checkDuplicateTitles;
    }

    public void setCheckDuplicateTitles(boolean checkDuplicateTitles) {
        this.checkDuplicateTitles = checkDuplicateTitles;
    }

    public boolean checkMgfSize() {
        return this.checkMgfSize;
    }

    public void setCheckMgfSize(boolean checkMgfSize) {
        this.checkMgfSize = checkMgfSize;
    }

    public double getMgfMaxSize() {
        return this.mgfMaxSize;
    }

    public void setMgfMaxSize(double mgfMaxSize) {
        this.mgfMaxSize = mgfMaxSize;
    }

    public int getMgfNSpectra() {
        return this.mgfNSpectra;
    }

    public void setMgfNSpectra(int mgfNSpectra) {
        this.mgfNSpectra = mgfNSpectra;
    }

    public double getRefMass() {
        return this.refMass;
    }

    public void setRefMass(double refMass) {
        this.refMass = refMass;
    }

    public void setSearchGuiOutputParameters(OutputParameters outputOption) {
        this.outputOption = outputOption;
    }

    public OutputParameters getSearchGuiOutputParameters() {
        return this.outputOption;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public boolean outputData() {
        return this.outputData;
    }

    public void setOutputData(boolean outputData) {
        this.outputData = outputData;
    }

    public boolean isIncludeDateInOutputName() {
        return this.includeDateInOutputName;
    }

    public void setIncludeDateInOutputName(boolean includeDateInOutputName) {
        this.includeDateInOutputName = includeDateInOutputName;
    }

    public boolean renameXTandemFile() {
        return this.renameXTandemFile;
    }

    public void setRenameXTandemFile(boolean renameXTandemFile) {
        this.renameXTandemFile = renameXTandemFile;
    }

    public boolean isCheckSpectrumCharges() {
        return this.checkSpectrumCharges;
    }

    public void setCheckSpectrumCharges(boolean checkSpectrumCharges) {
        this.checkSpectrumCharges = checkSpectrumCharges;
    }

    public int getMinSpectrumChargeRange() {
        return this.minSpectrumChargeRange;
    }

    public void setMinSpectrumChargeRange(int minSpectrumChargeRange) {
        this.minSpectrumChargeRange = minSpectrumChargeRange;
    }

    public int getMaxSpectrumChargeRange() {
        return this.maxSpectrumChargeRange;
    }

    public void setMaxSpectrumChargeRange(int maxSpectrumChargeRange) {
        this.maxSpectrumChargeRange = maxSpectrumChargeRange;
    }

    public File getDbSummaryFolder() {
        return new File(UtilitiesUserParameters.getUserParametersFolder(), "fastaSummary");
    }
}

