/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;

public class CometParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -2996752557726296967L;
    private Integer numberOfSpectrumMatches = 10;
    private Integer maxVariableMods = 10;
    private Boolean requireVariableMods = false;
    private Integer minPeaks = 10;
    private Double minPeakIntensity = 0.0;
    private Integer removePrecursor = 0;
    private Double removePrecursorTolerance = 1.5;
    private Double lowerClearMzRange = 0.0;
    private Double upperClearMzRange = 0.0;
    private Integer enzymeType = 2;
    private Integer isotopeCorrection = 3;
    private Double minPrecursorMass = 600.0;
    private Double maxPrecursorMass = 5000.0;
    private Integer maxFragmentCharge = 3;
    private Boolean removeMethionine = false;
    private Integer batchSize = 0;
    private Boolean theoreticalFragmentIonsSumOnly = false;
    private Double fragmentBinOffset = 0.0;
    private Boolean useSparseMatrix = true;
    private CometOutputFormat selectedOutputFormat = CometOutputFormat.PepXML;
    private Boolean printExpectScore = true;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.comet;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof CometParameters) {
            CometParameters cometParameters = (CometParameters)identificationAlgorithmParameter;
            if (!this.numberOfSpectrumMatches.equals(cometParameters.getNumberOfSpectrumMatches())) {
                return false;
            }
            if (!this.maxVariableMods.equals(cometParameters.getMaxVariableMods())) {
                return false;
            }
            if (this.getRequireVariableMods() != cometParameters.getRequireVariableMods()) {
                return false;
            }
            if (!this.minPeaks.equals(cometParameters.getMinPeaks())) {
                return false;
            }
            double diff = Math.abs(this.minPeakIntensity - cometParameters.getMinPeakIntensity());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.removePrecursor.equals(cometParameters.getRemovePrecursor())) {
                return false;
            }
            diff = Math.abs(this.removePrecursorTolerance - cometParameters.getRemovePrecursorTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.lowerClearMzRange - cometParameters.getLowerClearMzRange());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.upperClearMzRange - cometParameters.getUpperClearMzRange());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.enzymeType.equals(cometParameters.getEnzymeType())) {
                return false;
            }
            if (!this.isotopeCorrection.equals(cometParameters.getIsotopeCorrection())) {
                return false;
            }
            diff = Math.abs(this.minPrecursorMass - cometParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorMass - cometParameters.getMaxPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.minPeptideLength.equals(cometParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(cometParameters.getMaxPeptideLength())) {
                return false;
            }
            if (!this.maxFragmentCharge.equals(cometParameters.getMaxFragmentCharge())) {
                return false;
            }
            if (!this.removeMethionine.equals(cometParameters.getRemoveMethionine())) {
                return false;
            }
            if (!this.batchSize.equals(cometParameters.getBatchSize())) {
                return false;
            }
            if (!this.theoreticalFragmentIonsSumOnly.equals(cometParameters.getTheoreticalFragmentIonsSumOnly())) {
                return false;
            }
            diff = Math.abs(this.fragmentBinOffset - cometParameters.getFragmentBinOffset());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.useSparseMatrix.equals(cometParameters.getUseSparseMatrix())) {
                return false;
            }
            if (this.getSelectedOutputFormat() != cometParameters.getSelectedOutputFormat()) {
                return false;
            }
            return this.getPrintExpectScore() == cometParameters.getPrintExpectScore();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMatches);
        output.append(newLine);
        output.append("MAX_VARIABLE_MODS=");
        output.append(this.maxVariableMods);
        output.append(newLine);
        output.append("REQUIRE_VARIABLE_MODS=");
        output.append(this.requireVariableMods);
        output.append(newLine);
        output.append("MIN_PEAKS=");
        output.append(this.minPeaks);
        output.append(newLine);
        output.append("MIN_PEAKS_INTENSITY=");
        output.append(this.minPeakIntensity);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR=");
        output.append(this.removePrecursor);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR_TOLERANCE=");
        output.append(this.removePrecursorTolerance);
        output.append(newLine);
        output.append("LOWER_CLEAR_MZ_RANGE=");
        output.append(this.lowerClearMzRange);
        output.append(newLine);
        output.append("UPPER_CLEAR_MZ_RANGE=");
        output.append(this.upperClearMzRange);
        output.append(newLine);
        output.append("ENZYME_TYPE=");
        output.append(this.enzymeType);
        output.append(newLine);
        output.append("ISOTOPE_CORRECTION=");
        output.append(this.isotopeCorrection);
        output.append(newLine);
        output.append("MIN_PRECURSOR_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("MAX_PRECURSOR_MASS=");
        output.append(this.maxPrecursorMass);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("MAX_FRAGMENT_CHARGE=");
        output.append(this.maxFragmentCharge);
        output.append(newLine);
        output.append("REMOVE_METHIONINE=");
        output.append(this.removeMethionine);
        output.append(newLine);
        output.append("BATCH_SIZE=");
        output.append(this.batchSize);
        output.append(newLine);
        output.append("THEORETICAL_FRAGMENT_IONS_SUM_ONLY=");
        output.append(this.theoreticalFragmentIonsSumOnly);
        output.append(newLine);
        output.append("FRAGMENT_BIN_OFFSET=");
        output.append(this.fragmentBinOffset);
        output.append(newLine);
        output.append("USE_SPARSE_MATRIX=");
        output.append(this.useSparseMatrix);
        output.append(newLine);
        output.append("OUTPUT_FORAMT=");
        output.append((Object)this.getSelectedOutputFormat());
        output.append(newLine);
        output.append("PRINT_EXPECT_SCORE=");
        output.append(this.getPrintExpectScore());
        output.append(newLine);
        return output.toString();
    }

    public Integer getNumberOfSpectrumMatches() {
        if (this.numberOfSpectrumMatches == null) {
            this.numberOfSpectrumMatches = 10;
        }
        return this.numberOfSpectrumMatches;
    }

    public void setNumberOfSpectrumMatches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMatches = numberOfSpectrumMarches;
    }

    public Integer getMaxVariableMods() {
        return this.maxVariableMods;
    }

    public void setMaxVariableMods(Integer maxVariableMods) {
        this.maxVariableMods = maxVariableMods;
    }

    public Integer getMinPeaks() {
        return this.minPeaks;
    }

    public void setMinPeaks(Integer minPeaks) {
        this.minPeaks = minPeaks;
    }

    public Double getMinPeakIntensity() {
        return this.minPeakIntensity;
    }

    public void setMinPeakIntensity(Double minPeakIntensity) {
        this.minPeakIntensity = minPeakIntensity;
    }

    public Integer getRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Integer removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Double getRemovePrecursorTolerance() {
        return this.removePrecursorTolerance;
    }

    public void setRemovePrecursorTolerance(Double removePrecursorTolerance) {
        this.removePrecursorTolerance = removePrecursorTolerance;
    }

    public Double getLowerClearMzRange() {
        return this.lowerClearMzRange;
    }

    public void setLowerClearMzRange(Double lowerClearMzRange) {
        this.lowerClearMzRange = lowerClearMzRange;
    }

    public Double getUpperClearMzRange() {
        return this.upperClearMzRange;
    }

    public void setUpperClearMzRange(Double upperClearMzRange) {
        this.upperClearMzRange = upperClearMzRange;
    }

    public Integer getEnzymeType() {
        return this.enzymeType;
    }

    public void setEnzymeType(Integer enzymeType) {
        this.enzymeType = enzymeType;
    }

    public Integer getIsotopeCorrection() {
        return this.isotopeCorrection;
    }

    public void setIsotopeCorrection(Integer isotopeCorrection) {
        this.isotopeCorrection = isotopeCorrection;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMaxPrecursorMass() {
        return this.maxPrecursorMass;
    }

    public void setMaxPrecursorMass(Double maxPrecursorMass) {
        this.maxPrecursorMass = maxPrecursorMass;
    }

    public Integer getMaxFragmentCharge() {
        return this.maxFragmentCharge;
    }

    public void setMaxFragmentCharge(Integer maxFragmentCharge) {
        this.maxFragmentCharge = maxFragmentCharge;
    }

    public Boolean getRemoveMethionine() {
        return this.removeMethionine;
    }

    public void setRemoveMethionine(Boolean removeMethionine) {
        this.removeMethionine = removeMethionine;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Boolean getTheoreticalFragmentIonsSumOnly() {
        return this.theoreticalFragmentIonsSumOnly;
    }

    public void setTheoreticalFragmentIonsSumOnly(Boolean theoreticalFragmentIonsSumOnly) {
        this.theoreticalFragmentIonsSumOnly = theoreticalFragmentIonsSumOnly;
    }

    public Double getFragmentBinOffset() {
        return this.fragmentBinOffset;
    }

    public void setFragmentBinOffset(Double fragmentBinOffset) {
        this.fragmentBinOffset = fragmentBinOffset;
    }

    public Boolean getUseSparseMatrix() {
        return this.useSparseMatrix;
    }

    public void setUseSparseMatrix(Boolean useSparseMatrix) {
        this.useSparseMatrix = useSparseMatrix;
    }

    public boolean getRequireVariableMods() {
        if (this.requireVariableMods == null) {
            this.requireVariableMods = false;
        }
        return this.requireVariableMods;
    }

    public void setRequireVariableMods(Boolean requireVariableMods) {
        this.requireVariableMods = requireVariableMods;
    }

    public boolean getPrintExpectScore() {
        if (this.printExpectScore == null) {
            this.printExpectScore = true;
        }
        return this.printExpectScore;
    }

    public void setPrintExpectScore(boolean printExpectScore) {
        this.printExpectScore = printExpectScore;
    }

    public CometOutputFormat getSelectedOutputFormat() {
        if (this.selectedOutputFormat == null) {
            this.selectedOutputFormat = CometOutputFormat.PepXML;
        }
        return this.selectedOutputFormat;
    }

    public void setSelectedOutputFormat(CometOutputFormat selectedOutputFormat) {
        this.selectedOutputFormat = selectedOutputFormat;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(int maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(int minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public static enum CometOutputFormat {
        PepXML,
        SQT,
        TXT,
        Percolator,
        mzIdentML;

    }
}

