/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.quantification.spectrum_counting;

import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.quantification.spectrumcounting.SpectrumCountingMethod;
import com.compomics.util.experiment.units.MetricsPrefix;
import com.compomics.util.experiment.units.StandardUnit;
import com.compomics.util.experiment.units.UnitOfMeasurement;

public class SpectrumCountingParameters
extends ExperimentObject {
    private Double referenceMass = 2.0;
    private UnitOfMeasurement unit = new UnitOfMeasurement(StandardUnit.mol, MetricsPrefix.femto);
    private Boolean normalize = true;
    private SpectrumCountingMethod selectedMethod;
    private Integer matchValidationLevel;

    public SpectrumCountingParameters() {
        this.selectedMethod = SpectrumCountingMethod.NSAF;
        this.matchValidationLevel = MatchValidationLevel.doubtful.getIndex();
    }

    public SpectrumCountingParameters(SpectrumCountingParameters otherSpectrumCountingPreferences) {
        this.selectedMethod = otherSpectrumCountingPreferences.getSelectedMethod();
        this.normalize = otherSpectrumCountingPreferences.getNormalize();
        this.referenceMass = otherSpectrumCountingPreferences.getReferenceMass();
        this.unit = otherSpectrumCountingPreferences.getUnit();
    }

    public SpectrumCountingMethod getSelectedMethod() {
        return this.selectedMethod;
    }

    public void setSelectedMethod(SpectrumCountingMethod selectedMethod) {
        this.selectedMethod = selectedMethod;
    }

    public Integer getMatchValidationLevel() {
        return this.matchValidationLevel;
    }

    public void setMatchValidationLevel(Integer matchValidationLevel) {
        this.matchValidationLevel = matchValidationLevel;
    }

    public boolean isSameAs(SpectrumCountingParameters anotherSpectrumCountingPreferences) {
        if (!this.getNormalize().booleanValue() && anotherSpectrumCountingPreferences.getNormalize().booleanValue() || this.getNormalize().booleanValue() && !anotherSpectrumCountingPreferences.getNormalize().booleanValue()) {
            return false;
        }
        if (this.getNormalize().booleanValue() && anotherSpectrumCountingPreferences.getNormalize().booleanValue()) {
            if (!this.getUnit().isSameAs(anotherSpectrumCountingPreferences.getUnit())) {
                return false;
            }
            if (this.getReferenceMass() != null && anotherSpectrumCountingPreferences.getReferenceMass() == null || this.getReferenceMass() == null && anotherSpectrumCountingPreferences.getReferenceMass() != null) {
                return false;
            }
            if (this.getReferenceMass() != null && anotherSpectrumCountingPreferences.getReferenceMass() != null && !this.getReferenceMass().equals(anotherSpectrumCountingPreferences.getReferenceMass())) {
                return false;
            }
        }
        return anotherSpectrumCountingPreferences.getSelectedMethod() == this.selectedMethod && anotherSpectrumCountingPreferences.getMatchValidationLevel().equals(this.getMatchValidationLevel());
    }

    public Double getReferenceMass() {
        return this.referenceMass;
    }

    public void setReferenceMass(Double referenceMass) {
        this.referenceMass = referenceMass;
    }

    public UnitOfMeasurement getUnit() {
        return this.unit;
    }

    public void setUnit(UnitOfMeasurement unit) {
        this.unit = unit;
    }

    public Boolean getNormalize() {
        return this.normalize;
    }

    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }
}

