/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileExporter;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardMsFormat;
import com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.ThermoRawFileParserParameters;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.GzUtils;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.CometParameters;
import com.compomics.util.parameters.identification.tool_specific.MetaMorpheusParameters;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import com.compomics.util.parameters.identification.tool_specific.MyriMatchParameters;
import com.compomics.util.parameters.identification.tool_specific.OmssaParameters;
import com.compomics.util.parameters.identification.tool_specific.TideParameters;
import com.compomics.util.parameters.searchgui.OutputParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.AndromedaProcessBuilder;
import eu.isas.searchgui.processbuilders.CometProcessBuilder;
import eu.isas.searchgui.processbuilders.DirecTagProcessBuilder;
import eu.isas.searchgui.processbuilders.MakeblastdbProcessBuilder;
import eu.isas.searchgui.processbuilders.MetaMorpheusProcessBuilder;
import eu.isas.searchgui.processbuilders.MsAmandaProcessBuilder;
import eu.isas.searchgui.processbuilders.MsConvertProcessBuilder;
import eu.isas.searchgui.processbuilders.MsgfProcessBuilder;
import eu.isas.searchgui.processbuilders.MyriMatchProcessBuilder;
import eu.isas.searchgui.processbuilders.NovorProcessBuilder;
import eu.isas.searchgui.processbuilders.OmssaclProcessBuilder;
import eu.isas.searchgui.processbuilders.PeptideShakerProcessBuilder;
import eu.isas.searchgui.processbuilders.SageProcessBuilder;
import eu.isas.searchgui.processbuilders.TandemProcessBuilder;
import eu.isas.searchgui.processbuilders.ThermoRawFileParserProcessBuilder;
import eu.isas.searchgui.processbuilders.TideIndexProcessBuilder;
import eu.isas.searchgui.processbuilders.TideSearchProcessBuilder;
import eu.isas.searchgui.utilities.Properties;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;

public class SearchHandler {
    private static final String SEARCHGUI_INPUT = "searchGUI_input.txt";
    private WaitingHandler waitingHandler;
    public static final String SEARCHGUI_CONFIGURATION_FILE = "searchGUI_configuration.txt";
    public static final String OUTPUT_TEMP_FOLDER_NAME = ".SearchGUI_temp";
    private static final String PEAK_LIST_SUBFOLDER = "peak_lists";
    private static boolean useCommandLine = false;
    private static boolean closeProcessWhenDone = true;
    private SearchWorker searchWorker;
    private File resultsFolder;
    private boolean enableOmssa = false;
    private boolean enableXtandem = false;
    private boolean enableMsgf = false;
    private boolean enableMsAmanda = false;
    private boolean enableMyriMatch = false;
    private boolean enableComet = false;
    private boolean enableTide = false;
    private boolean enableAndromeda = false;
    private boolean enableMetaMorpheus = false;
    private boolean enableSage = false;
    private boolean enableNovor = false;
    private boolean enableDirecTag = false;
    private boolean enablePeptideShaker = false;
    private boolean enableReporter = false;
    private IdentificationParameters identificationParameters;
    private File identificationParametersFile;
    private ArrayList<File> rawFiles;
    private ArrayList<File> msFiles;
    private ArrayList<File> cmsFiles;
    private File fastaFile;
    private File omssaLocation = null;
    private File xtandemLocation = null;
    private File msgfLocation = null;
    private File msAmandaLocation = null;
    private File myriMatchLocation = null;
    private File cometLocation = null;
    private File tideLocation = null;
    private File tideIndexLocation = null;
    private File andromedaLocation = null;
    private File metaMorpheusLocation = null;
    private boolean metaMorpheusLocationSetByUser = false;
    private File sageLocation = null;
    private File novorLocation = null;
    private File direcTagLocation = null;
    private File makeblastdbLocation;
    private String experimentLabel;
    private File peptideShakerFile = null;
    private ArrayList<File> mascotFiles = new ArrayList();
    private ArrayList<MsConvertProcessBuilder> msConvertProcessBuilders = null;
    private ArrayList<ThermoRawFileParserProcessBuilder> thermoRawFileParserProcessBuilders = null;
    private MakeblastdbProcessBuilder makeblastdbProcessBuilder = null;
    private OmssaclProcessBuilder omssaProcessBuilder = null;
    private TandemProcessBuilder xTandemProcessBuilder = null;
    private MsgfProcessBuilder msgfProcessBuilder = null;
    private MsAmandaProcessBuilder msAmandaProcessBuilder = null;
    private MyriMatchProcessBuilder myriMatchProcessBuilder = null;
    private CometProcessBuilder cometProcessBuilder = null;
    private TideIndexProcessBuilder tideIndexProcessBuilder = null;
    private TideSearchProcessBuilder tideSearchProcessBuilder = null;
    private AndromedaProcessBuilder andromedaProcessBuilder = null;
    private MetaMorpheusProcessBuilder metaMorpheusProcessBuilder = null;
    private SageProcessBuilder sageProcessBuilder = null;
    private NovorProcessBuilder novorProcessBuilder = null;
    private DirecTagProcessBuilder direcTagProcessBuilder = null;
    private PeptideShakerProcessBuilder peptideShakerProcessBuilder = null;
    private ProcessingParameters processingParameters = new ProcessingParameters();
    private MsConvertParameters msConvertParameters;
    private ThermoRawFileParserParameters thermoRawFileParserParameters;
    private static String defaultOutputFileName = "searchgui_out";
    public static final String DEFAULT_OUTPUT_FILE_NAME_ENDING = ".zip";
    public static final String DEFAULT_DATA_FOLDER = "data";
    private ExceptionHandler exceptionHandler;
    private static String tempFolderPath = null;
    private static String tempSearchEngineFolderPath = null;
    private Duration searchDuration;
    private File logFolder = null;
    private static File configFolder = null;
    private static String outputTimeStamp = null;
    private HashMap<String, File> idFileToSpectrumFileMap;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private final MsFileHandler msFileHandler;
    public static final String CONDA_APP_NAME = "searchgui";

    public SearchHandler() {
        this.msFileHandler = null;
    }

    public SearchHandler(IdentificationParameters identificationParameters, File resultsFolder, File configFolder, ArrayList<File> msFiles, File fastaFile, ArrayList<File> rawFiles, File identificationParametersFile, ProcessingParameters processingParameters, MsFileHandler msFileHandler, ExceptionHandler exceptionHandler) {
        this.resultsFolder = resultsFolder;
        if (configFolder != null) {
            SearchHandler.configFolder = configFolder;
        }
        this.msFiles = msFiles;
        this.cmsFiles = new ArrayList();
        this.fastaFile = fastaFile;
        this.rawFiles = rawFiles;
        this.exceptionHandler = exceptionHandler;
        this.enableOmssa = this.loadSearchEngineLocation(Advocate.omssa, false, true, true, true, false, false, false);
        this.enableXtandem = this.loadSearchEngineLocation(Advocate.xtandem, false, true, true, true, true, false, true);
        this.enableMsgf = this.loadSearchEngineLocation(Advocate.msgf, true, true, true, true, false, false, false);
        this.enableMsAmanda = this.loadSearchEngineLocation(Advocate.msAmanda, false, true, true, true, false, false, false);
        this.enableMyriMatch = this.loadSearchEngineLocation(Advocate.myriMatch, false, true, false, true, true, false, true);
        this.enableComet = this.loadSearchEngineLocation(Advocate.comet, false, true, true, true, false, false, false);
        this.enableTide = this.loadSearchEngineLocation(Advocate.tide, false, true, true, true, false, false, false);
        this.enableAndromeda = this.loadSearchEngineLocation(Advocate.andromeda, false, true, false, false, false, false, false);
        this.enableMetaMorpheus = this.loadSearchEngineLocation(Advocate.metaMorpheus, true, true, true, true, false, false, false);
        this.enableSage = this.loadSearchEngineLocation(Advocate.sage, false, true, true, true, false, false, false);
        this.enableNovor = this.loadSearchEngineLocation(Advocate.novor, true, true, true, true, false, false, false);
        this.enableDirecTag = this.loadSearchEngineLocation(Advocate.direcTag, false, true, false, true, true, false, true);
        this.identificationParametersFile = identificationParametersFile;
        this.processingParameters = processingParameters;
        this.identificationParameters = identificationParameters;
        this.msFileHandler = msFileHandler;
        this.searchDuration = new Duration();
    }

    public SearchHandler(IdentificationParameters identificationParameters, File resultsFolder, File configFolder, String defaultOutputFileName, ArrayList<File> msFiles, File fastaFile, ArrayList<File> rawFiles, File identificationParametersFile, boolean runOmssa, boolean runXTandem, boolean runMsgf, boolean runMsAmanda, boolean runMyriMatch, boolean runComet, boolean runTide, boolean runAndromeda, boolean runMetaMorpheus, boolean runSage, boolean runNovor, boolean runDirecTag, File omssaFolder, File xTandemFolder, File msgfFolder, File msAmandaFolder, File myriMatchFolder, File cometFolder, File tideFolder, File tideIndexLocation, File andromedaFolder, File metaMorpheusFolder, File sageFolder, File novorFolder, File direcTagFolder, File makeblastdbFolder, ProcessingParameters processingParameters) {
        this.resultsFolder = resultsFolder;
        if (configFolder != null) {
            SearchHandler.configFolder = configFolder;
        }
        if (defaultOutputFileName != null) {
            SearchHandler.defaultOutputFileName = defaultOutputFileName;
        }
        this.msFiles = msFiles;
        this.cmsFiles = new ArrayList();
        this.fastaFile = fastaFile;
        this.rawFiles = rawFiles;
        this.enableOmssa = runOmssa;
        this.enableXtandem = runXTandem;
        this.enableMsgf = runMsgf;
        this.enableMsAmanda = runMsAmanda;
        this.enableMyriMatch = runMyriMatch;
        this.enableComet = runComet;
        this.enableTide = runTide;
        this.enableAndromeda = runAndromeda;
        this.enableMetaMorpheus = runMetaMorpheus;
        this.enableSage = runSage;
        this.enableNovor = runNovor;
        this.enableDirecTag = runDirecTag;
        this.identificationParameters = identificationParameters;
        this.processingParameters = processingParameters;
        this.identificationParametersFile = identificationParametersFile;
        if (omssaFolder != null) {
            this.omssaLocation = omssaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.omssa, false, true, true, true, false, false, false);
        }
        if (xTandemFolder != null) {
            this.xtandemLocation = xTandemFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.xtandem, false, true, true, true, true, false, true);
        }
        if (msgfFolder != null) {
            this.msgfLocation = msgfFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.msgf, true, true, true, true, false, false, false);
        }
        if (msAmandaFolder != null) {
            this.msAmandaLocation = msAmandaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.msAmanda, false, true, true, true, false, false, false);
        }
        if (myriMatchFolder != null) {
            this.myriMatchLocation = myriMatchFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.myriMatch, false, true, false, true, true, false, true);
        }
        if (cometFolder != null) {
            this.cometLocation = cometFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.comet, false, true, true, true, false, false, false);
        }
        if (tideFolder != null) {
            this.tideLocation = tideFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.tide, false, true, true, true, false, false, false);
        }
        this.tideIndexLocation = tideIndexLocation;
        if (andromedaFolder != null) {
            this.andromedaLocation = andromedaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.andromeda, false, true, false, false, false, false, false);
        }
        if (metaMorpheusFolder != null) {
            this.metaMorpheusLocation = metaMorpheusFolder;
            this.metaMorpheusLocationSetByUser = true;
        } else {
            this.loadSearchEngineLocation(Advocate.metaMorpheus, true, true, true, true, false, false, false);
        }
        if (sageFolder != null) {
            this.sageLocation = sageFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.sage, false, true, true, true, false, false, false);
        }
        if (novorFolder != null) {
            this.novorLocation = novorFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.novor, true, true, true, true, false, false, false);
        }
        if (direcTagFolder != null) {
            this.direcTagLocation = direcTagFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.direcTag, false, true, false, true, true, false, true);
        }
        if (makeblastdbFolder != null) {
            this.makeblastdbLocation = makeblastdbFolder;
        } else {
            this.loadSearchEngineLocation(null, false, true, true, true, false, false, true);
        }
        if (!SearchHandler.getJarFilePath().equalsIgnoreCase(".")) {
            UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
            String versionNumber = new Properties().getVersion();
            utilitiesUserParameters.setSearchGuiPath(new File(SearchHandler.getJarFilePath(), "SearchGUI-" + versionNumber + ".jar").getAbsolutePath());
            UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)utilitiesUserParameters);
        }
        this.msFileHandler = new MsFileHandler();
        this.searchDuration = new Duration();
    }

    public synchronized void startSearch(WaitingHandler waitingHandler) throws InterruptedException {
        this.waitingHandler = waitingHandler;
        this.searchDuration.start();
        this.searchWorker = new SearchWorker(waitingHandler);
        this.searchWorker.execute();
        if (waitingHandler != null && waitingHandler instanceof WaitingDialog) {
            try {
                ((WaitingDialog)waitingHandler).setVisible(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ((WaitingDialog)waitingHandler).setModal(true);
        } else {
            useCommandLine = true;
        }
        if (useCommandLine && !this.searchWorker.isFinished()) {
            this.wait();
        }
    }

    private synchronized void notifySearchFinished() {
        this.notify();
    }

    public void cancelSearch() {
        this.searchWorker.cancelRun();
        if (this.waitingHandler != null) {
            this.waitingHandler.setRunCanceled();
        }
    }

    private void searchCompleted() {
        if (this.searchWorker.isFinished()) {
            if (this.waitingHandler != null) {
                if (this.waitingHandler instanceof WaitingDialog) {
                    ((JFrame)((WaitingDialog)this.waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                }
                this.searchDuration.end();
                this.waitingHandler.appendReport("Search Completed (" + this.searchDuration.toString() + ").", true, true);
                this.waitingHandler.appendReportEndLine();
            }
            this.saveReport();
            if (this.waitingHandler != null && !this.waitingHandler.isRunCanceled()) {
                this.waitingHandler.setRunFinished();
            }
            if (this.enablePeptideShaker) {
                UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
                File tempPeptideShakerFile = this.peptideShakerFile;
                if (utilitiesUserParameters.outputData()) {
                    tempPeptideShakerFile = new File(this.peptideShakerFile.getParentFile(), IoUtil.removeExtension((String)this.peptideShakerFile.getName()) + DEFAULT_OUTPUT_FILE_NAME_ENDING);
                }
                if (tempPeptideShakerFile.exists()) {
                    try {
                        CompomicsWrapper wrapper = new CompomicsWrapper();
                        ArrayList javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserParameters.getPeptideShakerPath());
                        ArrayList<String> process_name_array = new ArrayList<String>();
                        process_name_array.add((String)javaHomeAndOptions.get(0));
                        for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                            process_name_array.add((String)javaHomeAndOptions.get(i));
                        }
                        process_name_array.add("-jar");
                        process_name_array.add(new File(utilitiesUserParameters.getPeptideShakerPath()).getName());
                        process_name_array.add("-psdb");
                        process_name_array.add(CommandLineUtils.getCommandLineArgument((File)tempPeptideShakerFile));
                        ProcessBuilder openPeptideShakerProcess = new ProcessBuilder(process_name_array);
                        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "PeptideShaker command: ");
                        for (String currentElement : process_name_array) {
                            System.out.print(currentElement + " ");
                        }
                        System.out.println(System.getProperty("line.separator"));
                        File psFolder = new File(utilitiesUserParameters.getPeptideShakerPath()).getParentFile();
                        openPeptideShakerProcess.directory(psFolder);
                        openPeptideShakerProcess.redirectErrorStream(true);
                        openPeptideShakerProcess.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("PeptideShaker file (" + tempPeptideShakerFile.getAbsolutePath() + ") not found!", true, true);
                }
            }
            if (useCommandLine) {
                System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Search Completed." + System.getProperty("line.separator"));
                if (closeProcessWhenDone) {
                    System.exit(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReport() {
        block14: {
            FileWriter fw;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            String fileName = "SearchGUI Report " + df.format(new Date()) + ".html";
            String report = "";
            if (this.waitingHandler instanceof WaitingDialog) {
                report = "<pre>" + ((WaitingDialog)this.waitingHandler).getReport(new File(this.resultsFolder, fileName)) + "</pre>";
            }
            report = report + this.identificationParameters.getSearchParameters().toString(true);
            report = "<html>" + report + "</html>";
            try {
                fw = new FileWriter(new File(this.resultsFolder, fileName));
                try {
                    fw.write(report);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("Failed to write to the report file!", true, true);
                }
                e.printStackTrace();
            }
            try {
                if (this.logFolder == null) break block14;
                fw = new FileWriter(new File(this.logFolder, fileName));
                try {
                    fw.write(report);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("Failed to write to the log report file!", true, true);
                }
                e.printStackTrace();
            }
        }
    }

    private void searchCrashed() {
        if (this.waitingHandler != null) {
            if (this.waitingHandler instanceof WaitingDialog) {
                ((JFrame)((WaitingDialog)this.waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
            }
            this.waitingHandler.appendReport("The search or processing did not finish properly!", true, true);
            this.waitingHandler.setRunCanceled();
            this.saveReport();
            if (this.waitingHandler instanceof WaitingHandlerCLIImpl && closeProcessWhenDone) {
                System.exit(0);
            }
        } else {
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "The search did not finish properly:" + System.getProperty("line.separator") + 0);
            if (closeProcessWhenDone) {
                System.exit(0);
            }
        }
    }

    private boolean loadSearchEngineLocation(Advocate searchEngineAdvocate, boolean sameVersionForAll, boolean windowsSupported, boolean osxSupported, boolean linuxSupported, boolean windowsBitVersions, boolean osxBitVersions, boolean linuxBitVersions) {
        boolean enableSearchEngine = false;
        String advocateName = searchEngineAdvocate == null ? "makeblastdb" : searchEngineAdvocate.getName();
        String correctedAdvocateName = advocateName.replaceAll("!", "");
        File folder = new File(SearchHandler.getJarFilePath() + File.separator + "resources" + File.separator + "conf" + File.separator);
        File searchEngineLoation = null;
        if (folder.exists()) {
            File input = new File(folder, SEARCHGUI_CONFIGURATION_FILE);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(input));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#") || !line.equals(advocateName + " Location:")) continue;
                    String result = br.readLine().trim();
                    searchEngineLoation = new File(result);
                    if (result.equalsIgnoreCase("Not Selected") || !searchEngineLoation.exists()) {
                        String basePath = SearchHandler.getJarFilePath() + File.separator + "resources" + File.separator + correctedAdvocateName;
                        if (sameVersionForAll) {
                            searchEngineLoation = new File(basePath);
                        } else {
                            boolean is64Bit;
                            String operatingSystem = System.getProperty("os.name").toLowerCase();
                            String arch = System.getProperty("os.arch").toLowerCase();
                            boolean bl = is64Bit = arch.lastIndexOf("64") != -1;
                            searchEngineLoation = operatingSystem.contains("windows") && windowsSupported ? (!windowsBitVersions ? new File(basePath + File.separator + "windows") : (is64Bit ? new File(basePath + File.separator + "windows" + File.separator + "windows_64bit") : new File(basePath + File.separator + "windows" + File.separator + "windows_32bit"))) : (operatingSystem.contains("mac os") && osxSupported ? (!osxBitVersions ? new File(basePath + File.separator + "osx") : (is64Bit ? new File(basePath + File.separator + "osx" + File.separator + "osx_64bit") : new File(basePath + File.separator + "osx" + File.separator + "osx_32bit"))) : ((operatingSystem.contains("nix") || operatingSystem.contains("nux")) && linuxSupported ? (!linuxBitVersions ? new File(basePath + File.separator + "linux") : (is64Bit ? new File(basePath + File.separator + "linux" + File.separator + "linux_64bit") : new File(basePath + File.separator + "linux" + File.separator + "linux_32bit"))) : null));
                        }
                    } else {
                        searchEngineLoation = new File(result);
                    }
                    if (searchEngineLoation == null) {
                        enableSearchEngine = false;
                        continue;
                    }
                    String selected = br.readLine().trim();
                    if (selected.length() > 0) {
                        enableSearchEngine = Boolean.parseBoolean(selected);
                        continue;
                    }
                    enableSearchEngine = true;
                }
                br.close();
            }
            catch (IOException ioe) {
                enableSearchEngine = false;
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred when trying to load the " + advocateName + " location.", "Configuration Import Error", 0);
            }
        } else {
            enableSearchEngine = false;
        }
        if (searchEngineAdvocate != null) {
            if (searchEngineAdvocate == Advocate.omssa) {
                this.omssaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.xtandem) {
                this.xtandemLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.myriMatch) {
                this.myriMatchLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.msAmanda) {
                this.msAmandaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.msgf) {
                this.msgfLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.comet) {
                this.cometLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.tide) {
                this.tideLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.andromeda) {
                this.andromedaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.metaMorpheus) {
                this.metaMorpheusLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.sage) {
                this.sageLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.novor) {
                this.novorLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.direcTag) {
                this.direcTagLocation = searchEngineLoation;
            }
        } else {
            this.makeblastdbLocation = searchEngineLoation;
        }
        return enableSearchEngine;
    }

    public static String getXTandemFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".t.xml";
    }

    public String getCometFileName(String spectrumFileName) {
        CometParameters cometParameters = (CometParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
        return SearchHandler.getCometFileName(spectrumFileName, cometParameters);
    }

    public static String getCometFileName(String spectrumFileName, CometParameters cometParameters) {
        if (cometParameters.getSelectedOutputFormat() != null) {
            switch (cometParameters.getSelectedOutputFormat()) {
                case PepXML: {
                    return IoUtil.removeExtension((String)spectrumFileName) + ".comet.pep.xml";
                }
                case Percolator: {
                    return IoUtil.removeExtension((String)spectrumFileName) + ".comet.pin";
                }
                case SQT: {
                    return IoUtil.removeExtension((String)spectrumFileName) + ".comet.sqt";
                }
                case TXT: {
                    return IoUtil.removeExtension((String)spectrumFileName) + ".comet.txt";
                }
            }
        }
        return IoUtil.removeExtension((String)spectrumFileName) + ".comet.pep.xml";
    }

    public String getTideFileName(String spectrumFileName) {
        TideParameters tideParameters = (TideParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        return SearchHandler.getTideFileName(spectrumFileName, tideParameters);
    }

    public static String getTideFileName(String spectrumFileName, TideParameters tideParameters) {
        if (tideParameters.getTextOutput().booleanValue()) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".tide-search.target.txt";
        }
        if (tideParameters.getMzidOutput().booleanValue()) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".tide-search.target.mzid";
        }
        if (tideParameters.getPepXmlOutput().booleanValue()) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".tide-search.target.pep.xml";
        }
        if (tideParameters.getSqtOutput().booleanValue()) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".tide-search.target.sqt";
        }
        return IoUtil.removeExtension((String)spectrumFileName) + ".tide-search.target.pin";
    }

    public static String getAndromedaFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".res";
    }

    public static String getMetaMorpheusFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".mzID";
    }

    public static String getNovorFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".novor.csv";
    }

    public static String getDirecTagFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".tags";
    }

    public String getOMSSAFileName(String spectrumFileName) {
        OmssaParameters omssaParameters = (OmssaParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        return SearchHandler.getOMSSAFileName(spectrumFileName, omssaParameters);
    }

    public static String getOMSSAFileName(String spectrumFileName, OmssaParameters omssaParameters) {
        return IoUtil.removeExtension((String)spectrumFileName) + "." + omssaParameters.getSelectedOutput().toLowerCase();
    }

    public static String getMsgfFileName(String spectrumFileName) {
        return IoUtil.removeExtension((String)spectrumFileName) + ".msgf.mzid";
    }

    public static String getSageFileName(String spectrumFileName) {
        return "results.sage.tsv";
    }

    public String getMsAmandaFileName(String spectrumFileName) {
        MsAmandaParameters msAmandaParameters = (MsAmandaParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex());
        return SearchHandler.getMsAmandaFileName(spectrumFileName, msAmandaParameters);
    }

    public static String getMsAmandaFileName(String spectrumFileName, MsAmandaParameters msAmandaParameters) {
        if (msAmandaParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".ms-amanda.mzid.gz";
        }
        return IoUtil.removeExtension((String)spectrumFileName) + ".ms-amanda.csv";
    }

    public String getMyriMatchFileName(String spectrumFileName) {
        MyriMatchParameters myriMatchParameters = (MyriMatchParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        return SearchHandler.getMyriMatchFileName(spectrumFileName, myriMatchParameters);
    }

    public static String getMyriMatchFileName(String spectrumFileName, MyriMatchParameters myriMatchParameters) {
        if (myriMatchParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            return IoUtil.removeExtension((String)spectrumFileName) + ".myrimatch.mzid";
        }
        return IoUtil.removeExtension((String)spectrumFileName) + ".myrimatch.pepXML";
    }

    public ArrayList<File> getXTandemFiles(File folder, String spectrumFileName) {
        String regex = ".*\\d{4}_\\d{2}[_]\\d{2}[_]\\d{2}[_]\\d{2}[_]\\d{2}[.]t[.]xml";
        Pattern pattern = Pattern.compile(regex);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : folder.listFiles()) {
            String fileName = file.getName();
            Matcher matcher = pattern.matcher(fileName);
            if (!matcher.matches() && !fileName.equals(SearchHandler.getXTandemFileName(spectrumFileName))) continue;
            result.add(file);
        }
        return result;
    }

    public File getOmssaLocation() {
        return this.omssaLocation;
    }

    public void setOmssaLocation(File omssaLocation) {
        this.omssaLocation = omssaLocation;
    }

    public File getXtandemLocation() {
        return this.xtandemLocation;
    }

    public void setXtandemLocation(File xtandemLocation) {
        this.xtandemLocation = xtandemLocation;
    }

    public File getMsgfLocation() {
        return this.msgfLocation;
    }

    public void setMsgfLocation(File msgfLocation) {
        this.msgfLocation = msgfLocation;
    }

    public File getMsAmandaLocation() {
        return this.msAmandaLocation;
    }

    public void setMsAmandaLocation(File msAmandaLocation) {
        this.msAmandaLocation = msAmandaLocation;
    }

    public File getMyriMatchLocation() {
        return this.myriMatchLocation;
    }

    public void setMyriMatchLocation(File myriMatchLocation) {
        this.myriMatchLocation = myriMatchLocation;
    }

    public File getCometLocation() {
        return this.cometLocation;
    }

    public void setCometLocation(File cometLocation) {
        this.cometLocation = cometLocation;
    }

    public File getTideLocation() {
        return this.tideLocation;
    }

    public void setTideLocation(File tideLocation) {
        this.tideLocation = tideLocation;
    }

    public File getAndromedaLocation() {
        return this.andromedaLocation;
    }

    public void setAndromedaLocation(File andromedaLocation) {
        this.andromedaLocation = andromedaLocation;
    }

    public File getMetaMorpheusLocation() {
        return this.metaMorpheusLocation;
    }

    public void setMetaMorpheusLocation(File metaMorpheusLocation) {
        this.metaMorpheusLocation = metaMorpheusLocation;
    }

    public File getSageLocation() {
        return this.sageLocation;
    }

    public void setSageLocation(File sageLocation) {
        this.sageLocation = sageLocation;
    }

    public File getNovorLocation() {
        return this.novorLocation;
    }

    public void setNovorLocation(File novorLocation) {
        this.novorLocation = novorLocation;
    }

    public File getDirecTagLocation() {
        return this.direcTagLocation;
    }

    public void setDirecTagLocation(File direcTagLocation) {
        this.direcTagLocation = direcTagLocation;
    }

    public File getMakeblastdbLocation() {
        return this.makeblastdbLocation;
    }

    public void setMakeblastdbLocation(File makeblastdbLocation) {
        this.makeblastdbLocation = makeblastdbLocation;
    }

    public boolean isOmssaEnabled() {
        return this.enableOmssa;
    }

    public void setPeptideShakerEnabled(boolean runPeptideShaker) {
        this.enablePeptideShaker = runPeptideShaker;
    }

    public boolean isPeptideShakerEnabled() {
        return this.enablePeptideShaker;
    }

    public boolean isReporterEnabled() {
        return this.enableReporter;
    }

    public void setOmssaEnabled(boolean runOmssa) {
        this.enableOmssa = runOmssa;
    }

    public boolean isXtandemEnabled() {
        return this.enableXtandem;
    }

    public boolean isMsgfEnabled() {
        return this.enableMsgf;
    }

    public boolean isMsAmandaEnabled() {
        return this.enableMsAmanda;
    }

    public boolean isMyriMatchEnabled() {
        return this.enableMyriMatch;
    }

    public boolean isCometEnabled() {
        return this.enableComet;
    }

    public boolean isTideEnabled() {
        return this.enableTide;
    }

    public boolean isAndromedaEnabled() {
        return this.enableAndromeda;
    }

    public boolean isMetaMorpheusEnabled() {
        return this.enableMetaMorpheus;
    }

    public boolean isSageEnabled() {
        return this.enableSage;
    }

    public boolean isNovorEnabled() {
        return this.enableNovor;
    }

    public boolean isDirecTagEnabled() {
        return this.enableDirecTag;
    }

    public void setXtandemEnabled(boolean runXtandem) {
        this.enableXtandem = runXtandem;
    }

    public void setMsgfEnabled(boolean runMsgf) {
        this.enableMsgf = runMsgf;
    }

    public void setMsAmandaEnabled(boolean runMsAmanda) {
        this.enableMsAmanda = runMsAmanda;
    }

    public void setMyriMatchEnabled(boolean runMyriMatch) {
        this.enableMyriMatch = runMyriMatch;
    }

    public void setCometEnabled(boolean runComet) {
        this.enableComet = runComet;
    }

    public void setTideEnabled(boolean runTide) {
        this.enableTide = runTide;
    }

    public void setAndromedaEnabled(boolean runAndromeda) {
        this.enableAndromeda = runAndromeda;
    }

    public void setMetaMorpheusEnabled(boolean runMetaMorpheus) {
        this.enableMetaMorpheus = runMetaMorpheus;
    }

    public void setSageEnabled(boolean runSage) {
        this.enableSage = runSage;
    }

    public void setNovorEnabled(boolean runNovor) {
        this.enableNovor = runNovor;
    }

    public void setDirecTagEnabled(boolean runDirecTag) {
        this.enableDirecTag = runDirecTag;
    }

    public File getResultsFolder() {
        return this.resultsFolder;
    }

    public void setResultsFolder(File resultsFolder) {
        this.resultsFolder = resultsFolder;
    }

    public ArrayList<File> getSpectrumFiles() {
        return this.msFiles;
    }

    public void setSpectrumFiles(ArrayList<File> msFiles) {
        this.msFiles = new ArrayList<File>(msFiles);
    }

    public File getSpectrumFile(String fileName) {
        for (File tempFile : this.msFiles) {
            if (!tempFile.getName().equalsIgnoreCase(fileName)) continue;
            return tempFile;
        }
        return null;
    }

    public ArrayList<File> getCmsFiles() {
        return this.cmsFiles;
    }

    public void setCmsFiles(ArrayList<File> cmsFiles) {
        this.cmsFiles = cmsFiles;
    }

    public File getCmsFile(String fileName) {
        for (File tempFile : this.cmsFiles) {
            if (!tempFile.getName().equalsIgnoreCase(fileName)) continue;
            return tempFile;
        }
        return null;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public ArrayList<File> getRawFiles() {
        return this.rawFiles;
    }

    public void setRawFiles(ArrayList<File> rawFiles) {
        this.rawFiles = rawFiles;
    }

    public String getExperimentLabel() {
        return this.experimentLabel;
    }

    public void setExperimentLabel(String experimentLabel) {
        this.experimentLabel = experimentLabel;
    }

    public File getPeptideShakerFile() {
        return this.peptideShakerFile;
    }

    public void setPeptideShakerFile(File peptideShakerFile) {
        this.peptideShakerFile = peptideShakerFile;
    }

    public void saveInputFile(File folder) {
        File outputFile = SearchHandler.getInputFile(folder);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));){
            bw.write(this.fastaFile.getAbsolutePath() + System.getProperty("line.separator"));
            for (File spectrumFile : this.msFiles) {
                bw.write(spectrumFile.getAbsolutePath() + System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
    }

    public void setIdentificationParametersFile(File identificationParametersFile) {
        this.identificationParametersFile = identificationParametersFile;
    }

    public void setMascotFiles(ArrayList<File> mascotFiles) {
        this.mascotFiles = mascotFiles;
    }

    public ArrayList<File> getMascotFiles() {
        return this.mascotFiles;
    }

    public ProcessingParameters getProcessingParameters() {
        return this.processingParameters;
    }

    public void setProcessingParameters(ProcessingParameters processingParameters) {
        this.processingParameters = processingParameters;
    }

    public MsConvertParameters getMsConvertParameters() {
        return this.msConvertParameters;
    }

    public void setMsConvertParameters(MsConvertParameters msConvertParameters) {
        this.msConvertParameters = msConvertParameters;
    }

    public ThermoRawFileParserParameters getThermoRawFileParserParameters() {
        return this.thermoRawFileParserParameters;
    }

    public void setThermoRawFileParserParameters(ThermoRawFileParserParameters thermoRawFileParserParameters) {
        this.thermoRawFileParserParameters = thermoRawFileParserParameters;
    }

    public static File getDefaultOutputFile(File outputFolder, boolean includeDate) {
        String fileName = defaultOutputFileName;
        if (includeDate) {
            fileName = fileName + "_" + outputTimeStamp;
        }
        fileName = fileName + DEFAULT_OUTPUT_FILE_NAME_ENDING;
        return new File(outputFolder, fileName);
    }

    public static File getDefaultOutputFile(File outputFolder, String classifier, boolean includeDate) {
        String fileName = classifier;
        fileName = fileName + "_" + defaultOutputFileName;
        if (includeDate) {
            fileName = fileName + "_" + outputTimeStamp;
        }
        fileName = fileName + DEFAULT_OUTPUT_FILE_NAME_ENDING;
        return new File(outputFolder, fileName);
    }

    public static String getOutputDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        return df.format(new Date());
    }

    public void setOutputTimeStamp(String outputTimeStamp) {
        SearchHandler.outputTimeStamp = outputTimeStamp;
    }

    public static File getInputFile(File outputFolder) {
        return new File(outputFolder, SEARCHGUI_INPUT);
    }

    public void organizeOutput(File outputFolder, File tempOutputFolder, HashMap<String, HashMap<Integer, File>> identificationFilesMap, File parametersFile, boolean includeDate) throws IOException {
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (utilitiesUserParameters.isGzip()) {
            ((Stream)identificationFilesMap.values().stream().flatMap(map -> map.values().stream()).parallel()).forEach(file -> GzUtils.gzFile((File)file, (boolean)true));
            HashMap compressedIdentificationFiles = new HashMap(identificationFilesMap.size());
            for (Map.Entry<String, HashMap<Integer, File>> entry1 : identificationFilesMap.entrySet()) {
                HashMap<Integer, File> map2 = entry1.getValue();
                HashMap<Integer, File> newMap = new HashMap<Integer, File>(map2.size());
                compressedIdentificationFiles.put(entry1.getKey(), newMap);
                for (Map.Entry<Integer, File> entry2 : map2.entrySet()) {
                    File file2 = entry2.getValue();
                    File gzFile = !file2.getAbsolutePath().endsWith(".gz") ? new File(file2.getAbsolutePath() + ".gz") : file2;
                    newMap.put(entry2.getKey(), gzFile);
                }
            }
            identificationFilesMap = compressedIdentificationFiles;
        }
        switch (utilitiesUserParameters.getSearchGuiOutputParameters()) {
            case grouped: {
                File zipFile = SearchHandler.getDefaultOutputFile(outputFolder, includeDate);
                if (zipFile.exists()) {
                    zipFile.delete();
                }
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
                    long totalUncompressedSize = this.getTotalUncompressedSize(tempOutputFolder, parametersFile, identificationFilesMap);
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                    this.waitingHandler.setSecondaryProgressCounter(0);
                    this.waitingHandler.setMaxSecondaryProgressCounter(100);
                    File inputFile = SearchHandler.getInputFile(tempOutputFolder);
                    ZipUtils.addFileToZip((File)inputFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                    ZipUtils.addFileToZip((File)parametersFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                    if (this.enableOmssa) {
                        File file2 = new File(tempOutputFolder, "omssa_mods.xml");
                        ZipUtils.addFileToZip((File)file2, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                        ZipUtils.addFileToZip((File)userModificationsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                    }
                    if (this.enableMsAmanda) {
                        for (File spectrumFile : this.msFiles) {
                            String newName = IoUtil.removeExtension((String)spectrumFile.getName()) + "_settings.xml";
                            File settingsFile = new File(tempOutputFolder, newName);
                            if (!settingsFile.exists()) continue;
                            ZipUtils.addFileToZip((File)settingsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                    }
                    for (HashMap<Integer, File> fileMap : identificationFilesMap.values()) {
                        for (File identificationFile : fileMap.values()) {
                            ZipUtils.addFileToZip((File)identificationFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                    }
                    if (!utilitiesUserParameters.outputData()) break;
                    this.addDataToZip(out, totalUncompressedSize);
                    break;
                }
            }
            case algorithm: {
                ZipOutputStream out;
                File zipFile;
                HashMap<Integer, ArrayList<File>> algorithmToFileMap = new HashMap<Integer, ArrayList<File>>();
                for (HashMap<Integer, File> fileMap : identificationFilesMap.values()) {
                    for (Integer n : fileMap.keySet()) {
                        ArrayList<File> files = (ArrayList<File>)algorithmToFileMap.get(n);
                        if (files == null) {
                            files = new ArrayList<File>();
                            algorithmToFileMap.put(n, files);
                        }
                        files.add(fileMap.get(n));
                    }
                }
                File inputFile = SearchHandler.getInputFile(tempOutputFolder);
                long totalUncompressedSize = 0L;
                for (Integer algorithm : algorithmToFileMap.keySet()) {
                    totalUncompressedSize += this.getTotalUncompressedSizeAlgorithm(inputFile, tempOutputFolder, algorithm, parametersFile, (ArrayList)algorithmToFileMap.get(algorithm));
                }
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.setSecondaryProgressCounter(0);
                this.waitingHandler.setMaxSecondaryProgressCounter(100);
                for (Integer algorithm : algorithmToFileMap.keySet()) {
                    String advocateName = Advocate.getAdvocate((int)algorithm).getName();
                    zipFile = SearchHandler.getDefaultOutputFile(outputFolder, advocateName, includeDate);
                    if (zipFile.exists()) {
                        zipFile.delete();
                    }
                    out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
                    try {
                        ZipUtils.addFileToZip((File)inputFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        ZipUtils.addFileToZip((File)parametersFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        if (algorithm.intValue() == Advocate.omssa.getIndex()) {
                            Iterator modificationsFile = new File(tempOutputFolder, "omssa_mods.xml");
                            ZipUtils.addFileToZip((File)((Object)modificationsFile), (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                            File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                            ZipUtils.addFileToZip((File)userModificationsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                        if (algorithm.intValue() == Advocate.msAmanda.getIndex()) {
                            for (File spectrumFile : this.msFiles) {
                                String newName = IoUtil.removeExtension((String)spectrumFile.getName()) + "_settings.xml";
                                File settingsFile = new File(tempOutputFolder, newName);
                                if (!settingsFile.exists()) continue;
                                ZipUtils.addFileToZip((File)settingsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                            }
                        }
                        for (File identificationFile : (ArrayList)algorithmToFileMap.get(algorithm)) {
                            ZipUtils.addFileToZip((File)identificationFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                        if (!utilitiesUserParameters.outputData()) continue;
                        this.addDataToZip(out, totalUncompressedSize);
                    }
                    finally {
                        out.close();
                    }
                }
                break;
            }
            case run: {
                String spectrumFileNameWithoutExtension;
                ZipOutputStream out;
                File zipFile;
                File inputFile = SearchHandler.getInputFile(tempOutputFolder);
                long totalUncompressedSize = 0L;
                for (String spectrumFileName : identificationFilesMap.keySet()) {
                    spectrumFileNameWithoutExtension = IoUtil.removeExtension((String)spectrumFileName);
                    totalUncompressedSize += this.getTotalUncompressedSizeRun(inputFile, tempOutputFolder, spectrumFileNameWithoutExtension, spectrumFileName, parametersFile, identificationFilesMap, this.getSpectrumFile(spectrumFileName), this.getCmsFile(IoUtil.removeExtension((String)spectrumFileName) + ".cms"));
                }
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.setSecondaryProgressCounter(0);
                this.waitingHandler.setMaxSecondaryProgressCounter(100);
                for (String spectrumFileName : identificationFilesMap.keySet()) {
                    spectrumFileNameWithoutExtension = IoUtil.removeExtension((String)spectrumFileName);
                    zipFile = SearchHandler.getDefaultOutputFile(outputFolder, spectrumFileNameWithoutExtension, includeDate);
                    if (zipFile.exists()) {
                        zipFile.delete();
                    }
                    out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
                    try {
                        String newName;
                        Object settingsFile;
                        ZipUtils.addFileToZip((File)inputFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        ZipUtils.addFileToZip((File)parametersFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        if (this.enableOmssa) {
                            File modificationsFile = new File(tempOutputFolder, "omssa_mods.xml");
                            ZipUtils.addFileToZip((File)modificationsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                            File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                            ZipUtils.addFileToZip((File)userModificationsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                        if (this.enableMsAmanda && ((File)(settingsFile = new File(tempOutputFolder, newName = spectrumFileNameWithoutExtension + "_settings.xml"))).exists()) {
                            ZipUtils.addFileToZip((File)settingsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                        HashMap<Integer, File> fileMap = identificationFilesMap.get(spectrumFileName);
                        settingsFile = fileMap.values().iterator();
                        while (settingsFile.hasNext()) {
                            File identificationFile = settingsFile.next();
                            ZipUtils.addFileToZip((File)identificationFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
                        }
                        if (!utilitiesUserParameters.outputData()) continue;
                        String cmsFileName = IoUtil.removeExtension((String)spectrumFileName) + ".cms";
                        this.addDataToZip(out, totalUncompressedSize, spectrumFileName, cmsFileName);
                    }
                    finally {
                        out.close();
                    }
                }
                break;
            }
            default: {
                if (!utilitiesUserParameters.outputData()) break;
                File file3 = new File(outputFolder, DEFAULT_DATA_FOLDER);
                file3.mkdir();
                IoUtil.copyFile((File)this.fastaFile, (File)new File(file3, this.fastaFile.getName()));
                for (File spectrumFile : this.getSpectrumFiles()) {
                    IoUtil.copyFile((File)spectrumFile, (File)new File(file3, spectrumFile.getName()));
                }
                for (File cmsFile : this.getCmsFiles()) {
                    IoUtil.copyFile((File)cmsFile, (File)new File(file3, cmsFile.getName()));
                }
            }
        }
        if (!outputFolder.getAbsolutePath().equals(tempOutputFolder.getAbsolutePath())) {
            IoUtil.deleteDir((File)tempOutputFolder);
        }
    }

    private void addDataToZip(ZipOutputStream out, long totalUncompressedSize) throws IOException {
        this.addDataToZip(out, totalUncompressedSize, null, null);
    }

    private void addDataToZip(ZipOutputStream out, long totalUncompressedSize, String spectrumFileName, String cmsFileName) throws IOException {
        boolean addFile;
        ZipUtils.addFolderToZip((String)DEFAULT_DATA_FOLDER, (ZipOutputStream)out);
        ZipUtils.addFileToZip((String)DEFAULT_DATA_FOLDER, (File)this.fastaFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
        for (File spectrumFile : this.getSpectrumFiles()) {
            addFile = true;
            if (spectrumFileName != null) {
                addFile = spectrumFile.getName().equals(spectrumFileName);
            }
            if (!addFile) continue;
            ZipUtils.addFileToZip((String)DEFAULT_DATA_FOLDER, (File)spectrumFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
        }
        for (File cmsFile : this.getCmsFiles()) {
            addFile = true;
            if (cmsFileName != null) {
                addFile = cmsFile.getName().equals(cmsFileName);
            }
            if (!addFile) continue;
            ZipUtils.addFileToZip((String)DEFAULT_DATA_FOLDER, (File)cmsFile, (ZipOutputStream)out, (WaitingHandler)this.waitingHandler, (long)totalUncompressedSize);
        }
    }

    private long getTotalUncompressedSize(File outputFolder, File parametersFile, HashMap<String, HashMap<Integer, File>> identificationFiles) {
        long totalUncompressedSize = 0L;
        totalUncompressedSize += SearchHandler.getInputFile(outputFolder).length();
        totalUncompressedSize += parametersFile.length();
        if (this.enableOmssa) {
            Iterator<HashMap<Integer, File>> modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += ((File)((Object)modificationsFile)).length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (this.enableMsAmanda) {
            for (File spectrumFile : this.msFiles) {
                String newName = IoUtil.removeExtension((String)spectrumFile.getName()) + "_settings.xml";
                File settingsFile = new File(outputFolder, newName);
                if (!settingsFile.exists()) continue;
                totalUncompressedSize += settingsFile.length();
            }
        }
        for (HashMap<Integer, File> fileMap : identificationFiles.values()) {
            for (File identificationFile : fileMap.values()) {
                totalUncompressedSize += identificationFile.length();
            }
        }
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (utilitiesUserParameters.outputData()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData();
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeAlgorithm(File inputFile, File outputFolder, Integer algorithm, File parametersFile, ArrayList<File> identificationFiles) {
        long totalUncompressedSize = 0L;
        totalUncompressedSize += inputFile.length();
        totalUncompressedSize += parametersFile.length();
        if (algorithm.intValue() == Advocate.omssa.getIndex()) {
            Iterator<File> modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += ((File)((Object)modificationsFile)).length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (algorithm.intValue() == Advocate.msAmanda.getIndex()) {
            for (File spectrumFile : this.msFiles) {
                String newName = IoUtil.removeExtension((String)spectrumFile.getName()) + "_settings.xml";
                File settingsFile = new File(outputFolder, newName);
                if (!settingsFile.exists()) continue;
                totalUncompressedSize += settingsFile.length();
            }
        }
        for (File identificationFile : identificationFiles) {
            totalUncompressedSize += identificationFile.length();
        }
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (utilitiesUserParameters.outputData()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData();
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeRun(File inputFile, File outputFolder, String runName, String run, File parametersFile, HashMap<String, HashMap<Integer, File>> identificationFiles, File spectrumFile, File cmsFile) {
        String newName;
        Object settingsFile;
        long totalUncompressedSize = 0L;
        totalUncompressedSize += inputFile.length();
        totalUncompressedSize += parametersFile.length();
        if (this.enableOmssa) {
            File modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += modificationsFile.length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (this.enableMsAmanda && ((File)(settingsFile = new File(outputFolder, newName = runName + "_settings.xml"))).exists()) {
            totalUncompressedSize += ((File)settingsFile).length();
        }
        HashMap<Integer, File> fileMap = identificationFiles.get(run);
        for (File identificationFile : fileMap.values()) {
            totalUncompressedSize += identificationFile.length();
        }
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (utilitiesUserParameters.outputData()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData(spectrumFile, cmsFile);
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeOfData() {
        return this.getTotalUncompressedSizeOfData(null, null);
    }

    private long getTotalUncompressedSizeOfData(File spectrumFile, File cmsFile) {
        long totalUncompressedSize = this.fastaFile.length();
        if (spectrumFile != null) {
            totalUncompressedSize += spectrumFile.length();
        } else {
            for (File tempSpectrumFile : this.getSpectrumFiles()) {
                totalUncompressedSize += tempSpectrumFile.length();
            }
        }
        if (cmsFile != null) {
            totalUncompressedSize += cmsFile.length();
        } else {
            for (File tempCmsFile : this.getCmsFiles()) {
                totalUncompressedSize += tempCmsFile.length();
            }
        }
        return totalUncompressedSize;
    }

    public File getPeakListFolder(File configFolder) {
        File peakListFolder = new File(SearchHandler.getTempFolderPath(configFolder), PEAK_LIST_SUBFOLDER);
        if (!peakListFolder.exists()) {
            peakListFolder.mkdirs();
        }
        return peakListFolder;
    }

    public static String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath((String)new SearchHandler().getClass().getResource("SearchHandler.class").getPath(), (String)"SearchGUI");
    }

    public static File getConfigFolder() {
        if (configFolder != null) {
            return configFolder;
        }
        return new File(SearchHandler.getJarFilePath());
    }

    public static String getTempFolderPath(File configFolder) {
        File tempFolder;
        if (tempFolderPath == null && !(tempFolder = new File(tempFolderPath = configFolder.toString().equals(".") ? "resources" + File.separator + "temp" : configFolder + File.separator + "resources" + File.separator + "temp")).exists()) {
            tempFolder.mkdirs();
        }
        return tempFolderPath;
    }

    public static void setTempFolderPath(String tempFolderPath) {
        SearchHandler.tempFolderPath = tempFolderPath;
    }

    public static String getTempSearchEngineFolderPath(File configFolder) {
        if (tempSearchEngineFolderPath == null) {
            tempSearchEngineFolderPath = configFolder.toString().equals(".") ? "resources" + File.separator + "temp" + File.separator + "search_engines" : configFolder + File.separator + "resources" + File.separator + "temp" + File.separator + "search_engines";
        }
        File tempFolder = new File(tempSearchEngineFolderPath);
        tempSearchEngineFolderPath = tempFolder.getAbsolutePath();
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        return tempSearchEngineFolderPath;
    }

    public static void setTempSearchEngineFolderPath(String tempSearchEngineFolderPath) {
        SearchHandler.tempSearchEngineFolderPath = tempSearchEngineFolderPath;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
    }

    public static String loadModifications(SearchParameters searchParameters) {
        String error = null;
        ArrayList toCheck = ModificationFactory.getInstance().loadBackedUpModifications(searchParameters, true);
        if (!toCheck.isEmpty()) {
            error = "The definition of the following PTM(s) seems to have changed and were overwritten:\n";
            for (int i = 0; i < toCheck.size(); ++i) {
                if (i > 0) {
                    error = i < toCheck.size() - 1 ? error + ", " : error + " and ";
                }
                error = error + (String)toCheck.get(i);
            }
            error = error + ".\nPlease verify the definition of the PTM(s) in the modifications editor.";
        }
        return error;
    }

    public static String getDefaultOutputFileName() {
        return defaultOutputFileName;
    }

    public static void setDefaultOutputFileName(String newOutputFileName) {
        defaultOutputFileName = newOutputFileName;
    }

    public static void setCloseProcessWhenDone(boolean aCloseProcessWhenDone) {
        closeProcessWhenDone = aCloseProcessWhenDone;
    }

    private class SearchWorker
    extends SwingWorker {
        private WaitingHandler waitingHandler;
        private boolean finished = false;

        public SearchWorker(WaitingHandler waitingHandler) {
            this.waitingHandler = waitingHandler;
            if (waitingHandler instanceof WaitingDialog) {
                ((JFrame)((WaitingDialog)waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
        }

        public void cancelRun() {
            if (this.waitingHandler != null) {
                this.waitingHandler.setWaitingText("Canceling");
            }
            if (SearchHandler.this.makeblastdbProcessBuilder != null) {
                SearchHandler.this.makeblastdbProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msConvertProcessBuilders != null) {
                for (MsConvertProcessBuilder msConvertProcessBuilder : SearchHandler.this.msConvertProcessBuilders) {
                    msConvertProcessBuilder.endProcess();
                }
            }
            if (SearchHandler.this.thermoRawFileParserProcessBuilders != null) {
                for (ThermoRawFileParserProcessBuilder thermoRawFileParserProcessBuilder : SearchHandler.this.thermoRawFileParserProcessBuilders) {
                    thermoRawFileParserProcessBuilder.endProcess();
                }
            }
            if (SearchHandler.this.omssaProcessBuilder != null) {
                SearchHandler.this.omssaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.xTandemProcessBuilder != null) {
                SearchHandler.this.xTandemProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msgfProcessBuilder != null) {
                SearchHandler.this.msgfProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msAmandaProcessBuilder != null) {
                SearchHandler.this.msAmandaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.myriMatchProcessBuilder != null) {
                SearchHandler.this.myriMatchProcessBuilder.endProcess();
            }
            if (SearchHandler.this.cometProcessBuilder != null) {
                SearchHandler.this.cometProcessBuilder.endProcess();
            }
            if (SearchHandler.this.tideIndexProcessBuilder != null) {
                SearchHandler.this.tideIndexProcessBuilder.endProcess();
            }
            if (SearchHandler.this.tideSearchProcessBuilder != null) {
                SearchHandler.this.tideSearchProcessBuilder.endProcess();
            }
            if (SearchHandler.this.andromedaProcessBuilder != null) {
                SearchHandler.this.andromedaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.metaMorpheusProcessBuilder != null) {
                SearchHandler.this.metaMorpheusProcessBuilder.endProcess();
            }
            if (SearchHandler.this.sageProcessBuilder != null) {
                SearchHandler.this.sageProcessBuilder.endProcess();
            }
            if (SearchHandler.this.novorProcessBuilder != null) {
                SearchHandler.this.novorProcessBuilder.endProcess();
            }
            if (SearchHandler.this.direcTagProcessBuilder != null) {
                SearchHandler.this.direcTagProcessBuilder.endProcess();
            }
            if (SearchHandler.this.peptideShakerProcessBuilder != null) {
                SearchHandler.this.peptideShakerProcessBuilder.endProcess();
            }
        }

        protected Object doInBackground() {
            try {
                File tempSearchEngineFolder;
                File outputTempFolder;
                UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
                File outputFolder = SearchHandler.this.getResultsFolder();
                if (utilitiesUserParameters.getSearchGuiOutputParameters() == OutputParameters.no_zip) {
                    outputTempFolder = outputFolder;
                } else {
                    try {
                        outputTempFolder = new File(outputFolder, SearchHandler.OUTPUT_TEMP_FOLDER_NAME);
                        if (outputTempFolder.exists()) {
                            IoUtil.deleteDir((File)outputTempFolder);
                        }
                        outputTempFolder.mkdirs();
                        TempFilesManager.registerTempFolder((File)outputTempFolder);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        outputTempFolder = outputFolder;
                    }
                }
                int nRawFiles = SearchHandler.this.getRawFiles().size();
                int nFilesToSearch = nRawFiles + SearchHandler.this.getSpectrumFiles().size();
                int nProgress = 3 + nRawFiles;
                if (SearchHandler.this.enableOmssa) {
                    nProgress += nFilesToSearch;
                    ++nProgress;
                }
                if (SearchHandler.this.enableXtandem) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMsgf) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMsAmanda) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMyriMatch) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableComet) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableTide) {
                    nProgress += nFilesToSearch;
                    ++nProgress;
                }
                if (SearchHandler.this.enableAndromeda) {
                    nProgress += nFilesToSearch;
                    ++nProgress;
                }
                if (SearchHandler.this.enableMetaMorpheus) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableSage) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableNovor) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableDirecTag) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enablePeptideShaker) {
                    ++nProgress;
                }
                if (SearchHandler.this.enableReporter) {
                    ++nProgress;
                }
                this.waitingHandler.setPrimaryProgressCounterIndeterminate(false);
                this.waitingHandler.setMaxPrimaryProgressCounter(nProgress);
                this.waitingHandler.increasePrimaryProgressCounter();
                SearchParameters searchParameters = SearchHandler.this.identificationParameters.getSearchParameters();
                if (SearchHandler.this.enableOmssa) {
                    File modsXmlFile;
                    File omssaTempFolder;
                    SearchHandler.this.makeblastdbProcessBuilder = new MakeblastdbProcessBuilder(SearchHandler.getJarFilePath(), SearchHandler.this.fastaFile, SearchHandler.this.makeblastdbLocation, this.waitingHandler, SearchHandler.this.exceptionHandler);
                    if (SearchHandler.this.makeblastdbProcessBuilder.needsFormatting()) {
                        if (this.waitingHandler != null) {
                            if (!useCommandLine) {
                                this.waitingHandler.setWaitingText("Formatting " + SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " for OMSSA.");
                            }
                            this.waitingHandler.appendReport("Formatting " + SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " for OMSSA.", true, true);
                            this.waitingHandler.appendReportEndLine();
                        }
                        SearchHandler.this.makeblastdbProcessBuilder.startProcess();
                        if (this.waitingHandler != null) {
                            this.waitingHandler.appendReport(SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " formatted for OMSSA.", true, true);
                            this.waitingHandler.appendReportEndLine();
                        }
                    }
                    if (!(omssaTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "omssa")).exists()) {
                        omssaTempFolder.mkdirs();
                    }
                    if (!(modsXmlFile = new File(SearchHandler.this.omssaLocation, "mods.xml")).exists()) {
                        throw new IllegalArgumentException("OMSSA mods.xml file not found.");
                    }
                    File userModsXmlFile = new File(omssaTempFolder, "usermods.xml");
                    OmssaclProcessBuilder.writeOmssaUserModificationsFile(userModsXmlFile, SearchHandler.this.identificationParameters, SearchHandler.this.identificationParametersFile);
                    File destinationFile = new File(outputTempFolder, "omssa_mods.xml");
                    IoUtil.copyFile((File)modsXmlFile, (File)destinationFile);
                    destinationFile = new File(outputTempFolder, "omssa_usermods.xml");
                    IoUtil.copyFile((File)userModsXmlFile, (File)destinationFile);
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                if (SearchHandler.this.enableAndromeda) {
                    if (!useCommandLine) {
                        this.waitingHandler.setWaitingText("Andromeda configuration.");
                    }
                    this.waitingHandler.appendReport("Andromeda configuration.", true, true);
                    this.waitingHandler.appendReportEndLine();
                    AndromedaProcessBuilder.createGenericFastaFile(new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "andromeda"), SearchHandler.this.fastaFile, this.waitingHandler);
                    AndromedaProcessBuilder.createDatabaseFile(SearchHandler.this.andromedaLocation, new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "andromeda"), SearchHandler.this.fastaFile);
                    AndromedaProcessBuilder.createEnzymesFile(SearchHandler.this.andromedaLocation);
                    AndromedaProcessBuilder.createPtmFile(SearchHandler.this.andromedaLocation, SearchHandler.this.identificationParameters, SearchHandler.this.identificationParametersFile);
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                if (SearchHandler.this.enableTide && !this.waitingHandler.isRunCanceled()) {
                    if (SearchHandler.this.tideIndexLocation == null || !SearchHandler.this.tideIndexLocation.exists()) {
                        File tideTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "tide");
                        TideParameters tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
                        if (tideParameters.getRemoveTempFolders().booleanValue() || !tideTempFolder.exists() || tideTempFolder.listFiles().length == 0) {
                            SearchHandler.this.tideIndexProcessBuilder = new TideIndexProcessBuilder(SearchHandler.this.tideLocation, tideTempFolder, SearchHandler.this.tideIndexLocation, SearchHandler.this.fastaFile, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                            this.waitingHandler.appendReport("Indexing " + SearchHandler.this.fastaFile.getName() + " for Tide.", true, true);
                            this.waitingHandler.appendReportEndLine();
                            SearchHandler.this.tideIndexProcessBuilder.startProcess();
                        }
                    }
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                ExecutorService pool = Executors.newFixedThreadPool(SearchHandler.this.processingParameters.getnThreads());
                ArrayList<File> rawFiles = SearchHandler.this.getRawFiles();
                if (!rawFiles.isEmpty() && !this.waitingHandler.isRunCanceled()) {
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setMaxSecondaryProgressCounter(rawFiles.size() * 100);
                    Duration conversionDuration = new Duration();
                    conversionDuration.start();
                    this.waitingHandler.appendReport("Converting raw files.", true, true);
                    boolean useThermoRawFileParser = true;
                    for (File tempRawFile : rawFiles) {
                        if (tempRawFile.getName().toLowerCase().endsWith(ProteoWizardMsFormat.raw.fileNameEnding)) continue;
                        useThermoRawFileParser = false;
                    }
                    if (useThermoRawFileParser) {
                        SearchHandler.this.thermoRawFileParserProcessBuilders = new ArrayList();
                        File thermoRawFileParserFolder = new File(SearchHandler.getJarFilePath() + File.separator + "resources" + File.separator + "ThermoRawFileParser");
                        ThermoRawFileParserParameters thermoRawFileParserParameters = SearchHandler.this.getThermoRawFileParserParameters();
                        for (int i = 0; i < rawFiles.size() && !this.waitingHandler.isRunCanceled(); ++i) {
                            File rawFile = rawFiles.get(i);
                            String rawFileName = rawFile.getName();
                            File folder = rawFile.getParentFile();
                            String msFileName = IoUtil.removeExtension((String)rawFileName) + thermoRawFileParserParameters.getOutputFormat().fileNameEnding.toLowerCase();
                            File msFile = new File(folder, msFileName);
                            if (!(msFile = IoUtil.existsExtensionNotCaseSensitive((File)msFile)).exists()) {
                                ThermoRawFileParserProcessBuilder thermoRawFileParserProcessBuilder = new ThermoRawFileParserProcessBuilder(thermoRawFileParserFolder, rawFile, folder, thermoRawFileParserParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                                SearchHandler.this.thermoRawFileParserProcessBuilders.add(thermoRawFileParserProcessBuilder);
                                pool.submit(thermoRawFileParserProcessBuilder);
                            } else {
                                this.waitingHandler.appendReport(msFileName + " already exists. Conversion canceled.", true, true);
                                this.waitingHandler.appendReportEndLine();
                            }
                            SearchHandler.this.msFiles.add(msFile);
                        }
                    } else {
                        SearchHandler.this.msConvertProcessBuilders = new ArrayList();
                        for (int i = 0; i < rawFiles.size() && !this.waitingHandler.isRunCanceled(); ++i) {
                            MsConvertParameters msConvertParameters = SearchHandler.this.getMsConvertParameters();
                            File rawFile = rawFiles.get(i);
                            String rawFileName = rawFile.getName();
                            File folder = rawFile.getParentFile();
                            String msFileName = IoUtil.removeExtension((String)rawFileName) + msConvertParameters.getMsFormat().fileNameEnding;
                            File msFile = new File(folder, msFileName);
                            if (!(msFile = IoUtil.existsExtensionNotCaseSensitive((File)msFile)).exists()) {
                                MsConvertProcessBuilder msConvertProcessBuilder = new MsConvertProcessBuilder(rawFile, folder, msConvertParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                                SearchHandler.this.msConvertProcessBuilders.add(msConvertProcessBuilder);
                                pool.submit(msConvertProcessBuilder);
                            } else {
                                this.waitingHandler.appendReport(msFileName + " already exists. Conversion canceled.", true, true);
                                this.waitingHandler.appendReportEndLine();
                            }
                            SearchHandler.this.msFiles.add(msFile);
                        }
                    }
                    if (this.waitingHandler.isRunCanceled()) {
                        pool.shutdownNow();
                    } else {
                        pool.shutdown();
                        if (!pool.awaitTermination(1 * rawFiles.size(), TimeUnit.DAYS)) {
                            throw new InterruptedException("Conversion timed out. Please contact the developers.");
                        }
                        if (!this.waitingHandler.isRunCanceled() && rawFiles.size() > 1) {
                            conversionDuration.end();
                            this.waitingHandler.appendReport("Raw files conversion completed (" + conversionDuration.toString() + ").", true, true);
                        }
                    }
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                }
                if (!this.waitingHandler.isRunCanceled()) {
                    this.waitingHandler.appendReportEndLine();
                    this.waitingHandler.appendReport("Importing spectrum files.", true, true);
                    Duration spectrumFilesImportDuration = new Duration();
                    spectrumFilesImportDuration.start();
                    for (File spectrumFile : SearchHandler.this.msFiles) {
                        this.waitingHandler.appendReport("Importing spectrum file " + spectrumFile.getName(), true, true);
                        File folder = CmsFolder.getParentFolder() == null ? spectrumFile.getParentFile() : new File(CmsFolder.getParentFolder());
                        SearchHandler.this.msFileHandler.register(spectrumFile, folder, this.waitingHandler);
                        File cmsFile = new File(MsFileHandler.getCmsFilePath((File)spectrumFile, (File)folder));
                        SearchHandler.this.cmsFiles.add(cmsFile);
                    }
                    spectrumFilesImportDuration.end();
                    this.waitingHandler.appendReport("Importing spectrum files completed (" + spectrumFilesImportDuration.toString() + ").", true, true);
                    this.waitingHandler.appendReportEndLine();
                }
                if (!this.waitingHandler.isRunCanceled()) {
                    SearchHandler.this.saveInputFile(outputTempFolder);
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                HashMap<String, HashMap<Integer, File>> identificationFiles = new HashMap<String, HashMap<Integer, File>>(SearchHandler.this.msFiles.size());
                SearchHandler.this.idFileToSpectrumFileMap = new HashMap();
                for (int i = 0; i < SearchHandler.this.getSpectrumFiles().size() && !this.waitingHandler.isRunCanceled(); ++i) {
                    File tempResultFile;
                    HashMap<Integer, File> runIdentificationFiles;
                    HashMap<Integer, File> runIdentificationFiles2;
                    HashMap<Integer, File> runIdentificationFiles3;
                    File spectrumFile = SearchHandler.this.getSpectrumFiles().get(i);
                    String spectrumFileName = spectrumFile.getName();
                    if (useCommandLine) {
                        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Processing: " + spectrumFileName + " (" + (i + 1) + "/" + SearchHandler.this.getSpectrumFiles().size() + ")");
                    } else {
                        this.waitingHandler.setWaitingText("Processing: " + spectrumFileName + " (" + (i + 1) + "/" + SearchHandler.this.getSpectrumFiles().size() + ")");
                    }
                    File mgfFile = null;
                    if (SearchHandler.this.enableXtandem || SearchHandler.this.enableMyriMatch || SearchHandler.this.enableOmssa || SearchHandler.this.enableNovor || SearchHandler.this.enableDirecTag) {
                        this.waitingHandler.appendReport("Converting spectrum file " + spectrumFileName + " to peak list.", true, true);
                        mgfFile = new File(SearchHandler.this.getPeakListFolder(SearchHandler.getConfigFolder()), IoUtil.removeExtension((String)spectrumFileName) + ".mgf");
                        MsFileExporter.writeMgfFile((SpectrumProvider)SearchHandler.this.msFileHandler, (boolean)false, (String)IoUtil.removeExtension((String)spectrumFileName), (File)mgfFile, (WaitingHandler)this.waitingHandler);
                    }
                    this.waitingHandler.appendReportEndLine();
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                    if (SearchHandler.this.enableXtandem && !this.waitingHandler.isRunCanceled()) {
                        File xTandemOutputFile = new File(outputTempFolder, SearchHandler.getXTandemFileName(spectrumFileName));
                        File xTandemTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "xtandem");
                        SearchHandler.this.xTandemProcessBuilder = new TandemProcessBuilder(SearchHandler.this.xtandemLocation, xTandemTempFolder, mgfFile, SearchHandler.this.fastaFile, xTandemOutputFile.getAbsolutePath(), searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + mgfFile.getName() + " with " + Advocate.xtandem.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.xTandemProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            if (utilitiesUserParameters.renameXTandemFile()) {
                                ArrayList<File> result = SearchHandler.this.getXTandemFiles(outputTempFolder, spectrumFileName);
                                if (result.size() == 1) {
                                    File xTandemFile = result.get(0);
                                    File destinationFile = new File(outputTempFolder, SearchHandler.getXTandemFileName(spectrumFileName));
                                    try {
                                        xTandemFile.renameTo(destinationFile);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.waitingHandler.appendReport("Could not rename " + Advocate.xtandem.getName() + " result for " + spectrumFileName + ".", true, true);
                                    }
                                } else {
                                    this.waitingHandler.appendReport("Could not rename " + Advocate.xtandem.getName() + " result for " + spectrumFileName + ".", true, true);
                                }
                            }
                            if ((runIdentificationFiles3 = identificationFiles.get(spectrumFileName)) == null) {
                                runIdentificationFiles3 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles3);
                            }
                            if (xTandemOutputFile.exists()) {
                                runIdentificationFiles3.put(Advocate.xtandem.getIndex(), xTandemOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(xTandemOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.xtandem.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMyriMatch && !this.waitingHandler.isRunCanceled()) {
                        File myriMatchOutputFile = new File(outputTempFolder, SearchHandler.this.getMyriMatchFileName(spectrumFileName));
                        SearchHandler.this.myriMatchProcessBuilder = new MyriMatchProcessBuilder(SearchHandler.this.myriMatchLocation, mgfFile, SearchHandler.this.fastaFile, outputTempFolder, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + mgfFile.getName() + " with " + Advocate.myriMatch.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.myriMatchProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            HashMap<Integer, File> runIdentificationFiles4 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles4 == null) {
                                runIdentificationFiles4 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles4);
                            }
                            if (myriMatchOutputFile.exists()) {
                                runIdentificationFiles4.put(Advocate.myriMatch.getIndex(), myriMatchOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(myriMatchOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.myriMatch.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMsAmanda && !this.waitingHandler.isRunCanceled()) {
                        File msAmandaOutputFile = new File(outputTempFolder, SearchHandler.this.getMsAmandaFileName(spectrumFileName));
                        String filePath = msAmandaOutputFile.getAbsolutePath();
                        File msAmandaTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "msamanda");
                        SearchHandler.this.msAmandaProcessBuilder = new MsAmandaProcessBuilder(SearchHandler.this.msAmandaLocation, msAmandaTempFolder, spectrumFile, SearchHandler.this.fastaFile, filePath, searchParameters, SearchHandler.this.identificationParameters.getFastaParameters(), this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + spectrumFile.getName() + " with " + Advocate.msAmanda.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.msAmandaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles2 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles2 == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles2);
                            }
                            if (msAmandaOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.msAmanda.getIndex(), msAmandaOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(msAmandaOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msAmanda.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMsgf && !this.waitingHandler.isRunCanceled()) {
                        File msgfOutputFile = new File(outputTempFolder, SearchHandler.getMsgfFileName(spectrumFileName));
                        File msgfTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "msgf");
                        SearchHandler.this.msgfProcessBuilder = new MsgfProcessBuilder(SearchHandler.this.msgfLocation, msgfTempFolder, spectrumFile, SearchHandler.this.fastaFile, msgfOutputFile, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads(), useCommandLine);
                        this.waitingHandler.appendReport("Processing " + spectrumFile.getName() + " with " + Advocate.msgf.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.msgfProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles3 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles3 == null) {
                                runIdentificationFiles3 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles3);
                            }
                            if (msgfOutputFile.exists()) {
                                runIdentificationFiles3.put(Advocate.msgf.getIndex(), msgfOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(msgfOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msgf.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableOmssa && !this.waitingHandler.isRunCanceled()) {
                        File omssaOutputFile = new File(outputTempFolder, SearchHandler.this.getOMSSAFileName(spectrumFileName));
                        File omssaTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "omssa");
                        SearchHandler.this.omssaProcessBuilder = new OmssaclProcessBuilder(SearchHandler.this.omssaLocation, omssaTempFolder, mgfFile, SearchHandler.this.fastaFile, omssaOutputFile, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, utilitiesUserParameters.getRefMass(), SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + mgfFile.getName() + " with " + Advocate.omssa.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.omssaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles3 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles3 == null) {
                                runIdentificationFiles3 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles3);
                            }
                            if (omssaOutputFile.exists()) {
                                runIdentificationFiles3.put(Advocate.omssa.getIndex(), omssaOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(omssaOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.omssa.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableComet && !this.waitingHandler.isRunCanceled()) {
                        File cometOutputFile = new File(outputTempFolder, SearchHandler.this.getCometFileName(spectrumFileName));
                        if (cometOutputFile.exists()) {
                            cometOutputFile.delete();
                        }
                        File cometTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "comet");
                        SearchHandler.this.cometProcessBuilder = new CometProcessBuilder(SearchHandler.this.cometLocation, cometTempFolder, searchParameters, spectrumFile, SearchHandler.this.fastaFile, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads(), utilitiesUserParameters.getRefMass());
                        this.waitingHandler.appendReport("Processing " + spectrumFile.getName() + " with " + Advocate.comet.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.cometProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            File tempCometOutputFile = new File(spectrumFile.getParent(), SearchHandler.this.getCometFileName(spectrumFileName));
                            FileUtils.moveFile((File)tempCometOutputFile, (File)cometOutputFile);
                            runIdentificationFiles2 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles2 == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles2);
                            }
                            if (cometOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.comet.getIndex(), cometOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(cometOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.comet.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    File ms2File = null;
                    if (SearchHandler.this.enableTide && !this.waitingHandler.isRunCanceled()) {
                        this.waitingHandler.appendReport("Converting spectrum file " + spectrumFileName + " for Tide.", true, true);
                        ms2File = new File(SearchHandler.this.getPeakListFolder(SearchHandler.getConfigFolder()), IoUtil.removeExtension((String)spectrumFileName) + ".ms2");
                        MsFileExporter.writeMs2File((SpectrumProvider)SearchHandler.this.msFileHandler, (boolean)false, (String)IoUtil.removeExtension((String)spectrumFileName), (File)ms2File, (WaitingHandler)this.waitingHandler);
                        File tideOutputFile = new File(outputTempFolder, SearchHandler.this.getTideFileName(spectrumFileName));
                        File tideTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "tide");
                        if (!this.waitingHandler.isRunCanceled()) {
                            SearchHandler.this.tideSearchProcessBuilder = new TideSearchProcessBuilder(SearchHandler.this.tideLocation, tideTempFolder, SearchHandler.this.tideIndexLocation, searchParameters, ms2File, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                            this.waitingHandler.appendReport("Processing " + ms2File.getName() + " with " + Advocate.tide.getName() + ".", true, true);
                            this.waitingHandler.appendReportEndLine();
                            SearchHandler.this.tideSearchProcessBuilder.startProcess();
                        }
                        if (!this.waitingHandler.isRunCanceled()) {
                            String tideResultsFolderName = ((TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex())).getOutputFolderName();
                            File tempTideOutputFile = new File(new File(tideTempFolder, tideResultsFolderName), SearchHandler.this.getTideFileName(spectrumFileName));
                            FileUtils.moveFile((File)tempTideOutputFile, (File)tideOutputFile);
                            runIdentificationFiles = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles == null) {
                                runIdentificationFiles = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles);
                            }
                            if (tideOutputFile.exists()) {
                                runIdentificationFiles.put(Advocate.tide.getIndex(), tideOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(tideOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.tide.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    File aplFile = null;
                    if (SearchHandler.this.enableAndromeda && !this.waitingHandler.isRunCanceled()) {
                        this.waitingHandler.appendReport("Converting spectrum file " + spectrumFileName + " for Andromeda.", true, true);
                        aplFile = new File(SearchHandler.this.getPeakListFolder(SearchHandler.getConfigFolder()), IoUtil.removeExtension((String)spectrumFileName) + ".apl");
                        MsFileExporter.writeAplFile((SpectrumProvider)SearchHandler.this.msFileHandler, (boolean)false, (String)IoUtil.removeExtension((String)spectrumFileName), (File)aplFile, (SearchParameters)searchParameters, (WaitingHandler)this.waitingHandler);
                        File andromedaOutputFile = new File(outputTempFolder, SearchHandler.getAndromedaFileName(spectrumFileName));
                        File andromedaTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "andromeda");
                        SearchHandler.this.andromedaProcessBuilder = new AndromedaProcessBuilder(SearchHandler.this.andromedaLocation, andromedaTempFolder, searchParameters, SearchHandler.this.identificationParametersFile, aplFile, SearchHandler.this.fastaFile, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + aplFile.getName() + " with " + Advocate.andromeda.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.andromedaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            tempResultFile = new File(aplFile.getParent(), SearchHandler.getAndromedaFileName(spectrumFileName));
                            if (tempResultFile.exists()) {
                                IoUtil.copyFile((File)tempResultFile, (File)andromedaOutputFile);
                                try {
                                    tempResultFile.delete();
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred when attempting to delete " + tempResultFile.getName() + ".", true, true);
                                }
                                runIdentificationFiles = identificationFiles.get(spectrumFileName);
                                if (runIdentificationFiles == null) {
                                    runIdentificationFiles = new HashMap();
                                    identificationFiles.put(spectrumFileName, runIdentificationFiles);
                                }
                                if (andromedaOutputFile.exists()) {
                                    runIdentificationFiles.put(Advocate.andromeda.getIndex(), andromedaOutputFile);
                                    SearchHandler.this.idFileToSpectrumFileMap.put(andromedaOutputFile.getName(), spectrumFile);
                                } else {
                                    this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " result file for " + spectrumFileName + ".", true, true);
                                }
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " .res file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMetaMorpheus && !this.waitingHandler.isRunCanceled()) {
                        File metaMorpheusOutputFile = new File(outputTempFolder, SearchHandler.getMetaMorpheusFileName(spectrumFileName));
                        File metaMorpheusTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "metamorpheus");
                        SearchHandler.this.metaMorpheusProcessBuilder = new MetaMorpheusProcessBuilder(SearchHandler.this.metaMorpheusLocation, SearchHandler.this.metaMorpheusLocationSetByUser, metaMorpheusTempFolder, searchParameters, spectrumFile, SearchHandler.this.processingParameters.getnThreads(), SearchHandler.this.fastaFile, metaMorpheusOutputFile, this.waitingHandler, SearchHandler.this.exceptionHandler);
                        this.waitingHandler.appendReport("Processing " + spectrumFileName + " with " + Advocate.metaMorpheus.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.metaMorpheusProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            String taskFileName = ((MetaMorpheusParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex())).runGptm() ? "Task2SearchTask" : "Task1SearchTask";
                            File tempResultFile2 = new File(metaMorpheusTempFolder.getAbsolutePath() + File.separator + taskFileName, SearchHandler.getMetaMorpheusFileName(spectrumFileName));
                            if (tempResultFile2.exists()) {
                                IoUtil.copyFile((File)tempResultFile2, (File)metaMorpheusOutputFile);
                                try {
                                    tempResultFile2.delete();
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred when attempting to delete " + tempResultFile2.getName() + ".", true, true);
                                }
                                HashMap<Integer, File> runIdentificationFiles5 = identificationFiles.get(spectrumFileName);
                                if (runIdentificationFiles5 == null) {
                                    runIdentificationFiles5 = new HashMap();
                                    identificationFiles.put(spectrumFileName, runIdentificationFiles5);
                                }
                                if (metaMorpheusOutputFile.exists()) {
                                    runIdentificationFiles5.put(Advocate.metaMorpheus.getIndex(), metaMorpheusOutputFile);
                                    SearchHandler.this.idFileToSpectrumFileMap.put(metaMorpheusOutputFile.getName(), spectrumFile);
                                } else {
                                    this.waitingHandler.appendReport("Could not find " + Advocate.metaMorpheus.getName() + " result file for " + spectrumFileName + ".", true, true);
                                }
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.metaMorpheus.getName() + " .mzID file for " + spectrumFileName + ".", true, true);
                            }
                        }
                    }
                    if (SearchHandler.this.enableSage && !this.waitingHandler.isRunCanceled()) {
                        File sageOutputFile = new File(outputTempFolder, IoUtil.removeExtension((String)spectrumFileName) + ".sage.tsv");
                        File sageTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "sage");
                        SearchHandler.this.sageProcessBuilder = new SageProcessBuilder(SearchHandler.this.sageLocation, sageTempFolder, searchParameters, spectrumFile, SearchHandler.this.fastaFile, SearchHandler.this.identificationParameters.getFastaParameters().getDecoyFlag(), this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingParameters.getnThreads());
                        this.waitingHandler.appendReport("Processing " + spectrumFileName + " with " + Advocate.sage.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.sageProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            tempResultFile = new File(sageTempFolder.getAbsolutePath(), SearchHandler.getSageFileName(spectrumFileName));
                            if (tempResultFile.exists()) {
                                IoUtil.copyFile((File)tempResultFile, (File)sageOutputFile);
                                try {
                                    tempResultFile.delete();
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred when attempting to delete " + tempResultFile.getName() + ".", true, true);
                                }
                                runIdentificationFiles = identificationFiles.get(spectrumFileName);
                                if (runIdentificationFiles == null) {
                                    runIdentificationFiles = new HashMap();
                                    identificationFiles.put(spectrumFileName, runIdentificationFiles);
                                }
                                if (sageOutputFile.exists()) {
                                    runIdentificationFiles.put(Advocate.sage.getIndex(), sageOutputFile);
                                    SearchHandler.this.idFileToSpectrumFileMap.put(sageOutputFile.getName(), spectrumFile);
                                } else {
                                    this.waitingHandler.appendReport("Could not find " + Advocate.sage.getName() + " result file for " + spectrumFileName + ".", true, true);
                                }
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.sage.getName() + " .mzID file for " + spectrumFileName + ".", true, true);
                            }
                        }
                    }
                    if (SearchHandler.this.enableNovor && !this.waitingHandler.isRunCanceled()) {
                        File novorOutputFile = new File(outputTempFolder, SearchHandler.getNovorFileName(spectrumFileName));
                        File novorTempFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()), "novor");
                        SearchHandler.this.novorProcessBuilder = new NovorProcessBuilder(SearchHandler.this.novorLocation, novorTempFolder, mgfFile, novorOutputFile, searchParameters, useCommandLine, this.waitingHandler, SearchHandler.this.exceptionHandler);
                        this.waitingHandler.appendReport("Processing " + mgfFile.getName() + " with " + Advocate.novor.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.novorProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            HashMap<Integer, File> runIdentificationFiles6 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles6 == null) {
                                runIdentificationFiles6 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles6);
                            }
                            if (novorOutputFile.exists()) {
                                runIdentificationFiles6.put(Advocate.novor.getIndex(), novorOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(novorOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.novor.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableDirecTag && !this.waitingHandler.isRunCanceled()) {
                        File direcTagOutputFile = new File(outputTempFolder, SearchHandler.getDirecTagFileName(spectrumFileName));
                        SearchHandler.this.direcTagProcessBuilder = new DirecTagProcessBuilder(SearchHandler.this.direcTagLocation, mgfFile, SearchHandler.this.processingParameters.getnThreads(), outputTempFolder, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                        this.waitingHandler.appendReport("Processing " + mgfFile.getName() + " with " + Advocate.direcTag.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.direcTagProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles2 = identificationFiles.get(spectrumFileName);
                            if (runIdentificationFiles2 == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(spectrumFileName, runIdentificationFiles2);
                            }
                            if (direcTagOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.direcTag.getIndex(), direcTagOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(direcTagOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.direcTag.getName() + " result file for " + spectrumFileName + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (mgfFile != null) {
                        mgfFile.delete();
                    }
                    if (aplFile != null) {
                        aplFile.delete();
                    }
                    if (ms2File == null) continue;
                    ms2File.delete();
                }
                SearchHandler.this.identificationParametersFactory.addIdentificationParameters(SearchHandler.this.identificationParameters);
                outputTimeStamp = SearchHandler.getOutputDate();
                if (!this.waitingHandler.isRunCanceled()) {
                    if (utilitiesUserParameters.getSearchGuiOutputParameters() != OutputParameters.no_zip) {
                        this.waitingHandler.appendReport("Zipping output files.", true, true);
                    } else {
                        this.waitingHandler.appendReport("Preparing output files.", true, true);
                    }
                    this.waitingHandler.appendReportEndLine();
                    SearchHandler.this.organizeOutput(outputFolder, outputTempFolder, identificationFiles, IdentificationParametersFactory.getIdentificationParametersFile((String)SearchHandler.this.identificationParameters.getName()), utilitiesUserParameters.isIncludeDateInOutputName());
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                if (SearchHandler.this.enablePeptideShaker && !this.waitingHandler.isRunCanceled()) {
                    ArrayList<File> identificationFilesList = new ArrayList<File>();
                    identificationFilesList.addAll(SearchHandler.this.mascotFiles);
                    if (utilitiesUserParameters.getSearchGuiOutputParameters() == OutputParameters.grouped) {
                        File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, utilitiesUserParameters.isIncludeDateInOutputName());
                        if (outputFile.exists()) {
                            identificationFilesList.add(outputFile);
                        } else {
                            this.waitingHandler.appendReport("Could not find SearchGUI results.", true, true);
                        }
                    } else if (utilitiesUserParameters.getSearchGuiOutputParameters() == OutputParameters.algorithm) {
                        if (SearchHandler.this.enableMsAmanda) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.msAmanda.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msAmanda.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableMsgf) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.msgf.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msgf.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableMyriMatch) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.myriMatch.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.myriMatch.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableOmssa) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.omssa.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.omssa.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableXtandem) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.xtandem.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.xtandem.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableComet) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.comet.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.comet.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableTide) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.tide.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.tide.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableAndromeda) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.andromeda.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableAndromeda) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.andromeda.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableMetaMorpheus) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.metaMorpheus.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.metaMorpheus.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableSage) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.sage.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.sage.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableDirecTag) {
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.direcTag.getName(), utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.direcTag.getName() + " results.", true, true);
                            }
                        }
                    } else if (utilitiesUserParameters.getSearchGuiOutputParameters() == OutputParameters.run) {
                        for (String run : identificationFiles.keySet()) {
                            String runName = IoUtil.removeExtension((String)run);
                            File outputFile = SearchHandler.getDefaultOutputFile(outputFolder, runName, utilitiesUserParameters.isIncludeDateInOutputName());
                            if (outputFile.exists()) {
                                identificationFilesList.add(outputFile);
                                continue;
                            }
                            this.waitingHandler.appendReport("SearchGUI results not found for run " + runName + ".", true, true);
                        }
                    } else {
                        for (HashMap<Integer, File> fileMap : identificationFiles.values()) {
                            for (File identificationFile : fileMap.values()) {
                                identificationFilesList.add(identificationFile);
                            }
                        }
                    }
                    if (utilitiesUserParameters.getPeptideShakerPath() == null || !new File(utilitiesUserParameters.getPeptideShakerPath()).exists()) {
                        this.waitingHandler.appendReport("PeptideShaker not found! Please check the PeptideShaker path.", true, true);
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.setRunCanceled();
                    } else if (!identificationFiles.isEmpty()) {
                        ArrayList<File> cmsAndMsFiles = new ArrayList<File>(SearchHandler.this.cmsFiles.size() + SearchHandler.this.msFiles.size());
                        cmsAndMsFiles.addAll(SearchHandler.this.cmsFiles);
                        cmsAndMsFiles.addAll(SearchHandler.this.msFiles);
                        if (utilitiesUserParameters.isIncludeDateInOutputName()) {
                            SearchHandler.this.peptideShakerFile = new File(SearchHandler.this.peptideShakerFile.getParentFile(), IoUtil.removeExtension((String)SearchHandler.this.peptideShakerFile.getName()) + "_" + outputTimeStamp + ".psdb");
                        }
                        SearchHandler.this.peptideShakerProcessBuilder = new PeptideShakerProcessBuilder(this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.experimentLabel, cmsAndMsFiles, SearchHandler.this.fastaFile, identificationFilesList, IdentificationParametersFactory.getIdentificationParametersFile((String)SearchHandler.this.identificationParameters.getName()), SearchHandler.this.peptideShakerFile, true, SearchHandler.this.processingParameters, utilitiesUserParameters.outputData());
                        this.waitingHandler.appendReport("Processing identification files with PeptideShaker.", true, true);
                        SearchHandler.this.peptideShakerProcessBuilder.startProcess();
                    } else {
                        SearchHandler.this.enablePeptideShaker = false;
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReport("No identification files to process with PeptideShaker.", true, true);
                        this.waitingHandler.appendReportEndLine();
                    }
                }
                if (!outputFolder.getAbsolutePath().equals(outputTempFolder.getAbsolutePath())) {
                    boolean deleteTempFolder = true;
                    if (!identificationFiles.isEmpty() && this.waitingHandler.isRunCanceled() && this.waitingHandler instanceof WaitingDialog) {
                        WaitingDialog guiWaitingDialog = (WaitingDialog)this.waitingHandler;
                        ((JFrame)guiWaitingDialog.getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                        int option = JOptionPane.showConfirmDialog((Component)guiWaitingDialog, "Keep the partial search results?", "Keep Partial Results?", 0);
                        deleteTempFolder = option == 1;
                        ((JFrame)guiWaitingDialog.getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                    }
                    if (deleteTempFolder) {
                        IoUtil.deleteDir((File)outputTempFolder);
                    }
                }
                if ((tempSearchEngineFolder = new File(SearchHandler.getTempSearchEngineFolderPath(SearchHandler.getConfigFolder()))).exists()) {
                    TideParameters tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
                    for (File tempFile : tempSearchEngineFolder.listFiles()) {
                        if (!tempFile.getName().equalsIgnoreCase("tide") || tempFile.getName().equalsIgnoreCase("tide") && tideParameters.getRemoveTempFolders().booleanValue()) {
                            if (tempFile.isDirectory()) {
                                FileUtils.deleteDirectory((File)tempFile);
                                continue;
                            }
                            FileUtils.delete((File)tempFile);
                            continue;
                        }
                        for (File tempTideFolder : tempFile.listFiles()) {
                            if (tideParameters.getRemoveTempFolders().booleanValue()) {
                                IoUtil.deleteDir((File)tempTideFolder);
                                continue;
                            }
                            if (tempTideFolder.getName().equalsIgnoreCase("fasta-index")) continue;
                            IoUtil.deleteDir((File)tempTideFolder);
                        }
                    }
                }
                this.finished = true;
                if (!this.waitingHandler.isRunCanceled()) {
                    SearchHandler.this.searchCompleted();
                } else {
                    SearchHandler.this.searchCrashed();
                }
                SearchHandler.this.notifySearchFinished();
                return 0;
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("Error: " + e.getMessage(), true, true);
                this.waitingHandler.appendReport("An error occurred while running SearchGUI. Please contact the developers.", true, true);
                e.printStackTrace();
                SearchHandler.this.searchCrashed();
                return 1;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

