/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.MetaMorpheusParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class MetaMorpheusProcessBuilder
extends SearchGUIProcessBuilder {
    private File metaMorpheusFolder;
    private boolean metaMorpheusLocationSetByUser;
    private File metaMorpheusTempFolder;
    private File spectrumFile;
    private File fastaFile;
    private SearchParameters searchParameters;
    private MetaMorpheusParameters metaMorpheusParameters;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private int numberOfThreads;

    public MetaMorpheusProcessBuilder(File metaMorpheusFolder, boolean metaMorpheusLocationSetByUser, File metaMorpheusTempFolder, SearchParameters searchParameters, File spectrumFile, int threads, File fastaFile, File outputFile, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException {
        String operatingSystem;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.metaMorpheusFolder = metaMorpheusFolder;
        this.metaMorpheusLocationSetByUser = metaMorpheusLocationSetByUser;
        this.metaMorpheusTempFolder = metaMorpheusTempFolder;
        this.searchParameters = searchParameters;
        this.metaMorpheusParameters = (MetaMorpheusParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex());
        this.spectrumFile = spectrumFile;
        this.numberOfThreads = threads;
        this.fastaFile = fastaFile;
        if (!metaMorpheusTempFolder.exists()) {
            metaMorpheusTempFolder.mkdirs();
        }
        File metaMorpheus = new File(metaMorpheusFolder.getAbsolutePath() + File.separator + MetaMorpheusProcessBuilder.getExecutableFileName(metaMorpheusLocationSetByUser));
        metaMorpheus.setExecutable(true);
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "Contaminants"), (File)new File(metaMorpheusTempFolder, "Contaminants"));
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "CustomAminoAcids"), (File)new File(metaMorpheusTempFolder, "CustomAminoAcids"));
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "Data"), (File)new File(metaMorpheusTempFolder, "Data"));
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "Glycan_Mods"), (File)new File(metaMorpheusTempFolder, "Glycan_Mods"));
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "Mods"), (File)new File(metaMorpheusTempFolder, "Mods"));
        FileUtils.copyDirectory((File)new File(metaMorpheusFolder, "Digestion"), (File)new File(metaMorpheusTempFolder, "Digestion"));
        File metaMorpheusModFile = new File(metaMorpheusTempFolder, "Mods" + File.separator + "CustomModifications.txt");
        this.createModificationsFile(metaMorpheusModFile);
        File metaMorpheusEnzymesFile = new File(metaMorpheusTempFolder, "ProteolyticDigestion" + File.separator + "proteases.tsv");
        this.createEnzymesFile(metaMorpheusEnzymesFile, searchParameters.getDigestionParameters());
        File metaMorpheusGptmdParameterFile = null;
        if (this.metaMorpheusParameters.runGptm()) {
            metaMorpheusGptmdParameterFile = this.createParameterFile(searchParameters, MetaMorpheusTaskType.Gptmd);
        }
        File metaMorpheusSearchParametersFile = this.createParameterFile(searchParameters, MetaMorpheusTaskType.Search);
        if (!(!metaMorpheusLocationSetByUser && CompomicsWrapper.appRunningIntoConda((String)"searchgui") || (operatingSystem = System.getProperty("os.name").toLowerCase()).contains("windows"))) {
            String dotNetPath = "dotnet";
            if (operatingSystem.contains("mac os x")) {
                dotNetPath = "/usr/local/share/dotnet/dotnet";
            }
            this.process_name_array.add(dotNetPath);
        }
        this.process_name_array.add(metaMorpheus.getAbsolutePath());
        this.process_name_array.add("--mmsettings");
        this.process_name_array.add(metaMorpheusTempFolder.getAbsolutePath());
        this.process_name_array.add("-d");
        this.process_name_array.add(fastaFile.getAbsolutePath());
        this.process_name_array.add("-s");
        this.process_name_array.add(spectrumFile.getAbsolutePath());
        this.process_name_array.add("-t");
        if (this.metaMorpheusParameters.runGptm() && metaMorpheusGptmdParameterFile != null) {
            this.process_name_array.add(metaMorpheusGptmdParameterFile.getAbsolutePath());
        }
        this.process_name_array.add(metaMorpheusSearchParametersFile.getAbsolutePath());
        this.process_name_array.add("-o");
        this.process_name_array.add(metaMorpheusTempFolder.getAbsolutePath());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "MetaMorpheus command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(metaMorpheusFolder);
        this.pb.redirectErrorStream(true);
    }

    public static String getExecutableFileName(boolean local) {
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (local || !CompomicsWrapper.appRunningIntoConda((String)"searchgui")) {
            if (operatingSystem.contains("windows")) {
                return "CMD.exe";
            }
            return "CMD.dll";
        }
        return "metamorpheus";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createParameterFile(SearchParameters searchParameters, MetaMorpheusTaskType taskType) throws IOException {
        File parameterFile = new File(this.metaMorpheusTempFolder, taskType.toString() + ".toml");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(parameterFile));){
            String enzymeName = "";
            Integer missedCleavages = null;
            DigestionParameters digestionParameters = searchParameters.getDigestionParameters();
            if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
                enzymeName = "Whole Protein";
                missedCleavages = 0;
            } else if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
                enzymeName = "Unspecific";
                missedCleavages = 24;
            } else {
                if (digestionParameters.getEnzymes().size() > 1) {
                    throw new IOException("Multiple enzymes not supported by MetaMorpheus!");
                }
                Enzyme enzyme = (Enzyme)digestionParameters.getEnzymes().get(0);
                enzymeName = enzyme.getName();
                missedCleavages = digestionParameters.getnMissedCleavages(enzymeName);
            }
            bw.write("TaskType = \"" + taskType.toString() + "\"" + System.getProperty("line.separator"));
            bw.newLine();
            if (taskType == MetaMorpheusTaskType.Gptmd) {
                bw.write("[GptmdParameters]" + System.getProperty("line.separator"));
                bw.write("ListOfModsGptmd = \"");
                for (ModificationCategory modCategory : this.metaMorpheusParameters.getGPtmCategories()) {
                    this.writeModifications(this.modificationFactory.getModifications(new ModificationCategory[]{modCategory}), bw);
                }
                bw.write("\"" + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            if (taskType == MetaMorpheusTaskType.Search) {
                bw.write("[SearchParameters]" + System.getProperty("line.separator"));
                bw.write("DisposeOfFileWhenDone = false" + System.getProperty("line.separator"));
                bw.write("DoParsimony = true" + System.getProperty("line.separator"));
                bw.write("ModPeptidesAreDifferent = " + this.metaMorpheusParameters.getModPeptidesAreDifferent() + System.getProperty("line.separator"));
                bw.write("NoOneHitWonders = " + this.metaMorpheusParameters.getNoOneHitWonders() + System.getProperty("line.separator"));
                bw.write("MatchBetweenRuns = false" + System.getProperty("line.separator"));
                bw.write("Normalize = false" + System.getProperty("line.separator"));
                bw.write("QuantifyPpmTol = 5.0" + System.getProperty("line.separator"));
                bw.write("DoHistogramAnalysis = false" + System.getProperty("line.separator"));
                bw.write("SearchTarget = " + this.metaMorpheusParameters.getSearchTarget() + System.getProperty("line.separator"));
                bw.write("DecoyType = \"" + this.metaMorpheusParameters.getDecoyType() + "\"" + System.getProperty("line.separator"));
                bw.write("MassDiffAcceptorType = \"" + this.metaMorpheusParameters.getMassDiffAcceptorType() + "\"" + System.getProperty("line.separator"));
                bw.write("WritePrunedDatabase = false" + System.getProperty("line.separator"));
                bw.write("KeepAllUniprotMods = true" + System.getProperty("line.separator"));
                bw.write("DoLocalizationAnalysis = true" + System.getProperty("line.separator"));
                bw.write("DoQuantification = false" + System.getProperty("line.separator"));
                bw.write("SearchType = \"" + this.metaMorpheusParameters.getSearchType() + "\"" + System.getProperty("line.separator"));
                bw.write("LocalFdrCategories = [\"FullySpecific\"]" + System.getProperty("line.separator"));
                bw.write("MaxFragmentSize = " + this.metaMorpheusParameters.getMaxFragmentSize() + System.getProperty("line.separator"));
                bw.write("MinAllowedInternalFragmentLength = " + this.metaMorpheusParameters.getMinAllowedInternalFragmentLength() + System.getProperty("line.separator"));
                bw.write("HistogramBinTolInDaltons = 0.003" + System.getProperty("line.separator"));
                bw.write("MaximumMassThatFragmentIonScoreIsDoubled = 0.0" + System.getProperty("line.separator"));
                bw.write("WriteMzId = " + this.metaMorpheusParameters.getWriteMzId() + System.getProperty("line.separator"));
                bw.write("WritePepXml = " + this.metaMorpheusParameters.getWritePepXml() + System.getProperty("line.separator"));
                bw.write("WriteDecoys = true" + System.getProperty("line.separator"));
                bw.write("WriteContaminants = true" + System.getProperty("line.separator"));
                bw.newLine();
                bw.write("[SearchParameters.ModsToWriteSelection]" + System.getProperty("line.separator"));
                bw.write("'N-linked glycosylation' = 3" + System.getProperty("line.separator"));
                bw.write("'O-linked glycosylation' = 3" + System.getProperty("line.separator"));
                bw.write("'Other glycosylation' = 3" + System.getProperty("line.separator"));
                bw.write("'Common Biological' = 3" + System.getProperty("line.separator"));
                bw.write("'Less Common' = 3" + System.getProperty("line.separator"));
                bw.write("Metal = 3" + System.getProperty("line.separator"));
                bw.write("'2+ nucleotide substitution' = 3" + System.getProperty("line.separator"));
                bw.write("'1 nucleotide substitution' = 3" + System.getProperty("line.separator"));
                bw.write("UniProt = 2" + System.getProperty("line.separator"));
                bw.newLine();
            }
            bw.write("[CommonParameters]" + System.getProperty("line.separator"));
            bw.write("MaxThreadsToUsePerFile = " + this.numberOfThreads + System.getProperty("line.separator"));
            bw.write("ListOfModsFixed = \"");
            this.writeModifications(searchParameters.getModificationParameters().getFixedModifications(), bw);
            bw.write("\"" + System.getProperty("line.separator"));
            bw.write("ListOfModsVariable = \"");
            this.writeModifications(searchParameters.getModificationParameters().getVariableModifications(), bw);
            bw.write("\"" + System.getProperty("line.separator"));
            bw.write("DoPrecursorDeconvolution = " + this.metaMorpheusParameters.getDoPrecursorDeconvolution() + System.getProperty("line.separator"));
            bw.write("UseProvidedPrecursorInfo = " + this.metaMorpheusParameters.getUseProvidedPrecursorInfo() + System.getProperty("line.separator"));
            bw.write("DeconvolutionIntensityRatio = " + this.metaMorpheusParameters.getDeconvolutionIntensityRatio() + System.getProperty("line.separator"));
            bw.write("DeconvolutionMaxAssumedChargeState = " + searchParameters.getMaxChargeSearched() + System.getProperty("line.separator"));
            bw.write("DeconvolutionMassTolerance = \"\u00c2\u00b1" + this.metaMorpheusParameters.getDeconvolutionMassTolerance() + " " + this.metaMorpheusParameters.getDeconvolutionMassToleranceType() + "\"" + System.getProperty("line.separator"));
            bw.write("TotalPartitions = 1" + System.getProperty("line.separator"));
            bw.write("ProductMassTolerance = \"\u00c2\u00b1" + searchParameters.getFragmentIonAccuracy());
            if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                bw.write(" PPM\"" + System.getProperty("line.separator"));
            } else {
                bw.write(" Absolute\"" + System.getProperty("line.separator"));
            }
            bw.write("PrecursorMassTolerance = \"\u00c2\u00b1" + searchParameters.getPrecursorAccuracy());
            if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                bw.write(" PPM\"" + System.getProperty("line.separator"));
            } else {
                bw.write(" Absolute\"" + System.getProperty("line.separator"));
            }
            bw.write("AddCompIons = false" + System.getProperty("line.separator"));
            bw.write("ScoreCutoff = " + this.metaMorpheusParameters.getScoreCutoff() + System.getProperty("line.separator"));
            bw.write("ReportAllAmbiguity = true" + System.getProperty("line.separator"));
            bw.write("NumberOfPeaksToKeepPerWindow = " + this.metaMorpheusParameters.getNumberOfPeaksToKeepPerWindow() + System.getProperty("line.separator"));
            bw.write("MinimumAllowedIntensityRatioToBasePeak = " + this.metaMorpheusParameters.getMinAllowedIntensityRatioToBasePeak() + System.getProperty("line.separator"));
            if (this.metaMorpheusParameters.getWindowWidthThomsons() != null) {
                bw.write("WindowWidthThomsons = " + this.metaMorpheusParameters.getWindowWidthThomsons() + System.getProperty("line.separator"));
            }
            if (this.metaMorpheusParameters.getNumberOfWindows() != null) {
                bw.write("NumberOfWindows = " + this.metaMorpheusParameters.getNumberOfWindows() + System.getProperty("line.separator"));
            }
            bw.write("NormalizePeaksAccrossAllWindows = " + this.metaMorpheusParameters.getNormalizePeaksAcrossAllWindows() + System.getProperty("line.separator"));
            bw.write("TrimMs1Peaks = " + this.metaMorpheusParameters.getTrimMs1Peaks() + System.getProperty("line.separator"));
            bw.write("TrimMsMsPeaks = " + this.metaMorpheusParameters.getTrimMsMsPeaks() + System.getProperty("line.separator"));
            bw.write("UseDeltaScore = " + this.metaMorpheusParameters.getUseDeltaScore() + System.getProperty("line.separator"));
            bw.write("QValueOutputFilter = 0.0" + System.getProperty("line.separator"));
            bw.write("CustomIons = []" + System.getProperty("line.separator"));
            bw.write("AssumeOrphanPeaksAreZ1Fragments = true" + System.getProperty("line.separator"));
            bw.write("MaxHeterozygousVariants = " + this.metaMorpheusParameters.getMaxHeterozygousVariants() + System.getProperty("line.separator"));
            bw.write("MinVariantDepth = " + this.metaMorpheusParameters.getMinVariantDepth() + System.getProperty("line.separator"));
            bw.write("DissociationType = \"" + this.metaMorpheusParameters.getDissociationType() + "\"" + System.getProperty("line.separator"));
            bw.write("ChildScanDissociationType = \"Unknown\"" + System.getProperty("line.separator"));
            bw.newLine();
            bw.write("[CommonParameters.DigestionParams]" + System.getProperty("line.separator"));
            bw.write("MaxMissedCleavages = " + missedCleavages + System.getProperty("line.separator"));
            bw.write("InitiatorMethionineBehavior = \"Variable\"" + System.getProperty("line.separator"));
            bw.write("MinPeptideLength = " + this.metaMorpheusParameters.getMinPeptideLength() + System.getProperty("line.separator"));
            bw.write("MaxPeptideLength = " + this.metaMorpheusParameters.getMaxPeptideLength() + System.getProperty("line.separator"));
            bw.write("MaxModificationIsoforms = " + this.metaMorpheusParameters.getMaxModificationIsoforms() + System.getProperty("line.separator"));
            bw.write("MaxModsForPeptide = " + this.metaMorpheusParameters.getMaxModsForPeptide() + System.getProperty("line.separator"));
            bw.write("Protease = \"" + enzymeName + "\"" + System.getProperty("line.separator"));
            bw.write("SearchModeType = \"Full\"" + System.getProperty("line.separator"));
            bw.write("FragmentationTerminus = \"" + this.metaMorpheusParameters.getFragmentationTerminus() + "\"" + System.getProperty("line.separator"));
            bw.write("SpecificProtease = \"" + enzymeName + "\"" + System.getProperty("line.separator"));
            bw.write("GeneratehUnlabeledProteinsForSilac = false" + System.getProperty("line.separator"));
        }
        return parameterFile;
    }

    @Override
    public String getType() {
        return "MetaMorpheus";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnzymesFile(File metaMorpheusEnzymesFile, DigestionParameters digestionPreferences) throws IOException {
        block27: {
            if (!metaMorpheusEnzymesFile.getParentFile().exists()) {
                metaMorpheusEnzymesFile.getParentFile().mkdirs();
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(metaMorpheusEnzymesFile));){
                bw.write("Name\tSequences Inducing Cleavage\tSequences Preventing Cleavage\tCleavage Terminus\tCleavage Specificity\tPSI-MS Accession Number\tPSI-MS Name\tSite Regular Expression\tNotes");
                bw.newLine();
                bw.write("trypsin\tK|,R|\t\t\tfull\tMS:1001313\tTrypsin/P\t(?<=[KR])\t");
                bw.newLine();
                if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
                    bw.write("Whole Protein\t\t\t\tnone\tMS:1001955\tno cleavage\t\t\t");
                    bw.newLine();
                    break block27;
                }
                if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
                    bw.write("Unspecific\tX|\t\t\tfull\tMS:1001956\tunspecific cleavage\t\t");
                    bw.newLine();
                    break block27;
                }
                if (digestionPreferences.getEnzymes().size() > 1) {
                    throw new IOException("Multiple enzymes not supported!");
                }
                Enzyme enzyme = (Enzyme)digestionPreferences.getEnzymes().get(0);
                String enzymeName = enzyme.getName();
                bw.write(enzymeName + "\t");
                String cleavageSite = "";
                if (!enzyme.getAminoAcidBefore().isEmpty()) {
                    for (Character cleaveCharacter : enzyme.getAminoAcidBefore()) {
                        if (!enzyme.getRestrictionAfter().isEmpty()) {
                            for (Character restrictCharacter : enzyme.getRestrictionAfter()) {
                                if (!cleavageSite.isEmpty()) {
                                    cleavageSite = cleavageSite + ",";
                                }
                                cleavageSite = cleavageSite + cleaveCharacter + "|[" + restrictCharacter + "]";
                            }
                            continue;
                        }
                        if (!cleavageSite.isEmpty()) {
                            cleavageSite = cleavageSite + ",";
                        }
                        cleavageSite = cleavageSite + cleaveCharacter + "|";
                    }
                } else {
                    for (Character cleaveCharacter : enzyme.getAminoAcidAfter()) {
                        if (!enzyme.getRestrictionBefore().isEmpty()) {
                            for (Character restrictCharacter : enzyme.getRestrictionBefore()) {
                                if (!cleavageSite.isEmpty()) {
                                    cleavageSite = cleavageSite + ",";
                                }
                                cleavageSite = cleavageSite + "[" + restrictCharacter + "]|" + cleaveCharacter;
                            }
                            continue;
                        }
                        if (!cleavageSite.isEmpty()) {
                            cleavageSite = cleavageSite + ",";
                        }
                        cleavageSite = cleavageSite + "|" + cleaveCharacter;
                    }
                }
                bw.write(cleavageSite + "\t\t\t");
                DigestionParameters.Specificity specificity = digestionPreferences.getSpecificity(enzymeName);
                if (null != specificity) {
                    if (specificity == DigestionParameters.Specificity.specific) {
                        bw.write("full\t");
                    } else {
                        bw.write("semi\t");
                    }
                } else {
                    bw.write("\t");
                }
                if (enzyme.getCvTerm() != null) {
                    bw.write(enzyme.getCvTerm().getAccession() + "\t");
                    bw.write(enzyme.getCvTerm().getName() + "\t");
                } else {
                    bw.write("\t\t");
                }
                bw.write("\t");
                bw.write("\t");
                bw.newLine();
            }
            catch (IOException ioe) {
                throw new IOException("Could not create MetaMorpheus enzymes file. Unable to write file: '" + ioe.getMessage() + "'.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModificationsFile(File metaMorpheusModFile) throws IOException {
        if (!metaMorpheusModFile.getParentFile().exists()) {
            metaMorpheusModFile.getParentFile().mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(metaMorpheusModFile));){
            bw.write("Custom Modifications\n");
            ArrayList fixedModifications = this.searchParameters.getModificationParameters().getFixedModifications();
            for (Object modName : fixedModifications) {
                bw.write(this.getModificationFormattedForMetaMorpheus((String)modName));
            }
            ArrayList variableModifications = this.searchParameters.getModificationParameters().getVariableModifications();
            for (String modName : variableModifications) {
                bw.write(this.getModificationFormattedForMetaMorpheus(modName));
            }
            if (this.metaMorpheusParameters.runGptm()) {
                ArrayList openSearchModifications = this.modificationFactory.getModifications(this.metaMorpheusParameters.getGPtmCategories().toArray(new ModificationCategory[0]));
                for (String fixedMod : fixedModifications) {
                    openSearchModifications.remove(fixedMod);
                }
                for (String variableMod : variableModifications) {
                    openSearchModifications.remove(variableMod);
                }
                for (String modName : openSearchModifications) {
                    bw.write(this.getModificationFormattedForMetaMorpheus(modName));
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MetaMorpheus modifications file. Unable to write file: '" + ioe.getMessage() + "'.");
        }
    }

    private String getModificationFormattedForMetaMorpheus(String modName) {
        Modification modification = this.modificationFactory.getModification(modName);
        String tempModName = modification.getName().replaceAll(" of ", " off ");
        String modificationAsString = "ID   " + tempModName + "\n";
        modificationAsString = modificationAsString + "TG   ";
        String aminoAcidsAtTarget = "";
        AminoAcidPattern aminoAcidPattern = modification.getPattern();
        if (aminoAcidPattern != null) {
            for (Iterator aa : modification.getPattern().getAminoAcidsAtTarget()) {
                if (!aminoAcidsAtTarget.isEmpty()) {
                    aminoAcidsAtTarget = aminoAcidsAtTarget + " or ";
                }
                aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
            }
        }
        if (aminoAcidsAtTarget.length() == 0) {
            aminoAcidsAtTarget = "X";
        }
        modificationAsString = modificationAsString + aminoAcidsAtTarget + "\n";
        modificationAsString = modificationAsString + "PP   ";
        String position = "";
        switch (modification.getModificationType()) {
            case modaa: {
                position = "Anywhere.";
                break;
            }
            case modc_protein: 
            case modcaa_protein: {
                position = "C-terminal.";
                break;
            }
            case modc_peptide: 
            case modcaa_peptide: {
                position = "Peptide C-terminal.";
                break;
            }
            case modn_protein: 
            case modnaa_protein: {
                position = "N-terminal.";
                break;
            }
            case modn_peptide: 
            case modnaa_peptide: {
                position = "Peptide N-terminal.";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Modification type " + modification.getModificationType() + " not supported.");
            }
        }
        modificationAsString = modificationAsString + position + "\n";
        for (NeutralLoss tempNeutralLoss : modification.getNeutralLosses()) {
            modificationAsString = modificationAsString + "NL   " + tempNeutralLoss.getComposition().getStringValue(true, false, true, true, false, true) + "\n";
        }
        modificationAsString = modificationAsString + "MT   " + modification.getCategory() + "\n";
        modificationAsString = modificationAsString + "CF   ";
        if (modification.getAtomChainAdded().size() > 0) {
            modificationAsString = modificationAsString + modification.getAtomChainAdded().getStringValue(true, false, true, true, false, true) + " ";
        }
        if (modification.getAtomChainRemoved().size() > 0) {
            modificationAsString = modificationAsString + modification.getAtomChainRemoved().getStringValue(true, false, true, true, true, true);
        }
        modificationAsString = modificationAsString + "\n";
        for (ReporterIon tempReporterIon : modification.getReporterIons()) {
            modificationAsString = modificationAsString + "DI   " + tempReporterIon.getAtomicComposition().getStringValue(true, false, true, true, false, true) + "\n";
        }
        CvTerm cvTerm = modification.getUnimodCvTerm();
        if (cvTerm != null) {
            String completeAccession = cvTerm.getAccession();
            modificationAsString = modificationAsString + "DR   Unimod; " + completeAccession.substring(7) + ".\n";
        }
        modificationAsString = modificationAsString + "//\n";
        return modificationAsString;
    }

    private void writeModifications(ArrayList<String> modifications, BufferedWriter bw) throws IOException {
        for (int i = 0; i < modifications.size(); ++i) {
            if (i > 0) {
                bw.write("\\t\\t");
            }
            String modName = modifications.get(i);
            String tempModName = modName.replaceAll(" of ", " off ");
            Modification tempModification = this.modificationFactory.getModification(modName);
            AminoAcidPattern aminoAcidPattern = tempModification.getPattern();
            if (aminoAcidPattern == null) continue;
            if (!aminoAcidPattern.getAminoAcidsAtTarget().isEmpty()) {
                for (Character residue : aminoAcidPattern.getAminoAcidsAtTarget()) {
                    bw.write(tempModification.getCategory() + "\\t" + tempModName + " on " + residue);
                }
                continue;
            }
            bw.write(tempModification.getCategory() + "\\t" + tempModName + " on X");
        }
    }

    public static enum MetaMorpheusTaskType {
        Search,
        Gptmd;

    }
}

