/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.NovorParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class NovorProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "novor.jar";
    private File novorTempFolder;
    private File spectrumFile;
    private SearchParameters searchParameters;
    private File novorFolder;
    private String parameterFileName = "novor_params.txt";
    private String modsFileName = "novor_mods.txt";
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private HashMap<String, String> novorModificationMap;

    public NovorProcessBuilder(File novorFolder, File novorTempFolder, File mgfFile, File outputFile, SearchParameters searchParameters, boolean isCommandLine, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException, ClassNotFoundException {
        this.novorFolder = novorFolder;
        this.novorTempFolder = novorTempFolder;
        this.spectrumFile = mgfFile;
        this.searchParameters = searchParameters;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        if (!novorTempFolder.exists()) {
            novorTempFolder.mkdirs();
        }
        File novorExecutable = new File(novorFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        novorExecutable.setExecutable(true);
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        ArrayList javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserParameters.getSearchGuiPath());
        this.process_name_array.add(javaHomeAndOptions.get(0));
        if (!isCommandLine) {
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
        } else {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            for (String element : aList) {
                this.process_name_array.add(element);
            }
        }
        this.process_name_array.add("-jar");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)new File(novorFolder, EXECUTABLE_FILE_NAME)));
        this.createParameterFile();
        this.process_name_array.add("-p");
        this.process_name_array.add(novorTempFolder.getAbsolutePath() + File.separator + this.parameterFileName);
        this.process_name_array.add("-m");
        this.process_name_array.add(novorTempFolder.getAbsolutePath() + File.separator + this.modsFileName);
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)outputFile));
        this.process_name_array.add("-f");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.spectrumFile));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "novor command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(novorFolder);
        this.pb.redirectErrorStream(true);
    }

    private void createParameterFile() {
        NovorParameters novorParameters = (NovorParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex());
        try (BufferedWriter bufferedParameterWriter = new BufferedWriter(new FileWriter(this.novorTempFolder.getAbsolutePath() + File.separator + this.parameterFileName));){
            Modification modification;
            bufferedParameterWriter.write("# Search parameters" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("enzyme = Trypsin" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("fragmentation = " + novorParameters.getFragmentationMethod() + System.getProperty("line.separator"));
            bufferedParameterWriter.write("massAnalyzer = " + novorParameters.getMassAnalyzer() + System.getProperty("line.separator"));
            bufferedParameterWriter.write("fragmentIonErrorTol = ");
            if (this.searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                bufferedParameterWriter.write(this.searchParameters.getFragmentIonAccuracy() + "Da" + System.getProperty("line.separator"));
            } else {
                double convertedTolerance = IdentificationParameters.getDaTolerance((double)this.searchParameters.getFragmentIonAccuracy(), (double)1000.0);
                bufferedParameterWriter.write(convertedTolerance + "Da" + System.getProperty("line.separator"));
            }
            bufferedParameterWriter.write("precursorErrorTol = " + this.searchParameters.getPrecursorAccuracy());
            if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                bufferedParameterWriter.write("Da" + System.getProperty("line.separator"));
            } else {
                bufferedParameterWriter.write("ppm" + System.getProperty("line.separator"));
            }
            bufferedParameterWriter.write(System.getProperty("line.separator"));
            FileWriter modsWriter = new FileWriter(this.novorTempFolder.getAbsolutePath() + File.separator + this.modsFileName);
            BufferedWriter bufferedModsWriter = new BufferedWriter(modsWriter);
            this.novorModificationMap = new HashMap();
            if (!this.searchParameters.getModificationParameters().getVariableModifications().isEmpty()) {
                bufferedParameterWriter.write("# Variable modifications" + System.getProperty("line.separator"));
                String variableModsAsString = "";
                for (String variableModification : this.searchParameters.getModificationParameters().getVariableModifications()) {
                    modification = this.modificationFactory.getModification(variableModification);
                    this.addModification(bufferedModsWriter, modification);
                    if (!variableModsAsString.isEmpty()) {
                        variableModsAsString = variableModsAsString + ", ";
                    }
                    variableModsAsString = variableModsAsString + modification.getName();
                }
                variableModsAsString = "variableModifications = " + variableModsAsString;
                bufferedParameterWriter.write(variableModsAsString + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            if (!this.searchParameters.getModificationParameters().getFixedModifications().isEmpty()) {
                bufferedParameterWriter.write("# Fixed modifications" + System.getProperty("line.separator"));
                String fixedModsAsString = "";
                for (String fixedModification : this.searchParameters.getModificationParameters().getFixedModifications()) {
                    modification = this.modificationFactory.getModification(fixedModification);
                    this.addModification(bufferedModsWriter, modification);
                    if (!fixedModsAsString.isEmpty()) {
                        fixedModsAsString = fixedModsAsString + ", ";
                    }
                    fixedModsAsString = fixedModsAsString + modification.getName();
                }
                fixedModsAsString = "fixedModifications = " + fixedModsAsString;
                bufferedParameterWriter.write(fixedModsAsString + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            novorParameters.setNovorPtmMap(this.novorModificationMap);
            bufferedModsWriter.close();
            modsWriter.close();
            bufferedParameterWriter.write("# The residue which will not be used in de novo algorithm." + System.getProperty("line.separator"));
            bufferedParameterWriter.write("# I is disabled as default because it is the same as L" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("# U is disabled because it is very rare" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("forbiddenResidues = I,U" + System.getProperty("line.separator"));
            bufferedParameterWriter.close();
            modsWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, new String[]{"Unable to write file: '" + e.getMessage() + "'!", "Could not save Novr+ parameter file."}, "Novor Parameter File Error", 2);
        }
    }

    private void addModification(BufferedWriter bufferedModsWriter, Modification modification) throws IOException {
        bufferedModsWriter.write(modification.getName() + ", ");
        bufferedModsWriter.write(this.novorModificationMap.keySet().size() + ", ");
        this.novorModificationMap.put("" + this.novorModificationMap.keySet().size(), modification.getName());
        bufferedModsWriter.write(modification.getName() + ", ");
        ModificationType modificationType = modification.getModificationType();
        switch (modificationType) {
            case modaa: {
                bufferedModsWriter.write("-r-, ");
                break;
            }
            case modnaa_peptide: 
            case modnaa_protein: {
                bufferedModsWriter.write("nr-, ");
                break;
            }
            case modn_peptide: 
            case modn_protein: {
                bufferedModsWriter.write("n--, ");
            }
            case modcaa_peptide: 
            case modcaa_protein: {
                bufferedModsWriter.write("-rc, ");
                break;
            }
            case modc_peptide: 
            case modc_protein: {
                bufferedModsWriter.write("--c, ");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Modification type " + modificationType + " not supported.");
            }
        }
        if (modification.getPattern() != null) {
            for (Character target : modification.getPattern().getAminoAcidsAtTarget()) {
                bufferedModsWriter.write(target.charValue());
            }
            bufferedModsWriter.write(", ");
        } else {
            bufferedModsWriter.write("*, ");
        }
        bufferedModsWriter.write(", ");
        bufferedModsWriter.write("" + modification.getRoundedMass());
        bufferedModsWriter.write(System.getProperty("line.separator"));
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    @Override
    public String getType() {
        return "Novor";
    }
}

