/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.OmssaParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class OmssaclProcessBuilder
extends SearchGUIProcessBuilder {
    private File spectrumFile;
    private ModificationParameters modificationParameters;
    public static final String EXECUTABLE_FILE_NAME = "omssacl";
    private File omssaTempFolder;

    public OmssaclProcessBuilder(File omssacl_directory, File aOmssaTempFolder, File mgfFile, File fastaFile, File outputFile, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, Double refMass, int nThreads) throws IOException, ClassNotFoundException {
        this.spectrumFile = mgfFile;
        this.waitingHandler = waitingHandler;
        this.modificationParameters = searchParameters.getModificationParameters();
        this.omssaTempFolder = aOmssaTempFolder;
        if (!this.omssaTempFolder.exists()) {
            this.omssaTempFolder.mkdirs();
        }
        OmssaParameters omssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        File seqDBFile = fastaFile;
        File dbFilePath = fastaFile.getParentFile();
        File omssaFile = new File(omssacl_directory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        omssaFile.setExecutable(true);
        this.process_name_array.add(omssacl_directory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.add("-w");
        this.process_name_array.add("-to");
        this.process_name_array.add(Double.toString(searchParameters.getFragmentIonAccuracyInDaltons(refMass.doubleValue())));
        this.process_name_array.add("-te");
        this.process_name_array.add(Double.toString(searchParameters.getPrecursorAccuracy()));
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.process_name_array.add("-teppm");
        }
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        int enzymeIndex = this.getEnzymeIndex(digestionPreferences);
        this.process_name_array.add("-e");
        this.process_name_array.add(Integer.toString(enzymeIndex));
        Integer missedCleavages = null;
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            for (Object enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                missedCleavages = enzymeMissedCleavages;
            }
        }
        if (missedCleavages != null) {
            this.process_name_array.add("-v");
            this.process_name_array.add(Integer.toString(missedCleavages));
        }
        this.process_name_array.add("-zl");
        this.process_name_array.add(Integer.toString(searchParameters.getMinChargeSearched()));
        this.process_name_array.add("-zh");
        this.process_name_array.add(Integer.toString(searchParameters.getMaxChargeSearched()));
        this.process_name_array.add("-zt");
        this.process_name_array.add(Integer.toString(omssaParameters.getMinimalChargeForMultipleChargedFragments()));
        if (omssaParameters.isMemoryMappedSequenceLibraries()) {
            this.process_name_array.add("-umm");
        }
        if (searchParameters.getMaxIsotopicCorrection() > 0) {
            this.process_name_array.add("-ti");
            this.process_name_array.add(Integer.toString(searchParameters.getMaxIsotopicCorrection()));
        }
        this.process_name_array.add("-tex");
        this.process_name_array.add(Double.toString(omssaParameters.getNeutronThreshold()));
        this.process_name_array.add("-cl");
        this.process_name_array.add(Double.toString(omssaParameters.getLowIntensityCutOff()));
        this.process_name_array.add("-ch");
        this.process_name_array.add(Double.toString(omssaParameters.getHighIntensityCutOff()));
        this.process_name_array.add("-ci");
        this.process_name_array.add(Double.toString(omssaParameters.getIntensityCutOffIncrement()));
        this.process_name_array.add("-w1");
        this.process_name_array.add(Integer.toString(omssaParameters.getSingleChargeWindow()));
        this.process_name_array.add("-w2");
        this.process_name_array.add(Integer.toString(omssaParameters.getDoubleChargeWindow()));
        this.process_name_array.add("-h1");
        this.process_name_array.add(Integer.toString(omssaParameters.getnPeaksInSingleChargeWindow()));
        this.process_name_array.add("-h2");
        this.process_name_array.add(Integer.toString(omssaParameters.getnPeaksInDoubleChargeWindow()));
        this.process_name_array.add("-hl");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxHitsPerSpectrumPerCharge()));
        this.process_name_array.add("-hc");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxHitsPerSpectrumPerCharge()));
        this.process_name_array.add("-hm");
        this.process_name_array.add(Integer.toString(omssaParameters.getMinAnnotatedPeaks()));
        this.process_name_array.add("-hs");
        this.process_name_array.add(Integer.toString(omssaParameters.getMinPeaks()));
        this.process_name_array.add("-ht");
        this.process_name_array.add(Integer.toString(omssaParameters.getnAnnotatedMostIntensePeaks()));
        if (!omssaParameters.isCleaveNterMethionine()) {
            this.process_name_array.add("-mnm");
        }
        this.process_name_array.add("-mm");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxMzLadders()));
        this.process_name_array.add("-zoh");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxFragmentCharge()));
        this.process_name_array.add("-z1");
        this.process_name_array.add(Double.toString(omssaParameters.getFractionOfPeaksForChargeEstimation()));
        if (!omssaParameters.isDetermineChargePlusOneAlgorithmically()) {
            this.process_name_array.add("-zc");
            this.process_name_array.add(Integer.toString(0));
        }
        if (!omssaParameters.isSearchPositiveIons()) {
            this.process_name_array.add("-zn");
            this.process_name_array.add(Integer.toString(-1));
        }
        this.process_name_array.add("-pc");
        this.process_name_array.add(Integer.toString(omssaParameters.getMinPrecPerSpectrum()));
        if (!omssaParameters.isSearchForwardFragmentFirst()) {
            this.process_name_array.add("-sb1");
            this.process_name_array.add(Integer.toString(0));
        }
        if (!omssaParameters.isSearchRewindFragments()) {
            this.process_name_array.add("-sct");
            this.process_name_array.add(Integer.toString(1));
        }
        this.process_name_array.add("-sp");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxFragmentPerSeries()));
        if (!omssaParameters.isUseCorrelationCorrectionScore()) {
            this.process_name_array.add("-scorr");
            this.process_name_array.add(Integer.toString(1));
        }
        this.process_name_array.add("-scorp");
        this.process_name_array.add(Double.toString(omssaParameters.getConsecutiveIonProbability()));
        this.process_name_array.add("-is");
        this.process_name_array.add(Double.toString(omssaParameters.getIterativeSequenceEvalue()));
        this.process_name_array.add("-ir");
        this.process_name_array.add(Double.toString(omssaParameters.getIterativeReplaceEvalue()));
        this.process_name_array.add("-ii");
        this.process_name_array.add(Double.toString(omssaParameters.getIterativeSpectrumEvalue()));
        this.process_name_array.add("-he");
        this.process_name_array.add(Double.toString(omssaParameters.getMaxEValue()));
        this.process_name_array.add("-tez");
        if (omssaParameters.isScalePrecursor()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-zcc");
        if (omssaParameters.isEstimateCharge()) {
            this.process_name_array.add("2");
        } else {
            this.process_name_array.add("1");
        }
        this.process_name_array.add("-cp");
        if (omssaParameters.isRemovePrecursor()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-no");
        this.process_name_array.add(Integer.toString(omssaParameters.getMinPeptideLength()));
        this.process_name_array.add("-nox");
        this.process_name_array.add(Integer.toString(omssaParameters.getMaxPeptideLength()));
        this.process_name_array.add("-tom");
        this.process_name_array.add("0");
        this.process_name_array.add("-tem");
        this.process_name_array.add("0");
        this.process_name_array.add("-i");
        StringBuilder ions = new StringBuilder();
        for (Integer ion : searchParameters.getForwardIons()) {
            if (ions.length() > 0) {
                ions.append(",");
            }
            ions.append(this.getIonId(PeptideFragmentIon.getSubTypeAsString((int)ion)));
        }
        for (Integer ion : searchParameters.getRewindIons()) {
            if (ions.length() > 0) {
                ions.append(",");
            }
            ions.append(this.getIonId(PeptideFragmentIon.getSubTypeAsString((int)ion)));
        }
        this.process_name_array.add(ions.toString());
        String modificationIndexes = "";
        for (Integer index : this.getSearchedModificationsIds(this.modificationParameters.getFixedModifications(), omssaParameters)) {
            if (!modificationIndexes.equals("")) {
                modificationIndexes = modificationIndexes + ",";
            }
            modificationIndexes = modificationIndexes + index;
        }
        if (!modificationIndexes.equals("")) {
            this.process_name_array.add("-mf");
            this.process_name_array.add(modificationIndexes);
        }
        modificationIndexes = "";
        for (Integer index : this.getSearchedModificationsIds(this.modificationParameters.getVariableModifications(), omssaParameters)) {
            if (!modificationIndexes.equals("")) {
                modificationIndexes = modificationIndexes + ",";
            }
            modificationIndexes = modificationIndexes + index;
        }
        if (!modificationIndexes.equals("")) {
            this.process_name_array.add("-mv");
            this.process_name_array.add(modificationIndexes);
        }
        this.process_name_array.add("-mux");
        this.process_name_array.add(new File(this.omssaTempFolder, "usermods.xml").getAbsolutePath());
        this.process_name_array.add("-d");
        this.process_name_array.add(seqDBFile.getName());
        if (this.spectrumFile != null) {
            if (this.spectrumFile.getName().endsWith(".mgf")) {
                this.process_name_array.add("-fm");
            } else if (this.spectrumFile.getName().toLowerCase().endsWith(".pkl")) {
                this.process_name_array.add("-fp");
            } else if (this.spectrumFile.getName().toLowerCase().endsWith(".dta")) {
                this.process_name_array.add("-f");
            }
            this.process_name_array.add(this.spectrumFile.getAbsolutePath());
        }
        if (outputFile != null) {
            switch (omssaParameters.getSelectedOutput()) {
                case "OMX": {
                    this.process_name_array.add("-ox");
                    break;
                }
                case "CSV": {
                    this.process_name_array.add("-oc");
                    break;
                }
                default: {
                    this.process_name_array.add("-op");
                }
            }
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)outputFile));
        }
        this.process_name_array.add("-nt");
        this.process_name_array.add(Integer.toString(nThreads));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "omssa command: ");
        for (int i = 0; i < this.process_name_array.size(); ++i) {
            System.out.print(this.process_name_array.get(i) + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(dbFilePath);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public String getType() {
        return "OMSSA";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    public int getIonId(String letter) {
        switch (letter) {
            case "a": {
                return 0;
            }
            case "b": {
                return 1;
            }
            case "c": {
                return 2;
            }
            case "x": {
                return 3;
            }
            case "y": {
                return 4;
            }
            case "z": {
                return 5;
            }
        }
        return -1;
    }

    public ArrayList<Integer> getSearchedModificationsIds(ArrayList<String> modificationsNames, OmssaParameters omssaParameters) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String modName : modificationsNames) {
            Integer index = omssaParameters.getPtmIndex(modName);
            if (index == null) {
                throw new IllegalArgumentException("No OMSSA index found for modification " + modName);
            }
            if (result.contains(index)) continue;
            result.add(index);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOmssaUserModificationsFile(File omssaFile, IdentificationParameters identificationParameters, File identificationParametersFile) throws IOException, ClassNotFoundException {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        OmssaParameters omssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        omssaParameters.setPtmIndexes(modificationParameters);
        IdentificationParameters.saveIdentificationParameters((IdentificationParameters)identificationParameters, (File)identificationParametersFile);
        HashMap ptmIndexes = omssaParameters.getPtmIndexes();
        ArrayList indexes = new ArrayList(ptmIndexes.keySet());
        Collections.sort(indexes);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(omssaFile));){
            String toWrite = "<?xml version=\"1.0\"?>\n<MSModSpecSet\nxmlns=\"http://www.ncbi.nlm.nih.gov\"\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\nxs:schemaLocation=\"http://www.ncbi.nlm.nih.gov OMSSA.xsd\"\n>\n\n";
            bw.write(toWrite);
            int cpt = 1;
            for (Integer index : indexes) {
                String ptmName = (String)ptmIndexes.get(index);
                Modification modification = modificationFactory.getModification(ptmName);
                toWrite = OmssaclProcessBuilder.getOmssaUserModBloc(modification, cpt, index);
                bw.write(toWrite);
                ++cpt;
            }
            toWrite = "</MSModSpecSet>";
            bw.write(toWrite);
        }
    }

    public static String getOmssaUserModBloc(Modification modification, int cpt, int omssaIndex) {
        String result = "\t<MSModSpec>\n";
        result = result + "\t\t<MSModSpec_mod>\n";
        result = result + "\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n";
        result = result + "\t\t</MSModSpec_mod>\n\t\t<MSModSpec_type>\n";
        ModificationType modificationType = modification.getModificationType();
        switch (modificationType) {
            case modaa: {
                result = result + "\t\t\t<MSModType value=\"modaa\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modn_peptide: {
                result = result + "\t\t\t<MSModType value=\"modnp\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modnaa_peptide: {
                result = result + "\t\t\t<MSModType value=\"modnpaa\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modn_protein: {
                result = result + "\t\t\t<MSModType value=\"modn\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modnaa_protein: {
                result = result + "\t\t\t<MSModType value=\"modnaa\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modc_peptide: {
                result = result + "\t\t\t<MSModType value=\"modcp\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modcaa_peptide: {
                result = result + "\t\t\t<MSModType value=\"modcpaa\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modc_protein: {
                result = result + "\t\t\t<MSModType value=\"modc\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            case modcaa_protein: {
                result = result + "\t\t\t<MSModType value=\"modcaa\">" + modificationType.index + "</MSModType>\n";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Export not implemented for modification of type " + modificationType + ".");
            }
        }
        result = result + "\t\t</MSModSpec_type>\n";
        result = result + "\t\t<MSModSpec_name>" + modification.getName() + "</MSModSpec_name>\n";
        result = result + "\t\t<MSModSpec_monomass>" + modification.getRoundedMass() + "</MSModSpec_monomass>\n\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n";
        if (modificationType == ModificationType.modaa || modificationType == ModificationType.modcaa_peptide || modificationType == ModificationType.modcaa_protein || modificationType == ModificationType.modnaa_peptide || modificationType == ModificationType.modnaa_protein) {
            result = result + "\t\t<MSModSpec_residues>\n";
            for (Character aa : modification.getPattern().getAminoAcidsAtTarget()) {
                result = result + "\t\t\t<MSModSpec_residues_E>" + aa + "</MSModSpec_residues_E>\n";
            }
            result = result + "\t\t</MSModSpec_residues>\n";
        }
        boolean first = true;
        for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
            if (!neutralLoss.isFixed()) continue;
            if (first) {
                result = result + "\t\t<MSModSpec_neutralloss>\n";
                first = false;
            }
            result = result + "\t\t\t<MSMassSet>\n";
            result = result + "\t\t\t\t<MSMassSet_monomass>" + neutralLoss.getMass() + "</MSMassSet_monomass>\n";
            result = result + "\t\t\t\t<MSMassSet_averagemass>0</MSMassSet_averagemass>";
            result = result + "\t\t\t\t<MSMassSet_n15mass>0</MSMassSet_n15mass>";
            result = result + "\t\t\t</MSMassSet>\n";
        }
        if (!first) {
            result = result + "\t\t</MSModSpec_neutralloss>\n";
        }
        result = result + "\t</MSModSpec>\n";
        return result;
    }

    private int getEnzymeIndex(DigestionParameters digestionPreferences) throws IOException {
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            return 11;
        }
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            return 17;
        }
        if (digestionPreferences.getEnzymes().size() > 1) {
            throw new IOException("Multiple enzymes not supported by OMSSA!");
        }
        Enzyme enzyme = (Enzyme)digestionPreferences.getEnzymes().get(0);
        String enzymeName = enzyme.getName();
        DigestionParameters.Specificity specificity = digestionPreferences.getSpecificity(enzymeName);
        switch (enzymeName) {
            case "Trypsin": {
                if (specificity == DigestionParameters.Specificity.specific) {
                    return 0;
                }
                return 16;
            }
            case "Trypsin (no P rule)": {
                return 10;
            }
            case "Arg-C": 
            case "Arg-C (no P rule)": {
                return 1;
            }
            case "Glu-C": {
                if (specificity == DigestionParameters.Specificity.specific) {
                    return 13;
                }
                return 24;
            }
            case "Lys-C": {
                return 5;
            }
            case "Lys-C (no P rule)": {
                return 6;
            }
            case "Lys-N": {
                return 21;
            }
            case "Asp-N": {
                return 12;
            }
            case "Asp-N Ammonium Bicarbonate": {
                return 19;
            }
            case "Chymotrypsin": {
                if (specificity == DigestionParameters.Specificity.specific) {
                    return 3;
                }
                return 23;
            }
            case "Chymotrypsin (no P rule)": {
                if (specificity == DigestionParameters.Specificity.specific) {
                    return 18;
                }
                return 23;
            }
            case "Pepsin A": {
                return 7;
            }
            case "CNBr": {
                return 2;
            }
            case "Thermolysin": {
                return 22;
            }
        }
        return 17;
    }
}

