/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.SageParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SageProcessBuilder
extends SearchGUIProcessBuilder {
    private File sageFolder;
    private File sageTempFolder;
    private final String SAGE_VERSION = "0.14.7";
    private File spectrumFile;
    private File fastaFile;
    private String decoyTag;
    private SearchParameters searchParameters;
    private SageParameters sageParameters;
    private int nThreads;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private Double refMass;

    public SageProcessBuilder(File sageFolder, File sageTempFolder, SearchParameters searchParameters, File spectrumFile, File fastaFile, String decoyTag, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) throws IOException {
        this.sageFolder = sageFolder;
        this.sageTempFolder = sageTempFolder;
        this.searchParameters = searchParameters;
        this.sageParameters = (SageParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.sage.getIndex());
        this.spectrumFile = spectrumFile;
        this.fastaFile = fastaFile;
        this.decoyTag = decoyTag;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.nThreads = nThreads;
        if (!sageTempFolder.exists()) {
            sageTempFolder.mkdirs();
        }
        this.createParametersFile();
        File sage = new File(sageFolder.getAbsolutePath() + File.separator + SageProcessBuilder.getExecutableFileName());
        sage.setExecutable(true);
        this.process_name_array.add(sage.getAbsolutePath());
        this.process_name_array.add("-o");
        this.process_name_array.add(sageTempFolder.getAbsolutePath());
        if (this.sageParameters.getBatchSize() != null) {
            this.process_name_array.add("--batch-size");
            this.process_name_array.add(this.sageParameters.getBatchSize().toString());
        }
        this.process_name_array.add("--disable-telemetry-i-dont-want-to-improve-sage");
        String path = new File(sageTempFolder, "sage.json").getAbsolutePath();
        this.process_name_array.add(path);
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "sage command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(sageFolder);
        this.pb.redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParametersFile() throws IOException {
        String enzymeDetailsAsString = "";
        String enzymeMissedCleavagesAsString = "";
        String enzymeSemiEnzymaticAsString = "";
        DigestionParameters digestionPreferences = this.searchParameters.getDigestionParameters();
        if (null == digestionPreferences.getCleavageParameter()) {
            throw new IOException("Enzyme type not supported by Sage!");
        }
        block1 : switch (digestionPreferences.getCleavageParameter()) {
            case enzyme: {
                String cleaveAt;
                if (this.searchParameters.getDigestionParameters().getEnzymes().size() > 1) {
                    throw new IOException("Multiple enzymes not supported by Sage!");
                }
                Enzyme tempEnzyme = (Enzyme)this.searchParameters.getDigestionParameters().getEnzymes().get(0);
                String aminoAcidsBefore = "";
                String restrictionAfter = "";
                String aminoAcidsAfter = "";
                String restrictionBefore = "";
                for (Character character : tempEnzyme.getAminoAcidBefore()) {
                    aminoAcidsBefore = aminoAcidsBefore + character;
                }
                for (Character character : tempEnzyme.getRestrictionAfter()) {
                    restrictionAfter = restrictionAfter + character;
                }
                for (Character character : tempEnzyme.getAminoAcidAfter()) {
                    aminoAcidsAfter = aminoAcidsAfter + character;
                }
                for (Character character : tempEnzyme.getRestrictionBefore()) {
                    restrictionBefore = restrictionBefore + character;
                }
                if (!aminoAcidsBefore.isEmpty() && !aminoAcidsAfter.isEmpty()) {
                    throw new IOException("Enzymes cleavage site not supported by Sage!");
                }
                String restrict = null;
                Boolean cTerminalEnzyme = null;
                if (!aminoAcidsBefore.isEmpty()) {
                    cTerminalEnzyme = true;
                    cleaveAt = aminoAcidsBefore;
                    restrict = restrictionAfter;
                } else if (!aminoAcidsAfter.isEmpty()) {
                    cTerminalEnzyme = false;
                    cleaveAt = aminoAcidsAfter;
                    restrict = restrictionBefore;
                } else {
                    throw new IOException("Enzyme type not supported by Sage!");
                }
                enzymeDetailsAsString = "\t\t\t\"cleave_at\": \"" + cleaveAt + "\"," + System.getProperty("line.separator");
                if (!restrict.isEmpty()) {
                    enzymeDetailsAsString = enzymeDetailsAsString + "\t\t\t\"restrict\": \"" + restrict + "\"," + System.getProperty("line.separator");
                }
                enzymeDetailsAsString = enzymeDetailsAsString + "\t\t\t\"c_terminal\": " + cTerminalEnzyme + "," + System.getProperty("line.separator");
                enzymeMissedCleavagesAsString = "\t\t\t\"missed_cleavages\": " + digestionPreferences.getnMissedCleavages(tempEnzyme.getName()) + "," + System.getProperty("line.separator");
                switch (this.searchParameters.getDigestionParameters().getSpecificity(tempEnzyme.getName())) {
                    case specific: {
                        enzymeSemiEnzymaticAsString = "\t\t\t\"semi_enzymatic\": null" + System.getProperty("line.separator");
                        break block1;
                    }
                    case semiSpecific: {
                        enzymeSemiEnzymaticAsString = "\t\t\t\"semi_enzymatic\": true" + System.getProperty("line.separator");
                        break block1;
                    }
                }
                throw new IOException("Enzyme specificity type not supported by Sage!");
            }
            case unSpecific: {
                enzymeDetailsAsString = "\t\t\t\"cleave_at\": \"\"" + System.getProperty("line.separator");
                break;
            }
            case wholeProtein: {
                enzymeDetailsAsString = "\t\t\t\"cleave_at\": \"$\"" + System.getProperty("line.separator");
                break;
            }
            default: {
                throw new IOException("Enzyme type not supported by Sage!");
            }
        }
        String fixedModificationsAsString = this.getModifications(this.searchParameters.getModificationParameters().getFixedModifications(), true);
        String variableModificationsAsString = this.getModifications(this.searchParameters.getModificationParameters().getVariableModifications(), false);
        String tmtType = this.sageParameters.getTmtType() != null ? "\"" + this.sageParameters.getTmtType() + "\"" : "null";
        String tmtLevel = this.sageParameters.getTmtLevel() != null ? this.sageParameters.getTmtLevel().toString() : "3";
        String tmtSn = this.sageParameters.getTmtSn() != false ? "true" : "null";
        String performLfq = this.sageParameters.getPerformLfq() != false ? "true" : "null";
        try (BufferedWriter br = new BufferedWriter(new FileWriter(new File(this.sageTempFolder, "sage.json")));){
            br.write("{" + System.getProperty("line.separator") + "\t\"database\": {" + System.getProperty("line.separator") + "\t\t\"bucket_size\": " + this.sageParameters.getBucketSize() + "," + System.getProperty("line.separator") + "\t\t\"enzyme\": {" + System.getProperty("line.separator") + enzymeMissedCleavagesAsString + "\t\t\t\"min_len\": " + this.sageParameters.getMinPeptideLength() + "," + System.getProperty("line.separator") + "\t\t\t\"max_len\": " + this.sageParameters.getMaxPeptideLength() + "," + System.getProperty("line.separator") + enzymeDetailsAsString + enzymeSemiEnzymaticAsString + "\t\t}," + System.getProperty("line.separator") + "\t\t\"fragment_min_mz\": " + this.sageParameters.getMinFragmentMz() + "," + System.getProperty("line.separator") + "\t\t\"fragment_max_mz\": " + this.sageParameters.getMaxFragmentMz() + "," + System.getProperty("line.separator") + "\t\t\"peptide_min_mass\": " + this.sageParameters.getMinPeptideMass() + "," + System.getProperty("line.separator") + "\t\t\"peptide_max_mass\": " + this.sageParameters.getMaxPeptideMass() + "," + System.getProperty("line.separator") + "\t\t\"ion_kinds\": " + this.getFragmentIonTypesAsList() + "," + System.getProperty("line.separator") + "\t\t\"min_ion_index\": " + this.sageParameters.getMinIonIndex() + "," + System.getProperty("line.separator") + fixedModificationsAsString + variableModificationsAsString + "\t\t\"max_variable_mods\": " + this.sageParameters.getMaxVariableMods() + "," + System.getProperty("line.separator") + "\t\t\"decoy_tag\": \"" + this.decoyTag + "\"," + System.getProperty("line.separator") + "\t\t\"generate_decoys\": " + this.sageParameters.getGenerateDecoys().toString() + "," + System.getProperty("line.separator") + "\t\t\"fasta\": \"" + this.fastaFile.getAbsolutePath().replace("\\", "\\\\") + "\"" + System.getProperty("line.separator") + "\t\t}," + System.getProperty("line.separator") + "\t\"quant\": {" + System.getProperty("line.separator") + "\t\t\"tmt\": " + tmtType + "," + System.getProperty("line.separator") + "\t\t\"tmt_settings\": {" + System.getProperty("line.separator") + "\t\t\t\"tmt_level\": " + tmtLevel + "," + System.getProperty("line.separator") + "\t\t\t\"tmt_sn\": " + tmtSn + System.getProperty("line.separator") + "\t\t}," + System.getProperty("line.separator") + "\t\t\"lfq\": " + performLfq + "," + System.getProperty("line.separator") + "\t\t\"lfq_settings\": {" + System.getProperty("line.separator") + "\t\t\t\"peak_scoring\" : \"" + this.sageParameters.getLfqPeakScoring() + "\"," + System.getProperty("line.separator") + "\t\t\t\"integration\": \"" + this.sageParameters.getLfqIntergration() + "\"," + System.getProperty("line.separator") + "\t\t\t\"spectral_angle\": " + this.sageParameters.getLfqSpectralAngle() + "," + System.getProperty("line.separator") + "\t\t\t\"ppm_tolerance\": " + this.sageParameters.getLfqPpmTolerance() + "," + System.getProperty("line.separator") + "\t\t\t\"combine_charge_state\": " + this.sageParameters.getCombineChargeStates().toString() + System.getProperty("line.separator") + "\t\t}" + System.getProperty("line.separator") + "\t}," + System.getProperty("line.separator") + "\t\"precursor_tol\": {" + System.getProperty("line.separator") + "\t\t\"" + this.searchParameters.getPrecursorAccuracyType().toString().toLowerCase() + "\": [" + System.getProperty("line.separator") + "\t\t\t" + -this.searchParameters.getPrecursorAccuracy() + "," + System.getProperty("line.separator") + "\t\t\t" + this.searchParameters.getPrecursorAccuracy() + System.getProperty("line.separator") + "\t\t]" + System.getProperty("line.separator") + "\t}," + System.getProperty("line.separator") + "\t\"fragment_tol\": {" + System.getProperty("line.separator") + "\t\t\"" + this.searchParameters.getFragmentAccuracyType().toString().toLowerCase() + "\": [" + System.getProperty("line.separator") + "\t\t\t" + -this.searchParameters.getFragmentIonAccuracy() + "," + System.getProperty("line.separator") + "\t\t\t" + this.searchParameters.getFragmentIonAccuracy() + System.getProperty("line.separator") + "\t\t]" + System.getProperty("line.separator") + "\t}," + System.getProperty("line.separator") + "\t\"precursor_charge\": [" + this.searchParameters.getMinChargeSearched() + ", " + this.searchParameters.getMaxChargeSearched() + "]," + System.getProperty("line.separator") + "\t\"isotope_errors\": [" + System.getProperty("line.separator") + "\t\t" + this.searchParameters.getMinIsotopicCorrection() + "," + System.getProperty("line.separator") + "\t\t" + this.searchParameters.getMaxIsotopicCorrection() + System.getProperty("line.separator") + "\t]," + System.getProperty("line.separator") + "\t\"deisotope\": " + this.sageParameters.getDeisotope().toString() + "," + System.getProperty("line.separator") + "\t\"chimera\": " + this.sageParameters.getChimera().toString() + "," + System.getProperty("line.separator") + "\t\"wide_window\": " + this.sageParameters.getWideWindow().toString() + "," + System.getProperty("line.separator") + "\t\"predict_rt\": " + this.sageParameters.getPredictRt().toString() + "," + System.getProperty("line.separator") + "\t\"min_peaks\": " + this.sageParameters.getMinPeaks() + "," + System.getProperty("line.separator") + "\t\"max_peaks\": " + this.sageParameters.getMaxPeaks() + "," + System.getProperty("line.separator") + "\t\"min_matched_peaks\": " + this.sageParameters.getMinMatchedPeaks() + "," + System.getProperty("line.separator") + "\t\"max_fragment_charge\": " + this.sageParameters.getMaxFragmentCharge() + "," + System.getProperty("line.separator") + "\t\"report_psms\": " + this.sageParameters.getNumPsmsPerSpectrum() + "," + System.getProperty("line.separator") + "\t\"mzml_paths\": [\"" + this.spectrumFile.getAbsolutePath().replace("\\", "\\\\") + "\"]" + System.getProperty("line.separator") + "}" + System.getProperty("line.separator"));
        }
    }

    private String getFragmentIonTypesAsList() {
        String listOfFragmentIonTypes = "[";
        for (Integer tempFragmentIonNumber : this.searchParameters.getForwardIons()) {
            if (listOfFragmentIonTypes.length() > 1) {
                listOfFragmentIonTypes = listOfFragmentIonTypes + ", ";
            }
            listOfFragmentIonTypes = listOfFragmentIonTypes + "\"" + PeptideFragmentIon.getSubTypeAsString((int)tempFragmentIonNumber) + "\"";
        }
        for (Integer tempFragmentIonNumber : this.searchParameters.getRewindIons()) {
            if (listOfFragmentIonTypes.length() > 1) {
                listOfFragmentIonTypes = listOfFragmentIonTypes + ", ";
            }
            listOfFragmentIonTypes = listOfFragmentIonTypes + "\"" + PeptideFragmentIon.getSubTypeAsString((int)tempFragmentIonNumber) + "\"";
        }
        listOfFragmentIonTypes = listOfFragmentIonTypes + "]";
        return listOfFragmentIonTypes;
    }

    private String getModifications(ArrayList<String> modifications, boolean fixed) throws IOException {
        HashMap modificationMap = new HashMap();
        block11: for (String modName : modifications) {
            Modification modification = this.modificationFactory.getModification(modName);
            switch (modification.getModificationType()) {
                case modaa: {
                    ArrayList modMassList;
                    for (Character aminoAcid : modification.getPattern().getAminoAcidsAtTarget()) {
                        if (!modificationMap.containsKey(aminoAcid.toString())) {
                            modMassList = new ArrayList();
                            modificationMap.put(aminoAcid.toString(), modMassList);
                        }
                        ((ArrayList)modificationMap.get(aminoAcid.toString())).add(modification.getMass());
                    }
                    continue block11;
                }
                case modn_protein: {
                    ArrayList modMassList;
                    if (!modificationMap.containsKey("[")) {
                        modMassList = new ArrayList();
                        modificationMap.put("[", modMassList);
                    }
                    ((ArrayList)modificationMap.get("[")).add(modification.getMass());
                    break;
                }
                case modn_peptide: {
                    ArrayList modMassList;
                    if (!modificationMap.containsKey("^")) {
                        modMassList = new ArrayList();
                        modificationMap.put("^", modMassList);
                    }
                    ((ArrayList)modificationMap.get("^")).add(modification.getMass());
                    break;
                }
                case modnaa_protein: {
                    ArrayList modMassList;
                    for (Character aminoAcid : modification.getPattern().getAminoAcidsAtTarget()) {
                        if (!modificationMap.containsKey("[" + aminoAcid)) {
                            modMassList = new ArrayList();
                            modificationMap.put("[" + aminoAcid, modMassList);
                        }
                        ((ArrayList)modificationMap.get("[" + aminoAcid)).add(modification.getMass());
                    }
                    continue block11;
                }
                case modnaa_peptide: {
                    ArrayList modMassList;
                    for (Character aminoAcid : modification.getPattern().getAminoAcidsAtTarget()) {
                        if (!modificationMap.containsKey("^" + aminoAcid)) {
                            modMassList = new ArrayList();
                            modificationMap.put("^" + aminoAcid, modMassList);
                        }
                        ((ArrayList)modificationMap.get("^" + aminoAcid)).add(modification.getMass());
                    }
                    continue block11;
                }
                case modc_protein: {
                    ArrayList modMassList;
                    if (!modificationMap.containsKey("]")) {
                        modMassList = new ArrayList();
                        modificationMap.put("]", modMassList);
                    }
                    ((ArrayList)modificationMap.get("]")).add(modification.getMass());
                    break;
                }
                case modc_peptide: {
                    ArrayList modMassList;
                    if (!modificationMap.containsKey("$")) {
                        modMassList = new ArrayList();
                        modificationMap.put("$", modMassList);
                    }
                    ((ArrayList)modificationMap.get("$")).add(modification.getMass());
                    break;
                }
                case modcaa_protein: {
                    ArrayList modMassList;
                    for (Character aminoAcid : modification.getPattern().getAminoAcidsAtTarget()) {
                        if (!modificationMap.containsKey("]" + aminoAcid)) {
                            modMassList = new ArrayList();
                            modificationMap.put("]" + aminoAcid, modMassList);
                        }
                        ((ArrayList)modificationMap.get("]" + aminoAcid)).add(modification.getMass());
                    }
                    continue block11;
                }
                case modcaa_peptide: {
                    ArrayList modMassList;
                    for (Character aminoAcid : modification.getPattern().getAminoAcidsAtTarget()) {
                        if (!modificationMap.containsKey("$" + aminoAcid)) {
                            modMassList = new ArrayList();
                            modificationMap.put("$" + aminoAcid, modMassList);
                        }
                        ((ArrayList)modificationMap.get("$" + aminoAcid)).add(modification.getMass());
                    }
                    continue block11;
                }
            }
        }
        String staticOrVariableTag = fixed ? "static_mods" : "variable_mods";
        String modificationsAsString = "\t\t\"" + staticOrVariableTag + "\": {" + System.getProperty("line.separator");
        String startBracket = fixed ? "" : "[";
        String endBracket = fixed ? "" : "]";
        String tempModString = "";
        for (String modKey : modificationMap.keySet()) {
            if (!tempModString.isEmpty()) {
                tempModString = tempModString + "," + System.getProperty("line.separator");
            }
            tempModString = tempModString + "\t\t\t\"" + modKey + "\": " + startBracket;
            ArrayList modMasses = (ArrayList)modificationMap.get(modKey);
            for (int i = 0; i < modMasses.size(); ++i) {
                if (i > 0) {
                    tempModString = tempModString + ", ";
                }
                tempModString = tempModString + modMasses.get(i);
            }
            tempModString = tempModString + endBracket;
        }
        modificationsAsString = modificationsAsString + tempModString + System.getProperty("line.separator");
        modificationsAsString = modificationsAsString + "\t\t}," + System.getProperty("line.separator");
        return modificationsAsString;
    }

    @Override
    public String getType() {
        return "Sage";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    public static String getExecutableFileName() {
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (operatingSystem.contains("windows")) {
            return "sage.exe";
        }
        return "sage";
    }
}

