/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.TideParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TideIndexProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "crux";
    private File tideTempFolder;
    private File fastaFile;
    private SearchParameters searchParameters;
    private TideParameters tideParameters;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();

    public TideIndexProcessBuilder(File tideFolder, File tideTempFolder, File tideIndexLocation, File fastaFile, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException {
        String cTermProteinMods;
        String cTermPeptideMods;
        String nTermProteinMods;
        String nTermPeptideMods;
        this.tideTempFolder = tideTempFolder;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.searchParameters = searchParameters;
        this.tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        this.fastaFile = fastaFile;
        if (!tideTempFolder.exists()) {
            tideTempFolder.mkdirs();
        }
        if (tideIndexLocation == null) {
            tideIndexLocation = new File(tideTempFolder, this.tideParameters.getFastIndexFolderName());
        }
        File tide = new File(tideFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        tide.setExecutable(true);
        this.process_name_array.add(tide.getAbsolutePath());
        this.process_name_array.add("tide-index");
        this.process_name_array.add(fastaFile.getAbsolutePath());
        this.process_name_array.add(tideIndexLocation.getAbsolutePath());
        this.process_name_array.add("--temp-dir");
        this.process_name_array.add(tideTempFolder.getAbsolutePath());
        this.process_name_array.add("--overwrite");
        this.process_name_array.add("T");
        String nonTerminalMods = this.getNonTerminalModifications();
        if (!nonTerminalMods.isEmpty()) {
            this.process_name_array.add("--mods-spec");
            this.process_name_array.add(this.getNonTerminalModifications());
        }
        if (!(nTermPeptideMods = this.getTerminalModifications(true, false)).isEmpty()) {
            this.process_name_array.add("--nterm-peptide-mods-spec");
            this.process_name_array.add(nTermPeptideMods);
        }
        if (!(nTermProteinMods = this.getTerminalModifications(true, true)).isEmpty()) {
            this.process_name_array.add("--nterm-protein-mods-spec");
            this.process_name_array.add(nTermProteinMods);
        }
        if (!(cTermPeptideMods = this.getTerminalModifications(false, false)).isEmpty()) {
            this.process_name_array.add("--cterm-peptide-mods-spec");
            this.process_name_array.add(cTermPeptideMods);
        }
        if (!(cTermProteinMods = this.getTerminalModifications(false, true)).isEmpty()) {
            this.process_name_array.add("--cterm-protein-mods-spec");
            this.process_name_array.add(cTermProteinMods);
        }
        if (this.tideParameters.getMaxVariableModificationsPerPeptide() != null) {
            this.process_name_array.add("--max-mods");
            this.process_name_array.add(this.tideParameters.getMaxVariableModificationsPerPeptide().toString());
        }
        this.process_name_array.add("--decoy-format");
        this.process_name_array.add(this.tideParameters.getDecoyFormat());
        if (!this.tideParameters.getDecoyFormat().equalsIgnoreCase("none")) {
            this.process_name_array.add("--keep-terminal-aminos");
            this.process_name_array.add(this.tideParameters.getKeepTerminalAminoAcids());
            this.process_name_array.add("--seed");
            this.process_name_array.add(this.tideParameters.getDecoySeed().toString());
        }
        this.process_name_array.add("--output-dir");
        this.process_name_array.add(tideTempFolder.getAbsolutePath());
        this.process_name_array.add("--peptide-list");
        if (this.tideParameters.getPrintPeptides().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--verbosity");
        this.process_name_array.add(this.tideParameters.getVerbosity().toString());
        this.process_name_array.add("--min-length");
        this.process_name_array.add(this.tideParameters.getMinPeptideLength().toString());
        this.process_name_array.add("--max-length");
        this.process_name_array.add(this.tideParameters.getMaxPeptideLength().toString());
        this.process_name_array.add("--min-mass");
        this.process_name_array.add(this.tideParameters.getMinPrecursorMass().toString());
        this.process_name_array.add("--max-mass");
        this.process_name_array.add(this.tideParameters.getMaxPrecursorMass().toString());
        this.process_name_array.add("--isotopic-mass");
        if (this.tideParameters.getMonoisotopicPrecursor().booleanValue()) {
            this.process_name_array.add("mono");
        } else {
            this.process_name_array.add("average");
        }
        this.process_name_array.add("--clip-nterm-methionine");
        if (this.tideParameters.getClipNtermMethionine().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (null != digestionPreferences.getCleavageParameter()) {
            switch (digestionPreferences.getCleavageParameter()) {
                case wholeProtein: {
                    this.process_name_array.add("--custom-enzyme");
                    this.process_name_array.add("[Z]|[Z]");
                    break;
                }
                case unSpecific: {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("no-enzyme");
                    break;
                }
                case enzyme: {
                    if (digestionPreferences.getEnzymes().size() == 1) {
                        String enzymeName;
                        Enzyme enzyme = (Enzyme)digestionPreferences.getEnzymes().get(0);
                        switch (enzymeName = enzyme.getName()) {
                            case "Trypsin": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("trypsin");
                                break;
                            }
                            case "Trypsin (no P rule)": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("trypsin/p");
                                break;
                            }
                            case "Chymotrypsin": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("chymotrypsin");
                                break;
                            }
                            case "CNBr": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("cyanogen-bromide");
                                break;
                            }
                            case "Asp-N": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("asp-n");
                                break;
                            }
                            case "Lys-C": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("lys-c");
                                break;
                            }
                            case "Lys-N": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("lys-n");
                                break;
                            }
                            case "Arg-C": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("arg-c");
                                break;
                            }
                            case "Glu-C": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("glu-c");
                                break;
                            }
                            case "Pepsin A": {
                                this.process_name_array.add("--enzyme");
                                this.process_name_array.add("pepsin-a");
                                break;
                            }
                            default: {
                                this.process_name_array.add("--custom-enzyme");
                                this.process_name_array.add(digestionPreferences.getXTandemFormat());
                            }
                        }
                        this.process_name_array.add("--missed-cleavages");
                        Integer missedCleavages = digestionPreferences.getnMissedCleavages(enzymeName);
                        this.process_name_array.add("" + missedCleavages);
                        break;
                    }
                    if (digestionPreferences.getEnzymes().size() > 1) {
                        throw new IOException("Multiple enzymes not supported by Tide!");
                    }
                    this.process_name_array.add("--custom-enzyme");
                    this.process_name_array.add(digestionPreferences.getXTandemFormat());
                    this.process_name_array.add("--missed-cleavages");
                    Integer missedCleavages = null;
                    for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                        int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                        if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                        missedCleavages = enzymeMissedCleavages;
                    }
                    this.process_name_array.add("" + missedCleavages);
                    break;
                }
            }
        }
        boolean semiSpecific = false;
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                if (digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.semiSpecific && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificCTermOnly && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificNTermOnly) continue;
                semiSpecific = true;
                break;
            }
        }
        this.process_name_array.add("--digestion");
        if (semiSpecific) {
            this.process_name_array.add("partial-digest");
        } else {
            this.process_name_array.add(this.tideParameters.getDigestionType());
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "tide index command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(tideFolder);
        this.pb.redirectErrorStream(true);
    }

    private String getNonTerminalModifications() {
        String tempFixedNonTerminalModifications = this.getNonTerminalModifications(this.searchParameters.getModificationParameters().getFixedModifications(), true);
        String tempVariableNonTerminalModifications = this.getNonTerminalModifications(this.searchParameters.getModificationParameters().getVariableModifications(), false);
        if (!tempFixedNonTerminalModifications.isEmpty() && !tempVariableNonTerminalModifications.isEmpty()) {
            tempFixedNonTerminalModifications = tempFixedNonTerminalModifications + "," + tempVariableNonTerminalModifications;
        } else if (!tempVariableNonTerminalModifications.isEmpty()) {
            return tempVariableNonTerminalModifications;
        }
        return tempFixedNonTerminalModifications;
    }

    private String getNonTerminalModifications(ArrayList<String> modifications, boolean fixed) {
        String nonTerminalModifications = "";
        for (String modName : modifications) {
            AminoAcidPattern modificationPattern;
            Modification modification = this.modificationFactory.getModification(modName);
            ModificationType modificationType = modification.getModificationType();
            if (modificationType != ModificationType.modaa) continue;
            if (!nonTerminalModifications.isEmpty()) {
                nonTerminalModifications = nonTerminalModifications + ",";
            }
            if (!fixed) {
                nonTerminalModifications = nonTerminalModifications + this.tideParameters.getMaxVariableModificationsPerTypePerPeptide();
            }
            if ((modificationPattern = modification.getPattern()) != null && modificationPattern.length() > 0) {
                for (Character aminoAcid : modificationPattern.getAminoAcidsAtTarget()) {
                    nonTerminalModifications = nonTerminalModifications + aminoAcid;
                }
            }
            if (modification.getMass() > 0.0) {
                nonTerminalModifications = nonTerminalModifications + "+";
            }
            nonTerminalModifications = nonTerminalModifications + modification.getMass();
        }
        return nonTerminalModifications;
    }

    private String getTerminalModifications(boolean nTerm, boolean proteinTerm) {
        String tempTermModifications = this.getTerminalModifications(this.searchParameters.getModificationParameters().getFixedModifications(), true, nTerm, proteinTerm);
        String tempTermVariableModifications = this.getTerminalModifications(this.searchParameters.getModificationParameters().getVariableModifications(), false, nTerm, proteinTerm);
        if (!tempTermModifications.isEmpty() && !tempTermVariableModifications.isEmpty()) {
            tempTermModifications = tempTermModifications + "," + tempTermVariableModifications;
        } else if (!tempTermVariableModifications.isEmpty()) {
            return tempTermVariableModifications;
        }
        return tempTermModifications;
    }

    private String getTerminalModifications(ArrayList<String> modifications, boolean fixed, boolean nTerm, boolean proteinTerm) {
        String terminalModifications = "";
        for (String modName : modifications) {
            Modification modification = this.modificationFactory.getSingleAAModification(modName);
            ModificationType modificationType = modification.getModificationType();
            boolean includeModification = false;
            switch (modificationType) {
                case modc_peptide: 
                case modcaa_peptide: {
                    includeModification = !nTerm && !proteinTerm;
                    break;
                }
                case modc_protein: 
                case modcaa_protein: {
                    includeModification = !nTerm && proteinTerm;
                    break;
                }
                case modn_peptide: 
                case modnaa_peptide: {
                    includeModification = nTerm && !proteinTerm;
                    break;
                }
                case modn_protein: 
                case modnaa_protein: {
                    includeModification = nTerm && proteinTerm;
                    break;
                }
            }
            if (!includeModification) continue;
            if (!terminalModifications.isEmpty()) {
                terminalModifications = terminalModifications + ",";
            }
            if (!fixed) {
                terminalModifications = terminalModifications + "1";
            }
            AminoAcidPattern modificationPattern = modification.getPattern();
            String tempPattern = "";
            if (modificationPattern != null && modificationPattern.length() > 0) {
                for (Character aminoAcid : modificationPattern.getAminoAcidsAtTarget()) {
                    tempPattern = tempPattern + aminoAcid;
                }
            }
            if (tempPattern.length() == 0) {
                tempPattern = "X";
            }
            terminalModifications = terminalModifications + tempPattern;
            if (modification.getRoundedMass() > 0.0) {
                terminalModifications = terminalModifications + "+";
            }
            terminalModifications = terminalModifications + modification.getRoundedMass();
        }
        return terminalModifications;
    }

    @Override
    public String getType() {
        return "Tide Indexing";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.fastaFile.getName();
    }
}

