/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.ComputeFDR;
import edu.ucsd.msjava.fdr.Pair;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.util.ArrayList;

public class ComputeQValue {
    public static final float FDR_REPORT_THRESHOLD = 0.1f;

    public static void main(String[] argv) throws Exception {
        File targetFile = null;
        File outputFile = null;
        boolean isConcatenated = false;
        boolean includeDecoy = false;
        float fdrThreshold = 1.0f;
        float pepFDRThreshold = 1.0f;
        String decoyProteinPrefix = "XXX";
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equalsIgnoreCase("-f")) {
                if (i + 1 >= argv.length) {
                    ComputeQValue.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                if (!(targetFile = new File(argv[i + 1])).exists()) {
                    ComputeQValue.printUsageAndExit(argv[i + 1] + " doesn't exist.");
                } else if (!targetFile.isFile()) {
                    ComputeQValue.printUsageAndExit(argv[i + 1] + " is not a file.");
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-o")) {
                if (i + 1 >= argv.length) {
                    ComputeQValue.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                outputFile = new File(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-decoy")) {
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    includeDecoy = true;
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-fdr")) {
                if (i + 1 >= argv.length) {
                    ComputeQValue.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    fdrThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeQValue.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pepfdr")) {
                if (i + 1 >= argv.length) {
                    ComputeQValue.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    pepFDRThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeQValue.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-decoyprefix")) {
                if (i + 1 >= argv.length) {
                    ComputeQValue.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                decoyProteinPrefix = argv[i + 1];
                i += 2;
                continue;
            }
            ComputeQValue.printUsageAndExit("Invalid parameter");
        }
        if (targetFile == null) {
            ComputeQValue.printUsageAndExit("Target is missing!");
        }
        ComputeQValue.computeFDR(targetFile, isConcatenated, includeDecoy, fdrThreshold, pepFDRThreshold, outputFile, decoyProteinPrefix);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.print("Usage: java -cp MSGFPlus.jar fdr.ComputeFDR\n\t -f MSGFPlusFileName (*.tsv)\n\t [-o outputFileName (default: stdout)]\n\t [-fdr fdrThreshold]\n\t [-pepfdr pepFDRThreshold]\n\t [-decoy 0/1] (0: don't include decoy (default), 1: include decoy)\n\t [-decoyPrefix DecoyProteinPrefix] (default: XXX)\n");
        System.exit(-1);
    }

    public static void computeFDR(File msgfTsvFile, boolean isConcatenated, boolean includeDecoy, float fdrThreshold, float pepFDRThreshold, File outputFile, String decoyProteinPrefix) throws Exception {
        boolean isGreaterBetter = false;
        boolean hasHeader = true;
        File decoyFile = null;
        String delimiter = "\t";
        ArrayList<Pair<Integer, ArrayList<String>>> reqStrList = new ArrayList<Pair<Integer, ArrayList<String>>>();
        int scoreCol = -1;
        int specFileCol = -1;
        int pepCol = -1;
        int specIndexCol = -1;
        int dbCol = -1;
        BufferedLineReader in = new BufferedLineReader(msgfTsvFile.getPath());
        String header = in.readLine();
        if (header == null) {
            System.out.println("Not a valid MS-GF+ result file!");
            System.exit(0);
        }
        String[] headerToken = header.split("\t");
        for (int i = 0; i < headerToken.length; ++i) {
            if (headerToken[i].equalsIgnoreCase("SpecEValue")) {
                scoreCol = i;
            }
            if (headerToken[i].equalsIgnoreCase("#SpecFile")) {
                specFileCol = i;
            }
            if (headerToken[i].equalsIgnoreCase("Peptide")) {
                pepCol = i;
            }
            if (headerToken[i].equalsIgnoreCase("SpecID")) {
                specIndexCol = i;
            }
            if (!headerToken[i].equalsIgnoreCase("Protein")) continue;
            dbCol = i;
        }
        if (scoreCol < 0) {
            System.out.println("SpecEValue column is missing!");
            System.exit(-1);
        }
        if (specFileCol < 0) {
            System.out.println("SpecFile column is missing!");
            System.exit(-1);
        }
        if (pepCol < 0) {
            System.out.println("Peptide column is missing!");
            System.exit(-1);
        }
        if (specIndexCol < 0) {
            System.out.println("SpecID column is missing!");
            System.exit(-1);
        }
        if (dbCol < 0) {
            System.out.println("Protein column is missing!");
            System.exit(-1);
        }
        ComputeFDR.computeFDR(msgfTsvFile, decoyFile, scoreCol, isGreaterBetter, delimiter, specFileCol, specIndexCol, pepCol, reqStrList, isConcatenated, includeDecoy, hasHeader, dbCol, decoyProteinPrefix, fdrThreshold, pepFDRThreshold, outputFile);
    }
}

