/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.ScoredString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class PSMSet {
    protected ArrayList<ScoredString> psmList;
    protected HashMap<String, Float> peptideScoreTable;

    public ArrayList<ScoredString> getPSMList() {
        return this.psmList;
    }

    public HashMap<String, Float> getPeptideScoreTable() {
        return this.peptideScoreTable;
    }

    public abstract boolean isGreaterBetter();

    public void printPSMSet() {
        if (this.psmList != null) {
            for (ScoredString s : this.psmList) {
                System.out.println(s.getStr());
            }
        }
    }

    public void printPeptideScoreTable() {
        if (this.peptideScoreTable != null) {
            for (Map.Entry<String, Float> entry : this.peptideScoreTable.entrySet()) {
                System.out.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }

    public ArrayList<Float> getPSMScores() {
        if (this.psmList == null) {
            return null;
        }
        ArrayList<Float> psmScores = new ArrayList<Float>();
        for (ScoredString ss : this.psmList) {
            psmScores.add(Float.valueOf(ss.getScore()));
        }
        return psmScores;
    }

    public ArrayList<Float> getPepScores() {
        if (this.peptideScoreTable == null) {
            return null;
        }
        ArrayList<Float> pepScores = new ArrayList<Float>();
        for (Map.Entry<String, Float> entry : this.peptideScoreTable.entrySet()) {
            pepScores.add(entry.getValue());
        }
        return pepScores;
    }

    public abstract void read();
}

