/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.PSMSet;
import edu.ucsd.msjava.fdr.TSVPSMSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TargetDecoyAnalysis {
    final PSMSet target;
    final PSMSet decoy;
    final boolean isGreaterBetter;
    final float pit;
    TreeMap<Float, Float> psmLevelFDRMap;
    TreeMap<Float, Float> pepLevelFDRMap;

    public TargetDecoyAnalysis(PSMSet target, PSMSet decoy) {
        this(target, decoy, 1.0f);
    }

    public TargetDecoyAnalysis(PSMSet target, PSMSet decoy, float pit) {
        this.target = target;
        this.decoy = decoy;
        this.isGreaterBetter = target.isGreaterBetter();
        this.pit = pit;
        this.psmLevelFDRMap = TargetDecoyAnalysis.getFDRMap(target.getPSMScores(), decoy.getPSMScores(), this.isGreaterBetter, pit);
        this.pepLevelFDRMap = TargetDecoyAnalysis.getFDRMap(target.getPepScores(), decoy.getPepScores(), this.isGreaterBetter, pit);
    }

    public PSMSet getTargetPSMSet() {
        return this.target;
    }

    public PSMSet getDecoyPSMSet() {
        return this.decoy;
    }

    public TreeMap<Float, Float> getPSMLevelFDRMap() {
        return this.psmLevelFDRMap;
    }

    public TreeMap<Float, Float> getPepLevelFDRMap() {
        return this.pepLevelFDRMap;
    }

    public float getPSMQValue(float score) {
        float fdr = this.isGreaterBetter ? this.psmLevelFDRMap.lowerEntry(Float.valueOf(score)).getValue().floatValue() : this.psmLevelFDRMap.higherEntry(Float.valueOf(score)).getValue().floatValue();
        return fdr;
    }

    public float getPepFDR(float score) {
        float fdr = this.isGreaterBetter ? this.pepLevelFDRMap.lowerEntry(Float.valueOf(score)).getValue().floatValue() : this.pepLevelFDRMap.higherEntry(Float.valueOf(score)).getValue().floatValue();
        return fdr;
    }

    public Float getPepQValueFromAnnotation(String annotation) {
        String pep = TSVPSMSet.getPeptideFromAnnotation(annotation);
        Float score = this.target.getPeptideScoreTable().get(pep);
        if (score == null && (score = this.decoy.getPeptideScoreTable().get(pep)) == null) {
            return null;
        }
        return Float.valueOf(this.getPepFDR(score.floatValue()));
    }

    public Float getPepQValue(String pep) {
        Float score = this.target.getPeptideScoreTable().get(pep);
        if (score == null && (score = this.decoy.getPeptideScoreTable().get(pep)) == null) {
            return null;
        }
        return Float.valueOf(this.getPepFDR(score.floatValue()));
    }

    public float getThresholdScore(float fdrThreshold, boolean isPeptideLevel) {
        float threshold;
        TreeMap<Float, Float> map = !isPeptideLevel ? this.psmLevelFDRMap : this.pepLevelFDRMap;
        if (this.isGreaterBetter) {
            threshold = Float.MAX_VALUE;
            for (Map.Entry entry : map.descendingMap().entrySet()) {
                if (((Float)entry.getValue()).floatValue() > fdrThreshold) break;
                threshold = ((Float)entry.getKey()).floatValue();
            }
        } else {
            threshold = Float.MIN_VALUE;
            for (Map.Entry<Float, Float> entry : map.entrySet()) {
                if (entry.getValue().floatValue() > fdrThreshold) break;
                threshold = entry.getKey().floatValue();
            }
        }
        return threshold;
    }

    public static TreeMap<Float, Float> getFDRMap(ArrayList<Float> target, ArrayList<Float> decoy, boolean isGreaterBetter, float pit) {
        TreeMap<Float, Float> fdrMap = new TreeMap<Float, Float>();
        if (!isGreaterBetter) {
            Collections.sort(target);
            Collections.sort(decoy);
        } else {
            Collections.sort(target, Collections.reverseOrder());
            Collections.sort(decoy, Collections.reverseOrder());
        }
        int targetIndex = 0;
        float prevDecoyScore = Float.NEGATIVE_INFINITY;
        if (isGreaterBetter) {
            fdrMap.put(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(0.0f));
            fdrMap.put(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(1.0f));
        } else {
            fdrMap.put(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(1.0f));
            fdrMap.put(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(0.0f));
        }
        for (int decoyIndex = 0; decoyIndex < decoy.size(); ++decoyIndex) {
            float decoyScore = decoy.get(decoyIndex).floatValue();
            if (decoyScore == prevDecoyScore) continue;
            prevDecoyScore = decoyScore;
            if (isGreaterBetter) {
                while (targetIndex < target.size() && target.get(targetIndex).floatValue() > decoyScore) {
                    ++targetIndex;
                }
            } else {
                while (targetIndex < target.size() && target.get(targetIndex).floatValue() < decoyScore) {
                    ++targetIndex;
                }
            }
            if (targetIndex <= 0) continue;
            float fdr = targetIndex <= decoyIndex ? 1.0f : (float)Math.round((float)decoyIndex * pit) / (float)targetIndex;
            if (fdr > 1.0f) {
                fdr = 1.0f;
            }
            fdrMap.put(Float.valueOf(decoyScore), Float.valueOf(fdr));
            if (fdr >= 1.0f) break;
        }
        if (decoy.size() == 0) {
            if (isGreaterBetter) {
                fdrMap.put(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(0.0f));
            } else {
                fdrMap.put(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(0.0f));
            }
        }
        TreeMap<Float, Float> finalFDRMap = new TreeMap<Float, Float>();
        Iterator itr = isGreaterBetter ? fdrMap.entrySet().iterator() : fdrMap.descendingMap().entrySet().iterator();
        float minFDR = 1.0f;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            float fdr = ((Float)entry.getValue()).floatValue();
            if (fdr > minFDR) {
                fdr = minFDR;
            }
            minFDR = fdr;
            finalFDRMap.put((Float)entry.getKey(), Float.valueOf(fdr));
        }
        return finalFDRMap;
    }
}

