/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ims;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class GetTheBestPerPeptide {
    public static void main(String[] argv) throws Exception {
        File tsvFile;
        if (argv.length != 1) {
            GetTheBestPerPeptide.printUsageAndExit("Invalid parameter.");
        }
        if (!(tsvFile = new File(argv[0])).exists()) {
            GetTheBestPerPeptide.printUsageAndExit("File does not exist.");
        }
        GetTheBestPerPeptide.getTheBest(tsvFile);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("Usage: java GetTheBestPerScan TSVFile");
        System.exit(-1);
    }

    public static void getTheBest(File tsvFile) throws Exception {
        String s;
        BufferedLineReader in = new BufferedLineReader(tsvFile.getPath());
        String header = in.readLine();
        String[] headerToken = header.split("\t");
        int annotationIndexCol = -1;
        int specProbCol = -1;
        for (int i = 0; i < headerToken.length; ++i) {
            if (headerToken[i].equalsIgnoreCase("Annotation")) {
                annotationIndexCol = i;
            }
            if (!headerToken[i].equalsIgnoreCase("SpecProb")) continue;
            specProbCol = i;
        }
        if (annotationIndexCol == -1) {
            System.err.println("DtaIndex column does not exist.");
            System.exit(-1);
        }
        if (specProbCol == -1) {
            System.err.println("SpecProb column does not exist.");
            System.exit(-1);
        }
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        while ((s = in.readLine()) != null) {
            if (s.startsWith("#")) continue;
            String[] token = s.split("\t");
            String annotation = token[annotationIndexCol];
            String prev = (String)table.get(annotation);
            if (prev == null) {
                table.put(annotation, s);
                continue;
            }
            String[] tokenPrev = prev.split("\t");
            float prevSpecProb = Float.parseFloat(tokenPrev[specProbCol]);
            float specProb = Float.parseFloat(token[specProbCol]);
            if (!(specProb < prevSpecProb)) continue;
            table.put(annotation, s);
        }
        in.close();
        ArrayList annotationList = new ArrayList(table.keySet());
        System.out.println(header);
        for (String annotation : annotationList) {
            System.out.println((String)table.get(annotation));
        }
    }
}

