/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ipa;

import edu.ucsd.msjava.ipa.MS1SpectraMap;
import edu.ucsd.msjava.ipa.MSGFPlusResultSet;
import edu.ucsd.msjava.ipa.PSM;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.Composition;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class IPA {
    private MS1SpectraMap ms1SpecMap;
    private MSGFPlusResultSet resultSet;
    private Tolerance tol = new Tolerance(5.0f, true);

    public IPA(File deconPeaksFile, File msgfPlusTsvFile) {
        this.ms1SpecMap = new MS1SpectraMap(deconPeaksFile);
        this.resultSet = new MSGFPlusResultSet(msgfPlusTsvFile);
    }

    public IPA tolerance(Tolerance tol) {
        this.tol = tol;
        return this;
    }

    public void writeTo(File outputFile) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        HashMap precursorMap = new HashMap();
        out.println(this.resultSet.getHeader());
        List<PSM> psmList = this.resultSet.getPSMList();
        for (PSM psm : psmList) {
            float precursorMz = (float)(psm.getComposition().getMass() / (double)psm.getCharge() + Composition.ChargeCarrierMass());
            int charge = psm.getCharge();
            if (!((double)psm.getSpecEValue() < 1.0E-10) && !this.ms1SpecMap.checkMS1Peaks(psm.getScanNum(), precursorMz, charge, this.tol, 3)) continue;
            int precursorScan = this.ms1SpecMap.getPrecursorScan(psm.getScanNum());
            HashSet<Float> identifiedPrecursors = (HashSet<Float>)precursorMap.get(precursorScan);
            if (identifiedPrecursors == null) {
                identifiedPrecursors = new HashSet<Float>();
                precursorMap.put(precursorScan, identifiedPrecursors);
            }
            if (identifiedPrecursors.contains(Float.valueOf(precursorMz))) continue;
            identifiedPrecursors.add(Float.valueOf(precursorMz));
            out.println(psm.getResultString());
        }
        out.close();
    }
}

