/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ipa;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class MS1SpectraMap {
    private TreeMap<Integer, Spectrum> ms1SpecMap;

    public MS1SpectraMap(File peaksFile) {
        this.parsePeaksFile(peaksFile);
    }

    public Integer getPrecursorScan(int scanNum) {
        return this.ms1SpecMap.floorKey(scanNum);
    }

    public Peak getPrecursorPeaks(int scanNum, float mz, Tolerance tol) {
        int precursorScan = this.getPrecursorScan(scanNum);
        return this.getMS1Peak(precursorScan, mz, tol);
    }

    public List<Pair<Integer, Float>> getXIC(int scanNum, float mz, Tolerance tol) {
        Peak p;
        ArrayList<Pair<Integer, Float>> xic = new ArrayList<Pair<Integer, Float>>();
        Integer curScanNum = scanNum;
        while (curScanNum != null && scanNum > 0 && (p = this.getMS1Peak(curScanNum = this.ms1SpecMap.lowerKey(curScanNum), mz, tol)) != null) {
            xic.add(new Pair<Integer, Float>(curScanNum, Float.valueOf(p.getIntensity())));
        }
        curScanNum = scanNum;
        while (curScanNum != null && curScanNum < 100000 && (p = this.getMS1Peak(curScanNum = this.ms1SpecMap.higherKey(curScanNum), mz, tol)) != null) {
            xic.add(new Pair<Integer, Float>(curScanNum, Float.valueOf(p.getIntensity())));
        }
        Collections.sort(xic, new Pair.PairComparator());
        return xic;
    }

    public Peak getMS1Peak(int ms1ScanNum, float mz, Tolerance tol) {
        Spectrum ms1Spec = this.ms1SpecMap.get(ms1ScanNum);
        if (ms1Spec == null) {
            return null;
        }
        ArrayList<Peak> matchList = ms1Spec.getPeakListByMz(mz, tol);
        if (matchList == null || matchList.size() == 0) {
            return null;
        }
        Peak bestPeak = null;
        float distance = Float.MAX_VALUE;
        for (Peak p : matchList) {
            float dis = p.getMz() - mz;
            if (dis < 0.0f) {
                dis = -dis;
            }
            if (!(dis < distance)) continue;
            distance = dis;
            bestPeak = p;
        }
        return bestPeak;
    }

    public boolean checkMS1Peaks(int scanNum, float mz, int charge, Tolerance tol, int windowSize) {
        int i;
        int precursorScanNum = this.ms1SpecMap.floorKey(scanNum);
        if (this.checkMS1Peaks(precursorScanNum, mz, charge, tol)) {
            return true;
        }
        Integer curScanNum = precursorScanNum;
        for (i = 0; i < windowSize && (curScanNum = this.ms1SpecMap.lowerKey(curScanNum)) != null; ++i) {
            if (!this.checkMS1Peaks(curScanNum, mz, charge, tol)) continue;
            return true;
        }
        curScanNum = precursorScanNum;
        for (i = 0; i < windowSize && (curScanNum = this.ms1SpecMap.higherKey(curScanNum)) != null; ++i) {
            if (!this.checkMS1Peaks(curScanNum, mz, charge, tol)) continue;
            return true;
        }
        return false;
    }

    public boolean checkMS1Peaks(int ms1ScanNum, float mz, int charge, Tolerance tol) {
        Spectrum ms1Spec = this.ms1SpecMap.get(ms1ScanNum);
        if (ms1Spec == null) {
            return false;
        }
        ArrayList<Peak> matchList = ms1Spec.getPeakListByMz(mz, tol);
        if (matchList == null || matchList.size() == 0) {
            return false;
        }
        for (Peak p : matchList) {
            float minusOne = p.getMz() - 1.0033548f / (float)charge;
            float secondIsotopeMz = p.getMz() + 1.0033548f / (float)charge;
            if (ms1Spec.getPeakListByMz(secondIsotopeMz, new Tolerance(5.0f, true)).isEmpty() || !ms1Spec.getPeakListByMz(minusOne, new Tolerance(1.0f, true)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void parsePeaksFile(File peaksFile) {
        String s;
        this.ms1SpecMap = new TreeMap();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(peaksFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        in.readLine();
        int curScanNum = 0;
        Spectrum currentSpec = null;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            int scanNum = Integer.parseInt(token[1]);
            if (scanNum > curScanNum) {
                if (currentSpec != null) {
                    this.ms1SpecMap.put(curScanNum, currentSpec);
                }
                curScanNum = scanNum;
                currentSpec = new Spectrum();
                currentSpec.setMsLevel(1);
            }
            float mz = Float.parseFloat(token[2]);
            float intensity = Float.parseFloat(token[3]);
            currentSpec.add(new Peak(mz, intensity, -1));
        }
    }
}

