/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import java.io.BufferedReader;
import java.io.FileReader;

public class CalcFastaDBSize {
    public static void main(String[] argv) throws Exception {
        int i;
        String s;
        if (argv.length != 1 || !argv[0].endsWith(".fasta") && !argv[0].endsWith(".fa")) {
            System.out.println("usage: java CalcFastaDBSize *.fasta");
            System.exit(0);
        }
        BufferedReader in = new BufferedReader(new FileReader(argv[0]));
        int length = 0;
        int numProteins = 0;
        int[] numTrypticPeptides = new int[11];
        int pepLen = 0;
        Histogram<Character> aaHist = new Histogram<Character>();
        while ((s = in.readLine()) != null) {
            if (s.startsWith(">")) {
                ++numProteins;
                pepLen = 0;
                continue;
            }
            length += s.length();
            for (i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isLetter(c)) {
                    aaHist.add(Character.valueOf(c));
                }
                if (c == 'K' || c == 'R') {
                    if (pepLen >= 4 && pepLen < numTrypticPeptides.length - 1) {
                        int n = ++pepLen;
                        numTrypticPeptides[n] = numTrypticPeptides[n] + 1;
                    }
                    pepLen = 0;
                    continue;
                }
                if (AminoAcidSet.getStandardAminoAcidSet().getAminoAcid(c) == null) {
                    pepLen = 0;
                    continue;
                }
                ++pepLen;
            }
        }
        System.out.println("#Proteins: " + numProteins);
        System.out.println("#Amino acids: " + length);
        System.out.println("#Tryptic Peptides (with no miscleavage)");
        System.out.println("Length\tNumber");
        for (i = 5; i < numTrypticPeptides.length; ++i) {
            System.out.println(i + "\t" + numTrypticPeptides[i]);
        }
        System.out.println("Amino Acid Composition:");
        aaHist.printSorted();
    }
}

