/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.MSGFDBResultGenerator;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class Chores {
    public static void main(String[] argv) throws Exception {
        String msgf = "MSGFDB";
        System.out.println(msgf.matches("MS-?GF[+-]?(DB)?"));
    }

    public static void recombCPReg() throws Exception {
        String s;
        File regList = new File("/Users/sangtaekim/Dropbox/Documents/RECOMB-CP 2012/regList.txt");
        File submissions = new File("/Users/sangtaekim/Dropbox/Documents/RECOMB-CP 2012/submissions.txt");
        HashSet<String> names = new HashSet<String>();
        BufferedLineReader in = new BufferedLineReader(regList.getPath());
        while ((s = in.readLine()) != null) {
            names.add(s.toLowerCase());
        }
        in.close();
        in = new BufferedLineReader(submissions.getPath());
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length != 4) {
                System.err.println("Error: " + s);
                System.exit(-1);
            }
            String authors = token[1];
            String type = token[3];
            if (!type.equalsIgnoreCase("Abstract")) continue;
            String[] aToken = authors.split("\\s+");
            boolean isRegistered = false;
            for (String name : aToken) {
                for (String r : names) {
                    if (!r.contains(name.toLowerCase())) continue;
                    System.out.println("***" + name + ":" + r);
                    isRegistered = true;
                }
            }
            if (!isRegistered) continue;
            System.out.println(s);
        }
    }

    public static void simpleTest() throws Exception {
        int specSize = 728178;
        int numThreads = 8;
        int numSpecScannedTogether = 116510;
        for (int fromIndexGlobal = 0; fromIndexGlobal < specSize; fromIndexGlobal += numSpecScannedTogether) {
            int toIndexGlobal = Math.min(specSize, fromIndexGlobal + numSpecScannedTogether);
            System.out.println("=========== " + fromIndexGlobal + "," + toIndexGlobal + " =============");
            int size = toIndexGlobal - fromIndexGlobal;
            int subListSize = size / numThreads;
            int residue = size % numThreads;
            int[] startIndex = new int[numThreads];
            int[] endIndex = new int[numThreads];
            for (int i = 0; i < numThreads; ++i) {
                startIndex[i] = i > 0 ? endIndex[i - 1] : fromIndexGlobal;
                endIndex[i] = startIndex[i] + subListSize + (i < residue ? 1 : 0);
                System.out.println(startIndex[i] + "," + endIndex[i]);
            }
        }
    }

    public static void printMaxScanNum() throws Exception {
        String mzXMLFileName = "/home/sangtaekim/Test/CCMS/3297b97db35241ba8547906b22377869/spectrum/00000.mzXML";
        MzXMLSpectraMap map = new MzXMLSpectraMap(mzXMLFileName);
        System.out.println(map.getMaxScanNumber());
    }

    public static void compareFiles() throws Exception {
        String mzXMLFileName = "/home/sangtaekim/Test/CCMS/3297b97db35241ba8547906b22377869/spectrum/00000.mzXML";
        String mgfFileName = "/home/sangtaekim/Test/CCMS/3297b97db35241ba8547906b22377869/spectrum/00000.mgf";
        SpectraIterator itr = new SpectraIterator(mgfFileName, (SpectrumParser)new MgfSpectrumParser());
        HashSet<Integer> mgfScanNum = new HashSet<Integer>();
        while (itr.hasNext()) {
            mgfScanNum.add(itr.next().getScanNum());
        }
        MzXMLSpectraIterator itr2 = new MzXMLSpectraIterator(mzXMLFileName);
        HashSet<Integer> mzXMLScanNum = new HashSet<Integer>();
        while (itr2.hasNext()) {
            mzXMLScanNum.add(itr2.next().getScanNum());
        }
        int mzXMLOnly = 0;
        Iterator iterator = mzXMLScanNum.iterator();
        while (iterator.hasNext()) {
            int scanNum = (Integer)iterator.next();
            if (mgfScanNum.contains(scanNum)) continue;
            System.out.println("MzXMLOnly: " + scanNum);
            ++mzXMLOnly;
        }
        int mgfOnly = 0;
        Iterator iterator2 = mgfScanNum.iterator();
        while (iterator2.hasNext()) {
            int scanNum = (Integer)iterator2.next();
            if (mzXMLScanNum.contains(scanNum)) continue;
            System.out.println("MgfOnly: " + scanNum);
            ++mgfOnly;
        }
        System.out.println("MzXMLOnly: " + mzXMLOnly);
        System.out.println("MgfOnly: " + mgfOnly);
    }

    public static void efdrTest() throws Exception {
        double[] specProb = new double[136964];
        Random rand = new Random();
        for (int i = 0; i < specProb.length; ++i) {
            specProb[i] = rand.nextDouble();
        }
        long time = System.currentTimeMillis();
        Arrays.sort(specProb);
        System.out.println("Sorting: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        double cumP = 0.0;
        for (int i = 0; i < specProb.length; ++i) {
            double eFDR;
            double probCorr = 1.0 - specProb[i];
            double pValue = MSGFDBResultGenerator.DBMatch.getPValue(specProb[i], 3000000);
            double eTD = (double)(i + 1) - (cumP += pValue);
            double eDD = cumP;
            for (int j = 1; j < specProb.length; ++j) {
                eDD += specProb[j];
            }
            double d = eFDR = eDD / eTD;
        }
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }

    public static void combination(int n, int r) throws Exception {
        for (LinkedList<Integer> ins : Chores.getCombinations(n, r)) {
            System.out.println(ins);
        }
    }

    public static ArrayList<LinkedList<Integer>> getCombinations(int n, int r) throws Exception {
        ArrayList<LinkedList<Integer>> nHr;
        block4: {
            block3: {
                nHr = new ArrayList<LinkedList<Integer>>();
                if (r != 1) break block3;
                for (int i = 0; i < n; ++i) {
                    LinkedList<Integer> newIns = new LinkedList<Integer>();
                    newIns.add(i);
                    nHr.add(newIns);
                }
                break block4;
            }
            if (r <= 1) break block4;
            ArrayList<LinkedList<Integer>> nHrMinus1 = Chores.getCombinations(n, r - 1);
            for (LinkedList<Integer> ins : nHrMinus1) {
                int prevLargest;
                for (int i = prevLargest = ins.getLast().intValue(); i < n; ++i) {
                    LinkedList<Integer> newIns = new LinkedList<Integer>(ins);
                    newIns.add(i);
                    nHr.add(newIns);
                }
            }
        }
        return nHr;
    }

    public static void mzXMLLoadingTest() throws Exception {
        long time = System.currentTimeMillis();
        String fileName = "/home/sangtaekim/Research/Data/HeckWhole/Spectra/090121_NM_Trypsin_20.mzXML";
        MzXMLSpectraMap map = new MzXMLSpectraMap(fileName);
        System.out.println("LoadingTime: " + (System.currentTimeMillis() - time));
        map.getSpectrumBySpecIndex(100);
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }

    public static void extractRECOMBCPEmails() throws Exception {
        String s;
        String fileName = System.getProperty("user.home") + "/Documents/RECOMB-CP/participantsEmails.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        while ((s = in.readLine()) != null) {
            if (!s.matches(".+@.+\\..+")) continue;
            System.out.println(s.split("\\s+")[0]);
        }
    }

    public static void extractRECOMBBEAbstracts() throws Exception {
        String s;
        String fileName = System.getProperty("user.home") + "/Desktop/abstracts.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        int lineNum = 0;
        Hashtable<String, String> entries = new Hashtable<String, String>();
        while ((s = in.readLine()) != null) {
            String email;
            if (s.startsWith("ID")) continue;
            ++lineNum;
            String[] token = s.split("\t");
            if (token.length < 12 || (email = token[7]).contains("sangtae") || email.contains("chorta")) continue;
            entries.put(email, s);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String e : entries.values()) {
            list.add(e);
        }
        Collections.sort(list);
        for (String e : list) {
            String[] token = e.split("\t");
            System.out.println("****************************");
            System.out.println("Date Submitted: " + token[1]);
            System.out.println("Category: " + token[2]);
            System.out.println("Title: " + token[3]);
            System.out.println("Author: " + token[4] + " " + token[5]);
            System.out.println("Co-Authors: " + token[6]);
            System.out.println("Email: " + token[7]);
            System.out.println("Affiliation: " + token[8]);
            System.out.println("Topic: " + token[9]);
            System.out.println("Keywords: " + token[10]);
            System.out.println();
            System.out.println("Abstract:");
            for (int i = 11; i < token.length; ++i) {
                System.out.print(token[i] + "\t");
            }
            System.out.println();
            System.out.println();
        }
    }

    public static void extractEmails() throws Exception {
        String s;
        String fileName = "/Users/sangtaekim/Documents/RECOMB-CP/asms09.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        while ((s = in.readLine()) != null) {
            String[] token;
            for (String t : token = s.split("\\s+")) {
                if (!t.contains("@") || !t.contains(".")) continue;
                System.out.println(t);
            }
        }
    }
}

