/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import java.io.File;

public class CountSequestIDs {
    public static void main(String[] argv) throws Exception {
        File seqDir;
        if (argv.length != 1) {
            CountSequestIDs.printUsageAndExit("Invalid parameters!");
        }
        if (!(seqDir = new File(argv[0])).isDirectory()) {
            CountSequestIDs.printUsageAndExit(argv[0] + " is not a directory!");
        }
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.exit(-1);
    }

    public static void processPPResults(File seqDir) throws Exception {
        File synFile = null;
        File synPPFile = null;
        for (File f : seqDir.listFiles()) {
            String fileName = f.getName();
            if (fileName.endsWith("_syn.txt") || fileName.endsWith("_syn.tsv")) {
                synFile = f;
                continue;
            }
            if (!fileName.endsWith("_syn_PepProphet.txt") && !fileName.endsWith("_syn_PepProphet.tsv")) continue;
            synPPFile = f;
        }
        if (synFile == null) {
            CountSequestIDs.printUsageAndExit("_syn.txt file is missing!");
        }
        if (synPPFile == null) {
            CountSequestIDs.printUsageAndExit("_syn_PepProphet.txt file is missing!");
        }
    }
}

