/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Deconvolution {
    public static void main(String[] argv) throws Exception {
        if (argv.length < 2 || argv.length % 2 != 0) {
            Deconvolution.printUsageAndExit("The number of parameters must be even.");
        }
        File specFile = null;
        File deconvSpecFile = null;
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                Deconvolution.printUsageAndExit("Invalid parameters");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-i")) {
                specFile = new File(argv[i + 1]);
                if (!specFile.exists()) {
                    Deconvolution.printUsageAndExit(argv[i + 1] + " doesn't exist!");
                }
                if (specFile.getName().endsWith(".mgf")) continue;
                Deconvolution.printUsageAndExit(argv[i + 1] + " is not mgf spectrum!");
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-o")) continue;
            deconvSpecFile = new File(argv[i + 1]);
            if (deconvSpecFile.exists()) {
                Deconvolution.printUsageAndExit(argv[i + 1] + " already exists!");
            }
            if (deconvSpecFile.getName().endsWith(".mgf")) continue;
            Deconvolution.printUsageAndExit(argv[i + 1] + " is not mgf spectrum!");
        }
        Deconvolution.deconvolute(specFile, deconvSpecFile);
    }

    public static void printUsageAndExit(String message) {
        System.out.println(message);
        System.out.println("Usage: java Deconvolution -i SpecFileName(*.mgf) -o DeconvolutedSpecFileName(*.mgf)");
        System.exit(-1);
    }

    public static void deconvolute(File specFile, File deconvSpecFile) throws Exception {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(deconvSpecFile)));
        int numSpecs = 0;
        SpectraIterator itr = new SpectraIterator(specFile.getPath(), (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            spec.getDeconvolutedSpectrum(0.02f).outputMgf(out);
            ++numSpecs;
        }
        out.close();
        System.out.println(numSpecs + " are deconvoluted.");
    }
}

