/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.FileFormat;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;

public class PepIdxToFasta {
    public static void main(String[] argv) throws Exception {
        ParamManager paramManager = new ParamManager("PepIdxToFasta", "1", "02/01/2012", "java -Xmx2000M -cp MSGFDB.jar misc.PepIdxToFasta");
        FileParameter sourceFileParam = new FileParameter("s", "*.pepidx", "pepidx file name");
        sourceFileParam.fileMustExist();
        sourceFileParam.addFileFormat(new FileFormat(".pepidx"));
        paramManager.addParameter(sourceFileParam);
        if (argv.length == 0) {
            paramManager.printUsageInfo();
            return;
        }
        String errMessage = paramManager.parseParams(argv);
        if (errMessage != null) {
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
            return;
        }
        String errorMessage = PepIdxToFasta.convertToFasta(paramManager);
        if (errorMessage != null) {
            System.err.println("[Error] " + errorMessage);
            System.out.println();
        } else {
            System.out.format("PepIdxToFasta complete.", new Object[0]);
        }
    }

    public static String convertToFasta(ParamManager paramManager) throws Exception {
        String s;
        File source = paramManager.getFile("s");
        String prevPep = "";
        BufferedLineReader in = new BufferedLineReader(source.getPath());
        while ((s = in.readLine()) != null) {
            String pep;
            String[] token;
            if (s.startsWith("#") || s.length() == 0 || (token = s.split("\t")).length != 3 || (pep = token[0]).equals(prevPep)) continue;
            prevPep = pep;
            System.out.println(">Fwd:" + pep.length());
            System.out.println(pep);
        }
        return null;
    }
}

