/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

public class ProgressData {
    private double progress = 0.0;
    private double minPercent = 0.0;
    private double maxPercent = 100.0;
    private ProgressData parentProgress;
    public boolean isPartialRange = false;

    public ProgressData() {
        this.parentProgress = null;
    }

    public ProgressData(ProgressData parent) {
        this.parentProgress = parent;
    }

    public void setParentProgressObj(ProgressData progressObj) {
        this.parentProgress = progressObj;
    }

    public ProgressData getParentProgressObj() {
        return this.parentProgress;
    }

    public void resetProgress() {
        this.progress = 0.0;
    }

    private void setProgress(double pct) {
        this.progress = pct;
    }

    public double getProgress() {
        if (this.isPartialRange) {
            return this.progress * ((this.maxPercent - this.minPercent) / 100.0) + this.minPercent;
        }
        return this.progress;
    }

    public void setMinPercentage(double pct) {
        this.checkSetMinMaxRange(pct, this.maxPercent);
    }

    public double getMinPercentage(double pct) {
        return this.minPercent;
    }

    public void setMaxPercentage(double pct) {
        this.checkSetMinMaxRange(this.minPercent, pct);
    }

    public double getMaxPercentage(double pct) {
        return this.maxPercent;
    }

    public void stepRange(double newMaxPct) {
        if (!this.isPartialRange) {
            this.isPartialRange = true;
            this.minPercent = 0.0;
            if (this.maxPercent >= 100.0) {
                this.maxPercent = 0.0;
            }
        }
        this.checkSetMinMaxRange(this.maxPercent, newMaxPct);
    }

    private void checkSetMinMaxRange(double minPct, double maxPct) {
        double pct;
        boolean partial = this.isPartialRange;
        this.progress = pct = this.progress;
        this.isPartialRange = false;
        if (maxPct > minPct) {
            this.minPercent = minPct;
            this.maxPercent = maxPct;
        }
        if (this.minPercent < 0.0) {
            this.minPercent = 0.0;
        }
        if (this.maxPercent > 100.0) {
            this.maxPercent = 100.0;
        }
        this.isPartialRange = partial;
        if (partial) {
            this.report(0.0);
        }
    }

    public void updateProgress(double pct) {
        this.setProgress(pct);
    }

    public void report(double pct) {
        this.setProgress(pct);
        if (this.parentProgress != null) {
            this.parentProgress.report(this.getProgress());
        }
    }

    public void reportDecimal(double pct) {
        this.report(pct * 100.0);
    }

    public void report(double count, double total) {
        this.reportDecimal(count / total);
    }
}

