/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.FileFormat;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SpectraSTToMSGFInput {
    public static final int VERSION = 7575;
    public static final String DATE = "04/13/2012";

    public static void main(String[] argv) throws Exception {
        ParamManager paramManager = new ParamManager("SpectraSTToMSGFInput", String.valueOf(7575), DATE, "java -Xmx2000M -cp MSGFDB.jar SpectraSTToMSGFInput");
        FileParameter stParam = new FileParameter("i", "SpectraSTResult", "SpectraST result file (*.txt)");
        stParam.addFileFormat(new FileFormat(".txt"));
        stParam.fileMustExist();
        stParam.mustBeAFile();
        paramManager.addParameter(stParam);
        FileParameter outputFileParam = new FileParameter("o", "OutputFile", "MS-GF input file");
        paramManager.addParameter(outputFileParam);
        paramManager.addSpecFileParam(false);
        if (argv.length == 0) {
            paramManager.printUsageInfo();
            return;
        }
        String errMessage = paramManager.parseParams(argv);
        if (errMessage != null) {
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
            return;
        }
        long time = System.currentTimeMillis();
        paramManager.printToolInfo();
        String errorMessage = SpectraSTToMSGFInput.convert(paramManager);
        if (errorMessage != null) {
            System.err.println("[Error] " + errorMessage);
            System.out.println();
        } else {
            System.out.format("AnnotatedMgfToMSGFInput complete (total elapsed time: %.2f sec)\n", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f));
        }
    }

    public static String convert(ParamManager paramManager) throws Exception {
        String s;
        File stFile = paramManager.getFile("i");
        File outputFile = paramManager.getFile("o");
        File specFile = paramManager.getFile("s");
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSet();
        BufferedLineReader in = new BufferedLineReader(stFile.getPath());
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        out.println("#SpectrumFile\tSpecIndex\tAnnotation\tProtein\tCharge\tSpectraSTScore");
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\\s+");
            if (token.length == 16) {
                String[] newToken = new String[17];
                for (int i = 0; i < token.length; ++i) {
                    if (i < 2) {
                        newToken[i] = token[i];
                        continue;
                    }
                    if (i > 2) {
                        newToken[i + 1] = token[i];
                        continue;
                    }
                    newToken[2] = token[2].substring(0, token[2].lastIndexOf(47) + 2);
                    newToken[3] = token[2].substring(token[2].lastIndexOf(47) + 2);
                }
                token = newToken;
            }
            if (token.length != 17) continue;
            String specIndex = token[0];
            String annotationStr = token[2].substring(0, token[2].lastIndexOf(47));
            StringBuffer buf = new StringBuffer();
            int startIndex = 0;
            if (annotationStr.startsWith("n[43]")) {
                buf.append("+42");
                startIndex = 5;
            }
            char prevAA = '\u0000';
            for (int i = startIndex; i < annotationStr.length(); ++i) {
                char c = annotationStr.charAt(i);
                if (Character.isUpperCase(c)) {
                    buf.append(c);
                } else if (c == '[') {
                    int residueMass;
                    StringBuffer massBuf = new StringBuffer();
                    while (annotationStr.charAt(++i) != ']') {
                        massBuf.append(annotationStr.charAt(i));
                    }
                    int mass = Integer.parseInt(massBuf.toString());
                    int delMass = mass - (residueMass = aaSet.getAminoAcid(prevAA).getNominalMass());
                    if (delMass > 0) {
                        buf.append("+");
                    }
                    buf.append(delMass);
                }
                prevAA = c;
            }
            int charge = Integer.parseInt(token[2].substring(token[2].lastIndexOf(47) + 1));
            float spectraSTScore = Float.parseFloat(token[11]);
            String protein = token[16];
            out.println(specFile.getName() + "\t" + specIndex + "\t." + buf.toString() + ".\t" + protein + "\t" + charge + "\t" + spectraSTScore);
        }
        in.close();
        out.close();
        return null;
    }
}

