/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class SwedCAD {
    public static void main(String[] argv) throws Exception {
        SwedCAD.makeAnnotatedMgf();
    }

    public static void simulateError() throws Exception {
        Tolerance[] fragTolerance = new Tolerance[]{new Tolerance(50.0f, true), new Tolerance(30.0f, true), new Tolerance(10.0f, true)};
        String[] paramStr = new String[]{"50ppm", "30ppm", "10ppm"};
        for (int i = 0; i < fragTolerance.length; ++i) {
            Tolerance tol = fragTolerance[i];
            String specFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedCAD_" + tol.toString() + ".mgf";
            String scoreParamFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/ionstat_FT_" + paramStr[i] + ".txt";
            System.out.println("#" + tol);
        }
    }

    public static void introduceError(Tolerance fragTolerance, Tolerance pmTolerance) throws Exception {
        String specFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedCADAnnotated.mgf";
        SpectraIterator itr = new SpectraIterator(specFileName, (SpectrumParser)new MgfSpectrumParser());
        String outputFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedCAD_" + fragTolerance.toString();
        if (pmTolerance != null) {
            outputFileName = outputFileName + "_" + pmTolerance.toString();
        }
        outputFileName = outputFileName + ".mgf";
        SpectraContainer container = new SpectraContainer();
        Random rand = new Random();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            Peptide annotation = spec.getAnnotation();
            float theoPM = annotation.getParentMass();
            if (pmTolerance != null) {
                float newPM = SwedCAD.getMassWithError(theoPM, pmTolerance, rand);
                float precursorMz = newPM / (float)spec.getCharge() + 1.008665f;
                spec.getPrecursorPeak().setMz(precursorMz);
            }
            for (Peak p : spec) {
                float mz = p.getMz();
                float newMz = SwedCAD.getMassWithError(mz, fragTolerance, rand);
                p.setMz(newMz);
            }
            container.add(spec);
        }
        container.outputMgfFile(outputFileName);
        System.out.println(outputFileName);
    }

    private static float getMassWithError(float mass, Tolerance tol, Random rand) {
        double coeff;
        while ((coeff = rand.nextGaussian()) > 1.0 || coeff < -1.0) {
        }
        float newMass = mass + (float)coeff * tol.getToleranceAsDa(mass);
        return newMass;
    }

    public static void getBasicStats() {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSet();
        String specFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedCADAnnotated.mgf";
        SpectraIterator itr = null;
        try {
            itr = new SpectraIterator(specFileName, (SpectrumParser)new MgfSpectrumParser());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Histogram<Integer> hist = new Histogram<Integer>();
        Histogram<Integer> lengthHist = new Histogram<Integer>();
        HashSet<String> pepSet = new HashSet<String>();
        int numTryptic = 0;
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            Peptide annotation = spec.getAnnotation();
            if (annotation.hasTrypticCTerm()) {
                ++numTryptic;
            }
            pepSet.add(annotation.toString());
            lengthHist.add(annotation.size());
            float errorPPM = (spec.getPrecursorMass() - annotation.getParentMass()) / annotation.getParentMass() * 1000000.0f;
            int intErrorPPM = Math.round(errorPPM * 10.0f);
            hist.add(intErrorPPM);
        }
        System.out.println("Error");
        hist.printSorted();
        System.out.println("\nLength");
        lengthHist.printSorted();
        System.out.println("\nNumPeptides: " + pepSet.size());
        System.out.println("\nNumTrypticPeptides: " + numTryptic);
    }

    public static void makeAnnotatedMgf() {
        String s;
        String mgfOutputFileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedCADAnnotated.mgf";
        mgfOutputFileName = System.getProperty("user.home") + "/Research/Data/SwedECD/swedECDAnnotated.mgf";
        SpectraContainer container = new SpectraContainer();
        String fileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/all.txt";
        fileName = System.getProperty("user.home") + "/Research/Data/SwedECD/ECD.txt";
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSet();
        ArrayList spec = null;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\\s+");
            if (token.length == 3) {
                String annotationStr = token[0];
                float parentMass = Float.parseFloat(token[1]);
                int charge = Integer.parseInt(token[2]);
                spec = new Spectrum(parentMass / (float)charge + 1.008665f, charge, 0.0f);
                Peptide annotation = new Peptide(annotationStr, aaSet);
                ((Spectrum)spec).setAnnotation(annotation);
                continue;
            }
            if (token.length == 2) {
                assert (spec != null);
                spec.add(new Peak(Float.parseFloat(token[0]), Float.parseFloat(token[1]), 1));
                continue;
            }
            if (!s.equalsIgnoreCase("<")) continue;
            assert (spec != null);
            container.add(spec);
        }
        container.outputMgfFile(mgfOutputFileName);
        System.out.println(container.size() + " spectra are converted.");
    }
}

