/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.misc.ExceptionCapturer;
import edu.ucsd.msjava.misc.ProgressData;
import edu.ucsd.msjava.misc.ProgressReporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorWithExceptions
extends ThreadPoolExecutor {
    private Throwable thrownData = null;
    private boolean hasThrownData = false;
    private String taskName;
    private String progressTitle = "Progress";
    private long startTime;
    private final ScheduledExecutorService statusExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Runnable progressReportRunnable = new Runnable(){

        @Override
        public void run() {
            ThreadPoolExecutorWithExceptions.this.outputProgressReport();
        }
    };
    private ScheduledFuture<?> currentProgressReportFuture;
    private int progressReportDelayNextChangeMinutes = 0;
    private final List<ProgressData> progressObjects;

    public static ThreadPoolExecutorWithExceptions newFixedThreadPool(int nThreads) {
        return new ThreadPoolExecutorWithExceptions(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutorWithExceptions newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolExecutorWithExceptions(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    private ThreadPoolExecutorWithExceptions(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory());
        this.progressObjects = Collections.synchronizedList(new ArrayList(maximumPoolSize));
        this.startTime = -1L;
    }

    private ThreadPoolExecutorWithExceptions(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.progressObjects = Collections.synchronizedList(new ArrayList(maximumPoolSize));
        this.startTime = -1L;
    }

    @Override
    public void execute(Runnable command) {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
            if (this.currentProgressReportFuture == null) {
                this.currentProgressReportFuture = this.statusExecutor.scheduleAtFixedRate(this.progressReportRunnable, 1L, 1L, TimeUnit.MINUTES);
            }
        }
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ExceptionCapturer exCap;
        super.afterExecute(r, t);
        if (r instanceof ProgressReporter) {
            ProgressReporter reporter = (ProgressReporter)((Object)r);
            this.progressObjects.remove(reporter.getProgressData());
        }
        if (r instanceof ExceptionCapturer && t == null && (exCap = (ExceptionCapturer)((Object)r)).hasException()) {
            System.out.println("Killing threadpool...");
            t = exCap.getException();
        }
        if (t != null && this.thrownData == null) {
            this.thrownData = t;
            this.hasThrownData = true;
            this.shutdownNow();
            return;
        }
        if (t == null) {
            this.statusExecutor.schedule(this.progressReportRunnable, 10L, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (r instanceof ProgressReporter) {
            ProgressReporter reporter = (ProgressReporter)((Object)r);
            reporter.setProgressData(new ProgressData());
            this.progressObjects.add(reporter.getProgressData());
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = false;
        InterruptedException except = null;
        try {
            result = super.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            except = e;
        }
        this.currentProgressReportFuture.cancel(true);
        this.statusExecutor.shutdown();
        if (except != null) {
            throw except;
        }
        return result;
    }

    public boolean awaitTerminationWithExceptions(long timeout, TimeUnit unit) throws Throwable {
        boolean result = false;
        InterruptedException interrupted = null;
        try {
            result = this.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            interrupted = e;
        }
        if (this.hasThrownData) {
            throw this.thrownData;
        }
        if (interrupted != null) {
            throw interrupted;
        }
        return result;
    }

    public boolean HasThrownData() {
        return this.hasThrownData;
    }

    public Throwable getThrownData() {
        return this.thrownData;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
        this.progressTitle = taskName + " progress";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProgressAdjustment() {
        double count = 0.0;
        double progressSum = 0.0;
        List<ProgressData> list = this.progressObjects;
        synchronized (list) {
            for (ProgressData data : this.progressObjects) {
                count += 1.0;
                progressSum += data.getProgress();
            }
        }
        if (count < 1.0) {
            return 0.0;
        }
        double progress = progressSum / count;
        double weight = count / (double)this.getTaskCount();
        return progress * weight;
    }

    public void outputProgressReport() {
        double completed = this.getCompletedTaskCount();
        double total = this.getTaskCount();
        if (total < 1.0) {
            total = 1.0;
        }
        double progress = completed / total * 100.0;
        double time = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double timeMinutes = time / 60.0;
        String units = "seconds";
        if (time > 3600.0) {
            time /= 3600.0;
            units = "hours";
        } else if (time > 60.0) {
            time /= 60.0;
            units = "minutes";
        }
        double totalProgress = progress + this.getProgressAdjustment();
        System.out.format("%s: %.0f / %.0f tasks, %.2f%%\t\t%.2f %s elapsed%n", this.progressTitle, completed, total, totalProgress, time, units);
        if (timeMinutes >= (double)this.progressReportDelayNextChangeMinutes) {
            this.ChangeProgressReportDelay();
        }
    }

    private void ChangeProgressReportDelay() {
        TimeUnit nextDelayUnits;
        int nextDelayValue;
        switch (this.progressReportDelayNextChangeMinutes) {
            case 0: {
                nextDelayValue = 1;
                nextDelayUnits = TimeUnit.MINUTES;
                this.progressReportDelayNextChangeMinutes = 60;
                break;
            }
            case 60: {
                nextDelayValue = 5;
                nextDelayUnits = TimeUnit.MINUTES;
                this.progressReportDelayNextChangeMinutes = 180;
                break;
            }
            case 180: {
                nextDelayValue = 15;
                nextDelayUnits = TimeUnit.MINUTES;
                this.progressReportDelayNextChangeMinutes = 600;
                break;
            }
            case 600: {
                nextDelayValue = 30;
                nextDelayUnits = TimeUnit.MINUTES;
                this.progressReportDelayNextChangeMinutes = Integer.MAX_VALUE;
                break;
            }
            default: {
                return;
            }
        }
        if (this.currentProgressReportFuture != null) {
            this.currentProgressReportFuture.cancel(false);
        }
        this.currentProgressReportFuture = this.statusExecutor.scheduleAtFixedRate(this.progressReportRunnable, nextDelayValue, nextDelayValue, nextDelayUnits);
    }
}

