/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.AminoAcidGraph;
import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msgf.IntMassFactory;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.NominalMassFactory;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.IonProbability;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.CompositionFactory;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.WindowFilter;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class Zubarev {
    public static void main(String[] argv) throws Exception {
        Zubarev.deconvolutionTest();
    }

    public static void deconvolutionTest() throws Exception {
        for (int charge = 3; charge <= 3; ++charge) {
            System.out.println("Charge: " + charge);
            System.out.println("Before deconvolution");
            Zubarev.deconvolutionTest(charge, false);
            System.out.println("After deconvolution");
            Zubarev.deconvolutionTest(charge, true);
            System.out.println();
        }
    }

    public static void deconvolutionTest(int charge, boolean applyDeconvolution) throws Exception {
        String specFileName = System.getProperty("user.home") + "/Research/Data/Heck_DDDT/AnnotatedSpectra/HCD_HighRes_Tryp.mgf";
        SpectraContainer container = new SpectraContainer();
        SpectraIterator itr = new SpectraIterator(specFileName, (SpectrumParser)new MgfSpectrumParser());
        IonType[] ionTypes = IonType.getAllKnownIonTypes(3, true).toArray(new IonType[0]);
        float toleranceBetweenIsotopes = 0.02f;
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            if (spec.getCharge() != charge) continue;
            if (applyDeconvolution) {
                container.add(spec.getDeconvolutedSpectrum(toleranceBetweenIsotopes));
                continue;
            }
            container.add(spec);
        }
        IonProbability probGen = new IonProbability(container.iterator(), ionTypes, new Tolerance(30.0f, true));
        float[] prob = probGen.getIonProb();
        int i = 0;
        for (IonType ion : ionTypes) {
            if ((double)prob[i] > 0.05) {
                System.out.println(ion.getName() + "\t" + prob[i]);
            }
            ++i;
        }
    }

    public static void filtrationPowerComposition(float tolerancePPM) throws Exception {
        float prob;
        Composition c;
        int compNum2;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        int maxMass = 700;
        float[] filtFactorNM = new float[maxMass + 1];
        filtFactorNM[0] = 1.0f;
        for (int mass = 1; mass < filtFactorNM.length; ++mass) {
            for (AminoAcid aa : aaSet.getAAList(Modification.Location.Anywhere)) {
                int prevMass = mass - aa.getNominalMass();
                if (prevMass < 0) continue;
                int n = mass;
                filtFactorNM[n] = filtFactorNM[n] + filtFactorNM[prevMass] * 0.05f;
            }
        }
        int maxLength = 13;
        Tolerance tolerance = new Tolerance(tolerancePPM, true);
        CompositionFactory factory = new CompositionFactory(aaSet, null, maxLength);
        HashMap<Composition, Float> filtFactor = new HashMap<Composition, Float>();
        filtFactor.put(Composition.NIL, Float.valueOf(1.0f));
        for (int compNum2 : factory.getData()) {
            c = new Composition(compNum2);
            if (c.equals(Composition.NIL)) continue;
            prob = 0.0f;
            for (AminoAcid aa : aaSet.getAAList(Modification.Location.Anywhere)) {
                Float prevProb;
                Composition aaComp = aa.getComposition();
                Composition prevComp = c.getSubtraction(aaComp);
                if (prevComp == null || (prevProb = (Float)filtFactor.get(prevComp)) == null) continue;
                prob += prevProb.floatValue() * 0.05f;
            }
            filtFactor.put(c, Float.valueOf(prob));
        }
        System.out.println("Mass\tFiltrationFactor");
        int[] nArray = factory.getData();
        int n = nArray.length;
        for (int i = 0; i < n && !((c = new Composition(compNum2 = nArray[i])).getMass() > 700.0f); ++i) {
            prob = 0.0f;
            for (Composition neighbor : factory.getNodes(c.getMass(), tolerance)) {
                prob += ((Float)filtFactor.get(neighbor)).floatValue();
            }
            System.out.println(c.getMass() + "\t" + filtFactorNM[c.getNominalMass()] + "\t" + prob);
        }
    }

    public static void filtrationPowerNominalMass() throws Exception {
        int mass;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        int maxMass = 700;
        float[] filtFactor = new float[maxMass + 1];
        filtFactor[0] = 1.0f;
        for (mass = 1; mass < filtFactor.length; ++mass) {
            for (AminoAcid aa : aaSet.getAAList(Modification.Location.Anywhere)) {
                int prevMass = mass - aa.getNominalMass();
                if (prevMass < 0) continue;
                int n = mass;
                filtFactor[n] = filtFactor[n] + filtFactor[prevMass] * 0.05f;
            }
        }
        System.out.println("Mass\tFiltrationFactor");
        for (mass = 0; mass < filtFactor.length; ++mass) {
            System.out.println(NominalMass.getMassFromNominalMass(mass) + "\t" + filtFactor[mass]);
        }
    }

    public static void testRandomPeakProb() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        fileName = System.getProperty("user.home") + "/Research/Data/HeckRevision/AnnotatedSpectra/CID_Tryp_Confident.mgf";
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        float sumPeakRatio = 0.0f;
        int numSpecs = 0;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            spec = new WindowFilter(10, 50.0f).apply(spec);
            ++numSpecs;
            boolean[] booleanSpec = new boolean[spec.getAnnotation().getNominalMass() + 1];
            booleanSpec[0] = true;
            booleanSpec[booleanSpec.length - 1] = true;
            int numPeaks = 0;
            for (Peak p : spec) {
                int mz = NominalMass.toNominalMass(p.getMz());
                if (mz < 0 || mz >= booleanSpec.length || booleanSpec[mz]) continue;
                ++numPeaks;
                booleanSpec[mz] = true;
            }
            int numPairs = 0;
            int[] numReal = new int[4];
            for (int i = 1; i < booleanSpec.length; ++i) {
                for (AminoAcid aa : aaSet) {
                    int aaMass = aa.getNominalMass();
                    int prevMass = i - aaMass;
                    if (prevMass < 0) continue;
                    ++numPairs;
                    if (booleanSpec[i]) {
                        if (booleanSpec[prevMass]) {
                            numReal[3] = numReal[3] + 1;
                            continue;
                        }
                        numReal[1] = numReal[1] + 1;
                        continue;
                    }
                    if (booleanSpec[prevMass]) {
                        numReal[2] = numReal[2] + 1;
                        continue;
                    }
                    numReal[0] = numReal[0] + 1;
                }
            }
            System.out.println(spec.size() + " " + numPeaks + " " + spec.getPrecursorMass());
            float peakRatio = (float)numPeaks / (float)booleanSpec.length;
            System.out.print((float)numReal[0] / (float)numPairs + "," + (1.0f - peakRatio) * (1.0f - peakRatio));
            System.out.print("\t" + (float)numReal[1] / (float)numPairs + "," + (1.0f - peakRatio) * peakRatio);
            System.out.print("\t" + (float)numReal[2] / (float)numPairs + "," + peakRatio * (1.0f - peakRatio));
            System.out.print("\t" + (float)numReal[3] / (float)numPairs + "," + peakRatio * peakRatio);
            System.out.println();
            int sum = numReal[0] + numReal[1] + numReal[2] + numReal[3];
            assert (sum == numPairs) : sum + "!=" + numPairs;
            sumPeakRatio += peakRatio;
        }
        System.out.println("Average\t" + sumPeakRatio / (float)numSpecs);
    }

    public static void testEdgeScoresRandom() throws Exception {
        float[] nominalMass = new float[200];
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        for (AminoAcid aa : aaSet) {
            nominalMass[aa.getNominalMass()] = aa.getMass();
        }
        Histogram<Integer> errHist = new Histogram<Integer>();
        AminoAcid aaQ = aaSet.getAminoAcid('Q');
        AminoAcid aaK = aaSet.getAminoAcid('K');
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numPairs = 0;
        HashSet<String> pepSet = new HashSet<String>();
        while (itr.hasNext()) {
            int i;
            Spectrum spec = itr.next();
            Peptide peptide = spec.getAnnotation();
            if (pepSet.contains(peptide.toString())) continue;
            pepSet.add(peptide.toString());
            boolean[] nominalBY = new boolean[10000];
            int nominalB = 1;
            int nominalY = 19;
            for (i = 0; i < peptide.size() - 1; ++i) {
                nominalBY[nominalB += peptide.get((int)i).getNominalMass()] = true;
                nominalBY[nominalY += peptide.get((int)(peptide.size() - 1 - i)).getNominalMass()] = true;
            }
            block3: for (i = 0; i < spec.size() - 1; ++i) {
                Peak p1 = (Peak)spec.get(i);
                float p1Mass = p1.getMz();
                int nominalP1 = NominalMass.toNominalMass(p1.getMz());
                if (nominalBY[nominalP1]) continue;
                for (int j = i + 1; j < spec.size(); ++j) {
                    Peak p2 = (Peak)spec.get(j);
                    float p2Mass = p2.getMz();
                    int nominalP2 = NominalMass.toNominalMass(p2.getMz());
                    if (nominalBY[nominalP2]) continue;
                    int nominalDiff = nominalP2 - nominalP1;
                    assert (nominalDiff >= 0);
                    if (nominalDiff > 186) continue block3;
                    if (nominalMass[nominalDiff] == 0.0f) continue;
                    ++numPairs;
                    float diff = p2Mass - p1Mass;
                    float aaMass = nominalMass[nominalDiff];
                    if (nominalDiff == 128) {
                        aaMass = Math.abs(diff - aaQ.getMass()) > Math.abs(diff - aaK.getMass()) ? aaK.getMass() : aaQ.getMass();
                    }
                    float err = diff - aaMass;
                    errHist.add(Math.round(err * 100.0f));
                }
            }
        }
        System.out.println("NumPairs: " + numPairs);
        errHist.printSortedRatio();
    }

    public static void testEdgeScoresNominalMass() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        int scalingFactor = 100;
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numYY = 0;
        int numNY = 0;
        int numYN = 0;
        int numNN = 0;
        int numY = 0;
        int numB = 0;
        int numBY = 0;
        int numNo = 0;
        int numSpecs = 0;
        int numCorrectLength3Tags = 0;
        float rescalingConstant = 0.999497f;
        Histogram<Integer> yHist = new Histogram<Integer>();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            Peptide peptide = spec.getAnnotation();
            if (Math.abs(spec.getPrecursorMass() - 18.010565f - peptide.getMass()) > 0.5f) continue;
            ++numSpecs;
            int intSRM = 0;
            int intPeptideMass = 0;
            for (int i = 0; i < peptide.size(); ++i) {
                intPeptideMass += Math.round(peptide.get(i).getMass() * rescalingConstant);
            }
            float[] b = new float[peptide.size() + 1];
            float[] y = new float[peptide.size() + 1];
            b[0] = IonType.B.getOffset();
            y[0] = IonType.Y.getOffset();
            for (int i = 0; i < peptide.size() - 1; ++i) {
                int byPresence = 0;
                float yMass = IonType.Y.getMz((float)(intSRM += Math.round(peptide.get(peptide.size() - 1 - i).getMass() * rescalingConstant)) / rescalingConstant);
                Peak p = spec.getPeakByMass(yMass, new Tolerance(0.5f));
                if (p != null) {
                    y[i + 1] = p.getMz();
                    byPresence += 2;
                } else {
                    y[i + 1] = -1.0f;
                }
                int intPRM = intPeptideMass - intSRM;
                float bMass = IonType.B.getMz((float)intPRM / rescalingConstant);
                p = spec.getPeakByMass(bMass, new Tolerance(0.5f));
                if (p != null) {
                    b[peptide.size() - (i + 1)] = p.getMz();
                    ++byPresence;
                } else {
                    b[peptide.size() - (i + 1)] = -1.0f;
                }
                if (byPresence == 1) {
                    y[i + 1] = spec.getPrecursorMass() + 2.01565f - b[peptide.size() - (i + 1)];
                }
                if (byPresence == 3) {
                    ++numBY;
                    continue;
                }
                if (byPresence == 2) {
                    ++numY;
                    continue;
                }
                if (byPresence == 1) {
                    ++numB;
                    continue;
                }
                ++numNo;
            }
            assert ((intSRM += Math.round(peptide.get(0).getMass() * 0.999497f)) == intPeptideMass) : peptide + ": " + intSRM + " != " + intPeptideMass + " " + (spec.getPrecursorMass() - 18.010565f);
            b[peptide.size()] = spec.getPrecursorMass() - 18.010565f + (float)Composition.ChargeCarrierMass();
            y[peptide.size()] = spec.getPrecursorMass() + (float)Composition.ChargeCarrierMass();
            boolean useY = true;
            float[] mainIon = useY ? y : b;
            for (int i = 1; i <= peptide.size(); ++i) {
                if (mainIon[i] >= 0.0f) {
                    if (mainIon[i - 1] >= 0.0f) {
                        ++numYY;
                        AminoAcid aa = useY ? peptide.get(peptide.size() - i) : peptide.get(i - 1);
                        float expMass = mainIon[i] - mainIon[i - 1];
                        float theoMass = aa.getMass();
                        float diff = expMass - theoMass;
                        yHist.add(Math.round(diff * (float)scalingFactor));
                        continue;
                    }
                    ++numNY;
                    continue;
                }
                if (mainIon[i - 1] >= 0.0f) {
                    ++numYN;
                    continue;
                }
                ++numNN;
            }
            boolean tagCorrect = false;
            for (int i = 3; i <= peptide.size() && mainIon[i] >= 0.0f; ++i) {
                int j = 1;
                if (j > 3 || !(mainIon[i - j] >= 0.0f)) continue;
                AminoAcid aa = useY ? peptide.get(peptide.size() - 1 - (i - j)) : peptide.get(i - j);
                float expMass = mainIon[i - j + 1] - mainIon[i - j];
                float theoMass = aa.getMass();
                float diff = expMass - theoMass;
                tagCorrect = true;
            }
            if (!tagCorrect) continue;
            ++numCorrectLength3Tags;
        }
        int sum = numYY + numYN + numNY + numNN;
        System.out.println("NumYY: " + numYY + " " + (float)numYY / (float)sum);
        System.out.println("NumYN: " + numYN + " " + (float)numYN / (float)sum);
        System.out.println("NumNY: " + numNY + " " + (float)numNY / (float)sum);
        System.out.println("NumNN: " + numNN + " " + (float)numNN / (float)sum);
        System.out.println();
        int sum2 = numBY + numY + numB + numNo;
        System.out.println("NumBothBY: " + numBY + " " + (float)numBY / (float)sum2);
        System.out.println("NumYOnly: " + numY + " " + (float)numY / (float)sum2);
        System.out.println("NumBOnly: " + numB + " " + (float)numB / (float)sum2);
        System.out.println("NumNoBY: " + numNo + " " + (float)numNo / (float)sum2);
        yHist.printSortedRatio();
        System.out.println("CorrectTag: " + (float)numCorrectLength3Tags / (float)numSpecs);
    }

    public static void testEdgeScores() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numYY = 0;
        int numNY = 0;
        int numYN = 0;
        int numNN = 0;
        Histogram<Integer> yHist = new Histogram<Integer>();
        Histogram<Integer> yHistPPM = new Histogram<Integer>();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            spec.setRanksOfPeaks();
            Peptide peptide = spec.getAnnotation();
            double prm = 0.0;
            double srm = 0.0;
            float[] b = new float[peptide.size() + 1];
            float[] y = new float[peptide.size() + 1];
            b[0] = IonType.B.getOffset();
            y[0] = IonType.Y.getOffset();
            for (int i = 0; i < peptide.size() - 1; ++i) {
                float bMass = IonType.B.getMz((float)(prm += peptide.get(i).getAccurateMass()));
                Peak p = spec.getPeakByMass(bMass, new Tolerance(0.5f));
                b[i + 1] = p != null ? p.getMz() : -1.0f;
                float yMass = IonType.Y.getMz((float)(srm += peptide.get(peptide.size() - 1 - i).getAccurateMass()));
                p = spec.getPeakByMass(yMass, new Tolerance(0.5f));
                y[i + 1] = p != null ? p.getMz() : -1.0f;
            }
            b[peptide.size()] = IonType.B.getMz((float)(srm += peptide.get(0).getAccurateMass()));
            y[peptide.size()] = IonType.Y.getMz((float)srm);
            boolean useY = false;
            float[] mainIon = useY ? y : b;
            for (int i = 1; i < peptide.size(); ++i) {
                if (mainIon[i] >= 0.0f) {
                    if (mainIon[i - 1] >= 0.0f) {
                        ++numYY;
                        AminoAcid aa = useY ? peptide.get(peptide.size() - i) : peptide.get(i - 1);
                        float expMass = mainIon[i] - mainIon[i - 1];
                        float theoMass = aa.getMass();
                        float diff = expMass - theoMass;
                        float diffPPM = diff * 1000000.0f / ((mainIon[i] + mainIon[i - 1]) / 2.0f);
                        if (Math.abs(diff) > 0.4f) continue;
                        yHist.add(Math.round(diff * 100.0f));
                        yHistPPM.add(Math.round(diffPPM / 10.0f));
                        continue;
                    }
                    ++numNY;
                    continue;
                }
                if (mainIon[i - 1] >= 0.0f) {
                    ++numYN;
                    continue;
                }
                ++numNN;
            }
        }
        System.out.println("NumYY: " + numYY);
        System.out.println("NumYN: " + numYN);
        System.out.println("NumNY: " + numNY);
        System.out.println("NumNN: " + numNN);
        yHist.printSortedRatio();
    }

    public static void paramTest() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/Zubarev/SACTest/SACTest_Decoy.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            String annotation = token[5];
            String pep = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
            float pepMass = aaSet.getPeptide(pep).getMass();
            float specPepMass = (Float.parseFloat(token[2]) - 1.007825f) * (float)Integer.parseInt(token[4]) - 18.010565f;
            if (!((double)Math.abs(specPepMass - pepMass) > 0.5)) continue;
            System.out.println(pepMass + " != " + specPepMass);
        }
    }

    public static void countTryptic() throws Exception {
        String s;
        Enzyme trypsin = Enzyme.TRYPSIN;
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/MSGFDB_HCD_Target_MSGFNM.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        float threshold = 8.363478E-10f;
        threshold = 6.115349E-10f;
        in.readLine();
        int numSpec = 0;
        int numTrypN = 0;
        int numTrypC = 0;
        int numNonTryptic = 0;
        int numSemiTryptic = 0;
        int numFullTryptic = 0;
        while ((s = in.readLine()) != null) {
            float specProb;
            String[] token = s.split("\t");
            if (token.length < 10 || (specProb = Float.parseFloat(token[12])) > threshold) continue;
            ++numSpec;
            String annotation = token[5];
            char nTermChar = annotation.charAt(0);
            boolean isNTermTryp = false;
            if (nTermChar == 'K' || nTermChar == 'R' || nTermChar == '_') {
                ++numTrypN;
                isNTermTryp = true;
            }
            boolean isCTermTryp = false;
            char cTermChar = annotation.charAt(annotation.lastIndexOf(46) - 1);
            if (cTermChar == 'K' || cTermChar == 'R') {
                ++numTrypC;
                isCTermTryp = true;
            }
            if (isNTermTryp && isCTermTryp) {
                ++numFullTryptic;
                continue;
            }
            if (isNTermTryp || isCTermTryp) {
                ++numSemiTryptic;
                continue;
            }
            ++numNonTryptic;
        }
        System.out.println("NumSpec\t" + numSpec);
        System.out.println("NTerm\t" + (float)numTrypN / (float)numSpec);
        System.out.println("CTerm\t" + (float)numTrypC / (float)numSpec);
        System.out.println("FullTryp\t" + (float)numFullTryptic / (float)numSpec);
        System.out.println("SemiTryp\t" + (float)numSemiTryptic / (float)numSpec);
        System.out.println("NonTryp\t" + (float)numNonTryptic / (float)numSpec);
    }

    public static void compareGraphSize() throws Exception {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        float rescalingFactor = 274.3352f;
        Tolerance pmTolerance = new Tolerance(30.0f, true);
        Enzyme enzyme = Enzyme.TRYPSIN;
        int maxLength = 20;
        float numPeptides = 1.0f;
        System.out.println("Length\tIntMass\tComposition");
        for (int length = 20; length <= 20; ++length) {
            NominalMassFactory intMassFactoryNominalMass = new NominalMassFactory(aaSet, enzyme, length);
            IntMassFactory intMassFactory = new IntMassFactory(aaSet, enzyme, length, rescalingFactor);
            CompositionFactory compFactory = new CompositionFactory(aaSet, enzyme, length);
            numPeptides = (float)((double)numPeptides + Math.pow(20.0, length));
            System.out.println(length + "\t" + intMassFactoryNominalMass.size() + "\t" + intMassFactory.size() + "\t" + compFactory.size() + "\t" + numPeptides);
        }
    }

    public static void rescalingTest() throws Exception {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        for (AminoAcid aa : aaSet) {
            double rescaled = aa.getAccurateMass() * (double)0.999497f;
            System.out.println(aa.getResidueStr() + "\t" + aa.getAccurateMass() + "\t" + rescaled + "\t" + ((double)aa.getNominalMass() - rescaled));
        }
    }

    public static void errorTest() throws Exception {
        float constant;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        float bestConstant = constant = 260.0f;
        float bestMaxError = Float.MAX_VALUE;
        bestConstant = 274.3352f;
        System.out.println(bestConstant);
        for (AminoAcid aa : aaSet) {
            int nominalMass = Math.round(aa.getMass() * bestConstant);
            float mass = aa.getMass();
            float err = mass - (float)nominalMass / bestConstant;
            float ppmErr = err / mass * 1000000.0f;
            System.out.println(aa.getResidueStr() + " " + mass + " " + (float)nominalMass / bestConstant + " " + err + " " + ppmErr + " " + nominalMass);
        }
    }

    public static void isMascotTwoPassSearch2() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/Zubarev/Mascot_HCD_PTM/Mascot_HCD_PTM_Target.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        HashSet<String> allProt = new HashSet<String>();
        HashSet<String> protNoPTM = new HashSet<String>();
        HashSet<String> protWithPTM = new HashSet<String>();
        int numNoPTM = 0;
        int numWithPTM = 0;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            String annotation = token[2];
            String protein = token[4].substring(0, token[4].indexOf(58));
            int sIndex = token[4].indexOf(58, token[4].indexOf(58) + 1);
            int eIndex = token[4].indexOf(58, sIndex + 1);
            int matchedPosition = Integer.parseInt(token[4].substring(sIndex + 1, eIndex));
            allProt.add(protein);
            String peptide = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
            if (peptide.equals(peptide.toUpperCase())) {
                ++numNoPTM;
                protNoPTM.add(protein);
                continue;
            }
            ++numWithPTM;
            protWithPTM.add(protein);
        }
        int numProtWithPTM = 0;
        for (String prot : protWithPTM) {
            if (protNoPTM.contains(prot)) continue;
            ++numProtWithPTM;
            System.out.println(prot);
        }
        int numProtWithNoPTM = 0;
        for (String prot : protNoPTM) {
            if (protWithPTM.contains(prot)) continue;
            ++numProtWithNoPTM;
        }
        System.out.println("NumProt: " + allProt.size());
        System.out.println("NumProtWithExclusivePTM: " + numProtWithPTM);
        System.out.println("NumProtWithExclusiveNoPTM: " + numProtWithNoPTM);
        System.out.println("NumNoPTM: " + numNoPTM);
        System.out.println("NumPTM: " + numWithPTM);
    }

    public static void isMascotTwoPassSearch() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/Zubarev/Mascot/Zubarev_HCD_Target.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        HashSet<String> allProt = new HashSet<String>();
        HashSet<String> protTryptic = new HashSet<String>();
        HashSet<String> protSemiTryptic = new HashSet<String>();
        int numTryptic = 0;
        int numSemiTryptic = 0;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            String annotation = token[2];
            String protein = token[4].substring(0, token[4].indexOf(58));
            int sIndex = token[4].indexOf(58, token[4].indexOf(58) + 1);
            int eIndex = token[4].indexOf(58, sIndex + 1);
            int matchedPosition = Integer.parseInt(token[4].substring(sIndex + 1, eIndex));
            allProt.add(protein);
            boolean isNTermTryptic = false;
            char nTerm = annotation.charAt(0);
            if (nTerm == 'K' || nTerm == 'R' || nTerm == '-' || nTerm == 'M' && matchedPosition == 2) {
                isNTermTryptic = true;
            }
            char cTerm = annotation.charAt(annotation.length() - 3);
            boolean isCTermTryptic = false;
            if (cTerm == 'K' || cTerm == 'R' || annotation.charAt(annotation.length() - 1) == '-') {
                isCTermTryptic = true;
            }
            if (isNTermTryptic && isCTermTryptic) {
                protTryptic.add(protein);
                ++numTryptic;
                continue;
            }
            protSemiTryptic.add(protein);
            ++numSemiTryptic;
        }
        int numProtWithSemiTryptic = 0;
        for (String prot : protSemiTryptic) {
            if (protTryptic.contains(prot)) continue;
            ++numProtWithSemiTryptic;
            System.out.println(prot);
        }
        int numProtWithTryptic = 0;
        for (String prot : protTryptic) {
            if (protSemiTryptic.contains(prot)) continue;
            ++numProtWithTryptic;
        }
        System.out.println("NumProt: " + allProt.size());
        System.out.println("NumProtWithExclusiveSemiTryptic: " + numProtWithSemiTryptic);
        System.out.println("NumProtWithExclusiveFullTryptic: " + numProtWithTryptic);
        System.out.println("NumTryptic: " + numTryptic);
        System.out.println("NumSemiTryptic: " + numSemiTryptic);
    }

    public static void countNTT() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/Zubarev/Mascot/Zubarev_HCD_Target.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        int numSpec = 0;
        int numFT = 0;
        int numSTN = 0;
        int numSTC = 0;
        int numNT = 0;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length < 5) continue;
            String annotation = token[2];
            boolean isNTermTryptic = false;
            char nTerm = annotation.charAt(0);
            if (nTerm == 'K' || nTerm == 'R' || nTerm == '-') {
                isNTermTryptic = true;
            }
            char cTerm = annotation.charAt(annotation.length() - 3);
            boolean isCTermTryptic = false;
            if (cTerm == 'K' || cTerm == 'R') {
                isCTermTryptic = true;
            }
            ++numSpec;
            if (isNTermTryptic && isCTermTryptic) {
                ++numFT;
                continue;
            }
            if (!isNTermTryptic && isCTermTryptic) {
                ++numSTN;
                continue;
            }
            if (isNTermTryptic && !isCTermTryptic) {
                ++numSTC;
                continue;
            }
            ++numNT;
        }
        System.out.println("NumFT\t" + (float)numFT / (float)numSpec);
        System.out.println("NumSTN\t" + (float)numSTN / (float)numSpec);
        System.out.println("NumSTC\t" + (float)numSTC / (float)numSpec);
        System.out.println("NumNT\t" + (float)numNT / (float)numSpec);
    }

    public static void testDBSearch() throws Exception {
        float precursorMass = 413.3487f;
        int charge = 2;
        float peptideMass = (precursorMass - (float)Composition.ChargeCarrierMass()) * (float)charge - 18.010565f;
        File databaseFile = new File("/home/sangtaekim/Research/Data/IPI/IPI_human_3.79.fasta");
        SuffixArray sa = new SuffixArray(new SuffixArraySequence(databaseFile.getPath()));
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        Tolerance tolerance = new Tolerance(30.0f, true);
        System.out.println(sa.getNumCandidatePeptides(aaSet, peptideMass, tolerance));
    }

    public static void summarizeAnnotatedSpec() throws Exception {
        String specFileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        SpectraIterator itr = new SpectraIterator(specFileName, (SpectrumParser)new MgfSpectrumParser());
        Histogram<Integer> massDiffHist = new Histogram<Integer>();
        Histogram fmDiffHist = new Histogram();
        int numC12 = 0;
        int numC13 = 0;
        int numC14 = 0;
        int numSpec = 0;
        int numBIons = 0;
        int numYIons = 0;
        int numObservedBIons = 0;
        int numObservedBIonsBySpecMass = 0;
        int numObservedYIons = 0;
        int numObservedYIonsIntMass = 0;
        int numObservedBIonsIntMass = 0;
        int numObserbedBIonsIntMassIntPM = 0;
        Tolerance fragTolerance = new Tolerance(30.0f, true);
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        Enzyme enzyme = Enzyme.TRYPSIN;
        int maxLength = 50;
        IntMassFactory factory = new IntMassFactory(aaSet, enzyme, maxLength, 274.3352f);
        int numFT = 0;
        int numNT = 0;
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            ++numSpec;
            Peptide pep = spec.getAnnotation();
            if (enzyme.isCleaved(pep)) {
                ++numFT;
            } else {
                ++numNT;
            }
            float theoPepMass = pep.getMass();
            float specPepMass = spec.getPrecursorMass() - 18.010565f;
            int diff = Math.round(specPepMass - theoPepMass);
            if (diff == 1) {
                specPepMass -= 1.0033548f;
                ++numC13;
            } else if (diff == 2) {
                specPepMass -= 2.0067096f;
                ++numC14;
            } else {
                ++numC12;
            }
            float massDiffPPM = (specPepMass - theoPepMass) / theoPepMass * 1000000.0f;
            int intMassDiffPPM = Math.round(massDiffPPM);
            massDiffHist.add(intMassDiffPPM);
            Spectrum filteredSpec = new WindowFilter(6, 50.0f).apply(spec);
            double prm = 0.0;
            double srm = 0.0;
            int srmIndex = 0;
            int pmIndex = factory.getMassIndex(spec.getPrecursorMass() - 18.010565f);
            for (int i = pep.size() - 1; i >= 0; --i) {
                prm += pep.get(pep.size() - 1 - i).getAccurateMass();
                double prmByPM = (double)specPepMass - (srm += pep.get(i).getAccurateMass());
                float srm2 = factory.getMassFromIndex(srmIndex += factory.getMassIndex(pep.get(i).getMass()));
                float prm2 = specPepMass - srm2;
                float prm3 = factory.getMassFromIndex(pmIndex - srmIndex);
                ++numYIons;
                if (filteredSpec.getPeakByMass((float)(srm + Composition.OffsetY()), fragTolerance) != null) {
                    ++numObservedYIons;
                }
                if (filteredSpec.getPeakByMass((float)((double)srm2 + Composition.OffsetY()), fragTolerance) != null) {
                    ++numObservedYIonsIntMass;
                }
                ++numBIons;
                if (filteredSpec.getPeakByMass((float)(prm + Composition.OffsetB()), fragTolerance) != null) {
                    ++numObservedBIons;
                }
                if (filteredSpec.getPeakByMass((float)(prmByPM + Composition.OffsetB()), fragTolerance) != null) {
                    ++numObservedBIonsBySpecMass;
                }
                if (filteredSpec.getPeakByMass((float)((double)prm2 + Composition.OffsetB()), fragTolerance) != null) {
                    ++numObservedBIonsIntMass;
                }
                if (filteredSpec.getPeakByMass((float)((double)prm3 + Composition.OffsetB()), fragTolerance) == null) continue;
                ++numObserbedBIonsIntMassIntPM;
            }
        }
        System.out.println("NumSpec: " + numSpec);
        fmDiffHist.printSortedRatio();
        System.out.println("Y: " + (float)numObservedYIons / (float)numYIons);
        System.out.println("B: " + (float)numObservedBIons / (float)numBIons);
        System.out.println("B_SpecPM: " + (float)numObservedBIonsBySpecMass / (float)numBIons);
        System.out.println("Y_Int: " + (float)numObservedYIonsIntMass / (float)numYIons);
        System.out.println("B_Int: " + (float)numObservedBIonsIntMass / (float)numBIons);
        System.out.println("B_Int_IntPM: " + (float)numObserbedBIonsIntMassIntPM / (float)numBIons);
        System.out.println("Tryptic: " + (float)numFT / (float)numSpec);
    }

    public static void addScanNum() throws Exception {
        String s;
        String specFileName = System.getProperty("user.home") + "/Research/Data/Zubarev/Zubarev_HCD.mgf";
        SpectraIterator itr = new SpectraIterator(specFileName, (SpectrumParser)new MgfSpectrumParser());
        int specNum = -1;
        HashMap<String, Integer> titleSpecNumMap = new HashMap<String, Integer>();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            titleSpecNumMap.put(spec.getTitle(), ++specNum);
        }
        String fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/Mascot/Zubarev_HCD_FDR01.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        String header = in.readLine();
        System.out.println(header + "\tSpecFileName\tSpecNum");
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length != 7) continue;
            String title = token[0];
            specNum = (Integer)titleSpecNumMap.get(title);
            System.out.println(s + "\tZubarev_HCD.mgf\t" + specNum);
        }
        in.close();
    }

    public static void splitHCDETD() throws Exception {
        File dir = new File(System.getProperty("user.home") + "/Research/Data/Zubarev");
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith("mgf") || f.getName().contains("29novpredict")) continue;
            System.out.println(f.getName());
            int numHCD = 0;
            int numETD = 0;
            SpectraIterator itr = new SpectraIterator(f.getPath(), (SpectrumParser)new MgfSpectrumParser());
            String fileName = f.getPath();
            String name = fileName.substring(0, fileName.lastIndexOf(46));
            String hcdFileName = name + "_hcd.mgf";
            String etdFileName = name + "_etd.mgf";
            PrintStream hcdOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(hcdFileName)));
            PrintStream etdOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(etdFileName)));
            while (itr.hasNext()) {
                Spectrum spec = itr.next();
                String title = spec.getTitle();
                if (!title.contains("experiment: 1")) {
                    spec.outputMgf(hcdOut);
                    ++numHCD;
                    continue;
                }
                spec.outputMgf(etdOut);
                ++numETD;
            }
            hcdOut.close();
            etdOut.close();
            System.out.println(numHCD + " HCD and " + numETD + " ETD spectra.");
        }
    }

    @Deprecated
    public static void testTagging() throws Exception {
        int dataset = 0;
        long time = System.currentTimeMillis();
        String fileName = null;
        if (dataset == 0) {
            fileName = System.getProperty("user.home") + "/Research/Data/Zubarev/AnnotatedSpectra/Zubarev_HCD_Annotated.mgf";
        } else if (dataset == 1) {
            fileName = System.getProperty("user.home") + "/Research/Data/HeckRevision/AnnotatedSpectra/CID_Tryp_Confident.mgf";
        } else if (dataset == 2) {
            fileName = System.getProperty("user.home") + "/Research/Data/HeckRevision/AnnotatedSpectra/ETD_Tryp_Confident.mgf";
        }
        int numMaxTags = 50;
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numSpecs = 0;
        int numSpecsWithCorrectTags = 0;
        int sumNumTags = 0;
        NewRankScorer scorer = null;
        if (dataset == 0) {
            scorer = NewScorerFactory.get(ActivationMethod.HCD, Enzyme.TRYPSIN);
        } else if (dataset == 1) {
            scorer = NewScorerFactory.get(ActivationMethod.CID, Enzyme.TRYPSIN);
        } else if (dataset == 2) {
            scorer = NewScorerFactory.get(ActivationMethod.ETD, Enzyme.TRYPSIN);
        }
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        float tagErrTolerance = 0.5f;
        if (dataset == 0) {
            tagErrTolerance = 0.02f;
        }
        Tolerance fragTolerance = new Tolerance(0.5f);
        if (dataset == 0) {
            fragTolerance = new Tolerance(30.0f, true);
        }
        float[] nominalMass = new float[200];
        char[] residue = new char[200];
        int[] intAAMass = new int[18];
        int aaMassIndex = 0;
        IonType[] ion = null;
        if (dataset == 0 || dataset == 1) {
            ion = new IonType[]{IonType.Y, IonType.getIonType("y2"), IonType.B};
        } else if (dataset == 2) {
            ion = new IonType[4];
            ion[0] = IonType.Z;
            ion[1] = IonType.getIonType("z+H");
            ion[2] = IonType.getIonType("z-H");
            ion[1] = IonType.getIonType("y2");
            ion[2] = IonType.B;
        }
        for (AminoAcid aa : aaSet) {
            int normAA = aa.getNominalMass();
            if (nominalMass[normAA] != 0.0f) continue;
            nominalMass[normAA] = aa.getMass();
            residue[normAA] = aa.getResidue();
            intAAMass[aaMassIndex++] = normAA;
        }
        AminoAcid aaQ = aaSet.getAminoAcid('Q');
        AminoAcid aaK = aaSet.getAminoAcid('K');
        NominalMassFactory factory = new NominalMassFactory(aaSet, Enzyme.TRYPSIN, 50);
        block1: while (itr.hasNext()) {
            float mz;
            Spectrum spec = itr.next();
            if ((spec = new WindowFilter(10, 50.0f).apply(spec)).getCharge() != 3) continue;
            Peptide peptide = spec.getAnnotation();
            float expPepMass = spec.getPrecursorMass() - 18.010565f;
            int nomExpPepMass = NominalMass.toNominalMass(expPepMass);
            float[] srm = new float[nomExpPepMass + 1];
            srm[0] = 0.0f;
            srm[nomExpPepMass] = expPepMass;
            float[] intensity = new float[srm.length];
            NewScoredSpectrum<NominalMass> scoredSpec = scorer.getScoredSpectrum(spec);
            ArrayList<NominalMass> nodeList = new ArrayList<NominalMass>();
            for (int i = 0; i <= nomExpPepMass; ++i) {
                nodeList.add(new NominalMass(i));
            }
            AminoAcidGraph graph = new AminoAcidGraph(factory, spec.getPrecursorMass(), scoredSpec);
            intensity[0] = 1000.0f;
            intensity[nomExpPepMass] = 1000.0f;
            ++numSpecs;
            for (Peak p : spec) {
                mz = p.getMz();
                int nomSRM = NominalMass.toNominalMass(mz) - 19;
                if (nomSRM <= 0 || nomSRM >= srm.length || !(p.getIntensity() > intensity[nomSRM])) continue;
                srm[nomSRM] = mz - IonType.Y.getOffset();
                intensity[nomSRM] = p.getIntensity();
            }
            for (Peak p : spec) {
                mz = p.getMz();
                float mass = IonType.getIonType("y2").getMass(mz);
                int nomSRM = NominalMass.toNominalMass(mass);
                if (nomSRM <= 0 || nomSRM >= srm.length || intensity[nomSRM] != 0.0f || !(p.getIntensity() > intensity[nomSRM])) continue;
                srm[nomSRM] = mass;
                intensity[nomSRM] = p.getIntensity();
            }
            for (Peak p : spec) {
                mz = p.getMz();
                float mass = IonType.B.getMass(mz);
                float compMass = expPepMass - mass;
                int nomSRM = NominalMass.toNominalMass(compMass);
                if (nomSRM <= 0 || nomSRM >= srm.length || intensity[nomSRM] != 0.0f || !(p.getIntensity() > intensity[nomSRM])) continue;
                srm[nomSRM] = compMass;
                intensity[nomSRM] = p.getIntensity();
            }
            ArrayList<Tag> length1Tag = new ArrayList<Tag>();
            for (int i = 0; i < srm.length - 1; ++i) {
                int j;
                if (intensity[i] == 0.0f) continue;
                float p1 = srm[i];
                for (int aaIndex = 0; aaIndex < intAAMass.length && (j = i + intAAMass[aaIndex]) < srm.length; ++aaIndex) {
                    float error;
                    if (intensity[j] == 0.0f) continue;
                    float p2 = srm[j];
                    float massDiff = p2 - p1;
                    int nominalDiff = j - i;
                    float aaMass = nominalMass[nominalDiff];
                    char aaResidue = residue[nominalDiff];
                    if (!(aaMass > 0.0f)) continue;
                    if (nominalDiff == 128) {
                        if (Math.abs(massDiff - aaQ.getMass()) > Math.abs(massDiff - aaK.getMass())) {
                            aaMass = aaK.getMass();
                            aaResidue = 'K';
                        } else {
                            aaMass = aaQ.getMass();
                            aaResidue = 'Q';
                        }
                    }
                    if (!((error = massDiff - aaMass) > -tagErrTolerance) || !(error < tagErrTolerance)) continue;
                    length1Tag.add(new Tag(i, j, aaResidue));
                }
            }
            ArrayList<Tag> length2Tag = new ArrayList<Tag>();
            block8: for (int i = 0; i < length1Tag.size() - 1; ++i) {
                Tag t1 = (Tag)length1Tag.get(i);
                int index1 = t1.getLast();
                for (int j = i + 1; j < length1Tag.size(); ++j) {
                    Tag t2 = (Tag)length1Tag.get(j);
                    int index2 = t2.getFirst();
                    if (index2 == index1) {
                        length2Tag.add(Tag.join(t1, t2));
                        continue;
                    }
                    if (index2 > index1) continue block8;
                }
            }
            ArrayList<Tag> length3Tag = new ArrayList<Tag>();
            block10: for (int i = 0; i < length2Tag.size() - 1; ++i) {
                Tag t1 = (Tag)length2Tag.get(i);
                int index1 = t1.getLast();
                for (int j = 0; j < length1Tag.size(); ++j) {
                    Tag t2 = (Tag)length1Tag.get(j);
                    int index2 = t2.getFirst();
                    if (index2 == index1) {
                        length3Tag.add(Tag.join(t1, t2));
                        continue;
                    }
                    if (index2 > index1) continue block10;
                }
            }
            for (Tag t : length3Tag) {
                int score = 0;
                for (int i : t.index) {
                    if (i == 0 || i == nomExpPepMass) {
                        score += 10;
                        continue;
                    }
                    NominalMass p = new NominalMass(nomExpPepMass - i);
                    NominalMass s = new NominalMass(i);
                    score += scoredSpec.getNodeScore(p, s);
                }
                t.score(score);
            }
            Collections.sort(length3Tag, Collections.reverseOrder());
            float[] theoSRM = new float[peptide.size() + 1];
            theoSRM[0] = 0.0f;
            float m = 0.0f;
            for (int i = 0; i < peptide.size(); ++i) {
                theoSRM[i + 1] = m += peptide.get(peptide.size() - 1 - i).getMass();
            }
            String pepStr = peptide.toString();
            pepStr = pepStr.replaceAll("I", "L");
            int numTags = 0;
            boolean hasCorrectTag = false;
            sumNumTags += Math.min(length3Tag.size(), numMaxTags);
            for (Tag t : length3Tag) {
                String tagSeq = t.getRevSeq();
                int matchIndex = pepStr.indexOf(tagSeq);
                if (matchIndex >= 0) {
                    float error = theoSRM[peptide.size() - (matchIndex + 3)] - srm[t.getFirst()];
                    if (error > 0.0f && fragTolerance.isTolerancePPM()) {
                        error = error * 1000000.0f / theoSRM[peptide.size() - (matchIndex + 3)];
                    }
                    if (error < fragTolerance.getValue()) {
                        hasCorrectTag = true;
                        ++numSpecsWithCorrectTags;
                        break;
                    }
                }
                if (++numTags < numMaxTags) continue;
                break;
            }
            if (hasCorrectTag) continue;
            System.out.println(spec.getScanNum() + "\t" + peptide);
            int rank = 0;
            for (Tag t : length3Tag) {
                ++rank;
                String tagSeq = t.getRevSeq();
                int matchIndex = pepStr.indexOf(tagSeq);
                boolean isCorrect = false;
                if (matchIndex >= 0) {
                    float error = theoSRM[peptide.size() - (matchIndex + 3)] - srm[t.getFirst()];
                    if (error > 0.0f && fragTolerance.isTolerancePPM()) {
                        error = error * 1000000.0f / theoSRM[peptide.size() - (matchIndex + 3)];
                    }
                    if (error < fragTolerance.getValue()) {
                        isCorrect = true;
                    }
                }
                System.out.println(rank + "\t" + t.getRevSeq() + "\t" + srm[t.getFirst()] + "\t" + isCorrect);
                if (!isCorrect) continue;
                continue block1;
            }
        }
        System.out.println("NumSpecs\t" + numSpecs);
        System.out.println("NumSpecsWithCorrectTags\t" + numSpecsWithCorrectTags + "\t" + (float)numSpecsWithCorrectTags / (float)numSpecs);
        System.out.println("AvgNumTags\t" + (float)sumNumTags / (float)numSpecs);
        System.out.println("Time\t" + (float)(System.currentTimeMillis() - time) / (float)numSpecs / 1000.0f);
    }

    static class Tag
    implements Comparable<Tag> {
        int[] index;
        String seq;
        int score;

        public Tag(int i1, int i2, char residue) {
            this.index = new int[2];
            this.index[0] = i1;
            this.index[1] = i2;
            this.seq = String.valueOf(residue);
        }

        private Tag() {
        }

        public Tag score(int score) {
            this.score = score;
            return this;
        }

        public int getScore() {
            return this.score;
        }

        public static Tag join(Tag tag1, Tag tag2) {
            Tag newTag = new Tag();
            newTag.index = Arrays.copyOf(tag1.index, tag1.index.length + 1);
            newTag.index[newTag.index.length - 1] = tag2.getLast();
            newTag.seq = tag1.seq + tag2.seq;
            return newTag;
        }

        int getFirst() {
            return this.index[0];
        }

        int getLast() {
            return this.index[this.index.length - 1];
        }

        String getSeq() {
            return this.seq;
        }

        String getRevSeq() {
            StringBuffer rev = new StringBuffer();
            for (int i = this.seq.length() - 1; i >= 0; --i) {
                rev.append(this.seq.charAt(i));
            }
            return rev.toString();
        }

        @Override
        public int compareTo(Tag arg0) {
            return this.score - arg0.score;
        }
    }
}

