/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.CompactFastaSequence;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.ReverseDB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;

public class BuildSA {
    public static void main(String[] argv) {
        if (argv.length < 1) {
            BuildSA.printUsageAndExit("");
        }
        if (argv.length < 2 || argv.length % 2 != 0) {
            BuildSA.printUsageAndExit("The number of parameters must be even. If a file path has a space, surround it with double quotes.");
        }
        File dbPath = null;
        File outputDir = null;
        int mode = 2;
        String decoyProteinPrefix = "XXX";
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                BuildSA.printUsageAndExit("Invalid parameters");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-d")) {
                dbPath = new File(argv[i + 1]);
                if (dbPath.exists()) continue;
                BuildSA.printUsageAndExit(argv[i + 1] + " doesn't exist.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-o")) {
                outputDir = new File(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-tda")) {
                if (argv[i + 1].equals("0")) {
                    mode = 0;
                    continue;
                }
                if (argv[i + 1].equals("1")) {
                    mode = 1;
                    continue;
                }
                if (argv[i + 1].equals("2")) {
                    mode = 2;
                    continue;
                }
                BuildSA.printUsageAndExit("Invalid parameter: -tda " + argv[i + 1]);
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-decoy")) continue;
            decoyProteinPrefix = argv[i + 1];
        }
        if (dbPath == null) {
            BuildSA.printUsageAndExit("Database must be specified!");
        }
        BuildSA.buildSA(dbPath, outputDir, mode, decoyProteinPrefix);
    }

    public static void printUsageAndExit(String message) {
        System.out.println();
        if (!message.isEmpty()) {
            System.out.println("Error: " + message);
            System.out.println();
        }
        System.out.println("Usage: java -Xmx3500M -cp MSGFPlus.jar edu.ucsd.msjava.msdbsearch.BuildSA");
        System.out.println("\t-d DatabaseFile (*.fasta or *.fa or *.faa; if a directory path, index all FASTA files)");
        System.out.println("\t[-tda 0/1/2] (0: Target database only, 1: Concatenated target-decoy database only, 2: Both (Default))");
        System.out.println("\t[-o OutputDir] (Directory to save index files; default is the same as the input file)");
        System.out.println("\t[-decoy DecoyPrefix] (Prefix for decoy protein names; default is XXX)");
        System.out.println();
        System.out.println("Documentation: https://github.com/MSGFPlus/msgfplus");
        System.exit(-1);
    }

    public static void buildSA(File dbPath, File outputDir, int mode, String decoyProteinPrefix) {
        if (dbPath.isDirectory()) {
            for (File f : dbPath.listFiles()) {
                if (!BuildSA.isFastaFile(f.getName())) continue;
                BuildSA.buildSAFiles(f, outputDir, mode, decoyProteinPrefix);
            }
        } else if (BuildSA.isFastaFile(dbPath.getName())) {
            BuildSA.buildSAFiles(dbPath, outputDir, mode, decoyProteinPrefix);
        }
        System.out.println("Done");
    }

    public static void buildSAFiles(File databaseFile, File outputDir, int mode, String decoyProteinPrefix) {
        if (outputDir == null) {
            outputDir = databaseFile.getAbsoluteFile().getParentFile();
        }
        if (!BuildSA.validateOutputDirectory(outputDir)) {
            System.exit(-1);
        }
        String dbFileName = databaseFile.getName();
        if (decoyProteinPrefix == null || decoyProteinPrefix.trim().isEmpty()) {
            decoyProteinPrefix = "XXX";
        }
        while (decoyProteinPrefix.endsWith("_")) {
            decoyProteinPrefix = decoyProteinPrefix.substring(0, decoyProteinPrefix.length() - 1);
        }
        if (decoyProteinPrefix.trim().isEmpty()) {
            decoyProteinPrefix = "XXX";
        }
        if (mode == 1 || mode == 2) {
            float fractionDecoyProteins;
            String concatDBFileName = dbFileName.substring(0, dbFileName.lastIndexOf(46)) + ".revCat.fasta";
            File concatTargetDecoyDBFile = new File(Paths.get(outputDir.getPath(), concatDBFileName).toString());
            if (!concatTargetDecoyDBFile.exists()) {
                System.out.println("Creating " + concatDBFileName + ".");
                if (!ReverseDB.reverseDB(databaseFile.getPath(), concatTargetDecoyDBFile.getPath(), true, decoyProteinPrefix)) {
                    System.err.println("Cannot create decoy database file!");
                    System.out.println("Consider using -o to specify the output directory");
                    System.exit(-1);
                }
            }
            System.out.println("Building suffix array: " + concatTargetDecoyDBFile.getPath());
            CompactFastaSequence tdaSequence = new CompactFastaSequence(concatTargetDecoyDBFile.getPath());
            tdaSequence.setDecoyProteinPrefix(decoyProteinPrefix);
            float ratioUniqueProteins = tdaSequence.getRatioUniqueProteins();
            if (ratioUniqueProteins < 0.5f) {
                tdaSequence.printTooManyDuplicateSequencesMessage(concatTargetDecoyDBFile.getName(), "MS-GF+", ratioUniqueProteins);
                System.exit(-1);
            }
            if ((fractionDecoyProteins = tdaSequence.getFractionDecoyProteins()) < 0.4f || fractionDecoyProteins > 0.6f) {
                System.err.println("Error while reading: " + databaseFile.getName() + " (fraction of decoy proteins: " + fractionDecoyProteins + ")");
                if (databaseFile.getName().toLowerCase().endsWith(".revCat.fasta".toLowerCase())) {
                    System.err.println("Delete " + databaseFile.getName() + " and run MS-GF+ (or BuildSA) again.");
                } else {
                    String baseName = FilenameUtils.removeExtension(databaseFile.getName());
                    System.err.println("Delete files starting with " + baseName + " (but keep " + databaseFile.getName() + ") and run MS-GF+ (or BuildSA) again.");
                }
                System.err.println("Decoy protein names should start with " + tdaSequence.getDecoyProteinPrefix());
                System.exit(-1);
            }
            new CompactSuffixArray(tdaSequence);
        }
        if (mode == 0 || mode == 2) {
            File targetDBFile = new File(Paths.get(outputDir.getPath(), dbFileName).toString());
            if (!targetDBFile.exists()) {
                System.out.println("Creating " + targetDBFile.getName() + ".");
                if (!ReverseDB.copyDB(databaseFile.getPath(), targetDBFile.getPath())) {
                    System.err.println("Cannot create target database file!");
                    System.out.println("Consider using -o to specify the output directory");
                    System.exit(-1);
                }
            }
            System.out.println("Building suffix array: " + databaseFile.getPath());
            CompactFastaSequence sequence = new CompactFastaSequence(targetDBFile.getPath());
            sequence.setDecoyProteinPrefix(decoyProteinPrefix);
            new CompactSuffixArray(sequence);
        }
        System.out.println();
    }

    public static boolean isFastaFile(String filePath) {
        String fileNameLcase = filePath.toLowerCase();
        return fileNameLcase.endsWith(".fasta") || fileNameLcase.endsWith(".fa") || fileNameLcase.endsWith(".faa");
    }

    private static boolean validateOutputDirectory(File outputDir) {
        try {
            Boolean success;
            if (!outputDir.exists() && !(success = Boolean.valueOf(outputDir.mkdirs())).booleanValue()) {
                System.err.println("Error creating the output directory (access denied?): " + outputDir.getPath());
                return false;
            }
        }
        catch (Throwable ex) {
            System.err.println("Error validating / creating the output directory: " + outputDir.getPath());
            return false;
        }
        Path testFilePath = Paths.get(outputDir.getPath(), "WritePermTestFile.tmp");
        if (!Files.isWritable(testFilePath)) {
            Boolean accessDenied = true;
            try {
                File testFile = new File(testFilePath.toString());
                if (testFile.exists()) {
                    testFile.delete();
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(testFile.getPath()));
                writer.write("test");
                writer.close();
                if (testFile.exists()) {
                    accessDenied = false;
                    testFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accessDenied.booleanValue()) {
                System.err.println("Write access denied to directory: " + outputDir.getPath());
                System.out.println("Consider using -o to specify the output directory");
                return false;
            }
        }
        return true;
    }
}

