/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;

public class CandidatePeptideGrid {
    private static final int STANDARD_RESIDUE_MAX_RESIDUE = 128;
    private final AminoAcidSet aaSet;
    private final Enzyme enzyme;
    private final int maxPeptideLength;
    private final int numMaxMods;
    private final int maxNumVariantsPerPeptide;
    private final int maxNumMissedCleavages;
    private final int[] nMissedCleavages;
    private final char[] residues;
    private final boolean enzymeIsNonSpecific;
    private int[][] nominalPRM;
    private double[][] prm;
    private int[][] numMods;
    private StringBuffer[] peptide;
    private int[][] aaNominalMass;
    private double[][] aaMass;
    private char[][] aaResidue;
    private int[][] nTermAANominalMass;
    private double[][] nTermAAMass;
    private char[][] nTermAAResidue;
    private int[][] cTermAANominalMass;
    private double[][] cTermAAMass;
    private char[][] cTermAAResidue;
    private int[][] protNTermAANominalMass;
    private double[][] protNTermAAMass;
    private char[][] protNTermAAResidue;
    private int[][] protCTermAANominalMass;
    private double[][] protCTermAAMass;
    private char[][] protCTermAAResidue;
    private int length;
    private int[] size;

    public CandidatePeptideGrid(AminoAcidSet aaSet, Enzyme enzyme, int maxPeptideLength, int maxNumVariantsPerPeptide, int maxMissedCleavages) {
        this.numMaxMods = aaSet.getMaxNumberOfVariableModificationsPerPeptide();
        this.maxPeptideLength = maxPeptideLength;
        this.maxNumVariantsPerPeptide = maxNumVariantsPerPeptide;
        this.maxNumMissedCleavages = maxMissedCleavages;
        this.aaSet = aaSet;
        this.enzyme = enzyme;
        this.enzymeIsNonSpecific = enzyme.getName().equals("UnspecificCleavage");
        this.cacheAASet();
        this.nominalPRM = new int[maxNumVariantsPerPeptide][maxPeptideLength + 1];
        this.prm = new double[maxNumVariantsPerPeptide][maxPeptideLength + 1];
        this.numMods = new int[maxNumVariantsPerPeptide][maxPeptideLength + 1];
        this.peptide = new StringBuffer[maxNumVariantsPerPeptide];
        this.size = new int[maxPeptideLength + 1];
        this.nMissedCleavages = new int[maxPeptideLength + 1];
        this.residues = new char[maxPeptideLength + 1];
        this.initializeNTerm();
    }

    private void initializeNTerm() {
        for (int i = 0; i < this.maxNumVariantsPerPeptide; ++i) {
            this.nominalPRM[i][0] = 0;
            this.prm[i][0] = 0.0;
            this.numMods[i][0] = 0;
            this.peptide[i] = new StringBuffer();
        }
        this.size[0] = 1;
        this.nMissedCleavages[0] = 0;
        this.residues[0] = 95;
        this.length = 0;
    }

    public int[] getNominalPRMGrid(int index) {
        return this.nominalPRM[index];
    }

    public double[] getPRMGrid(int index) {
        return this.prm[index];
    }

    public int size() {
        return this.size[this.length];
    }

    public float getPeptideMass(int index) {
        return (float)this.prm[index][this.length];
    }

    public int getNominalPeptideMass(int index) {
        return this.nominalPRM[index][this.length];
    }

    public String getPeptideSeq(int index) {
        return this.peptide[index].toString();
    }

    public boolean gridIsOverMaxMissedCleavages(int index) {
        return this.maxNumMissedCleavages != -1 && this.nMissedCleavages[this.length] > this.maxNumMissedCleavages;
    }

    public int getPeptideNumMissedCleavages(int index) {
        return this.nMissedCleavages[this.length];
    }

    public int getNumMods(int index) {
        return this.numMods[index][this.length];
    }

    public boolean addResidue(int length, char residue) {
        double[] aaMassArr = this.aaMass[residue];
        if (aaMassArr == null || length > this.maxPeptideLength) {
            return false;
        }
        int[] aaNominalMassArr = this.aaNominalMass[residue];
        char[] aaResidueArr = this.aaResidue[residue];
        return this.addResidue(aaMassArr, aaNominalMassArr, aaResidueArr, length);
    }

    public boolean addProtNTermResidue(char residue) {
        double[] aaMassArr = this.protNTermAAMass[residue];
        if (aaMassArr == null) {
            return false;
        }
        int[] aaNominalMassArr = this.protNTermAANominalMass[residue];
        char[] aaResidueArr = this.protNTermAAResidue[residue];
        return this.addResidue(aaMassArr, aaNominalMassArr, aaResidueArr, 1);
    }

    public boolean addNTermResidue(char residue) {
        double[] aaMassArr = this.nTermAAMass[residue];
        if (aaMassArr == null) {
            return false;
        }
        int[] aaNominalMassArr = this.nTermAANominalMass[residue];
        char[] aaResidueArr = this.nTermAAResidue[residue];
        return this.addResidue(aaMassArr, aaNominalMassArr, aaResidueArr, 1);
    }

    public boolean addProtCTermResidue(int length, char residue) {
        double[] aaMassArr = this.protCTermAAMass[residue];
        if (aaMassArr == null) {
            return false;
        }
        int[] aaNominalMassArr = this.protCTermAANominalMass[residue];
        char[] aaResidueArr = this.protCTermAAResidue[residue];
        return this.addResidue(aaMassArr, aaNominalMassArr, aaResidueArr, length);
    }

    public boolean addCTermResidue(int length, char residue) {
        double[] aaMassArr = this.cTermAAMass[residue];
        if (aaMassArr == null) {
            return false;
        }
        int[] aaNominalMassArr = this.cTermAANominalMass[residue];
        char[] aaResidueArr = this.cTermAAResidue[residue];
        return this.addResidue(aaMassArr, aaNominalMassArr, aaResidueArr, length);
    }

    public boolean isNTermMetCleaved(int index) {
        return false;
    }

    private boolean addResidue(double[] aaMassArr, int[] aaNominalMassArr, char[] aaResidueArr, int length) {
        int parentSize = this.size[length - 1];
        for (int parentIndex = 0; parentIndex < parentSize; ++parentIndex) {
            this.nominalPRM[parentIndex][length] = this.nominalPRM[parentIndex][length - 1] + aaNominalMassArr[0];
            this.prm[parentIndex][length] = this.prm[parentIndex][length - 1] + aaMassArr[0];
            this.numMods[parentIndex][length] = this.numMods[parentIndex][length - 1];
            this.peptide[parentIndex].setLength(length - 1);
            this.peptide[parentIndex].append(aaResidueArr[0]);
        }
        this.size[length] = parentSize;
        if (aaMassArr.length > 1 && parentSize < this.maxNumVariantsPerPeptide) {
            int newIndex = parentSize;
            for (int parentIndex = 0; parentIndex < parentSize; ++parentIndex) {
                int numModParent = this.numMods[parentIndex][length - 1];
                if (numModParent < this.numMaxMods) {
                    for (int j = 1; j < aaMassArr.length; ++j) {
                        for (int k = 1; k < length; ++k) {
                            this.nominalPRM[newIndex][k] = this.nominalPRM[parentIndex][k];
                            this.prm[newIndex][k] = this.prm[parentIndex][k];
                        }
                        this.peptide[newIndex] = new StringBuffer(this.peptide[parentIndex].substring(0, length - 1));
                        this.nominalPRM[newIndex][length] = this.nominalPRM[newIndex][length - 1] + aaNominalMassArr[j];
                        this.prm[newIndex][length] = this.prm[newIndex][length - 1] + aaMassArr[j];
                        this.numMods[newIndex][length] = numModParent + 1;
                        this.peptide[newIndex].append(aaResidueArr[j]);
                        if (++newIndex >= this.maxNumVariantsPerPeptide) break;
                    }
                }
                if (newIndex >= this.maxNumVariantsPerPeptide) break;
            }
            this.size[length] = newIndex;
        }
        this.length = length;
        if (this.maxNumMissedCleavages != -1 && !this.enzymeIsNonSpecific) {
            this.nMissedCleavages[length] = this.enzyme.isCleavable(aaResidueArr[0]) && this.enzyme.isNTerm() && length > 1 ? this.nMissedCleavages[length - 1] + 1 : (this.enzyme.isCTerm() && this.enzyme.isCleavable(this.residues[length - 1]) ? this.nMissedCleavages[length - 1] + 1 : this.nMissedCleavages[length - 1]);
            this.residues[length] = aaResidueArr[0];
            if (this.nMissedCleavages[length] > this.maxNumMissedCleavages) {
                return false;
            }
        }
        return true;
    }

    private void cacheAASet() {
        for (Modification.Location location : Modification.Location.values()) {
            this.cacheAASet(location);
        }
    }

    private void cacheAASet(Modification.Location location) {
        int[][] stdResidue2NominalMasses = null;
        double[][] stdResidue2Masses = null;
        char[][] stdResidue2Residues = null;
        if (location == Modification.Location.Anywhere) {
            int[][] nArrayArray = new int[128][];
            this.aaNominalMass = nArrayArray;
            stdResidue2NominalMasses = nArrayArray;
            double[][] dArrayArray = new double[128][];
            this.aaMass = dArrayArray;
            stdResidue2Masses = dArrayArray;
            char[][] cArrayArray = new char[128][];
            this.aaResidue = cArrayArray;
            stdResidue2Residues = cArrayArray;
        } else if (location == Modification.Location.N_Term) {
            int[][] nArrayArray = new int[128][];
            this.nTermAANominalMass = nArrayArray;
            stdResidue2NominalMasses = nArrayArray;
            double[][] dArrayArray = new double[128][];
            this.nTermAAMass = dArrayArray;
            stdResidue2Masses = dArrayArray;
            char[][] cArrayArray = new char[128][];
            this.nTermAAResidue = cArrayArray;
            stdResidue2Residues = cArrayArray;
        } else if (location == Modification.Location.C_Term) {
            int[][] nArrayArray = new int[128][];
            this.cTermAANominalMass = nArrayArray;
            stdResidue2NominalMasses = nArrayArray;
            double[][] dArrayArray = new double[128][];
            this.cTermAAMass = dArrayArray;
            stdResidue2Masses = dArrayArray;
            char[][] cArrayArray = new char[128][];
            this.cTermAAResidue = cArrayArray;
            stdResidue2Residues = cArrayArray;
        } else if (location == Modification.Location.Protein_N_Term) {
            int[][] nArrayArray = new int[128][];
            this.protNTermAANominalMass = nArrayArray;
            stdResidue2NominalMasses = nArrayArray;
            double[][] dArrayArray = new double[128][];
            this.protNTermAAMass = dArrayArray;
            stdResidue2Masses = dArrayArray;
            char[][] cArrayArray = new char[128][];
            this.protNTermAAResidue = cArrayArray;
            stdResidue2Residues = cArrayArray;
        } else if (location == Modification.Location.Protein_C_Term) {
            int[][] nArrayArray = new int[128][];
            this.protCTermAANominalMass = nArrayArray;
            stdResidue2NominalMasses = nArrayArray;
            double[][] dArrayArray = new double[128][];
            this.protCTermAAMass = dArrayArray;
            stdResidue2Masses = dArrayArray;
            char[][] cArrayArray = new char[128][];
            this.protCTermAAResidue = cArrayArray;
            stdResidue2Residues = cArrayArray;
        }
        for (Character aa : this.aaSet.getResidueListWithoutMods()) {
            char residue = aa.charValue();
            AminoAcid[] aaArr = this.aaSet.getAminoAcids(location, residue);
            stdResidue2NominalMasses[residue] = new int[aaArr.length];
            stdResidue2Masses[residue] = new double[aaArr.length];
            stdResidue2Residues[residue] = new char[aaArr.length];
            for (int i = 0; i < aaArr.length; ++i) {
                stdResidue2NominalMasses[residue][i] = aaArr[i].getNominalMass();
                stdResidue2Masses[residue][i] = aaArr[i].getAccurateMass();
                stdResidue2Residues[residue][i] = aaArr[i].getResidue();
            }
        }
    }
}

