/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.BuildSA;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.sequences.Sequence;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

public class CompactFastaSequence
implements Sequence {
    public static final int COMPACT_FASTA_SEQUENCE_FILE_FORMAT_ID = 9873;
    public static final String SEQ_FILE_EXTENSION = ".cseq";
    public static final String ANNOTATION_FILE_EXTENSION = ".canno";
    private String baseFilepath;
    private TreeMap<Integer, String> annotations;
    private byte[] sequence;
    private int size;
    private HashMap<Character, Byte> alpha2byte;
    private HashMap<Byte, Character> byte2alpha;
    private String alphabetString;
    private String decoyProteinPrefix;
    private int id;
    private long lastModified;
    private boolean truncateAnnotation = false;

    public CompactFastaSequence(String filepath) {
        this(filepath, "A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z", "XXX");
    }

    private CompactFastaSequence(String filepath, String alphabet) {
        this(filepath, alphabet, "XXX");
    }

    private CompactFastaSequence(String filepath, String alphabet, String decoyProteinPrefix) {
        String basepath;
        this.decoyProteinPrefix = decoyProteinPrefix;
        if (!BuildSA.isFastaFile(filepath)) {
            System.err.println("Input error: not a fasta file (extension must be .fasta or .fa or .faa)");
            System.exit(-1);
        }
        String[] tokens = filepath.split("\\.");
        String extension = tokens[tokens.length - 1];
        this.baseFilepath = basepath = filepath.substring(0, filepath.length() - extension.length() - 1);
        this.lastModified = new File(filepath).lastModified();
        String metaFile = basepath + ANNOTATION_FILE_EXTENSION;
        String sequenceFile = basepath + SEQ_FILE_EXTENSION;
        if (!new File(metaFile).exists() || !new File(sequenceFile).exists()) {
            this.createObjectFromRawFile(filepath, alphabet);
        }
        FileSignature metaIdSignature = null;
        FileSignature seqIdSignature = null;
        try {
            metaIdSignature = this.readMetaInfo();
            seqIdSignature = this.readSequence();
        }
        catch (NumberFormatException e) {
            this.createObjectFromRawFile(filepath, alphabet);
            metaIdSignature = this.readMetaInfo();
            seqIdSignature = this.readSequence();
        }
        boolean indexingRequired = false;
        if (metaIdSignature == null || seqIdSignature == null) {
            System.out.println("Re-creating the .canno file since metaIdSignature is null or seqIdSignature is null");
            indexingRequired = true;
        }
        if (!indexingRequired && metaIdSignature.getFormatId() != 9873) {
            System.out.println("Re-creating the .canno file since the metaIdSignature is not 9873, it is " + metaIdSignature.getFormatId());
            indexingRequired = true;
        }
        if (!indexingRequired && seqIdSignature.getFormatId() != 9873) {
            System.out.println("Re-creating the .canno file since the seqIdSignature is not 9873, it is " + seqIdSignature.getFormatId());
            indexingRequired = true;
        }
        if (!indexingRequired && metaIdSignature.getId() != seqIdSignature.getId()) {
            System.out.println("Re-creating the .canno file since the metaIdSignature ID doesn't match seqIdSignature ID:\n " + metaIdSignature.getId() + " vs. " + seqIdSignature.getId());
            indexingRequired = true;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        long metaIdLastModified = metaIdSignature.getLastModified();
        long seqIdLastModified = seqIdSignature.getLastModified();
        if (!indexingRequired && metaIdLastModified != seqIdLastModified) {
            System.out.println("Re-creating the .canno file since metaIdSignature LastModified doesn't match seqIdSignature LastModified:\n  .canno has " + metaIdLastModified + " (" + dateFormatter.format(metaIdLastModified) + ")  but .cseq has " + seqIdLastModified + " (" + dateFormatter.format(seqIdLastModified) + ")");
            indexingRequired = true;
        }
        if (!indexingRequired && !CompactSuffixArray.NearlyEqualFileTimes(metaIdLastModified, this.lastModified)) {
            System.out.println("Re-creating the .canno file since metaIdSignature LastModified is not within 2 seconds of the file modification time on disk:\n Expected " + metaIdLastModified + " (" + dateFormatter.format(metaIdLastModified) + ") but actually " + this.lastModified + " (" + dateFormatter.format(this.lastModified) + ")");
            indexingRequired = true;
        }
        if (indexingRequired) {
            this.createObjectFromRawFile(filepath, alphabet);
            metaIdSignature = this.readMetaInfo();
            seqIdSignature = this.readSequence();
        }
        this.initializeAlphabet(this.alphabetString);
        this.id = metaIdSignature.getId();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getDecoyProteinPrefix() {
        return this.decoyProteinPrefix;
    }

    public void setDecoyProteinPrefix(String decoyProteinPrefix) {
        this.decoyProteinPrefix = decoyProteinPrefix;
    }

    public CompactFastaSequence truncateAnnotation() {
        this.truncateAnnotation = true;
        return this;
    }

    @Override
    public Set<Byte> getAlphabetAsBytes() {
        return this.byte2alpha.keySet();
    }

    @Override
    public Collection<Character> getAlphabet() {
        ArrayList<Character> results = new ArrayList<Character>();
        for (char c : this.byte2alpha.values()) {
            if (c == '_') continue;
            results.add(Character.valueOf(c));
        }
        return results;
    }

    @Override
    public boolean isTerminator(long position) {
        return this.getByteAt(position) == 0;
    }

    @Override
    public char toChar(byte b) {
        if (this.byte2alpha.containsKey(b)) {
            return this.byte2alpha.get(b).charValue();
        }
        return '?';
    }

    @Override
    public int getAlphabetSize() {
        return this.byte2alpha.size();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte getByteAt(long position) {
        return this.sequence[(int)position];
    }

    @Override
    public String getSubsequence(long start, long end) {
        if (start >= end || end > (long)this.size) {
            return null;
        }
        char[] seq = new char[(int)(end - start)];
        for (long i = start; i < end; ++i) {
            seq[(int)(i - start)] = this.toChar(this.sequence[(int)i]);
        }
        return new String(seq);
    }

    @Override
    public char getCharAt(long position) {
        return this.toChar(this.sequence[(int)position]);
    }

    @Override
    public String toString(byte[] sequence) {
        String retVal = "";
        for (byte item : sequence) {
            Character c = this.byte2alpha.get(item);
            retVal = c != null ? retVal + c : retVal + '?';
        }
        return retVal;
    }

    @Override
    public byte toByte(char c) {
        return this.alpha2byte.get(Character.valueOf(c));
    }

    @Override
    public byte[] getBytes(int start, int end) {
        byte[] result = new byte[end - start];
        for (int i = start; i < end; ++i) {
            result[i - start] = this.getByteAt(i);
        }
        return result;
    }

    @Override
    public boolean isInAlphabet(char c) {
        return this.alpha2byte.containsKey(Character.valueOf(c));
    }

    @Override
    public boolean isValid(long position) {
        if (this.isTerminator(position)) {
            return false;
        }
        return this.isInAlphabet(this.getCharAt(position));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAnnotation(long position) {
        Map.Entry<Integer, String> entry = this.annotations.higherEntry((int)position);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public long getStartPosition(long position) {
        Integer startPos = this.annotations.floorKey((int)position);
        if (startPos == null) {
            return 0L;
        }
        return startPos.intValue();
    }

    @Override
    public String getMatchingEntry(long position) {
        Integer start = this.annotations.floorKey((int)position);
        Integer end = this.annotations.higherKey((int)position);
        if (start == null) {
            start = 0;
        }
        if (end == null) {
            end = (int)this.getSize();
        }
        while (!this.isValid(end - 1)) {
            Integer n = end;
            end = end - 1;
        }
        return this.getSubsequence(start + 1, end.intValue());
    }

    @Override
    public String getMatchingEntry(String name) {
        return null;
    }

    public float getFractionDecoyProteins() {
        int numTargetProteins = 0;
        int numDecoyProteins = 0;
        for (String annotation : this.annotations.values()) {
            if (annotation.startsWith(this.decoyProteinPrefix)) {
                ++numDecoyProteins;
                continue;
            }
            ++numTargetProteins;
        }
        if (numTargetProteins + numDecoyProteins == 0) {
            return 0.0f;
        }
        return (float)numDecoyProteins / (float)(numTargetProteins + numDecoyProteins);
    }

    public void setBaseFilepath(String baseFilepath) {
        this.baseFilepath = baseFilepath;
    }

    public String getBaseFilepath() {
        return this.baseFilepath;
    }

    private void initializeAlphabet(String s) {
        String[] tokens = s.split(":");
        this.alpha2byte = new HashMap();
        this.byte2alpha = new HashMap();
        this.byte2alpha.put((byte)0, Character.valueOf('_'));
        this.byte2alpha.put((byte)1, Character.valueOf('?'));
        byte value = 2;
        int i = 0;
        while (i < tokens.length) {
            for (int j = 0; j < tokens[i].length(); ++j) {
                this.alpha2byte.put(Character.valueOf(tokens[i].charAt(j)), value);
            }
            this.byte2alpha.put(value, Character.valueOf(tokens[i].charAt(0)));
            i = (byte)(i + 1);
            value = (byte)(value + 1);
        }
    }

    private void createObjectFromRawFile(String filepath, String alphabet) {
        this.initializeAlphabet(alphabet);
        int size = 0;
        int formatId = 9873;
        int id = UUID.randomUUID().hashCode();
        String seqFilepath = this.baseFilepath + SEQ_FILE_EXTENSION;
        String metaFilepath = this.baseFilepath + ANNOTATION_FILE_EXTENSION;
        File rawFile = new File(filepath);
        long lastModified = rawFile.lastModified();
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            DataOutputStream seqOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(seqFilepath)));
            seqOut.writeInt(size);
            seqOut.writeInt(formatId);
            seqOut.writeInt(id);
            seqOut.writeLong(lastModified);
            PrintStream metaOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(metaFilepath)));
            metaOut.println(formatId);
            metaOut.println(id);
            metaOut.println(lastModified);
            metaOut.println(alphabet);
            Integer offset = 0;
            String annotation = null;
            while ((s = in.readLine()) != null) {
                if (!s.startsWith(">")) {
                    for (int index = 0; index < s.length(); ++index) {
                        Byte encoded = this.alpha2byte.get(Character.valueOf(s.charAt(index)));
                        if (encoded != null) {
                            seqOut.writeByte(encoded.byteValue());
                            continue;
                        }
                        seqOut.writeByte(1);
                    }
                    offset = offset + s.length();
                    continue;
                }
                seqOut.writeByte(0);
                if (annotation != null) {
                    metaOut.println(offset + ":" + annotation);
                }
                Integer index = offset;
                offset = offset + 1;
                if (this.truncateAnnotation) {
                    annotation = s.substring(1).split("\\s+")[0];
                    continue;
                }
                annotation = s.substring(1);
            }
            seqOut.writeByte(0);
            Integer index = offset;
            offset = offset + 1;
            metaOut.println(offset + ":" + annotation);
            size = offset;
            in.close();
            metaOut.flush();
            metaOut.close();
            seqOut.close();
            seqOut.close();
            RandomAccessFile raf = new RandomAccessFile(seqFilepath, "rw");
            raf.seek(0L);
            raf.writeInt(size);
            raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private FileSignature readMetaInfo() {
        String filepath = this.baseFilepath + ANNOTATION_FILE_EXTENSION;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            int formatId = Integer.parseInt(in.readLine());
            int id = Integer.parseInt(in.readLine());
            long lastModified = Long.parseLong(in.readLine());
            this.alphabetString = in.readLine().trim();
            this.annotations = new TreeMap();
            String line = in.readLine();
            while (line != null) {
                String[] tokens = line.split(":", 2);
                this.annotations.put(Integer.parseInt(tokens[0]), tokens[1]);
                line = in.readLine();
            }
            in.close();
            return new FileSignature(formatId, id, lastModified);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private FileSignature readSequence() {
        String filepath = this.baseFilepath + SEQ_FILE_EXTENSION;
        try {
            int size;
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(filepath)));
            this.size = size = in.readInt();
            int formatId = in.readInt();
            int id = in.readInt();
            long lastModified = in.readLong();
            this.sequence = new byte[size];
            in.read(this.sequence);
            in.close();
            return new FileSignature(formatId, id, lastModified);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public int getNumProteins() {
        return this.annotations.keySet().size();
    }

    public float getRatioUniqueProteins() {
        int length;
        int numProteins = 0;
        ArrayList<Integer> proteinLastIndexList = new ArrayList<Integer>(this.annotations.keySet());
        HashMap<Integer, ArrayList<Integer>> lengthProtIndexMap = new HashMap<Integer, ArrayList<Integer>>();
        int fromIndex = 0;
        for (int i = 0; i < proteinLastIndexList.size(); ++i) {
            int toIndex = proteinLastIndexList.get(i);
            length = toIndex - fromIndex;
            ArrayList<Integer> list = (ArrayList<Integer>)lengthProtIndexMap.get(length);
            if (list == null) {
                list = new ArrayList<Integer>();
                lengthProtIndexMap.put(length, list);
            }
            list.add(i);
            fromIndex = toIndex;
        }
        int numUniqueProteins = 0;
        Iterator iterator = lengthProtIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            length = (Integer)iterator.next();
            ArrayList protIndexList = (ArrayList)lengthProtIndexMap.get(length);
            if (protIndexList.size() > 500) continue;
            numProteins += protIndexList.size();
            boolean[] isRedundant = new boolean[protIndexList.size()];
            for (int i = 0; i < protIndexList.size(); ++i) {
                if (isRedundant[i]) continue;
                int toIndex1 = proteinLastIndexList.get((Integer)protIndexList.get(i));
                for (int j = i + 1; j < protIndexList.size(); ++j) {
                    if (isRedundant[j]) continue;
                    int toIndex2 = proteinLastIndexList.get((Integer)protIndexList.get(j));
                    boolean isIdentical = true;
                    for (int l = 0; l < length; ++l) {
                        if (this.sequence[toIndex1 - 1 - l] == this.sequence[toIndex2 - 1 - l]) continue;
                        isIdentical = false;
                        break;
                    }
                    if (!isIdentical) continue;
                    isRedundant[j] = true;
                    isRedundant[i] = true;
                    break;
                }
                if (isRedundant[i]) continue;
                ++numUniqueProteins;
            }
        }
        return (float)numUniqueProteins / (float)numProteins;
    }

    public void printTooManyDuplicateSequencesMessage(String fileName, String toolName) {
        this.printTooManyDuplicateSequencesMessage(fileName, toolName, -1.0f);
    }

    public void printTooManyDuplicateSequencesMessage(String fileName, String toolName, float ratio) {
        System.err.println();
        System.err.println("Error while indexing: " + fileName + " (too many redundant proteins)");
        if (ratio > 0.0f) {
            System.err.println("Ratio of unique proteins: " + ratio);
        }
        System.err.println("If the database contains forward and reverse proteins, run " + toolName + " (or BuildSA) again with \"-tda 0\"");
        System.err.println("If the decoy protein names do not start with XXX either rename them, or use the -decoy switch");
        System.err.println();
        System.err.println("If the database does not contain forward and reverse proteins, this error is probably caused by multiple duplicate protein sequences. You can consolidate the duplicates using the 'Validate Fasta File' tool in the Protein Digestion Simulator, available at https://github.com/PNNL-Comp-Mass-Spec/Protein-Digestion-Simulator/releases");
    }

    private class FileSignature {
        int formatId;
        int id;
        long lastModified;

        public FileSignature(int formatId, int id, long lastModified) {
            this.formatId = formatId;
            this.id = id;
            this.lastModified = lastModified;
        }

        public int getFormatId() {
            return this.formatId;
        }

        public int getId() {
            return this.id;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

