/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.misc.ProgressData;
import edu.ucsd.msjava.msdbsearch.CandidatePeptideGrid;
import edu.ucsd.msjava.msdbsearch.CandidatePeptideGridConsideringMetCleavage;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DatabaseMatch;
import edu.ucsd.msjava.msdbsearch.MSGFPlusMatch;
import edu.ucsd.msjava.msdbsearch.Match;
import edu.ucsd.msjava.msdbsearch.PSMFeatureFinder;
import edu.ucsd.msjava.msdbsearch.ScoredSpectraMap;
import edu.ucsd.msjava.msgf.FlexAminoAcidGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.GeneratingFunctionGroup;
import edu.ucsd.msjava.msgf.MSGFDBResultGenerator;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.SimpleDBSearchScorer;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpecKey;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class DBScanner {
    private int minPeptideLength;
    private int maxPeptideLength;
    private int maxMissedCleavages;
    private int maxNumVariantsPerPeptide;
    private AminoAcidSet aaSet;
    private double[] aaMass;
    private int[] intAAMass;
    private Enzyme enzyme;
    private int numPeptidesPerSpec;
    private final CompactSuffixArray sa;
    private final int size;
    private final ScoredSpectraMap specScanner;
    private int minDeNovoScore;
    private boolean ignoreNTermMetCleavage;
    private Map<SpecKey, PriorityQueue<DatabaseMatch>> specKeyDBMatchMap;
    private Map<Integer, PriorityQueue<DatabaseMatch>> specIndexDBMatchMap;
    private ProgressData progress;
    private PrintStream output;
    private String threadName = "";

    public DBScanner(ScoredSpectraMap specScanner, CompactSuffixArray sa, Enzyme enzyme, AminoAcidSet aaSet, int numPeptidesPerSpec, int minPeptideLength, int maxPeptideLength, int maxNumVariantsPerPeptide, int minDeNovoScore, boolean ignoreNTermMetCleavage, int maxMissedCleavages) {
        this.specScanner = specScanner;
        this.sa = sa;
        this.size = sa.getSize();
        this.aaSet = aaSet;
        this.enzyme = enzyme;
        this.numPeptidesPerSpec = numPeptidesPerSpec;
        this.minPeptideLength = minPeptideLength;
        this.maxPeptideLength = maxPeptideLength;
        this.maxMissedCleavages = maxMissedCleavages;
        this.maxNumVariantsPerPeptide = maxNumVariantsPerPeptide;
        this.minDeNovoScore = minDeNovoScore;
        this.ignoreNTermMetCleavage = ignoreNTermMetCleavage;
        this.aaMass = new double[aaSet.getMaxResidue()];
        this.intAAMass = new int[aaSet.getMaxResidue()];
        for (int i = 0; i < this.aaMass.length; ++i) {
            this.aaMass[i] = -1.0;
            this.intAAMass[i] = -1;
        }
        for (AminoAcid aa : aaSet.getAllAminoAcidArr()) {
            this.aaMass[aa.getResidue()] = aa.getAccurateMass();
            this.intAAMass[aa.getResidue()] = aa.getNominalMass();
        }
        this.specKeyDBMatchMap = Collections.synchronizedMap(new HashMap());
        this.specIndexDBMatchMap = Collections.synchronizedMap(new HashMap());
        this.progress = null;
        this.output = System.out;
    }

    public DBScanner maxPeptideLength(int maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
        return this;
    }

    public DBScanner minPeptideLength(int minPeptideLength) {
        if (minPeptideLength > 1) {
            this.minPeptideLength = minPeptideLength;
        } else {
            minPeptideLength = 1;
        }
        return this;
    }

    public DBScanner setThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public synchronized void addDBMatches(Map<SpecKey, PriorityQueue<DatabaseMatch>> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<SpecKey, PriorityQueue<DatabaseMatch>> entry : map.entrySet()) {
            SpecKey specKey = entry.getKey();
            PriorityQueue<DatabaseMatch> queue = entry.getValue();
            PriorityQueue<DatabaseMatch> existingQueue = this.specKeyDBMatchMap.get(entry.getKey());
            if (existingQueue == null) {
                existingQueue = new PriorityQueue();
                this.specKeyDBMatchMap.put(specKey, existingQueue);
            }
            existingQueue.addAll(queue);
        }
    }

    public Map<SpecKey, PriorityQueue<DatabaseMatch>> getSpecKeyDBMatchMap() {
        return this.specKeyDBMatchMap;
    }

    public Map<Integer, PriorityQueue<DatabaseMatch>> getSpecIndexDBMatchMap() {
        return this.specIndexDBMatchMap;
    }

    public void setProgressObj(ProgressData progObj) {
        this.progress = progObj;
    }

    public ProgressData getProgressObj() {
        return this.progress;
    }

    public void setPrintStream(PrintStream out) {
        this.output = out == null ? System.out : out;
    }

    public PrintStream getPrintStream() {
        return this.output;
    }

    public void dbSearchCTermEnzymeNoMod(int numberOfAllowableNonEnzymaticTermini, boolean verbose) {
        this.dbSearch(numberOfAllowableNonEnzymaticTermini, 0, this.size, verbose);
    }

    public void dbSearchCTermEnzyme(int numberOfAllowableNonEnzymaticTermini, boolean verbose) {
        this.dbSearch(numberOfAllowableNonEnzymaticTermini, 0, this.size, verbose);
    }

    public void dbSearchNTermEnzyme(int numberOfAllowableNonEnzymaticTermini, boolean verbose) {
        this.dbSearch(numberOfAllowableNonEnzymaticTermini, 0, this.size, verbose);
    }

    public void dbSearchNoEnzyme(boolean verbose) {
        this.dbSearch(2, 0, this.size, verbose);
    }

    public void dbSearch(int numberOfAllowableNonEnzymaticTermini) {
        this.dbSearch(numberOfAllowableNonEnzymaticTermini, 0, this.size, true);
    }

    /*
     * Unable to fully structure code
     */
    public void dbSearch(int numberOfAllowableNonEnzymaticTermini, int fromIndex, int toIndex, boolean verbose) {
        if (this.progress == null) {
            this.progress = new ProgressData();
        }
        curSpecKeyDBMatchMap = new HashMap<SpecKey, PriorityQueue<DatabaseMatch>>();
        candidatePepGrid = this.enzyme != null && this.ignoreNTermMetCleavage == false ? new CandidatePeptideGridConsideringMetCleavage(this.aaSet, this.enzyme, this.maxPeptideLength, this.maxNumVariantsPerPeptide, this.maxMissedCleavages) : new CandidatePeptideGrid(this.aaSet, this.enzyme, this.maxPeptideLength, this.maxNumVariantsPerPeptide, this.maxMissedCleavages);
        peptideLengthIndex = 2147482647;
        enzymaticSearch = numberOfAllowableNonEnzymaticTermini != 2;
        neighboringAACleavageCredit = this.aaSet.getNeighboringAACleavageCredit();
        neighboringAACleavagePenalty = this.aaSet.getNeighboringAACleavagePenalty();
        peptideCleavageCredit = this.aaSet.getPeptideCleavageCredit();
        peptideCleavagePenalty = this.aaSet.getPeptideCleavagePenalty();
        containsCTermMod = this.aaSet.containsCTermModification();
        try {
            indices = new DataInputStream(new BufferedInputStream(new FileInputStream(this.sa.getIndexFile())));
            indices.skip(8 + 4 * fromIndex);
            nlcps = new DataInputStream(new BufferedInputStream(new FileInputStream(this.sa.getNeighboringLcpFile())));
            nlcps.skip(8 + fromIndex);
            sequence = this.sa.getSequence();
            isProteinNTerm = true;
            nTermCleavageScore = 0;
            numNonEnzTermini = 0;
            numIndices = toIndex - fromIndex;
            prevMatchList = new MatchList[this.maxPeptideLength + 2];
            block2: for (bufferIndex = 0; bufferIndex < numIndices; ++bufferIndex) {
                if (verbose && bufferIndex % 2000000 == 0) {
                    this.output.print(this.threadName + ": Database search progress... ");
                    this.output.format("%.1f%% complete\n", new Object[]{Float.valueOf((float)bufferIndex / (float)numIndices * 100.0f)});
                }
                this.progress.report(bufferIndex, numIndices);
                isExtensionAtTheSameIndex = false;
                index = indices.readInt();
                lcp = nlcps.readByte();
                if (bufferIndex == 0) {
                    lcp = 0;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                for (peptideLength = this.minPeptideLength; peptideLength < prevMatchList.length; ++peptideLength) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (lcp >= peptideLength + 2) {
                        if (prevMatchList[peptideLength] == null) continue;
                        for (DatabaseMatch m : prevMatchList[peptideLength]) {
                            m.addIndex(index);
                        }
                        continue;
                    }
                    if (lcp == peptideLength + 1) {
                        if (prevMatchList[peptideLength] == null) continue;
                        for (DatabaseMatch m : prevMatchList[peptideLength]) {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            if (!m.isProteinCTerm() || this.enzyme == null || this.enzyme.isNTerm() || numberOfAllowableNonEnzymaticTermini == 2) {
                                m.addIndex(index);
                                continue;
                            }
                            pre = sequence.getCharAt(index);
                            if (numberOfAllowableNonEnzymaticTermini == 1 && this.enzyme.isCleavable(pre)) {
                                m.addIndex(index);
                                continue;
                            }
                            cTermResidue = sequence.getCharAt(index + peptideLength);
                            if (this.enzyme.isCleavable(cTermResidue)) {
                                m.addIndex(index);
                                continue;
                            }
                            post = sequence.getCharAt(index + peptideLength + 1);
                            if (post != '_') continue;
                            m.addIndex(index);
                        }
                        continue;
                    }
                    prevMatchList[peptideLength] = null;
                }
                if (lcp >= peptideLengthIndex + 2 || lcp == peptideLengthIndex + 1 && (this.enzyme == null || this.enzyme.isCTerm())) continue;
                if (lcp == 0) {
                    precedingAA = sequence.getCharAt(index);
                    v0 = isProteinNTerm = precedingAA == '_';
                    if (this.enzyme == null || this.enzyme.isNTerm()) {
                        nTermCleavageScore = 0;
                    } else if (this.enzyme.isCTerm()) {
                        if (isProteinNTerm || this.enzyme.isCleavable(precedingAA)) {
                            nTermCleavageScore = neighboringAACleavageCredit;
                            if (enzymaticSearch) {
                                numNonEnzTermini = 0;
                            }
                        } else {
                            nTermCleavageScore = neighboringAACleavagePenalty;
                            if (enzymaticSearch && (numNonEnzTermini = 1) > numberOfAllowableNonEnzymaticTermini) {
                                peptideLengthIndex = 0;
                                continue;
                            }
                        }
                    }
                }
                peptideLengthIndex = lcp == 0 ? 1 : (this.enzyme != null && this.enzyme.isNTerm() ? (lcp > 1 ? lcp - 1 : 1) : (int)lcp);
                while (peptideLengthIndex <= this.maxPeptideLength && index + peptideLengthIndex < this.size - 1) {
                    block52: {
                        block55: {
                            block53: {
                                block54: {
                                    block49: {
                                        block51: {
                                            block50: {
                                                block48: {
                                                    if (Thread.currentThread().isInterrupted()) {
                                                        return;
                                                    }
                                                    residue = sequence.getCharAt(index + peptideLengthIndex);
                                                    isProteinCTerm = false;
                                                    if (peptideLengthIndex != 1) break block48;
                                                    if (this.enzyme != null && this.enzyme.isNTerm()) {
                                                        if (isProteinNTerm || this.enzyme.isCleavable(residue)) {
                                                            nTermCleavageScore = peptideCleavageCredit;
                                                            if (enzymaticSearch) {
                                                                numNonEnzTermini = 0;
                                                            }
                                                        } else {
                                                            nTermCleavageScore = peptideCleavagePenalty;
                                                            if (enzymaticSearch && (numNonEnzTermini = 1) > numberOfAllowableNonEnzymaticTermini) continue block2;
                                                        }
                                                    }
                                                    if (isProteinNTerm != false ? candidatePepGrid.addProtNTermResidue(residue) == false : candidatePepGrid.addNTermResidue(residue) == false) {
                                                        continue block2;
                                                    }
                                                    break block49;
                                                }
                                                if (containsCTermMod) break block50;
                                                if (!candidatePepGrid.addResidue(peptideLengthIndex, residue)) {
                                                    continue block2;
                                                }
                                                break block49;
                                            }
                                            if (peptideLengthIndex >= this.minPeptideLength) break block51;
                                            if (!candidatePepGrid.addResidue(peptideLengthIndex, residue)) {
                                                continue block2;
                                            }
                                            break block52;
                                        }
                                        if (isExtensionAtTheSameIndex && peptideLengthIndex > this.minPeptideLength) {
                                            candidatePepGrid.addResidue(peptideLengthIndex - 1, sequence.getCharAt(index + peptideLengthIndex - 1));
                                        }
                                        if (!(success = (isProteinCTerm = sequence.getCharAt(index + peptideLengthIndex + 1) == '_') != false ? candidatePepGrid.addProtCTermResidue(peptideLengthIndex, residue) : candidatePepGrid.addCTermResidue(peptideLengthIndex, residue))) continue block2;
                                    }
                                    if (peptideLengthIndex < this.minPeptideLength) break block52;
                                    cTermCleavageScore = 0;
                                    if (this.enzyme == null) ** GOTO lbl-1000
                                    cTermNeighboringResidue = sequence.getCharAt(index + peptideLengthIndex + 1);
                                    v1 = isProteinCTerm = cTermNeighboringResidue == '_';
                                    if (!this.enzyme.isCTerm()) break block53;
                                    if (!this.enzyme.isCleavable(residue)) break block54;
                                    cTermCleavageScore = peptideCleavageCredit;
                                    ** GOTO lbl-1000
                                }
                                cTermCleavageScore = peptideCleavagePenalty;
                                if (isProteinCTerm || numNonEnzTermini + 1 <= numberOfAllowableNonEnzymaticTermini) ** GOTO lbl-1000
                                isExtensionAtTheSameIndex = true;
                                break block52;
                            }
                            if (!this.enzyme.isNTerm()) ** GOTO lbl-1000
                            if (!isProteinCTerm && !this.enzyme.isCleavable(cTermNeighboringResidue)) break block55;
                            cTermCleavageScore = neighboringAACleavageCredit;
                            ** GOTO lbl-1000
                        }
                        cTermCleavageScore = neighboringAACleavagePenalty;
                        if (numNonEnzTermini + 1 > numberOfAllowableNonEnzymaticTermini) {
                            isExtensionAtTheSameIndex = true;
                        } else lbl-1000:
                        // 6 sources

                        {
                            cleavageScore = nTermCleavageScore + cTermCleavageScore;
                            for (j = 0; j < candidatePepGrid.size(); ++j) {
                                if (Thread.currentThread().isInterrupted()) {
                                    return;
                                }
                                if (candidatePepGrid.gridIsOverMaxMissedCleavages(j)) continue;
                                theoPeptideMass = candidatePepGrid.getPeptideMass(j);
                                nominalPeptideMass = candidatePepGrid.getNominalPeptideMass(j);
                                tolDaLeft = this.specScanner.getLeftPrecursorMassTolerance().getToleranceAsDa(theoPeptideMass);
                                tolDaRight = this.specScanner.getRightPrecursorMassTolerance().getToleranceAsDa(theoPeptideMass);
                                leftThr = theoPeptideMass - tolDaLeft;
                                rightThr = theoPeptideMass + tolDaRight;
                                if (leftThr < 1.0 || rightThr < 1.0 || (matchedSpecKeyList = this.specScanner.getPepMassSpecKeyMap().subMap(leftThr, rightThr).values()).size() <= 0 || (pepLength = (isNTermMetCleaved = candidatePepGrid.isNTermMetCleaved(j)) == false ? peptideLengthIndex : peptideLengthIndex - 1) < this.minPeptideLength) continue;
                                for (SpecKey specKey : matchedSpecKeyList) {
                                    if (Thread.currentThread().isInterrupted()) {
                                        return;
                                    }
                                    scorer = this.specScanner.getSpecKeyScorerMap().get(specKey);
                                    score = cleavageScore + scorer.getScore(candidatePepGrid.getPRMGrid(j), candidatePepGrid.getNominalPRMGrid(j), 1, pepLength + 1, candidatePepGrid.getNumMods(j));
                                    prevMatchQueue = (PriorityQueue<DatabaseMatch>)curSpecKeyDBMatchMap.get(specKey);
                                    if (prevMatchQueue == null) {
                                        prevMatchQueue = new PriorityQueue<DatabaseMatch>();
                                        curSpecKeyDBMatchMap.put(specKey, prevMatchQueue);
                                    }
                                    if (prevMatchQueue.size() < this.numPeptidesPerSpec || score == ((DatabaseMatch)prevMatchQueue.peek()).getScore()) {
                                        dbMatch = new DatabaseMatch(index, (byte)(pepLength + 2), score, theoPeptideMass, nominalPeptideMass, specKey.getCharge(), candidatePepGrid.getPeptideSeq(j), scorer.getActivationMethodArr()).setProteinNTerm(isProteinNTerm).setProteinCTerm(isProteinCTerm);
                                        dbMatch.setNTermMetCleaved(isNTermMetCleaved);
                                        prevMatchQueue.add(dbMatch);
                                        if (prevMatchList[peptideLengthIndex] == null) {
                                            prevMatchList[peptideLengthIndex] = new MatchList();
                                        }
                                        prevMatchList[peptideLengthIndex].add(dbMatch);
                                        continue;
                                    }
                                    if (prevMatchQueue.size() < this.numPeptidesPerSpec || score <= (worstScore = ((DatabaseMatch)prevMatchQueue.peek()).getScore())) continue;
                                    removed = new ArrayList<DatabaseMatch>();
                                    while (!prevMatchQueue.isEmpty() && ((DatabaseMatch)prevMatchQueue.peek()).getScore() == worstScore) {
                                        removed.add((DatabaseMatch)prevMatchQueue.poll());
                                    }
                                    dbMatch = new DatabaseMatch(index, (byte)(pepLength + 2), score, theoPeptideMass, nominalPeptideMass, specKey.getCharge(), candidatePepGrid.getPeptideSeq(j), scorer.getActivationMethodArr()).setProteinNTerm(isProteinNTerm).setProteinCTerm(isProteinCTerm);
                                    dbMatch.setNTermMetCleaved(isNTermMetCleaved);
                                    prevMatchQueue.add(dbMatch);
                                    if (prevMatchQueue.size() < this.numPeptidesPerSpec) {
                                        for (DatabaseMatch m : removed) {
                                            prevMatchQueue.add(m);
                                        }
                                    }
                                    if (prevMatchList[peptideLengthIndex] == null) {
                                        prevMatchList[peptideLengthIndex] = new MatchList();
                                    }
                                    prevMatchList[peptideLengthIndex].add(dbMatch);
                                }
                            }
                            isExtensionAtTheSameIndex = true;
                        }
                    }
                    ++peptideLengthIndex;
                }
            }
            this.addDBMatches(curSpecKeyDBMatchMap);
            indices.close();
            nlcps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void computeSpecEValue(boolean storeScoreDist) {
        this.computeSpecEValue(storeScoreDist, 0, this.specScanner.getSpecKeyList().size());
    }

    public void computeSpecEValue(boolean storeScoreDist, int fromIndex, int toIndex) {
        if (this.progress == null) {
            this.progress = new ProgressData();
        }
        List<SpecKey> specKeyList = this.specScanner.getSpecKeyList().subList(fromIndex, toIndex);
        int numSpecs = toIndex - fromIndex;
        int numProcessedSpecs = 0;
        for (SpecKey specKey : specKeyList) {
            int minPeptideMassIndex;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (++numProcessedSpecs % 1000 == 0) {
                this.output.print(this.threadName + ": Computing spectral E-values... ");
                this.output.format("%.1f%% complete\n", Float.valueOf((float)numProcessedSpecs / (float)numSpecs * 100.0f));
            }
            this.progress.report(numProcessedSpecs, numSpecs);
            PriorityQueue<DatabaseMatch> matchQueue = this.specKeyDBMatchMap.get(specKey);
            if (matchQueue == null) continue;
            int specIndex = specKey.getSpecIndex();
            boolean useProtNTerm = false;
            boolean useProtCTerm = false;
            int minScore = Integer.MAX_VALUE;
            for (DatabaseMatch m : matchQueue) {
                if (m.isProteinNTerm()) {
                    useProtNTerm = true;
                }
                if (m.isProteinCTerm()) {
                    useProtCTerm = true;
                }
                if (m.getScore() >= minScore) continue;
                minScore = m.getScore();
            }
            GeneratingFunctionGroup<NominalMass> gf = new GeneratingFunctionGroup<NominalMass>();
            SimpleDBSearchScorer<NominalMass> scoredSpec = this.specScanner.getSpecKeyScorerMap().get(specKey);
            float peptideMass = scoredSpec.getPrecursorPeak().getMass() - 18.010565f;
            int nominalPeptideMass = NominalMass.toNominalMass(peptideMass);
            int minNominalPeptideMass = nominalPeptideMass - this.specScanner.getMaxIsotopeError();
            int maxNominalPeptideMass = nominalPeptideMass - this.specScanner.getMinIsotopeError();
            float tolDaLeft = this.specScanner.getLeftPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            float tolDaRight = this.specScanner.getRightPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            int maxPeptideMassIndex = maxNominalPeptideMass + Math.round(tolDaLeft - 0.4999f);
            for (int peptideMassIndex = minPeptideMassIndex = minNominalPeptideMass - Math.round(tolDaRight - 0.4999f); peptideMassIndex <= maxPeptideMassIndex; ++peptideMassIndex) {
                FlexAminoAcidGraph graph = new FlexAminoAcidGraph(this.aaSet, peptideMassIndex, this.enzyme, scoredSpec, useProtNTerm, useProtCTerm);
                GeneratingFunction<NominalMass> gfi = new GeneratingFunction<NominalMass>(graph).doNotBacktrack().doNotCalcNumber();
                gfi.setUpScoreThreshold(minScore);
                gf.registerGF((NominalMass)graph.getPMNode(), gfi);
            }
            boolean isGFComputed = gf.computeGeneratingFunction();
            for (DatabaseMatch match : matchQueue) {
                if (!isGFComputed || match.getNominalPeptideMass() < minPeptideMassIndex || match.getNominalPeptideMass() > maxPeptideMassIndex) {
                    match.setDeNovoScore(Integer.MIN_VALUE);
                    match.setSpecProb(1.0);
                    continue;
                }
                match.setDeNovoScore(gf.getMaxScore() - 1);
                int score = match.getScore();
                double specProb = gf.getSpectralProbability(score);
                assert (specProb > 0.0) : specIndex + ": " + match.getDeNovoScore() + " " + match.getScore() + " " + specProb;
                match.setSpecProb(specProb);
                if (!storeScoreDist) continue;
                match.setScoreDist(gf.getScoreDist());
            }
        }
    }

    public synchronized void generateSpecIndexDBMatchMap() {
        Iterator<Map.Entry<SpecKey, PriorityQueue<DatabaseMatch>>> itr = this.specKeyDBMatchMap.entrySet().iterator();
        int numPeptidesPerSpec = this.numPeptidesPerSpec;
        while (itr.hasNext()) {
            Map.Entry<SpecKey, PriorityQueue<DatabaseMatch>> entry = itr.next();
            SpecKey specKey = entry.getKey();
            PriorityQueue<DatabaseMatch> matchQueue = entry.getValue();
            if (matchQueue == null || matchQueue.size() == 0) continue;
            HashMap<String, DatabaseMatch> pepSeqMap = new HashMap<String, DatabaseMatch>();
            for (DatabaseMatch m : matchQueue) {
                String pepSeq = m.getPepSeq();
                String key = pepSeq + m.getScore();
                DatabaseMatch existingMatch = (DatabaseMatch)pepSeqMap.get(key);
                if (existingMatch == null) {
                    pepSeqMap.put(key, m);
                    continue;
                }
                Iterator iterator = m.getIndices().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    existingMatch.addIndex(index);
                }
            }
            matchQueue = new PriorityQueue(pepSeqMap.values());
            pepSeqMap = null;
            int specIndex = specKey.getSpecIndex();
            PriorityQueue<Match> existingQueue = this.specIndexDBMatchMap.get(specIndex);
            if (existingQueue == null) {
                existingQueue = new PriorityQueue<Match>(numPeptidesPerSpec, new Match.SpecProbComparator());
                this.specIndexDBMatchMap.put(specIndex, existingQueue);
            }
            for (DatabaseMatch match : matchQueue) {
                double curEValue = match.getSpecEValue();
                if (existingQueue.size() < numPeptidesPerSpec || curEValue == ((DatabaseMatch)existingQueue.peek()).getSpecEValue()) {
                    existingQueue.add(match);
                    continue;
                }
                double prevEValue = ((DatabaseMatch)existingQueue.peek()).getSpecEValue();
                if (!(curEValue < prevEValue)) continue;
                while (!existingQueue.isEmpty() && ((DatabaseMatch)existingQueue.peek()).getSpecEValue() == prevEValue) {
                    existingQueue.poll();
                }
                existingQueue.add(match);
            }
        }
    }

    public synchronized void addResultsToList(List<MSGFPlusMatch> resultList) {
        for (Map.Entry<Integer, PriorityQueue<DatabaseMatch>> entry : this.specIndexDBMatchMap.entrySet()) {
            resultList.add(new MSGFPlusMatch(entry.getKey(), entry.getValue()));
        }
    }

    public void addAdditionalFeatures() {
        for (Map.Entry<Integer, PriorityQueue<DatabaseMatch>> entry : this.specIndexDBMatchMap.entrySet()) {
            int specIndex = entry.getKey();
            PriorityQueue<DatabaseMatch> matchQueue = entry.getValue();
            if (matchQueue == null || matchQueue.size() == 0) continue;
            Spectrum spec = this.specScanner.getSpectraAccessor().getSpectrumBySpecIndex(specIndex);
            for (DatabaseMatch match : matchQueue) {
                NewRankScorer scorer = this.specScanner.getRankScorer(new SpecKey(specIndex, match.getCharge()));
                if (scorer == null) continue;
                spec.setCharge(match.getCharge());
                PSMFeatureFinder addFeatures = new PSMFeatureFinder(spec, this.aaSet.getPeptide(match.getPepSeq()), scorer);
                for (Pair<String, String> feature : addFeatures.getAllFeatures()) {
                    match.addAdditionalFeature(feature.getFirst(), feature.getSecond());
                }
            }
        }
    }

    public synchronized void addDBSearchResults(List<MSGFDBResultGenerator.DBMatch> gen, String specFileName, boolean replicateMergedResults) {
        HashMap<Integer, PriorityQueue<Match>> specIndexDBMatchMap = new HashMap<Integer, PriorityQueue<Match>>();
        for (Map.Entry<SpecKey, PriorityQueue<DatabaseMatch>> entry : this.specKeyDBMatchMap.entrySet()) {
            SpecKey specKey = entry.getKey();
            PriorityQueue<DatabaseMatch> matchQueue = entry.getValue();
            if (matchQueue == null || matchQueue.size() == 0) continue;
            int specIndex = specKey.getSpecIndex();
            PriorityQueue<Match> existingQueue = (PriorityQueue<Match>)specIndexDBMatchMap.get(specIndex);
            if (existingQueue == null) {
                existingQueue = new PriorityQueue<Match>(this.numPeptidesPerSpec, new Match.SpecProbComparator());
                specIndexDBMatchMap.put(specIndex, existingQueue);
            }
            for (DatabaseMatch match : matchQueue) {
                if (existingQueue.size() < this.numPeptidesPerSpec) {
                    existingQueue.add(match);
                    continue;
                }
                if (existingQueue.size() < this.numPeptidesPerSpec || !(match.getSpecEValue() < ((DatabaseMatch)existingQueue.peek()).getSpecEValue())) continue;
                existingQueue.poll();
                existingQueue.add(match);
            }
        }
        for (Map.Entry entry : specIndexDBMatchMap.entrySet()) {
            ArrayList matchList;
            int specIndex = (Integer)entry.getKey();
            PriorityQueue matchQueue = (PriorityQueue)entry.getValue();
            if (matchQueue == null || (matchList = new ArrayList(matchQueue)).size() == 0) continue;
            for (int i = matchList.size() - 1; i >= 0; --i) {
                DatabaseMatch match;
                match = (DatabaseMatch)matchList.get(i);
                if (match.getDeNovoScore() < this.minDeNovoScore) continue;
                int index = match.getIndex();
                int length = match.getLength();
                int charge = match.getCharge();
                String peptideStr = match.getPepSeq();
                if (peptideStr == null) {
                    peptideStr = this.sa.getSequence().getSubsequence(index + 1, index + length - 1);
                }
                Peptide pep = this.aaSet.getPeptide(peptideStr);
                String annotationStr = this.sa.getSequence().getCharAt(index) + "." + pep + "." + this.sa.getSequence().getCharAt(index + length - 1);
                SimpleDBSearchScorer<NominalMass> scorer = this.specScanner.getSpecKeyScorerMap().get(new SpecKey(specIndex, charge));
                ArrayList<Integer> specIndexList = this.specScanner.getSpecKey(specIndex, charge).getSpecIndexList();
                if (specIndexList == null) {
                    specIndexList = new ArrayList();
                    specIndexList.add(specIndex);
                }
                float expMass = scorer.getPrecursorPeak().getMass();
                float peptideMass = match.getPeptideMass();
                float pmError = Float.MAX_VALUE;
                float theoMass = peptideMass + 18.010565f;
                for (int delta = this.specScanner.getMinIsotopeError(); delta <= this.specScanner.getMaxIsotopeError(); ++delta) {
                    float error = expMass - theoMass - 1.0033548f * (float)delta;
                    if (!(Math.abs(error) < Math.abs(pmError))) continue;
                    pmError = error;
                }
                if (this.specScanner.getRightPrecursorMassTolerance().isTolerancePPM()) {
                    pmError = pmError / theoMass * 1000000.0f;
                }
                String protein = this.sa.getAnnotation(index + 1);
                int score = match.getScore();
                double specProb = match.getSpecEValue();
                int numPeptides = this.sa.getNumDistinctPeptides(peptideStr.length() + 1);
                double pValue = MSGFDBResultGenerator.DBMatch.getPValue(specProb, numPeptides);
                String specProbStr = specProb < 1.1754943508222875E-38 ? String.valueOf(specProb) : String.valueOf((float)specProb);
                String pValueStr = specProb < 1.1754943508222875E-38 ? String.valueOf(pValue) : String.valueOf((float)pValue);
                if (!replicateMergedResults) {
                    StringBuffer specIndexStrBuf = new StringBuffer();
                    StringBuffer scanNumStrBuf = new StringBuffer();
                    StringBuffer actMethodStrBuf = new StringBuffer();
                    specIndexStrBuf.append(specIndexList.get(0));
                    actMethodStrBuf.append(scorer.getActivationMethodArr()[0]);
                    scanNumStrBuf.append(scorer.getScanNumArr()[0]);
                    for (int j = 1; j < scorer.getActivationMethodArr().length; ++j) {
                        specIndexStrBuf.append("/" + specIndexList.get(j));
                        scanNumStrBuf.append("/" + scorer.getScanNumArr()[j]);
                        actMethodStrBuf.append("/" + scorer.getActivationMethodArr()[j]);
                    }
                    String resultStr = specFileName + "\t" + specIndexStrBuf.toString() + "\t" + scanNumStrBuf.toString() + "\t" + actMethodStrBuf.toString() + "\t" + scorer.getPrecursorPeak().getMz() + "\t" + pmError + "\t" + match.getCharge() + "\t" + annotationStr + "\t" + protein + "\t" + match.getDeNovoScore() + "\t" + score + "\t" + specProbStr + "\t" + pValueStr;
                    MSGFDBResultGenerator.DBMatch dbMatch = new MSGFDBResultGenerator.DBMatch(specProb, numPeptides, resultStr, match.getScoreDist());
                    gen.add(dbMatch);
                    continue;
                }
                for (int j = 0; j < scorer.getActivationMethodArr().length; ++j) {
                    String resultStr = specFileName + "\t" + specIndexList.get(j) + "\t" + scorer.getScanNumArr()[j] + "\t" + scorer.getActivationMethodArr()[j] + "\t" + scorer.getPrecursorPeak().getMz() + "\t" + pmError + "\t" + match.getCharge() + "\t" + annotationStr + "\t" + protein + "\t" + match.getDeNovoScore() + "\t" + score + "\t" + specProbStr + "\t" + pValueStr;
                    MSGFDBResultGenerator.DBMatch dbMatch = new MSGFDBResultGenerator.DBMatch(specProb, numPeptides, resultStr, match.getScoreDist());
                    gen.add(dbMatch);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setAminoAcidProbabilities(String databaseFileName, AminoAcidSet aaSet) {
        void var8_14;
        String s;
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(databaseFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long[] aaCount = new long[128];
        while ((s = in.readLine()) != null) {
            if (s.startsWith(">")) continue;
            for (int i = 0; i < s.length(); ++i) {
                char residue = s.charAt(i);
                if (!Character.isLetter(residue)) continue;
                char c = residue;
                aaCount[c] = aaCount[c] + 1L;
            }
        }
        long totalAACount = 0L;
        for (AminoAcid aminoAcid : aaSet.getAAList(Modification.Location.Anywhere)) {
            if (aminoAcid.isModified()) continue;
            totalAACount += aaCount[aminoAcid.getResidue()];
        }
        boolean success = true;
        for (AminoAcid aa : aaSet.getAllAminoAcidArr()) {
            long count = aaCount[aa.getUnmodResidue()];
            if (count == 0L && AminoAcid.isStdAminoAcid(aa.getUnmodResidue())) {
                success = false;
                break;
            }
            aa.setProbability((float)count / (float)totalAACount);
        }
        boolean bl = false;
        while (var8_14 < 128) {
            if (!aaSet.contains((char)var8_14) && aaCount[var8_14] > 0L) {
                System.out.println("Warning: Sequence database contains " + aaCount[var8_14] + " counts of letter '" + (char)var8_14 + "', which does not correspond to an amino acid.");
            }
            ++var8_14;
        }
        if (!success) {
            System.out.println("Warning: database does not contain all standard amino acids. Probability 0.05 will be used for all amino acids.");
            for (AminoAcid aa : aaSet.getAllAminoAcidArr()) {
                aa.setProbability(0.05f);
            }
        }
    }
}

