/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.LibraryMatch;
import edu.ucsd.msjava.msdbsearch.Match;
import edu.ucsd.msjava.msdbsearch.ScoredSpectraMap;
import edu.ucsd.msjava.msgf.FlexAminoAcidGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.GeneratingFunctionGroup;
import edu.ucsd.msjava.msgf.MSGFDBResultGenerator;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msscorer.SimpleDBSearchScorer;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.SpecKey;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class LibraryScanner {
    private final int MAX_LIBRARY_PEPTIDE_LENGTH = 100;
    private double[] aaMass;
    private int[] intAAMass;
    private int numPeptidesPerSpec;
    private final ScoredSpectraMap specScanner;
    private Map<SpecKey, PriorityQueue<LibraryMatch>> specKeyDBMatchMap;
    private Map<Integer, PriorityQueue<LibraryMatch>> specIndexDBMatchMap;
    private int numPeptidesInLib = 0;
    private String threadName = "";
    private static HashMap<String, Double> modTable = new HashMap();
    private static HashMap<String, String> modResidueTable;
    private static AminoAcidSet aaSet;

    public LibraryScanner(ScoredSpectraMap specScanner, int numPeptidesPerSpec) {
        this.specScanner = specScanner;
        this.numPeptidesPerSpec = numPeptidesPerSpec;
        this.aaMass = new double[aaSet.getMaxResidue()];
        this.intAAMass = new int[aaSet.getMaxResidue()];
        for (int i = 0; i < this.aaMass.length; ++i) {
            this.aaMass[i] = -1.0;
            this.intAAMass[i] = -1;
        }
        for (AminoAcid aa : aaSet.getAllAminoAcidArr()) {
            this.aaMass[aa.getResidue()] = aa.getAccurateMass();
            this.intAAMass[aa.getResidue()] = aa.getNominalMass();
        }
        this.specKeyDBMatchMap = Collections.synchronizedMap(new HashMap());
        this.specIndexDBMatchMap = Collections.synchronizedMap(new HashMap());
    }

    public LibraryScanner setThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public synchronized void addDBMatches(Map<SpecKey, PriorityQueue<LibraryMatch>> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<SpecKey, PriorityQueue<LibraryMatch>> entry : map.entrySet()) {
            SpecKey specKey = entry.getKey();
            PriorityQueue<LibraryMatch> queue = this.specKeyDBMatchMap.get(entry.getKey());
            if (queue == null) {
                queue = new PriorityQueue();
                this.specKeyDBMatchMap.put(specKey, queue);
            }
            for (LibraryMatch match : entry.getValue()) {
                if (queue.size() < this.numPeptidesPerSpec) {
                    queue.add(match);
                    continue;
                }
                if (queue.size() < this.numPeptidesPerSpec || match.getScore() <= queue.peek().getScore()) continue;
                queue.poll();
                queue.add(match);
            }
        }
    }

    public void libSearch(String libFilePath, boolean verbose) {
        this.addDBMatches(this.libSearchPlain(libFilePath, true));
    }

    private Map<SpecKey, PriorityQueue<LibraryMatch>> libSearchPlain(String libFilePath, boolean verbose) {
        String s;
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(libFilePath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        HashMap<SpecKey, PriorityQueue<LibraryMatch>> curSpecKeyDBMatchMap = new HashMap<SpecKey, PriorityQueue<LibraryMatch>>();
        int numPeptides = 0;
        String pepStr = null;
        int pepLength = 0;
        int charge = -1;
        while ((s = in.readLine()) != null) {
            if (s.trim().length() == 0) continue;
            if (s.startsWith("Name:")) {
                if (++numPeptides % 100000 == 99999) {
                    System.out.print(this.threadName + ": Database search progress... ");
                    System.out.format("%dE5 peptides complete\n", numPeptides / 100000);
                }
                String[] token = s.split("\\s+");
                String name = token[1];
                charge = Integer.parseInt(name.substring(name.lastIndexOf(47) + 1));
                StringBuffer pepBuf = new StringBuffer();
                for (int i = 0; i < name.length(); ++i) {
                    if (!Character.isUpperCase(name.charAt(i))) continue;
                    pepBuf.append(name.charAt(i));
                }
                pepLength = pepBuf.length();
                pepStr = pepBuf.toString();
                continue;
            }
            if (!s.startsWith("Comment:")) continue;
            int numMods = -1;
            double[] modMass = new double[100];
            int[] nominalModMass = new int[100];
            String[] modResidues = new String[100];
            String protein = null;
            String[] token = s.split("\\s+");
            for (int i = 0; i < token.length; ++i) {
                String curToken = token[i];
                if (curToken.startsWith("Mods=")) {
                    String[] modToken = curToken.split("[=/]");
                    numMods = Integer.parseInt(modToken[1]);
                    for (int j = 2; j < modToken.length; ++j) {
                        double deltaMass;
                        String[] mod = modToken[j].split(",");
                        int location = Integer.parseInt(mod[0]);
                        if (location == -1) {
                            location = 0;
                        }
                        String modName = mod[2];
                        modMass[location + 1] = deltaMass = modTable.get(modName).doubleValue();
                        nominalModMass[location + 1] = NominalMass.toNominalMass((float)deltaMass);
                        modResidues[location + 1] = modResidueTable.get(modName);
                    }
                    continue;
                }
                if (!curToken.startsWith("Protein=")) continue;
                String[] protToken = curToken.split("[=/]");
                protein = protToken[2];
            }
            int[] nominalPRM = new int[100];
            double[] prm = new double[100];
            nominalPRM[0] = 0;
            prm[0] = 0.0;
            StringBuffer peptideOutput = new StringBuffer();
            for (int i = 0; i < pepLength; ++i) {
                char residue = pepStr.charAt(i);
                nominalPRM[i + 1] = nominalPRM[i] + this.intAAMass[residue] + nominalModMass[i + 1];
                prm[i + 1] = prm[i] + this.aaMass[residue] + modMass[i + 1];
                peptideOutput.append(pepStr.charAt(i) + (modResidues[i + 1] == null ? "" : modResidues[i + 1]));
            }
            float peptideMass = (float)prm[pepLength];
            int nominalPeptideMass = nominalPRM[pepLength];
            float tolDaLeft = this.specScanner.getLeftPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            float tolDaRight = this.specScanner.getRightPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            double leftThr = peptideMass - tolDaRight;
            double rightThr = peptideMass + tolDaLeft;
            Collection<SpecKey> matchedSpecKeyList = this.specScanner.getPepMassSpecKeyMap().subMap(leftThr, rightThr).values();
            for (SpecKey specKey : matchedSpecKeyList) {
                if (charge != specKey.getCharge()) continue;
                SimpleDBSearchScorer<NominalMass> scorer = this.specScanner.getSpecKeyScorerMap().get(specKey);
                int score = scorer.getScore(prm, nominalPRM, 1, pepLength + 1, numMods);
                PriorityQueue<LibraryMatch> prevMatchQueue = (PriorityQueue<LibraryMatch>)curSpecKeyDBMatchMap.get(specKey);
                if (prevMatchQueue == null) {
                    prevMatchQueue = new PriorityQueue<LibraryMatch>();
                    curSpecKeyDBMatchMap.put(specKey, prevMatchQueue);
                }
                if (prevMatchQueue.size() < this.numPeptidesPerSpec) {
                    prevMatchQueue.add(new LibraryMatch(score, peptideMass, nominalPeptideMass, charge, peptideOutput.toString(), protein));
                    continue;
                }
                if (prevMatchQueue.size() < this.numPeptidesPerSpec || score <= ((LibraryMatch)prevMatchQueue.peek()).getScore()) continue;
                prevMatchQueue.poll();
                prevMatchQueue.add(new LibraryMatch(score, peptideMass, nominalPeptideMass, charge, peptideOutput.toString(), protein));
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return curSpecKeyDBMatchMap;
    }

    private Map<SpecKey, PriorityQueue<LibraryMatch>> libSearch(String libFilePath, boolean isDecoy, boolean verbose) {
        String s;
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(libFilePath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        HashMap<SpecKey, PriorityQueue<LibraryMatch>> curSpecKeyDBMatchMap = new HashMap<SpecKey, PriorityQueue<LibraryMatch>>();
        int numPeptides = 0;
        while ((s = in.readLine()) != null) {
            if (!s.startsWith("Comment:")) continue;
            if (verbose && numPeptides > 0 && numPeptides % 100000 == 0) {
                System.out.print(this.threadName + ": Database search progress... ");
                System.out.format("%dE5 peptides complete\n", numPeptides / 100000);
            }
            String pepStr = null;
            int pepLength = 0;
            int charge = -1;
            int numMods = -1;
            double[] modMass = new double[100];
            int[] nominalModMass = new int[100];
            String[] modResidues = new String[100];
            String protein = null;
            String[] token = s.split("\\s+");
            for (int i = 0; i < token.length; ++i) {
                String curToken = token[i];
                if (curToken.startsWith("Fullname=")) {
                    String[] pepToken = curToken.split("[=./]");
                    pepStr = pepToken[2];
                    pepStr = pepStr.replaceAll("M\\(O\\)", "M");
                    pepLength = pepStr.length();
                    charge = Integer.parseInt(pepToken[4]);
                    if (!isDecoy) continue;
                    StringBuffer reversePepStr = new StringBuffer();
                    reversePepStr.append(pepStr.charAt(0));
                    for (int j = pepLength - 2; j >= 1; --j) {
                        reversePepStr.append(pepStr.charAt(j));
                    }
                    reversePepStr.append(pepStr.charAt(pepLength - 1));
                    pepStr = reversePepStr.toString();
                    continue;
                }
                if (curToken.startsWith("Mods=")) {
                    String[] modToken = curToken.split("[=/]");
                    numMods = Integer.parseInt(modToken[1]);
                    for (int j = 2; j < modToken.length; ++j) {
                        double deltaMass;
                        String[] mod = modToken[j].split(",");
                        int location = Integer.parseInt(mod[0]);
                        if (location == -1) {
                            location = 0;
                        }
                        if (isDecoy && location > 0 && location < pepLength - 1) {
                            location = pepLength - 1 - location;
                        }
                        String modName = mod[2];
                        modMass[location + 1] = deltaMass = modTable.get(modName).doubleValue();
                        nominalModMass[location + 1] = NominalMass.toNominalMass((float)deltaMass);
                        modResidues[location + 1] = modResidueTable.get(modName);
                    }
                    continue;
                }
                if (!curToken.startsWith("Protein=")) continue;
                String[] protToken = curToken.split("[=/]");
                protein = protToken[2];
                if (!isDecoy) continue;
                protein = "DECOY_" + protein;
            }
            ++numPeptides;
            int[] nominalPRM = new int[100];
            double[] prm = new double[100];
            nominalPRM[0] = 0;
            prm[0] = 0.0;
            StringBuffer peptideOutput = new StringBuffer();
            for (int i = 0; i < pepLength; ++i) {
                char residue = pepStr.charAt(i);
                nominalPRM[i + 1] = nominalPRM[i] + this.intAAMass[residue] + nominalModMass[i + 1];
                prm[i + 1] = prm[i] + this.aaMass[residue] + modMass[i + 1];
                peptideOutput.append(pepStr.charAt(i) + (modResidues[i + 1] == null ? "" : modResidues[i + 1]));
            }
            float peptideMass = (float)prm[pepLength];
            int nominalPeptideMass = nominalPRM[pepLength];
            float tolDaLeft = this.specScanner.getLeftPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            float tolDaRight = this.specScanner.getRightPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            double leftThr = peptideMass - tolDaRight;
            double rightThr = peptideMass + tolDaLeft;
            Collection<SpecKey> matchedSpecKeyList = this.specScanner.getPepMassSpecKeyMap().subMap(leftThr, rightThr).values();
            for (SpecKey specKey : matchedSpecKeyList) {
                if (charge != specKey.getCharge()) continue;
                SimpleDBSearchScorer<NominalMass> scorer = this.specScanner.getSpecKeyScorerMap().get(specKey);
                int score = scorer.getScore(prm, nominalPRM, 1, pepLength + 1, numMods);
                PriorityQueue<LibraryMatch> prevMatchQueue = (PriorityQueue<LibraryMatch>)curSpecKeyDBMatchMap.get(specKey);
                if (prevMatchQueue == null) {
                    prevMatchQueue = new PriorityQueue<LibraryMatch>();
                    curSpecKeyDBMatchMap.put(specKey, prevMatchQueue);
                }
                if (prevMatchQueue.size() < this.numPeptidesPerSpec) {
                    prevMatchQueue.add(new LibraryMatch(score, peptideMass, nominalPeptideMass, charge, peptideOutput.toString(), protein));
                    continue;
                }
                if (prevMatchQueue.size() < this.numPeptidesPerSpec || score <= ((LibraryMatch)prevMatchQueue.peek()).getScore()) continue;
                prevMatchQueue.poll();
                prevMatchQueue.add(new LibraryMatch(score, peptideMass, nominalPeptideMass, charge, peptideOutput.toString(), protein));
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return curSpecKeyDBMatchMap;
    }

    public void computeSpecProb() {
        this.computeSpecProb(0, this.specScanner.getSpecKeyList().size());
    }

    public void computeSpecProb(int fromIndex, int toIndex) {
        List<SpecKey> specKeyList = this.specScanner.getSpecKeyList().subList(fromIndex, toIndex);
        int numSpecs = toIndex - fromIndex;
        int numProcessedSpecs = 0;
        for (SpecKey specKey : specKeyList) {
            int minPeptideMassIndex;
            PriorityQueue<LibraryMatch> matchQueue;
            if (++numProcessedSpecs % 1000 == 0) {
                System.out.print(this.threadName + ": Computing spectral probabilities... ");
                System.out.format("%.1f%% complete\n", Float.valueOf((float)numProcessedSpecs / (float)numSpecs * 100.0f));
            }
            if ((matchQueue = this.specKeyDBMatchMap.get(specKey)) == null) continue;
            int specIndex = specKey.getSpecIndex();
            int minScore = Integer.MAX_VALUE;
            for (LibraryMatch m : matchQueue) {
                if (m.getScore() >= minScore) continue;
                minScore = m.getScore();
            }
            GeneratingFunctionGroup<NominalMass> gf = new GeneratingFunctionGroup<NominalMass>();
            SimpleDBSearchScorer<NominalMass> scoredSpec = this.specScanner.getSpecKeyScorerMap().get(specKey);
            float peptideMass = scoredSpec.getPrecursorPeak().getMass() - 18.010565f;
            int nominalPeptideMass = NominalMass.toNominalMass(peptideMass);
            int minNominalPeptideMass = nominalPeptideMass + this.specScanner.getMinIsotopeError();
            int maxNominalPeptideMass = nominalPeptideMass + this.specScanner.getMaxIsotopeError();
            float tolDaLeft = this.specScanner.getLeftPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            float tolDaRight = this.specScanner.getRightPrecursorMassTolerance().getToleranceAsDa(peptideMass);
            int maxPeptideMassIndex = minNominalPeptideMass + Math.round(tolDaLeft - 0.4999f);
            for (int peptideMassIndex = minPeptideMassIndex = maxNominalPeptideMass - Math.round(tolDaRight - 0.4999f); peptideMassIndex <= maxPeptideMassIndex; ++peptideMassIndex) {
                FlexAminoAcidGraph graph = new FlexAminoAcidGraph(aaSet, peptideMassIndex, null, scoredSpec, true, false);
                GeneratingFunction<NominalMass> gfi = new GeneratingFunction<NominalMass>(graph).doNotBacktrack().doNotCalcNumber();
                gfi.setUpScoreThreshold(minScore);
                gf.registerGF((NominalMass)graph.getPMNode(), gfi);
            }
            boolean isGFComputed = gf.computeGeneratingFunction();
            for (LibraryMatch match : matchQueue) {
                if (!isGFComputed || match.getNominalPeptideMass() < minPeptideMassIndex || match.getNominalPeptideMass() > maxPeptideMassIndex) {
                    match.setDeNovoScore(Integer.MIN_VALUE);
                    match.setSpecProb(1.0);
                    continue;
                }
                match.setDeNovoScore(gf.getMaxScore() - 1);
                int score = match.getScore();
                double specProb = gf.getSpectralProbability(score);
                assert (specProb > 0.0) : specIndex + ": " + match.getDeNovoScore() + " " + match.getScore() + " " + specProb;
                match.setSpecProb(specProb);
            }
        }
    }

    public synchronized void addLibSearchResults(List<MSGFDBResultGenerator.DBMatch> gen, String specFileName) {
        for (Map.Entry<SpecKey, PriorityQueue<LibraryMatch>> entry : this.specKeyDBMatchMap.entrySet()) {
            SpecKey specKey = entry.getKey();
            PriorityQueue<LibraryMatch> matchQueue = entry.getValue();
            if (matchQueue == null || matchQueue.size() == 0) continue;
            int specIndex = specKey.getSpecIndex();
            PriorityQueue<Match> existingQueue = this.specIndexDBMatchMap.get(specIndex);
            if (existingQueue == null) {
                existingQueue = new PriorityQueue<Match>(this.numPeptidesPerSpec, new Match.SpecProbComparator());
                this.specIndexDBMatchMap.put(specIndex, existingQueue);
            }
            for (LibraryMatch match : matchQueue) {
                if (existingQueue.size() < this.numPeptidesPerSpec) {
                    existingQueue.add(match);
                    continue;
                }
                if (existingQueue.size() < this.numPeptidesPerSpec || !(match.getSpecEValue() < ((LibraryMatch)existingQueue.peek()).getSpecEValue())) continue;
                existingQueue.poll();
                existingQueue.add(match);
            }
        }
        for (Map.Entry<Integer, PriorityQueue<LibraryMatch>> entry : this.specIndexDBMatchMap.entrySet()) {
            ArrayList<LibraryMatch> matchList;
            int specIndex = entry.getKey();
            PriorityQueue<LibraryMatch> matchQueue = entry.getValue();
            if (matchQueue == null || (matchList = new ArrayList<LibraryMatch>(matchQueue)).size() == 0) continue;
            for (int i = matchList.size() - 1; i >= 0; --i) {
                LibraryMatch match;
                match = matchList.get(i);
                if (match.getDeNovoScore() < 0) continue;
                int charge = match.getCharge();
                String annotationStr = match.getPepSeq();
                SimpleDBSearchScorer<NominalMass> scorer = this.specScanner.getSpecKeyScorerMap().get(new SpecKey(specIndex, charge));
                ArrayList<Integer> specIndexList = this.specScanner.getSpecKey(specIndex, charge).getSpecIndexList();
                if (specIndexList == null) {
                    specIndexList = new ArrayList();
                    specIndexList.add(specIndex);
                }
                float expMass = scorer.getPrecursorPeak().getMass();
                float peptideMass = match.getPeptideMass();
                float theoMass = peptideMass + 18.010565f;
                float pmError = Float.MAX_VALUE;
                int deltaNominalMass = 0;
                for (int delta = this.specScanner.getMinIsotopeError(); delta <= this.specScanner.getMaxIsotopeError(); ++delta) {
                    float error = expMass - theoMass - 1.0033548f * (float)delta;
                    if (!(Math.abs(error) < Math.abs(pmError))) continue;
                    pmError = error;
                    deltaNominalMass = delta;
                }
                if (this.specScanner.getRightPrecursorMassTolerance().isTolerancePPM()) {
                    pmError = pmError / theoMass * 1000000.0f;
                }
                String protein = match.getProtein();
                int score = match.getScore();
                double specProb = match.getSpecEValue();
                double pValue = MSGFDBResultGenerator.DBMatch.getPValue(specProb, this.numPeptidesInLib);
                String specProbStr = specProb < 1.1754943508222875E-38 ? String.valueOf(specProb) : String.valueOf((float)specProb);
                String pValueStr = specProb < 1.1754943508222875E-38 ? String.valueOf(pValue) : String.valueOf((float)pValue);
                StringBuffer specIndexStrBuf = new StringBuffer();
                StringBuffer scanNumStrBuf = new StringBuffer();
                StringBuffer actMethodStrBuf = new StringBuffer();
                specIndexStrBuf.append(specIndexList.get(0));
                actMethodStrBuf.append(scorer.getActivationMethodArr()[0]);
                scanNumStrBuf.append(scorer.getScanNumArr()[0]);
                for (int j = 1; j < scorer.getActivationMethodArr().length; ++j) {
                    specIndexStrBuf.append("/" + specIndexList.get(j));
                    scanNumStrBuf.append("/" + scorer.getScanNumArr()[j]);
                    actMethodStrBuf.append("/" + scorer.getActivationMethodArr()[j]);
                }
                String resultStr = specFileName + "\t" + specIndexStrBuf.toString() + "\t" + scanNumStrBuf.toString() + "\t" + actMethodStrBuf.toString() + "\t" + scorer.getPrecursorPeak().getMz() + "\t" + pmError + "\t" + match.getCharge() + "\t" + annotationStr + "\t" + protein + "\t" + match.getDeNovoScore() + "\t" + score + "\t" + specProbStr + "\t" + pValueStr;
                MSGFDBResultGenerator.DBMatch dbMatch = new MSGFDBResultGenerator.DBMatch(specProb, this.numPeptidesInLib, resultStr, match.getScoreDist());
                gen.add(dbMatch);
            }
        }
    }

    static {
        modTable.put("Carbamidomethyl", 0.0);
        modTable.put("Pyro-carbamidomethyl", Modification.PyroCarbamidomethyl.getAccurateMass());
        modTable.put("Oxidation", Modification.Oxidation.getAccurateMass());
        modTable.put("Acetyl", Modification.Acetyl.getAccurateMass());
        modTable.put("Gln->pyro-Glu", Modification.PyroGluQ.getAccurateMass());
        modTable.put("Glu->pyro-Glu", Modification.PyroGluE.getAccurateMass());
        modResidueTable = new HashMap();
        modResidueTable.put("Carbamidomethyl", "");
        modResidueTable.put("Pyro-carbamidomethyl", String.format("%.3f", Float.valueOf(Modification.PyroCarbamidomethyl.getMass())));
        modResidueTable.put("Oxidation", String.format("+%.3f", Float.valueOf(Modification.Oxidation.getMass())));
        modResidueTable.put("Acetyl", String.format("+%.3f", Float.valueOf(Modification.Acetyl.getMass())));
        modResidueTable.put("Gln->pyro-Glu", String.format("%.3f", Float.valueOf(Modification.PyroGluQ.getMass())));
        modResidueTable.put("Glu->pyro-Glu", String.format("%.3f", Float.valueOf(Modification.PyroGluE.getMass())));
        ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
        mods.add(new Modification.Instance(Modification.Carbamidomethyl, 'C').fixedModification());
        mods.add(new Modification.Instance(Modification.PyroCarbamidomethyl, 'C', Modification.Location.N_Term));
        mods.add(new Modification.Instance(Modification.Oxidation, 'M', Modification.Location.Anywhere));
        mods.add(new Modification.Instance(Modification.Acetyl, '*', Modification.Location.N_Term));
        mods.add(new Modification.Instance(Modification.PyroGluQ, 'Q', Modification.Location.N_Term));
        mods.add(new Modification.Instance(Modification.PyroGluE, 'E', Modification.Location.N_Term));
        aaSet = AminoAcidSet.getAminoAcidSet(mods);
    }
}

