/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import java.io.File;

public class MakePairedSpectra {
    public static void main(String[] argv) {
        File etdFile;
        String ext;
        File cidFile;
        if (argv.length != 3) {
            MakePairedSpectra.printErrorAndExit("Invalid parameters!");
        }
        if (!(cidFile = new File(argv[0])).isFile()) {
            MakePairedSpectra.printErrorAndExit(argv[0] + " is not a file.");
        }
        if (!(ext = cidFile.getName().substring(cidFile.getName().lastIndexOf(46) + 1)).equalsIgnoreCase("mgf")) {
            MakePairedSpectra.printErrorAndExit(argv[0] + " must be a mgf file.");
        }
        if (!(etdFile = new File(argv[1])).isFile()) {
            MakePairedSpectra.printErrorAndExit(argv[1] + " is not a file.");
        }
        if (!(ext = etdFile.getName().substring(etdFile.getName().lastIndexOf(46) + 1)).equalsIgnoreCase("mgf")) {
            MakePairedSpectra.printErrorAndExit(argv[1] + " must be a mgf file.");
        }
        File outFile = new File(argv[2]);
        MakePairedSpectra.merge(cidFile, etdFile, outFile);
    }

    public static void printErrorAndExit(String message) {
        System.err.println(message);
        System.out.println("usage: java -Xmx3500M MakePairedSpectra CIDSpectra (*.mgf) ETDSpectra (*.mgf) OutputSpectra (*.mgf)");
        System.exit(-1);
    }

    public static void merge(File cidFile, File etdFile, File outFile) {
        SpectraMap cidMap = new SpectraMap(cidFile.getPath(), new MgfSpectrumParser());
        SpectraMap etdMap = new SpectraMap(etdFile.getPath(), new MgfSpectrumParser());
        SpectraContainer mergedContainer = new SpectraContainer();
        for (Integer cidScanNum : cidMap.getSpecIndexList()) {
            float etdPreMz;
            Spectrum cidSpec;
            float cidPreMz;
            float error;
            int etdScanNum = cidScanNum + 1;
            Spectrum etdSpec = etdMap.getSpectrumBySpecIndex(etdScanNum);
            if (etdSpec == null || !((error = Math.abs((cidPreMz = (cidSpec = cidMap.getSpectrumBySpecIndex(cidScanNum)).getPrecursorPeak().getMz()) - (etdPreMz = etdSpec.getPrecursorPeak().getMz()))) < 0.001f) || cidSpec.getCharge() != etdSpec.getCharge()) continue;
            mergedContainer.add(cidSpec);
            mergedContainer.add(etdSpec);
        }
        mergedContainer.outputMgfFile(outFile.getPath());
    }
}

