/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MassErrorStat {
    private List<Pair<Float, Float>> errorList = new ArrayList<Pair<Float, Float>>();
    private float mean;
    private float sd;
    private float mean7;
    private float sd7;
    private float rMean;
    private float rSd;
    private float rMean7;
    private float rSd7;

    public void add(Pair<Float, Float> error) {
        this.errorList.add(error);
    }

    public void computeStats() {
        ArrayList<Float> allErrors = new ArrayList<Float>();
        ArrayList<Float> top7Errors = new ArrayList<Float>();
        ArrayList<Float> allRErrors = new ArrayList<Float>();
        ArrayList<Float> top7RErrors = new ArrayList<Float>();
        Collections.sort(this.errorList, new Pair.PairReverseComparator(true));
        int rank = 0;
        for (Pair<Float, Float> errInfo : this.errorList) {
            float error = errInfo.getFirst().floatValue();
            float absError = Math.abs(error);
            allErrors.add(Float.valueOf(absError));
            allRErrors.add(Float.valueOf(error));
            if (++rank > 7) continue;
            top7Errors.add(Float.valueOf(absError));
            top7RErrors.add(Float.valueOf(error));
        }
        this.mean = this.mean(allErrors);
        this.rMean = this.mean(allRErrors);
        this.sd = this.stdev(allErrors);
        this.rSd = this.stdev(allRErrors);
        this.mean7 = this.mean(top7Errors);
        this.rMean7 = this.mean(top7RErrors);
        this.sd7 = this.stdev(top7Errors);
        this.rSd7 = this.stdev(top7RErrors);
    }

    public List<Pair<Float, Float>> getErrorList() {
        return this.errorList;
    }

    public int size() {
        return this.errorList.size();
    }

    public float getMean() {
        return this.mean;
    }

    public float getRMean() {
        return this.rMean;
    }

    public float getSd() {
        return this.sd;
    }

    public float getRSd() {
        return this.rSd;
    }

    public float getMean7() {
        return this.mean7;
    }

    public float getRMean7() {
        return this.rMean7;
    }

    public float getSd7() {
        return this.sd7;
    }

    public float getRSd7() {
        return this.rSd7;
    }

    public static float sum(List<Float> numbers) {
        float sum = 0.0f;
        for (float num : numbers) {
            sum += num;
        }
        return sum;
    }

    public float mean(List<Float> numbers) {
        return MassErrorStat.sum(numbers) / (float)numbers.size();
    }

    public float median(List<Float> numbers) {
        ArrayList<Float> sorted = new ArrayList<Float>(numbers);
        Collections.sort(sorted);
        int mid = sorted.size() / 2;
        if (sorted.size() % 2 == 0) {
            return (sorted.get(mid - 1).floatValue() + sorted.get(mid).floatValue()) / 2.0f;
        }
        return sorted.get(mid).floatValue();
    }

    public float stdev(List<Float> numbers) {
        double sumSq = 0.0;
        for (float num : numbers) {
            sumSq += (double)(num * num);
        }
        float mean = this.mean(numbers);
        float var = (float)sumSq / (float)numbers.size() - mean * mean;
        return (float)Math.sqrt(var);
    }
}

