/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msgf.ScoreDist;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Match
implements Comparable<Match> {
    private final int score;
    private final float peptideMass;
    private final int nominalPeptideMass;
    private final int charge;
    private final String pepSeq;
    private final ActivationMethod[] actMethodArr;
    private int deNovoScore;
    private double specProb = 1.0;
    private ScoreDist scoreDist;
    private List<Pair<String, String>> additionalFeatureList = null;

    public Match(int score, float peptideMass, int nominalPeptideMass, int charge, String pepSeq, ActivationMethod[] actMethodArr) {
        this.score = score;
        this.peptideMass = peptideMass;
        this.nominalPeptideMass = nominalPeptideMass;
        this.charge = charge;
        this.pepSeq = pepSeq;
        this.actMethodArr = actMethodArr;
    }

    public int getScore() {
        return this.score;
    }

    public float getPeptideMass() {
        return this.peptideMass;
    }

    public int getNominalPeptideMass() {
        return this.nominalPeptideMass;
    }

    public int getCharge() {
        return this.charge;
    }

    public String getPepSeq() {
        return this.pepSeq;
    }

    public ActivationMethod[] getActivationMethodArr() {
        return this.actMethodArr;
    }

    public void setDeNovoScore(int deNovoScore) {
        this.deNovoScore = deNovoScore;
    }

    public int getDeNovoScore() {
        return this.deNovoScore;
    }

    public void setSpecProb(double specProb) {
        this.specProb = specProb;
    }

    public double getSpecEValue() {
        return this.specProb;
    }

    public void addAdditionalFeature(String key, String value) {
        if (this.additionalFeatureList == null) {
            this.additionalFeatureList = new ArrayList<Pair<String, String>>();
        }
        this.additionalFeatureList.add(new Pair<String, String>(key, value));
    }

    public List<Pair<String, String>> getAdditionalFeatureList() {
        return this.additionalFeatureList;
    }

    public void setScoreDist(ScoreDist scoreDist) {
        this.scoreDist = scoreDist;
    }

    public ScoreDist getScoreDist() {
        return this.scoreDist;
    }

    @Override
    public int compareTo(Match o) {
        return this.score - o.score;
    }

    public static class SpecProbComparator
    implements Comparator<Match> {
        @Override
        public int compare(Match arg0, Match arg1) {
            if (arg0.getSpecEValue() < arg1.getSpecEValue()) {
                return 1;
            }
            if (arg0.getSpecEValue() > arg1.getSpecEValue()) {
                return -1;
            }
            return 0;
        }
    }
}

