/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class ReverseDB {
    public static void main(String[] argv) {
        if (argv.length != 2) {
            ReverseDB.printUsageAndExit();
        }
        String ext1 = argv[0].substring(argv[0].lastIndexOf(46) + 1);
        String ext2 = argv[1].substring(argv[1].lastIndexOf(46) + 1);
        if (!ext1.equalsIgnoreCase("fasta") || !ext2.equalsIgnoreCase("fasta")) {
            System.out.println(ext1 + "," + ext2);
            ReverseDB.printUsageAndExit();
        }
        String decoyProteinPrefix = argv.length > 2 ? argv[2].trim() : "XXX";
        ReverseDB.reverseDB(argv[0], argv[1], false, decoyProteinPrefix);
    }

    public static void printUsageAndExit() {
        System.out.println("usage: java ReverseDB input.fasta output.fasta [DecoyProteinPrefix]");
        System.exit(0);
    }

    public static boolean reverseDB(String inFileName, String outFileName, boolean concat, String revPrefix) {
        String s;
        BufferedReader in = null;
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFileName)));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        if (revPrefix == null || revPrefix.trim().isEmpty()) {
            revPrefix = "XXX";
        }
        while (revPrefix.endsWith("_")) {
            revPrefix = revPrefix.substring(0, revPrefix.length() - 1);
        }
        if (revPrefix.trim().isEmpty()) {
            revPrefix = "XXX";
        }
        if (concat) {
            try {
                in = new BufferedReader(new FileReader(inFileName));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                while ((s = in.readLine()) != null) {
                    out.println(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            in = new BufferedReader(new FileReader(inFileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        StringBuffer protein = null;
        String annotation = null;
        try {
            while ((s = in.readLine()) != null) {
                if (s.startsWith(">")) {
                    if (annotation != null) {
                        StringBuffer rev = new StringBuffer();
                        for (int i = protein.length() - 1; i >= 0; --i) {
                            rev.append(protein.charAt(i));
                        }
                        out.println(">" + revPrefix + "_" + annotation);
                        out.println(rev.toString().trim());
                    }
                    annotation = s.substring(1);
                    protein = new StringBuffer();
                    continue;
                }
                protein.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (protein != null && annotation != null) {
            out.println(">" + revPrefix + "_" + annotation);
            out.println(protein.reverse().toString().trim());
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.close();
        return true;
    }

    public static boolean copyDB(String inFileName, String outFileName) {
        BufferedReader in = null;
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFileName)));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            in = new BufferedReader(new FileReader(inFileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            String s;
            while ((s = in.readLine()) != null) {
                out.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        out.flush();
        out.close();
        return true;
    }
}

