/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.misc.ProgressData;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.ScoredSpectrumSum;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.DBScanScorer;
import edu.ucsd.msjava.msscorer.FastScorer;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msscorer.SimpleDBSearchScorer;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpecKey;
import edu.ucsd.msjava.msutil.SpectraAccessor;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ScoredSpectraMap {
    private final SpectraAccessor specAcc;
    private final List<SpecKey> specKeyList;
    private final Tolerance leftPrecursorMassTolerance;
    private final Tolerance rightPrecursorMassTolerance;
    private final int minIsotopeError;
    private final int maxIsotopeError;
    private final NewScorerFactory.SpecDataType specDataType;
    private SortedMap<Double, SpecKey> pepMassSpecKeyMap;
    private Map<SpecKey, SimpleDBSearchScorer<NominalMass>> specKeyScorerMap;
    private Map<Pair<Integer, Integer>, SpecKey> specIndexChargeToSpecKeyMap;
    private Map<SpecKey, NewRankScorer> specKeyRankScorerMap;
    private boolean turnOffEdgeScoring = false;
    private ProgressData progress;

    public ScoredSpectraMap(SpectraAccessor specAcc, List<SpecKey> specKeyList, Tolerance leftPrecursorMassTolerance, Tolerance rightPrecursorMassTolerance, int minIsotopeError, int maxIsotopeError, NewScorerFactory.SpecDataType specDataType, boolean storeRankScorer, boolean supportSpectrumSpecificErrorTolerance) {
        this.specAcc = specAcc;
        this.specKeyList = specKeyList;
        this.leftPrecursorMassTolerance = leftPrecursorMassTolerance;
        this.rightPrecursorMassTolerance = rightPrecursorMassTolerance;
        this.minIsotopeError = minIsotopeError;
        this.maxIsotopeError = maxIsotopeError;
        this.specDataType = specDataType;
        this.pepMassSpecKeyMap = Collections.synchronizedSortedMap(new TreeMap());
        this.specKeyScorerMap = Collections.synchronizedMap(new HashMap());
        this.specIndexChargeToSpecKeyMap = Collections.synchronizedMap(new HashMap());
        if (storeRankScorer) {
            this.specKeyRankScorerMap = Collections.synchronizedMap(new HashMap());
        }
        this.progress = null;
    }

    public ScoredSpectraMap(SpectraAccessor specAcc, List<SpecKey> specKeyList, Tolerance leftPrecursorMassTolerance, Tolerance rightPrecursorMassTolerance, int maxNum13C, NewScorerFactory.SpecDataType specDataType, boolean storeRankScorer, boolean supportSpectrumSpecificErrorTolerance) {
        this(specAcc, specKeyList, leftPrecursorMassTolerance, rightPrecursorMassTolerance, 0, maxNum13C, specDataType, storeRankScorer, supportSpectrumSpecificErrorTolerance);
    }

    public ScoredSpectraMap(SpectraAccessor specAcc, List<SpecKey> specKeyList, Tolerance leftPrecursorMassTolerance, Tolerance rightPrecursorMassTolerance, int maxNum13C, NewScorerFactory.SpecDataType specDataType, boolean storeRankScorer) {
        this(specAcc, specKeyList, leftPrecursorMassTolerance, rightPrecursorMassTolerance, 0, maxNum13C, specDataType, storeRankScorer, false);
    }

    public ScoredSpectraMap turnOffEdgeScoring() {
        this.turnOffEdgeScoring = true;
        return this;
    }

    public SortedMap<Double, SpecKey> getPepMassSpecKeyMap() {
        return this.pepMassSpecKeyMap;
    }

    public Map<SpecKey, SimpleDBSearchScorer<NominalMass>> getSpecKeyScorerMap() {
        return this.specKeyScorerMap;
    }

    public SpectraAccessor getSpectraAccessor() {
        return this.specAcc;
    }

    public NewScorerFactory.SpecDataType getSpecDataType() {
        return this.specDataType;
    }

    @Deprecated
    public Tolerance getLeftParentMassTolerance() {
        return this.getLeftPrecursorMassTolerance();
    }

    @Deprecated
    public Tolerance getRightParentMassTolerance() {
        return this.getRightPrecursorMassTolerance();
    }

    public Tolerance getLeftPrecursorMassTolerance() {
        return this.leftPrecursorMassTolerance;
    }

    public Tolerance getRightPrecursorMassTolerance() {
        return this.rightPrecursorMassTolerance;
    }

    public int getMaxIsotopeError() {
        return this.maxIsotopeError;
    }

    public int getMinIsotopeError() {
        return this.minIsotopeError;
    }

    public List<SpecKey> getSpecKeyList() {
        return this.specKeyList;
    }

    public SpecKey getSpecKey(int specIndex, int charge) {
        return this.specIndexChargeToSpecKeyMap.get(new Pair<Integer, Integer>(specIndex, charge));
    }

    public NewRankScorer getRankScorer(SpecKey specKey) {
        if (this.specKeyRankScorerMap == null) {
            return null;
        }
        return this.specKeyRankScorerMap.get(specKey);
    }

    public ScoredSpectraMap makePepMassSpecKeyMap() {
        for (SpecKey specKey : this.specKeyList) {
            int specIndex = specKey.getSpecIndex();
            Spectrum spec = this.specAcc.getSpectrumBySpecIndex(specIndex);
            float peptideMass = (spec.getPrecursorPeak().getMz() - (float)Composition.ChargeCarrierMass()) * (float)specKey.getCharge() - 18.010565f;
            if (!(peptideMass > 0.0f)) continue;
            for (int delta = this.minIsotopeError; delta <= this.maxIsotopeError; ++delta) {
                float mass1 = peptideMass - (float)delta * 1.0033548f;
                double mass1Key = mass1;
                while (this.pepMassSpecKeyMap.get(mass1Key) != null) {
                    mass1Key = Math.nextUp(mass1Key);
                }
                this.pepMassSpecKeyMap.put(mass1Key, specKey);
            }
            this.specIndexChargeToSpecKeyMap.put(new Pair<Integer, Integer>(specIndex, specKey.getCharge()), specKey);
        }
        return this;
    }

    public void setProgressObj(ProgressData progObj) {
        this.progress = progObj;
    }

    public ProgressData getProgressObj() {
        return this.progress;
    }

    public void preProcessSpectra() {
        this.preProcessSpectra(0, this.specKeyList.size());
    }

    public void preProcessSpectra(int fromIndex, int toIndex) {
        if (this.progress == null) {
            this.progress = new ProgressData();
        }
        if (this.specDataType.getActivationMethod() != ActivationMethod.FUSION) {
            this.preProcessIndividualSpectra(fromIndex, toIndex);
        } else {
            this.preProcessFusedSpectra(fromIndex, toIndex);
        }
    }

    private void preProcessIndividualSpectra(int fromIndex, int toIndex) {
        NewRankScorer scorer = null;
        ActivationMethod activationMethod = this.specDataType.getActivationMethod();
        InstrumentType instType = this.specDataType.getInstrumentType();
        Enzyme enzyme = this.specDataType.getEnzyme();
        Protocol protocol = this.specDataType.getProtocol();
        if (activationMethod != ActivationMethod.ASWRITTEN && activationMethod != ActivationMethod.FUSION) {
            scorer = NewScorerFactory.get(activationMethod, instType, enzyme, protocol);
            if (this.turnOffEdgeScoring) {
                scorer.doNotUseError();
            }
        }
        int count = 0;
        int countIgnored = 0;
        int total = toIndex - fromIndex;
        for (SpecKey specKey : this.specKeyList.subList(fromIndex, toIndex)) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            int specIndex = specKey.getSpecIndex();
            Spectrum spec = this.specAcc.getSpectrumBySpecIndex(specIndex);
            if (activationMethod == ActivationMethod.ASWRITTEN || activationMethod == ActivationMethod.FUSION) {
                scorer = NewScorerFactory.get(spec.getActivationMethod(), instType, enzyme, protocol);
                if (this.turnOffEdgeScoring) {
                    scorer.doNotUseError();
                }
            }
            int charge = specKey.getCharge();
            spec.setCharge(charge);
            NewScoredSpectrum<NominalMass> scoredSpec = scorer.getScoredSpectrum(spec);
            float peptideMass = spec.getPrecursorMass() - 18.010565f;
            float tolDaLeft = this.leftPrecursorMassTolerance.getToleranceAsDa(peptideMass);
            int maxNominalPeptideMass = NominalMass.toNominalMass(peptideMass) + Math.round(tolDaLeft - 0.4999f) - this.minIsotopeError;
            if (maxNominalPeptideMass > 0) {
                if (scorer.supportEdgeScores()) {
                    this.specKeyScorerMap.put(specKey, new DBScanScorer(scoredSpec, maxNominalPeptideMass));
                } else {
                    this.specKeyScorerMap.put(specKey, new FastScorer(scoredSpec, maxNominalPeptideMass));
                }
                if (this.specKeyRankScorerMap != null) {
                    this.specKeyRankScorerMap.put(specKey, scorer);
                }
            } else if (++countIgnored <= 4) {
                System.out.println("... ignoring spectrum at index " + String.format("%1$5s", specKey.getSpecIndex()) + " with invalid precursor ion of " + spec.getPrecursorMass() + " Da");
            }
            this.progress.report(++count, total);
        }
        if (countIgnored > 1) {
            String threadName = Thread.currentThread().getName();
            System.out.println("Warning: Ignored " + countIgnored + " spectra with invalid precursor ions (" + threadName + ")");
        }
    }

    private void preProcessFusedSpectra(int fromIndex, int toIndex) {
        InstrumentType instType = this.specDataType.getInstrumentType();
        Enzyme enzyme = this.specDataType.getEnzyme();
        Protocol protocol = this.specDataType.getProtocol();
        for (SpecKey specKey : this.specKeyList.subList(fromIndex, toIndex)) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Integer> specIndexList = specKey.getSpecIndexList();
            if (specIndexList == null) {
                specIndexList = new ArrayList();
                specIndexList.add(specKey.getSpecIndex());
            }
            ArrayList scoredSpecList = new ArrayList();
            boolean supportEdgeScore = true;
            for (int specIndex : specIndexList) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Spectrum spec = this.specAcc.getSpectrumBySpecIndex(specIndex);
                NewRankScorer scorer = NewScorerFactory.get(spec.getActivationMethod(), instType, enzyme, protocol);
                if (!scorer.supportEdgeScores()) {
                    supportEdgeScore = false;
                }
                int charge = specKey.getCharge();
                spec.setCharge(charge);
                NewScoredSpectrum sSpec = scorer.getScoredSpectrum(spec);
                scoredSpecList.add(sSpec);
            }
            if (scoredSpecList.size() == 0) continue;
            ScoredSpectrumSum<NominalMass> scoredSpec = new ScoredSpectrumSum<NominalMass>(scoredSpecList);
            float peptideMass = scoredSpec.getPrecursorPeak().getMass() - 18.010565f;
            float tolDaLeft = this.leftPrecursorMassTolerance.getToleranceAsDa(peptideMass);
            int maxNominalPeptideMass = NominalMass.toNominalMass(peptideMass) + Math.round(tolDaLeft - 0.4999f) + 1;
            if (supportEdgeScore) {
                this.specKeyScorerMap.put(specKey, new FastScorer(scoredSpec, maxNominalPeptideMass));
                continue;
            }
            this.specKeyScorerMap.put(specKey, new FastScorer(scoredSpec, maxNominalPeptideMass));
        }
    }
}

