/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.DBSearchIOFiles;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.IntRangeParameter;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.params.Parameter;
import edu.ucsd.msjava.params.ToleranceParameter;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SearchParams {
    private List<DBSearchIOFiles> dbSearchIOList;
    private File databaseFile;
    private String decoyProteinPrefix;
    private Tolerance leftPrecursorMassTolerance;
    private Tolerance rightPrecursorMassTolerance;
    private int minIsotopeError;
    private int maxIsotopeError;
    private Enzyme enzyme;
    private int numTolerableTermini;
    private ActivationMethod activationMethod;
    private InstrumentType instType;
    private Protocol protocol;
    private AminoAcidSet aaSet;
    private int numMatchesPerSpec;
    private int startSpecIndex;
    private int endSpecIndex;
    private boolean useTDA;
    private boolean ignoreMetCleavage;
    private int minPeptideLength;
    private int maxPeptideLength;
    private int maxNumVariantsPerPeptide;
    private int minCharge;
    private int maxCharge;
    private int numThreads;
    private int numTasks;
    private boolean verbose;
    private boolean doNotUseEdgeScore;
    private File dbIndexDir;
    private boolean outputAdditionalFeatures;
    private int minNumPeaksPerSpectrum;
    private int minDeNovoScore;
    private double chargeCarrierMass;
    private int maxMissedCleavages;
    private int maxNumMods;
    private boolean allowDenseCentroidedPeaks;

    public List<DBSearchIOFiles> getDBSearchIOList() {
        return this.dbSearchIOList;
    }

    public File getDatabaseFile() {
        return this.databaseFile;
    }

    public String getDecoyProteinPrefix() {
        return this.decoyProteinPrefix;
    }

    public Tolerance getLeftPrecursorMassTolerance() {
        return this.leftPrecursorMassTolerance;
    }

    public Tolerance getRightPrecursorMassTolerance() {
        return this.rightPrecursorMassTolerance;
    }

    public int getMinIsotopeError() {
        return this.minIsotopeError;
    }

    public int getMaxIsotopeError() {
        return this.maxIsotopeError;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public int getNumTolerableTermini() {
        return this.numTolerableTermini;
    }

    public ActivationMethod getActivationMethod() {
        return this.activationMethod;
    }

    public InstrumentType getInstType() {
        return this.instType;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public AminoAcidSet getAASet() {
        return this.aaSet;
    }

    public int getNumMatchesPerSpec() {
        return this.numMatchesPerSpec;
    }

    public int getStartSpecIndex() {
        return this.startSpecIndex;
    }

    public int getEndSpecIndex() {
        return this.endSpecIndex;
    }

    public boolean useTDA() {
        return this.useTDA;
    }

    public boolean ignoreMetCleavage() {
        return this.ignoreMetCleavage;
    }

    public int getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public int getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public int getMaxNumVariantsPerPeptide() {
        return this.maxNumVariantsPerPeptide;
    }

    public int getMinCharge() {
        return this.minCharge;
    }

    public int getMaxCharge() {
        return this.maxCharge;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean doNotUseEdgeScore() {
        return this.doNotUseEdgeScore;
    }

    public File getDBIndexDir() {
        return this.dbIndexDir;
    }

    public boolean outputAdditionalFeatures() {
        return this.outputAdditionalFeatures;
    }

    public int getMinNumPeaksPerSpectrum() {
        return this.minNumPeaksPerSpectrum;
    }

    public int getMinDeNovoScore() {
        return this.minDeNovoScore;
    }

    public double getChargeCarrierMass() {
        return this.chargeCarrierMass;
    }

    public int getMaxMissedCleavages() {
        return this.maxMissedCleavages;
    }

    public boolean getAllowDenseCentroidedPeaks() {
        return this.allowDenseCentroidedPeaks;
    }

    public static String getConfigLineWithoutComment(String dataLine) {
        String[] tokenArray = dataLine.split("#");
        if (tokenArray.length == 0) {
            return "";
        }
        return tokenArray[0].trim();
    }

    public String parse(ParamManager paramManager) {
        AminoAcidSet configAASet = null;
        FileParameter configFileParam = paramManager.getConfigFileParam();
        if (configFileParam != null && configFileParam.getFile() != null) {
            configAASet = this.parseConfigParamFile(paramManager);
        }
        this.chargeCarrierMass = paramManager.getChargeCarrierMass();
        Composition.setChargeCarrierMass(this.chargeCarrierMass);
        FileParameter specParam = paramManager.getSpecFileParam();
        File specPath = specParam.getFile();
        if (specPath == null) {
            return "Spectrum file is not defined; use -s at the command line or SpectrumFile in a config file";
        }
        if (!specPath.exists()) {
            return "Spectrum file not found: " + specPath.getPath();
        }
        this.dbSearchIOList = new ArrayList<DBSearchIOFiles>();
        if (!specPath.isDirectory()) {
            File[] specFormat = (File[])specParam.getFileFormat();
            File outputFile = paramManager.getOutputFileParam().getFile();
            if (outputFile == null) {
                String outputFilePath = specPath.getPath().substring(0, specPath.getPath().lastIndexOf(46)) + ".mzid";
                outputFile = new File(outputFilePath);
            }
            this.dbSearchIOList = new ArrayList<DBSearchIOFiles>();
            this.dbSearchIOList.add(new DBSearchIOFiles(specPath, (SpecFileFormat)specFormat, outputFile));
        } else {
            this.dbSearchIOList = new ArrayList<DBSearchIOFiles>();
            for (File f : specPath.listFiles()) {
                SpecFileFormat specFormat = SpecFileFormat.getSpecFileFormat(f.getName());
                if (!specParam.isSupported(specFormat)) continue;
                String outputFileName = f.getName().substring(0, f.getName().lastIndexOf(46)) + ".mzid";
                File outputFile = new File(outputFileName);
                this.dbSearchIOList.add(new DBSearchIOFiles(f, specFormat, outputFile));
            }
        }
        this.databaseFile = paramManager.getDBFileParam().getFile();
        this.decoyProteinPrefix = paramManager.getDecoyProteinPrefix();
        ToleranceParameter tol = paramManager.getPrecursorMassToleranceParam();
        this.leftPrecursorMassTolerance = tol.getLeftTolerance();
        this.rightPrecursorMassTolerance = tol.getRightTolerance();
        int toleranceUnit = paramManager.getToleranceUnit();
        if (toleranceUnit != 2) {
            boolean isTolerancePPM = toleranceUnit != 0;
            this.leftPrecursorMassTolerance = new Tolerance(this.leftPrecursorMassTolerance.getValue(), isTolerancePPM);
            this.rightPrecursorMassTolerance = new Tolerance(this.rightPrecursorMassTolerance.getValue(), isTolerancePPM);
        }
        IntRangeParameter isotopeParam = paramManager.getIsotopeRangeParameter();
        this.minIsotopeError = (Integer)isotopeParam.getMin();
        this.maxIsotopeError = (Integer)isotopeParam.getMax();
        if (this.rightPrecursorMassTolerance.getToleranceAsDa(1000.0f, 2) >= 0.5f || this.leftPrecursorMassTolerance.getToleranceAsDa(1000.0f, 2) >= 0.5f) {
            this.maxIsotopeError = 0;
            this.minIsotopeError = 0;
        }
        this.enzyme = paramManager.getEnzyme();
        this.numTolerableTermini = paramManager.getNumTolerableTermini();
        this.activationMethod = paramManager.getActivationMethod();
        this.instType = paramManager.getInstType();
        if (this.activationMethod == ActivationMethod.HCD && this.instType != InstrumentType.HIGH_RESOLUTION_LTQ && this.instType != InstrumentType.QEXACTIVE) {
            this.instType = InstrumentType.QEXACTIVE;
        }
        this.protocol = paramManager.getProtocol();
        this.aaSet = null;
        File modFile = paramManager.getModFileParam().getFile();
        if (modFile == null && configAASet == null) {
            this.aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        } else {
            String modFileName;
            String ext;
            this.aaSet = modFile != null ? ((ext = (modFileName = modFile.getName()).substring(modFileName.lastIndexOf(46) + 1)).equalsIgnoreCase("xml") ? AminoAcidSet.getAminoAcidSetFromXMLFile(modFile.getPath()) : AminoAcidSet.getAminoAcidSetFromModFile(modFile.getPath(), paramManager)) : configAASet;
            if (this.protocol == Protocol.AUTOMATIC) {
                this.protocol = this.aaSet.containsITRAQ() ? (this.aaSet.containsPhosphorylation() ? Protocol.ITRAQPHOSPHO : Protocol.ITRAQ) : (this.aaSet.containsTMT() ? Protocol.TMT : (this.aaSet.containsPhosphorylation() ? Protocol.PHOSPHORYLATION : Protocol.STANDARD));
            }
        }
        this.numMatchesPerSpec = paramManager.getNumMatchesPerSpectrum();
        IntRangeParameter specIndexParam = paramManager.getSpecIndexParameter();
        this.startSpecIndex = (Integer)specIndexParam.getMin();
        this.endSpecIndex = (Integer)specIndexParam.getMax();
        this.useTDA = paramManager.getTDA() == 1;
        this.ignoreMetCleavage = paramManager.getIgnoreMetCleavage() == 1;
        this.outputAdditionalFeatures = paramManager.getOutputAdditionalFeatures() == 1;
        this.minPeptideLength = paramManager.getMinPeptideLength();
        this.maxPeptideLength = paramManager.getMaxPeptideLength();
        this.maxNumVariantsPerPeptide = paramManager.getMaxNumVariantsPerPeptide();
        if (this.minPeptideLength > this.maxPeptideLength) {
            return "MinPepLength must not be larger than MaxPepLength";
        }
        this.minCharge = paramManager.getMinCharge();
        this.maxCharge = paramManager.getMaxCharge();
        if (this.minCharge > this.maxCharge) {
            return "MinCharge must not be larger than MaxCharge";
        }
        this.numThreads = paramManager.getNumThreads();
        this.numTasks = paramManager.getNumTasks();
        this.verbose = paramManager.getVerboseFlag() == 1;
        this.doNotUseEdgeScore = paramManager.getEdgeScoreFlag() == 1;
        this.dbIndexDir = paramManager.getDatabaseIndexDir();
        this.minNumPeaksPerSpectrum = paramManager.getMinNumPeaksPerSpectrum();
        this.minDeNovoScore = paramManager.getMinDeNovoScore();
        this.maxMissedCleavages = paramManager.getMaxMissedCleavages();
        if (this.maxMissedCleavages > -1 && this.enzyme.getName().equals("UnspecificCleavage")) {
            return "Cannot specify a MaxMissedCleavages when using unspecific cleavage enzyme";
        }
        if (this.maxMissedCleavages > -1 && this.enzyme.getName().equals("NoCleavage")) {
            return "Cannot specify a MaxMissedCleavages when using no cleavage enzyme";
        }
        this.allowDenseCentroidedPeaks = paramManager.getAllowDenseCentroidedPeaks() == 1;
        this.maxNumMods = paramManager.getMaxNumModsPerPeptide();
        int maxNumModsCompare = this.aaSet.getMaxNumberOfVariableModificationsPerPeptide();
        if (this.maxNumMods != maxNumModsCompare) {
            System.err.println("Error, code bug: MaxNumModsPerPeptide tracked by the ParamManager does not match the value tracked by the AminoAcidSet: " + this.maxNumMods + " vs. " + maxNumModsCompare);
            System.exit(-1);
        }
        Modification.setModIdentifiers();
        return null;
    }

    private AminoAcidSet parseConfigParamFile(ParamManager paramManager) {
        String dataLine;
        BufferedLineReader reader = null;
        File paramFile = paramManager.getConfigFileParam().getFile();
        try {
            reader = new BufferedLineReader(paramFile.getPath());
        }
        catch (IOException e) {
            System.err.println("Error opening parameter file " + paramFile.getPath());
            e.printStackTrace();
            System.exit(-1);
        }
        int lineNum = 0;
        Hashtable<Integer, String> customAAByLine = new Hashtable<Integer, String>();
        Hashtable<Integer, String> modsByLine = new Hashtable<Integer, String>();
        int invalidParameterCount = 0;
        assert (reader != null);
        while ((dataLine = reader.readLine()) != null) {
            String paramName;
            ++lineNum;
            String lineSetting = SearchParams.getConfigLineWithoutComment(dataLine);
            if (lineSetting.length() == 0 || (paramName = ParamManager.ParamNameEnum.getParamNameFromLine(lineSetting)).isEmpty()) continue;
            if (ParamManager.ParamNameEnum.DYNAMIC_MODIFICATION.isThisParam(paramName) || ParamManager.ParamNameEnum.STATIC_MODIFICATION.isThisParam(paramName) || ParamManager.ParamNameEnum.CUSTOM_AA.isThisParam(paramName)) {
                String value = lineSetting.split("=")[1].trim();
                if (value.equalsIgnoreCase("none")) continue;
                if (ParamManager.ParamNameEnum.CUSTOM_AA.isThisParam(paramName)) {
                    customAAByLine.put(lineNum, value);
                    continue;
                }
                modsByLine.put(lineNum, value);
                continue;
            }
            boolean validParameter = false;
            for (ParamManager.ParamNameEnum param : ParamManager.ParamNameEnum.values()) {
                Parameter commandLineParam;
                if (!param.isThisParam(paramName) || (commandLineParam = paramManager.getParameter(param.getKey())) == null) continue;
                validParameter = true;
                if (commandLineParam.isValueAssigned()) continue;
                String value = lineSetting.split("=")[1].trim();
                String parseError = commandLineParam.parse(value);
                if (parseError == null || parseError.isEmpty()) {
                    commandLineParam.setValueAssigned();
                    continue;
                }
                if (commandLineParam.getKey().equals(ParamManager.ParamNameEnum.NUM_THREADS.getKey()) && value.equalsIgnoreCase("all")) continue;
                System.err.println("Error parsing '" + lineSetting + "' in config file " + paramFile.getAbsolutePath() + ": " + parseError);
                System.exit(-1);
            }
            if (validParameter || lineSetting.toLowerCase().startsWith("enzymedef")) continue;
            System.out.println("Warning, unrecognized parameter '" + lineSetting + "' in config file " + paramFile.getName());
            ++invalidParameterCount;
        }
        if (invalidParameterCount > 0) {
            System.out.println("Valid parameters are described in the example parameter file at https://github.com/MSGFPlus/msgfplus/blob/master/docs/examples/MSGFPlus_Params.txt");
        }
        return AminoAcidSet.getAminoAcidSetFromList(paramFile.getName(), customAAByLine, modsByLine, paramManager);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\tPrecursorMassTolerance: ");
        if (this.leftPrecursorMassTolerance.equals(this.rightPrecursorMassTolerance)) {
            buf.append(this.leftPrecursorMassTolerance);
        } else {
            buf.append("[" + this.leftPrecursorMassTolerance + "," + this.rightPrecursorMassTolerance + "]");
        }
        buf.append("\n");
        buf.append("\tIsotopeError: " + this.minIsotopeError + "," + this.maxIsotopeError + "\n");
        buf.append("\tTargetDecoyAnalysis: " + this.useTDA + "\n");
        buf.append("\tFragmentationMethod: " + this.activationMethod + "\n");
        buf.append("\tInstrument: " + (this.instType == null ? "null" : this.instType.getNameAndDescription()) + "\n");
        buf.append("\tEnzyme: " + (this.enzyme == null ? "null" : this.enzyme.getName()) + "\n");
        String customEnzymeFile = Enzyme.getCustomEnzymeFilePath();
        if (customEnzymeFile != null && !customEnzymeFile.isEmpty()) {
            buf.append("\tEnzyme file: " + customEnzymeFile + "\n");
        }
        ArrayList<String> customEnzymeMessages = Enzyme.getCustomEnzymeMessages();
        for (String message : customEnzymeMessages) {
            buf.append("\tEnzyme info: " + message + "\n");
        }
        buf.append("\tProtocol: " + (this.protocol == null ? "null" : this.protocol.getName()) + "\n");
        buf.append("\tNumTolerableTermini: " + this.numTolerableTermini + "\n");
        buf.append("\tIgnoreMetCleavage: " + this.ignoreMetCleavage + "\n");
        buf.append("\tMinPepLength: " + this.minPeptideLength + "\n");
        buf.append("\tMaxPepLength: " + this.maxPeptideLength + "\n");
        buf.append("\tMinCharge: " + this.minCharge + "\n");
        buf.append("\tMaxCharge: " + this.maxCharge + "\n");
        buf.append("\tNumMatchesPerSpec: " + this.numMatchesPerSpec + "\n");
        buf.append("\tMaxMissedCleavages: " + this.maxMissedCleavages + "\n");
        buf.append("\tMaxNumModsPerPeptide: " + this.maxNumMods + "\n");
        buf.append("\tChargeCarrierMass: " + this.chargeCarrierMass);
        if (Math.abs(this.chargeCarrierMass - 1.00727649) < 0.005) {
            buf.append(" (proton)\n");
        } else if (Math.abs(this.chargeCarrierMass - 38.96315989) < 0.005) {
            buf.append(" (potassium)\n");
        } else if (Math.abs(this.chargeCarrierMass - 22.98922189) < 0.005) {
            buf.append(" (sodium)\n");
        } else {
            buf.append(" (custom)\n");
        }
        buf.append("\tMinNumPeaksPerSpectrum: " + this.minNumPeaksPerSpectrum + "\n");
        buf.append("\tNumIsoforms: " + this.maxNumVariantsPerPeptide + "\n");
        ArrayList<String> modificationsInUse = this.aaSet.getModificationsInUse();
        if (modificationsInUse.size() == 0) {
            buf.append("No static or dynamic post translational modifications are defined.\n");
        } else {
            buf.append("Post translational modifications in use:\n");
            for (String modInfo : modificationsInUse) {
                buf.append("\t" + modInfo + "\n");
            }
        }
        return buf.toString();
    }
}

